/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr.volume;

import com.sanrad.log.LogMgr;
import com.sanrad.nms.server.comm.CommItem;
import com.sanrad.nms.server.comm.CommMgr;
import com.sanrad.nms.server.comm.CommVarBindList;
import com.sanrad.nms.server.comm.exception.SrCommunicationException;
import com.sanrad.nms.server.comm.snmp.MibItem;
import com.sanrad.nms.server.comm.snmp.SrOid;
import com.sanrad.nms.server.comm.snmp.SrSnmpVarBind;
import com.sanrad.nms.server.comm.snmp.SrSnmpVarBindList;
import com.sanrad.nms.server.comm.snmp.trap.SrTrap;
import com.sanrad.nms.server.event.SrEventHandler;
import com.sanrad.nms.server.exception.MissingValueException;
import com.sanrad.nms.server.exception.SrElementOperationException;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.discover.DiscoverMgr;
import com.sanrad.nms.server.mgr.volume.SnapshotVolConfigElementData;
import com.sanrad.nms.server.mgr.volume.VirtualVolumeConfigurator;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKey;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.CommKeyUtil;
import com.sanrad.nms.server.util.Parameter;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.SnmpCommKey;
import com.sanrad.nms.server.util.types.SrInteger;
import com.sanrad.nms.server.util.types.SrType;
import com.sanrad.nms.server.util.types.constants.SnapshotActivateTypeConstants;
import com.sanrad.nms.server.util.types.constants.VolumeTypeConstants;
import java.util.HashMap;

public class SnapshotVolumeConfigurator
extends VirtualVolumeConfigurator {
    public SnapshotVolumeConfigurator() {
        super(ClassID.SNAPSHOT_VOLUME, "srVirtVolSpecSnapshotTable", MibItem.VIRTUAL_VOLUME_RS, MibItem.VIRTUAL_VOLUME_MIRROR_TBL_LAST_UPDATE, VolumeTypeConstants.VOLUME_TYPE_SNAPSHOT);
    }

    public void internalCreate(ConfigElementData element) throws SrCommunicationException, SrElementOperationException {
        this.updateCedAfterCreate(element);
        char agentIndex = element.getSnmpAgentFromParameter();
        Object sourceId = element.removeParameter(ParameterCode.SNAPSHOT_VOLUME_SOURCE);
        Object threshold = element.removeParameter(ParameterCode.SNAPSHOT_VOLUME_PERCENT_THRESH);
        element.removeParameter(ParameterCode.SNAPSHOT_ACTIVATE);
        CommKeyClassId vSwitchData = (CommKeyClassId)element.getValue(ParameterCode.VSWITCH_ID);
        if (sourceId == null) {
            throw new MissingValueException("Source volume is missing for the new Snapshot volume");
        }
        CommKeyClassId sourceData = (CommKeyClassId)sourceId;
        ClassID classId = sourceData.getClassID();
        String key = "";
        boolean simpleWasCreatedOverSource = false;
        if (classId.equals(ClassID.DIRECT_ACCESS_DEVICE) || classId.equals(ClassID.SUB_DIRECT_ACCESS_DEVICE)) {
            int ind;
            key = DiscoverMgr.getInstance().getVolIdForPhysStor(sourceData, agentIndex);
            if (key == null) {
                CommKey[] commKey = this.createSimpleVolume(sourceData, vSwitchData);
                key = commKey[0].getKey();
                simpleWasCreatedOverSource = true;
            }
            if ((ind = key.indexOf(".")) != -1) {
                key = key.substring(ind + 1);
            }
        } else {
            key = CommKeyUtil.getSpecificSnmpKey(sourceData.getCommKeys(), agentIndex).getKey();
            key = key.substring(key.indexOf(".") + 1);
        }
        Integer srcId = new Integer(key);
        try {
            super.internalCreate(element);
        }
        catch (SrCommunicationException e) {
            if (simpleWasCreatedOverSource) {
                this.removeSimpleVolume(sourceData, agentIndex);
            }
            throw e;
        }
        SrSnmpVarBindList list = new SrSnmpVarBindList();
        SnmpCommKey volumeKey = element.getSnmpKey();
        SrOid sourceOid = new SrOid(MibItem.SNAPSHOT_VOLUME_SOURCE.toString(), volumeKey.toString());
        SrSnmpVarBind sourceVarBind = new SrSnmpVarBind(sourceOid, (SrType)new SrInteger(srcId));
        list.add(sourceVarBind);
        if (threshold != null) {
            SrOid threshOid = new SrOid(MibItem.SNAPSHOT_VOLUME_PERCENT_THRESH.toString(), volumeKey.toString());
            SrSnmpVarBind threshVarBind = new SrSnmpVarBind(threshOid, (SrType)((SrInteger)threshold));
            list.add(threshVarBind);
        }
        try {
            CommMgr.getInstance(agentIndex).setList(list, agentIndex);
        }
        catch (SrCommunicationException e) {
            LogMgr.getServerLog().error("Failed to set Source volume to Snapshot " + volumeKey.toDisplayString(), e);
            if (simpleWasCreatedOverSource) {
                this.removeSimpleVolumeIfNeed(sourceData, vSwitchData);
            }
            this.internalRemove(element);
            throw e;
        }
        element.addParameter(new Parameter(ParameterCode.SNAPSHOT_VOLUME_SOURCE, sourceId));
        element.addParameter(new Parameter(ParameterCode.SNAPSHOT_VOLUME_PERCENT_THRESH, threshold));
        DiscoverMgr.getInstance().addVolumeToInvolvedList(sourceData, agentIndex);
    }

    public boolean readAfterCreate(ConfigElementData element) throws SrCommunicationException {
        Object value = element.removeParameter(ParameterCode.SNAPSHOT_VOLUME_SOURCE);
        super.readAfterCreate(element);
        element.addParameter(new Parameter(ParameterCode.SNAPSHOT_VOLUME_SOURCE, value));
        return false;
    }

    public void readDiscoverPostOperation(ConfigElementData element, CommVarBindList rowList) throws SrCommunicationException {
        SrInteger activationState;
        super.readDiscoverPostOperation(element, rowList);
        Object source = element.removeParameter(ParameterCode.SNAPSHOT_VOLUME_SOURCE);
        if (source != null) {
            String key = ((SrInteger)source).toString();
            key = "1." + key;
            CommKeyClassId commKeyClassId = DiscoverMgr.getInstance().getPhysStorOfVolId(key, element.getMyFirstSnmpAgentIndex());
            if (commKeyClassId == null) {
                commKeyClassId = new CommKeyClassId(new SnmpCommKey(key, element.getMyFirstSnmpAgentIndex()), ClassID.GENERAL_VOLUME);
            }
            element.addParameter(new Parameter(ParameterCode.SNAPSHOT_VOLUME_SOURCE, commKeyClassId));
        }
        Object activationVal = element.removeParameter(ParameterCode.SNAPSHOT_ACTIVATE);
        if (source != null && (activationState = (SrInteger)activationVal) != null) {
            SnapshotActivateTypeConstants av = activationState.equals(1) ? SnapshotActivateTypeConstants.SNAPSHOT_INACTIVE : SnapshotActivateTypeConstants.SNAPSHOT_ACTIVE;
            element.addParameter(new Parameter(ParameterCode.SNAPSHOT_ACTIVATE, av));
        }
    }

    public HashMap getListOfParams() {
        HashMap paramList = super.getListOfParams();
        paramList.put(ParameterCode.SNAPSHOT_VOLUME_DATE_AND_TIME, null);
        paramList.put(ParameterCode.SNAPSHOT_VOLUME_SOURCE, null);
        paramList.put(ParameterCode.SNAPSHOT_VOLUME_PERCENT_THRESH, null);
        paramList.put(ParameterCode.SNAPSHOT_VOLUME_PERCENT_LOAD, null);
        paramList.put(ParameterCode.SNAPSHOT_ACTIVATE, null);
        return paramList;
    }

    protected void trapProccessingPostOperation(ConfigElementData element, SrTrap trap) {
        try {
            super.trapProccessingPostOperation(element, trap);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        if (trap.getTrapType().getTrapId() != 13) {
            throw new UnsupportedOperationException("Operation not supported for trap " + trap.toString());
        }
        LogMgr.getServerLog().debug("SnapshotConfigurator: Snapshot volume load above threshold !");
        SrEventHandler.getEventMgr().sendChangeElementEvent(element);
    }

    public void internalRemove(ConfigElementData element) throws SrCommunicationException {
        char agentIndex = element.getSnmpAgentFromParameter();
        CommKeyClassId sourceId = (CommKeyClassId)element.removeParameter(ParameterCode.SNAPSHOT_VOLUME_SOURCE);
        super.internalRemove(element);
        DiscoverMgr.getInstance().removeVolumeFromInvolvedList(sourceId, agentIndex);
        if (element instanceof SnapshotVolConfigElementData && !((SnapshotVolConfigElementData)element).isSourceExposed()) {
            try {
                this.removeSimpleVolume(sourceId, agentIndex);
            }
            catch (SrCommunicationException e) {
                LogMgr.getServerLog().warning("Remove Snapshot - Failed to remove Simple Volume over Snapshot source: " + sourceId);
            }
        }
    }

    protected CommItem getCommItemForTrapCommKey(SrTrap trap) {
        switch (trap.getTrapType().getTrapId()) {
            case 13: {
                return MibItem.SNAPSHOT_VOLUME_PERCENT_UTIL;
            }
        }
        return super.getCommItemForTrapCommKey(trap);
    }
}

