/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr.volume;

import com.sanrad.log.LogMgr;
import com.sanrad.nms.server.comm.CommMgr;
import com.sanrad.nms.server.comm.exception.SrCommunicationException;
import com.sanrad.nms.server.comm.snmp.MibItem;
import com.sanrad.nms.server.comm.snmp.SrOid;
import com.sanrad.nms.server.comm.snmp.SrSnmpVarBind;
import com.sanrad.nms.server.exception.MissingValueException;
import com.sanrad.nms.server.exception.SrElementOperationException;
import com.sanrad.nms.server.exception.TypeMismatchException;
import com.sanrad.nms.server.mgr.CheckListConfigElementData;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.volume.VolumeConfigurator;
import com.sanrad.nms.server.mgr.volume.VolumeOperationConfigurator;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.CommKeyUtil;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.SnmpCommKey;
import com.sanrad.nms.server.util.types.SrInteger;
import com.sanrad.nms.server.util.types.SrType;
import com.sanrad.nms.server.util.types.constants.VolumeTypeConstants;

public class NonVirtualVolumeConfigurator
extends VolumeConfigurator {
    protected NonVirtualVolumeConfigurator(ClassID classId, String tableName, MibItem rs, VolumeTypeConstants volType) {
        super(classId, tableName, rs, volType);
    }

    public void internalCreate(ConfigElementData element) throws SrCommunicationException, SrElementOperationException {
        CommKeyClassId[] obj = (CommKeyClassId[])element.getValue(ParameterCode.VOLUME_CHILDREN);
        if (obj.length > 1) {
            throw new TypeMismatchException("For Non Virtual Volume, only one child is expected.");
        }
        CommKeyClassId physStoregeData = obj[0];
        SnmpCommKey physStorSnmpKey = CommKeyUtil.getSpecificSnmpKey(physStoregeData, element.getSnmpAgentFromParameter());
        if (physStorSnmpKey == null) {
            throw new MissingValueException("Non Virtual Volume Create - Missing Data of Physical Storage for Agent: " + CommKeyUtil.getIpFromIndex(element.getMyFirstSnmpAgentIndex()));
        }
        super.internalCreate(element);
        SrOid oid = null;
        if (physStoregeData.getClassID().equals(ClassID.DIRECT_ACCESS_DEVICE) || physStoregeData.getClassID().equals(ClassID.SEQUENTIAL_ACCESS_DEVICE) || physStoregeData.getClassID().equals(ClassID.GENERAL_SCSI_DEVICE)) {
            oid = new SrOid(MibItem.PHYSICAL_STORAGE_VOL_ID.toString(), physStorSnmpKey.getKey());
        } else if (physStoregeData.getClassID().equals(ClassID.SUB_DIRECT_ACCESS_DEVICE)) {
            oid = new SrOid(MibItem.SUB_DIRECT_ACCESS_DEVICE_VOL_ID.toString(), physStorSnmpKey.getKey());
        } else {
            logger.error(physStoregeData.getClassID() + " not found when trying to set the volume to be the parent of the Physical Storage");
            return;
        }
        SnmpCommKey snmpVolKey = CommKeyUtil.getSnmpCommKey(element.getCommKey());
        String volIndex = snmpVolKey.getKey();
        String volIdStr = volIndex.substring(volIndex.indexOf(".") + 1);
        SrInteger volId = new SrInteger(volIdStr);
        SrSnmpVarBind varBind = new SrSnmpVarBind(oid, (SrType)volId);
        try {
            CommMgr.getInstance(element.getMyFirstSnmpAgentIndex()).set(varBind, element.getMyFirstSnmpAgentIndex());
        }
        catch (SrCommunicationException e) {
            LogMgr.getServerLog().warning("Failed to set volume Id " + snmpVolKey.toString() + " to the physical Storage " + physStorSnmpKey.toDisplayString(), e);
            super.internalRemove(element);
            throw e;
        }
    }

    public void internalRemove(ConfigElementData element) throws SrCommunicationException {
        super.internalRemove(element);
        VolumeOperationConfigurator volumeOperCfg = new VolumeOperationConfigurator();
        volumeOperCfg.refreshTable(element.getMyFirstSnmpAgentIndex(), null, new CheckListConfigElementData(ClassID.COPY_OPERATION));
    }
}

