/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr.volume;

import com.sanrad.log.LogMgr;
import com.sanrad.nms.server.comm.CommVarBindList;
import com.sanrad.nms.server.comm.exception.SrCommunicationException;
import com.sanrad.nms.server.comm.snmp.MibItem;
import com.sanrad.nms.server.comm.snmp.SrOid;
import com.sanrad.nms.server.comm.snmp.SrSnmpVarBind;
import com.sanrad.nms.server.comm.snmp.trap.SrTrap;
import com.sanrad.nms.server.event.SrEventHandler;
import com.sanrad.nms.server.exception.SrElementOperationErrorException;
import com.sanrad.nms.server.exception.SrElementOperationException;
import com.sanrad.nms.server.exception.SrElementOperationFailedException;
import com.sanrad.nms.server.mgr.CheckListConfigElementData;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.ConfigElementDataList;
import com.sanrad.nms.server.mgr.ElementConfigurator;
import com.sanrad.nms.server.mgr.discover.DiscoverMgr;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKey;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.CommKeyUtil;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.SnmpCommKey;
import com.sanrad.nms.server.util.types.SrInteger;
import com.sanrad.nms.server.util.types.SrTimeTicks;
import com.sanrad.nms.server.util.types.SrType;
import com.sanrad.nms.server.util.types.constants.MirrorSyncAdminStatusConstant;
import com.sanrad.nms.server.util.types.constants.VolumeOperationType;
import java.util.HashMap;
import java.util.Iterator;

public class MirrorVolumeSyncConfigurator
extends ElementConfigurator {
    public MirrorVolumeSyncConfigurator() {
        super(ClassID.COPY_OPERATION, "srVirtVolSpecMirrorTable", MibItem.VIRTUAL_VOLUME_MIRROR_SYNC_RS, MibItem.VIRTUAL_VOLUME_MIRROR_TBL_LAST_UPDATE);
    }

    public HashMap getListOfParams() {
        HashMap<ParameterCode, Object> paramList = new HashMap<ParameterCode, Object>(5);
        paramList.put(ParameterCode.VIRTUAL_VOLUME_MIRROR_SYNCH_ADMIN_STATUS, null);
        paramList.put(ParameterCode.VIRTUAL_VOLUME_MIRROR_SYNCH_OPER_STATUS, null);
        paramList.put(ParameterCode.VIRTUAL_VOLUME_MIRROR_SYNCH_PERCENTAGE_COPIED, null);
        paramList.put(ParameterCode.VIRTUAL_VOLUME_MIRROR_SYNCH_SRC, null);
        return paramList;
    }

    public ConfigElementDataList getAllExtended(char snmpAgentIndex, SrTimeTicks lastUpdate, CheckListConfigElementData checkListElement) throws SrCommunicationException {
        ConfigElementDataList list = super.getAllExtended(snmpAgentIndex, lastUpdate, checkListElement);
        Iterator i = list.iterator();
        while (i.hasNext()) {
            ConfigElementData ced = (ConfigElementData)i.next();
            if (ced.getValue(ParameterCode.COPY_OPERATION_TYPE) != null) continue;
            logger.info("Mirror Sync Operation was ignored - \nCED: " + ced, new Exception("Trace (NOT AN EXCEPTION):Mirror Sync Operation was ignored"));
            i.remove();
        }
        return list;
    }

    protected void readDiscoverPostOperation(ConfigElementData element, CommVarBindList list) throws SrCommunicationException {
        SrType srcVolId;
        MirrorSyncAdminStatusConstant adminStat = (MirrorSyncAdminStatusConstant)this.getVarBindValueFromList(list, MibItem.VIRTUAL_VOLUME_MIRROR_SYNC_ADMIN_STATUS);
        VolumeOperationType operType = this.getVolOperFromAdminStatus(adminStat);
        if (operType != null) {
            element.setValue(ParameterCode.COPY_OPERATION_TYPE, operType);
        }
        if ((srcVolId = this.getVarBindValueFromList(list, MibItem.VIRTUAL_VOLUME_MIRROR_SYNC_SRC_ID)) != null) {
            CommKeyClassId srcVolData = DiscoverMgr.getInstance().getPhysStorOfVolId("1." + ((Object)srcVolId).toString(), list.getSnmpAgentIndex());
            if (srcVolData == null) {
                srcVolData = new CommKeyClassId(new SnmpCommKey("1." + ((Object)srcVolId).toString(), list.getSnmpAgentIndex()), ClassID.GENERAL_VOLUME);
            }
            element.setValue(ParameterCode.VOLUME_OPERATION_SRC, srcVolData);
        }
        SnmpCommKey dstCommKey = CommKeyUtil.getSpecificSnmpKey(element.getCommKey(), element.getMyFirstSnmpAgentIndex());
        CommKeyClassId dstVolData = DiscoverMgr.getInstance().getPhysStorOfVolId(dstCommKey.getKey(), dstCommKey.getSnmpAgentIndex());
        if (dstVolData == null) {
            dstVolData = new CommKeyClassId(element.getCommKey(), ClassID.GENERAL_VOLUME);
        }
        element.setValue(ParameterCode.VOLUME_OPERATION_DST, dstVolData);
    }

    protected void addCommVarBindsToChangeList(CommVarBindList list, ConfigElementData element) {
        VolumeOperationType operType = (VolumeOperationType)element.getValue(ParameterCode.COPY_OPERATION_TYPE);
        if (operType != null) {
            MirrorSyncAdminStatusConstant adminStat = this.getAdminStatFromOperType(operType);
            SnmpCommKey mirrSyncKey = element.getSnmpKey();
            SrOid adminStatOid = new SrOid(MibItem.VIRTUAL_VOLUME_MIRROR_SYNC_ADMIN_STATUS.toString(), mirrSyncKey.toString());
            list.add(new SrSnmpVarBind(adminStatOid, (SrType)adminStat));
        }
    }

    public ConfigElementDataList refreshTableFields(ConfigElementData fieldsData) throws SrCommunicationException {
        ConfigElementData mirrElement = this.createMirrSyncElement(fieldsData);
        return super.refreshTableFields(mirrElement);
    }

    public ConfigElementData createMirrSyncElement(ConfigElementData volOperElement) {
        ConfigElementData newElement = new ConfigElementData(ClassID.COPY_OPERATION);
        if (volOperElement.containParameter(ParameterCode.VOLUME_OPERATION_ADMIN_STATUS)) {
            newElement.setValue(ParameterCode.VIRTUAL_VOLUME_MIRROR_SYNCH_ADMIN_STATUS, (SrType)volOperElement.getValue(ParameterCode.VIRTUAL_VOLUME_MIRROR_SYNCH_ADMIN_STATUS));
        }
        if (volOperElement.containParameter(ParameterCode.VOLUME_OPERATION_OPER_STATUS)) {
            newElement.setValue(ParameterCode.VIRTUAL_VOLUME_MIRROR_SYNCH_OPER_STATUS, (SrType)volOperElement.getValue(ParameterCode.VIRTUAL_VOLUME_MIRROR_SYNCH_OPER_STATUS));
        }
        if (volOperElement.containParameter(ParameterCode.VOLUME_OPERATION_PERCENTAGE_COPIED)) {
            newElement.setValue(ParameterCode.VIRTUAL_VOLUME_MIRROR_SYNCH_PERCENTAGE_COPIED, (SrType)volOperElement.getValue(ParameterCode.VIRTUAL_VOLUME_MIRROR_SYNCH_PERCENTAGE_COPIED));
        }
        if (volOperElement.containParameter(ParameterCode.VOLUME_OPERATION_SRC)) {
            newElement.setValue(ParameterCode.VIRTUAL_VOLUME_MIRROR_SYNCH_SRC, (SrType)volOperElement.getValue(ParameterCode.VIRTUAL_VOLUME_MIRROR_SYNCH_SRC));
        }
        newElement.setValue(ParameterCode.VSWITCH_ID, (SrType)volOperElement.getValue(ParameterCode.VSWITCH_ID));
        return newElement;
    }

    public void operate(ConfigElementData element, VolumeOperationType operType) throws SrCommunicationException, SrElementOperationException {
        if (operType.equals(VolumeOperationType.VOL_OPER_ABORT_MIRROR_SYNC)) {
            this.abortMirrorSync(element);
        } else if (operType.equals(VolumeOperationType.VOL_OPER_MIRROR_SYNC)) {
            this.mirrorSync(element);
        }
    }

    private void abortMirrorSync(ConfigElementData element) throws SrCommunicationException, SrElementOperationException {
        element.setValue(ParameterCode.COPY_OPERATION_TYPE, VolumeOperationType.VOL_OPER_ABORT_MIRROR_SYNC);
        this.internalChange(element);
    }

    private void mirrorSync(ConfigElementData element) throws SrCommunicationException, SrElementOperationException {
        this.mirrorSync(element, false);
    }

    private void mirrorSync(ConfigElementData element, boolean isDummy) throws SrCommunicationException, SrElementOperationException {
        char agentIndex = element.getSnmpAgentFromParameter();
        CommKeyClassId dstVol = (CommKeyClassId)element.getValue(ParameterCode.VOLUME_OPERATION_DST);
        CommKey dstSpecificCommKey = null;
        ClassID dstClassId = dstVol.getClassID();
        if (dstClassId.equals(ClassID.DIRECT_ACCESS_DEVICE) || dstClassId.equals(ClassID.SUB_DIRECT_ACCESS_DEVICE)) {
            String volId = DiscoverMgr.getInstance().getVolIdForPhysStor(dstVol, agentIndex);
            dstSpecificCommKey = new SnmpCommKey(volId, agentIndex);
            dstClassId = ClassID.SIMPLE_VOLUME;
        } else {
            dstSpecificCommKey = CommKeyUtil.getSpecificCommKey(dstVol, agentIndex);
        }
        ClassID srcClassId = element.getClassId();
        CommKeyClassId srcData = new CommKeyClassId(element.getCommKey(), srcClassId);
        String volId = null;
        if (srcClassId.equals(ClassID.DIRECT_ACCESS_DEVICE) || srcClassId.equals(ClassID.SUB_DIRECT_ACCESS_DEVICE)) {
            volId = DiscoverMgr.getInstance().getVolIdForPhysStor(srcData, agentIndex);
            if (volId != null) {
                if (volId.indexOf(".") >= 0) {
                    volId = volId.substring(volId.indexOf(".") + 1);
                }
            } else {
                logger.debug("Failed to find VolId for PhysStor " + srcData + " in MirrorVolumeSyncConfigurator::mirrorSync()");
            }
        } else {
            String volIndices = CommKeyUtil.getSpecificCommKey(srcData, agentIndex).toString();
            volId = volIndices.substring(volIndices.indexOf(".") + 1);
        }
        ConfigElementData syncElement = new ConfigElementData(dstSpecificCommKey, dstClassId);
        syncElement.setValue(ParameterCode.VIRTUAL_VOLUME_MIRROR_SYNCH_SRC, new SrInteger(volId));
        SrType vSwitchId = (SrType)element.getValue(ParameterCode.VSWITCH_ID);
        MirrorSyncAdminStatusConstant adminStat = null;
        adminStat = !isDummy ? MirrorSyncAdminStatusConstant.MIRROR_SYNCH_ADMIN_STATUS_SYNC : MirrorSyncAdminStatusConstant.MIRROR_SYNCH_ADMIN_STATUS_DUMMY_SYNC;
        syncElement.setValue(ParameterCode.VIRTUAL_VOLUME_MIRROR_SYNCH_ADMIN_STATUS, adminStat);
        ConfigElementData mirrSyncElement = new ConfigElementData(dstSpecificCommKey, ClassID.COPY_OPERATION);
        mirrSyncElement.setValue(ParameterCode.VOLUME_OPERATION_SRC, srcData);
        mirrSyncElement.setValue(ParameterCode.VOLUME_OPERATION_DST, dstVol);
        mirrSyncElement.setValue(ParameterCode.VSWITCH_ID, vSwitchId);
        mirrSyncElement.setValue(ParameterCode.COPY_OPERATION_TYPE, this.getVolOperFromAdminStatus(adminStat));
        try {
            this.internalCreate(syncElement);
        }
        catch (SrElementOperationErrorException ex) {
            LogMgr.getServerLog().debug(ex);
            throw ex;
        }
        catch (SrCommunicationException ex) {
            LogMgr.getServerLog().warning("Failed to set Mirror Sync operation to VSwitch", ex);
            throw new SrElementOperationFailedException(this, mirrSyncElement, null);
        }
        this.readAfterCreate(syncElement);
        mirrSyncElement.setValue(ParameterCode.VOLUME_OPERATION_PERCENTAGE_COPIED, (SrType)syncElement.getValue(ParameterCode.VOLUME_OPERATION_PERCENTAGE_COPIED));
        mirrSyncElement.setValue(ParameterCode.VOLUME_OPERATION_OPER_STATUS, (SrType)syncElement.getValue(ParameterCode.VOLUME_OPERATION_OPER_STATUS));
        SrEventHandler.getEventMgr().sendAddElementEvent(mirrSyncElement);
        if (isDummy) {
            this.internalRemove(syncElement);
        }
    }

    protected void trapProccessingPostOperation(ConfigElementData element, SrTrap trap) {
        switch (trap.getTrapType().getTrapId()) {
            case 4: {
                element.setClassId(ClassID.COPY_OPERATION);
                LogMgr.getServerLog().debug("Changed by Trap for " + element.getClassId().toString() + " CommKey is: " + CommKeyUtil.getKeyForMessage(element.getCommKey()));
                SrEventHandler.getEventMgr().sendChangeElementEvent(element);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Operation not supported for trap ID " + trap.getTrapType().getTrapId());
            }
        }
    }

    private VolumeOperationType getVolOperFromAdminStatus(MirrorSyncAdminStatusConstant status) {
        if (status == null) {
            return null;
        }
        if (status.equals(MirrorSyncAdminStatusConstant.MIRROR_SYNCH_ADMIN_STATUS_SYNC)) {
            return VolumeOperationType.VOL_OPER_MIRROR_SYNC;
        }
        if (status.equals(MirrorSyncAdminStatusConstant.MIRROR_SYNCH_ADMIN_STATUS_ABORT)) {
            return VolumeOperationType.VOL_OPER_ABORT_MIRROR_SYNC;
        }
        if (status.equals(MirrorSyncAdminStatusConstant.MIRROR_SYNCH_ADMIN_STATUS_NONE)) {
            return VolumeOperationType.VOL_OPER_NONE;
        }
        return null;
    }

    private MirrorSyncAdminStatusConstant getAdminStatFromOperType(VolumeOperationType operType) {
        if (operType.equals(VolumeOperationType.VOL_OPER_ABORT_MIRROR_SYNC)) {
            return MirrorSyncAdminStatusConstant.MIRROR_SYNCH_ADMIN_STATUS_ABORT;
        }
        if (operType.equals(VolumeOperationType.VOL_OPER_MIRROR_SYNC)) {
            return MirrorSyncAdminStatusConstant.MIRROR_SYNCH_ADMIN_STATUS_SYNC;
        }
        if (operType.equals(VolumeOperationType.VOL_OPER_NONE)) {
            return MirrorSyncAdminStatusConstant.MIRROR_SYNCH_ADMIN_STATUS_NONE;
        }
        return null;
    }
}

