/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr.volume;

import com.sanrad.log.LogMgr;
import com.sanrad.nms.server.comm.CommItem;
import com.sanrad.nms.server.comm.CommMgr;
import com.sanrad.nms.server.comm.CommVarBindList;
import com.sanrad.nms.server.comm.exception.SrCommunicationException;
import com.sanrad.nms.server.comm.snmp.MibItem;
import com.sanrad.nms.server.comm.snmp.SrOid;
import com.sanrad.nms.server.comm.snmp.SrSnmpVarBind;
import com.sanrad.nms.server.comm.snmp.SrSnmpVarBindList;
import com.sanrad.nms.server.comm.snmp.trap.SrTrap;
import com.sanrad.nms.server.event.SrEventHandler;
import com.sanrad.nms.server.exception.MissingValueException;
import com.sanrad.nms.server.exception.SrElementOperationException;
import com.sanrad.nms.server.mgr.CheckListConfigElementData;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.ConfigElementDataList;
import com.sanrad.nms.server.mgr.volume.VirtualVolumeConfigurator;
import com.sanrad.nms.server.mgr.volume.VolumeConfigurator;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKey;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.CommKeyUtil;
import com.sanrad.nms.server.util.Parameter;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.SnmpCommKey;
import com.sanrad.nms.server.util.types.SrInteger;
import com.sanrad.nms.server.util.types.SrType;
import com.sanrad.nms.server.util.types.constants.JournalVolumeActivityConstants;
import com.sanrad.nms.server.util.types.constants.VolumeTypeConstants;
import java.util.Collection;
import java.util.HashMap;

public class JournalVolumeConfigurator
extends VirtualVolumeConfigurator {
    public JournalVolumeConfigurator() {
        super(ClassID.JOURNAL_VOLUME, "srVirtVolSpecJournalTable", MibItem.VIRTUAL_VOLUME_RS, null, VolumeTypeConstants.VOLUME_TYPE_JOURNAL);
    }

    public HashMap getListOfParams() {
        HashMap paramList = super.getListOfParams();
        paramList.put(ParameterCode.JOURNAL_VOLUME_PRECENT_THRESH, null);
        paramList.put(ParameterCode.JOURNAL_VOLUME_PRECENT_UTILIZATION, null);
        paramList.put(ParameterCode.JOURNAL_VOLUME_ACTIVITY, null);
        paramList.put(ParameterCode.JOURNAL_VOLUME_DATE_AND_TIME, null);
        return paramList;
    }

    public void internalCreate(ConfigElementData element) throws SrCommunicationException, SrElementOperationException {
        char agentIndex = element.getSnmpAgentFromParameter();
        this.updateCedAfterCreate(element);
        Object threshold = element.removeParameter(ParameterCode.JOURNAL_VOLUME_PRECENT_THRESH);
        Object activityState = element.removeParameter(ParameterCode.JOURNAL_VOLUME_ACTIVITY);
        if (threshold == null) {
            throw new MissingValueException("Journal Volume threshold precentage is missing for the new volume");
        }
        if (activityState == null) {
            throw new MissingValueException("Journal Volume activity state is missing for the new volume");
        }
        CommKey[][] allChildrenCommKey = this.createVolumeNoAttachVolume(element);
        SrSnmpVarBindList list = new SrSnmpVarBindList();
        SnmpCommKey volumeKey = element.getSnmpKey();
        SrOid thresholdOid = new SrOid(MibItem.JOURNAL_VOLUME_PRECENT_THRESH.toString(), volumeKey.toString());
        SrSnmpVarBind thresholdVarBind = new SrSnmpVarBind(thresholdOid, (SrType)((SrInteger)threshold));
        list.add(thresholdVarBind);
        SrOid activityStateOid = new SrOid(MibItem.JOURNAL_VOLUME_ACTIVITY.toString(), volumeKey.toString());
        SrSnmpVarBind activityStateVarBind = new SrSnmpVarBind(activityStateOid, (SrType)new SrInteger(((JournalVolumeActivityConstants)activityState).intValue()));
        list.add(activityStateVarBind);
        try {
            CommMgr.getInstance(agentIndex).setList(list, agentIndex);
        }
        catch (SrCommunicationException e) {
            LogMgr.getServerLog().error("Failed to set values for journal volume " + volumeKey.toDisplayString(), e);
            this.internalRemove(element);
            throw e;
        }
        this.attachVolumeToChildren(element, allChildrenCommKey);
        CommKeyClassId[] children = (CommKeyClassId[])element.getValue(ParameterCode.VOLUME_CHILDREN);
        this.readVolumePosition(children, element.getCommKeyClassId());
    }

    public void internalChange(ConfigElementData element) throws SrCommunicationException, SrElementOperationException {
        CommKeyClassId vswitchCommKeyClassId = CommKeyUtil.getVSwitchData(element.getMyFirstSnmpAgentIndex());
        if (element.containParameter(ParameterCode.JOURNAL_VOLUME_ACTIVE_ON_VSWITCH_ID)) {
            CommKeyClassId vswitchActiveOnCommKeyClassId = (CommKeyClassId)element.removeParameter(ParameterCode.JOURNAL_VOLUME_ACTIVE_ON_VSWITCH_ID);
            if (vswitchCommKeyClassId.equals(vswitchActiveOnCommKeyClassId)) {
                element.addParameter(new Parameter(ParameterCode.JOURNAL_VOLUME_ACTIVITY, JournalVolumeActivityConstants.ACTIVE));
            } else {
                element.addParameter(new Parameter(ParameterCode.JOURNAL_VOLUME_ACTIVITY, JournalVolumeActivityConstants.INACTIVE));
            }
        }
        super.internalChange(element);
    }

    protected void readDiscoverPostOperation(ConfigElementData element, CommVarBindList rowList) throws SrCommunicationException {
        super.readDiscoverPostOperation(element, rowList);
        JournalVolumeActivityConstants activeState = (JournalVolumeActivityConstants)element.getValue(ParameterCode.JOURNAL_VOLUME_ACTIVITY);
        if (activeState != null && activeState.equals(JournalVolumeActivityConstants.ACTIVE)) {
            element.addParameter(new Parameter(ParameterCode.JOURNAL_VOLUME_ACTIVE_ON_VSWITCH_ID, CommKeyUtil.getVSwitchData(element.getMyFirstSnmpAgentIndex())));
        }
    }

    protected void trapProccessingPostOperation(ConfigElementData element, SrTrap trap) {
        try {
            super.trapProccessingPostOperation(element, trap);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        if (trap.getTrapType().getTrapId() != 24) {
            throw new UnsupportedOperationException("Operation not supported for trap " + trap.toString());
        }
        LogMgr.getServerLog().debug("JournalVolumeConfigurator: Journal volume load above threshold !");
        SrEventHandler.getEventMgr().sendChangeElementEvent(element);
    }

    protected CommItem getCommItemForTrapCommKey(SrTrap trap) {
        switch (trap.getTrapType().getTrapId()) {
            case 24: {
                return MibItem.JOURNAL_VOLUME_PRECENT_UTILIZATION;
            }
        }
        return super.getCommItemForTrapCommKey(trap);
    }

    public ConfigElementDataList refreshJournalVolumesTable(char snmpAgentIndex) {
        ConfigElementDataList virtVolList = new ConfigElementDataList();
        try {
            VolumeConfigurator volumeConfigurator = new VolumeConfigurator();
            virtVolList = volumeConfigurator.getAllExtended(snmpAgentIndex, null, CheckListConfigElementData.NO_CHECK_LIST_NEEDED);
            if (virtVolList.size() > 0) {
                this.removeNonJournalVolumesFromList(virtVolList);
            }
            return virtVolList;
        }
        catch (SrCommunicationException e) {
            LogMgr.getServerLog().debug("Failed to refresh journal volumes table after pair creation");
            return virtVolList;
        }
    }

    private void removeNonJournalVolumesFromList(ConfigElementDataList virtVolList) {
        ConfigElementDataList journalVolList = new ConfigElementDataList();
        for (int index = 0; index < virtVolList.size(); ++index) {
            ConfigElementData element = virtVolList.getConfigElementDataAt(index);
            if (!element.getClassId().equals(ClassID.JOURNAL_VOLUME)) continue;
            journalVolList.add(element);
        }
        virtVolList.clear();
        virtVolList.addAll((Collection)journalVolList);
    }
}

