/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr.threads;

import com.sanrad.log.LogMgr;
import com.sanrad.nms.server.comm.exception.SrCommunicationException;
import com.sanrad.nms.server.comm.snmp.exception.SrSnmpTimeoutException;
import com.sanrad.nms.server.event.SrCreateElementFailedEvent;
import com.sanrad.nms.server.event.SrEventHandler;
import com.sanrad.nms.server.event.SrVolumeOperationFailedEvent;
import com.sanrad.nms.server.exception.MissingValueException;
import com.sanrad.nms.server.exception.SrElementOperationErrorException;
import com.sanrad.nms.server.exception.SrElementOperationFailedException;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.threads.SrThread;
import com.sanrad.nms.server.mgr.threads.SrThreadCreationException;
import com.sanrad.nms.server.mgr.threads.ThreadType;
import com.sanrad.nms.server.mgr.volume.VolumeOperationConfigurator;
import com.sanrad.nms.server.util.CommKeyUtil;
import com.sanrad.nms.server.util.types.SrDateAndTime;
import com.sanrad.nms.server.util.types.constants.VolumeOperationType;

public class VolumeOperationThread
extends SrThread {
    SrDateAndTime timeOperSentToVSwitch;
    VolumeOperationType myOperType;

    public VolumeOperationThread(ConfigElementData element, VolumeOperationType volOperType) throws SrThreadCreationException {
        super(element, "VolumeOperation", ThreadType.VOL_OPERATION_THREAD_TYPE);
        this.myOperType = volOperType;
    }

    public void setTimeSentToVSwtich(Long time) {
        this.timeOperSentToVSwitch = new SrDateAndTime(time);
    }

    public void setTimeSentToVSwtich(SrDateAndTime time) {
        this.timeOperSentToVSwitch = time;
    }

    public SrDateAndTime getTimeSentToVSwtich() {
        return this.timeOperSentToVSwitch;
    }

    public void run() {
        this.operationThreadManageSupportFromThreadMgr();
        VolumeOperationConfigurator operConfig = new VolumeOperationConfigurator();
        boolean operationFailed = false;
        try {
            operConfig.operate(this.m_Element, this.myOperType);
            operConfig.postOperate(this.m_Element, this.myOperType);
        }
        catch (SrSnmpTimeoutException e) {
            LogMgr.getServerLog().error("Timeout while changing " + this.m_Element.getClassId().toString() + " CommKey is: " + CommKeyUtil.getKeyForMessage(this.m_Element.getCommKey()));
            this.sendTimeOutEvent(this, e);
            operationFailed = true;
        }
        catch (SrCommunicationException e) {
            LogMgr.getServerLog().debug("Operation " + this.myOperType.toString() + " Failed for " + this.m_Element.getClassId().toString() + " CommKey is: " + CommKeyUtil.getKeyForMessage(this.m_Element.getCommKey()), e);
            operationFailed = true;
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            LogMgr.getServerLog().debug("Operation " + this.myOperType.toString() + " Failed for " + this.m_Element.getClassId().toString() + " CommKey is: " + CommKeyUtil.getKeyForMessage(this.m_Element.getCommKey()) + ". Got null value", e);
            operationFailed = true;
        }
        catch (SrElementOperationErrorException e) {
            LogMgr.getServerLog().debug("Operation" + this.myOperType.toString() + "completed wirh Error " + this.m_Element.getClassId().toString() + " CommKey is: " + CommKeyUtil.getKeyForMessage(this.m_Element.getCommKey()), e);
            this.operationThreadDoneSupportFromThreadMgr();
            return;
        }
        catch (SrElementOperationFailedException ex) {
            LogMgr.getServerLog().debug(ex);
            SrCreateElementFailedEvent event = new SrCreateElementFailedEvent((Object)this, ex.getElement());
            SrEventHandler.getEventMgr().sendElementOperationEvent(event);
            this.operationThreadDoneSupportFromThreadMgr();
            return;
        }
        catch (MissingValueException e) {
            LogMgr.getServerLog().debug("ERROR !!!!" + e.getMessage(), e);
            LogMgr.getServerLog().error(e);
            operationFailed = true;
        }
        catch (Exception e) {
            LogMgr.getServerLog().error(e);
            LogMgr.getServerLog().debug("Operation " + this.myOperType.toString() + " Failed for " + this.m_Element.getClassId().toString() + " CommKey is: " + CommKeyUtil.getKeyForMessage(this.m_Element.getCommKey()));
            operationFailed = true;
        }
        if (operationFailed) {
            SrVolumeOperationFailedEvent event = new SrVolumeOperationFailedEvent((Object)this, this.m_Element);
            SrEventHandler.getEventMgr().sendElementOperationEvent(event);
        }
        this.operationThreadDoneSupportFromThreadMgr();
    }
}

