/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr.threads;

import com.sanrad.nms.server.mgr.VSwitchConfigurator;
import com.sanrad.nms.server.mgr.threads.AgentThreadMgr;
import com.sanrad.nms.server.util.CommKeyClassId;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;

public class ThreadMgr {
    private static ThreadMgr m_theInstance = new ThreadMgr();
    private static Vector m_agentThreadMgrs = new Vector();
    private HashMap currentThreads = new HashMap();
    private HashMap threadNotifiers = new HashMap();

    private ThreadMgr() {
    }

    public static ThreadMgr getInstance() {
        return m_theInstance;
    }

    public void addAgentThreadMgr(char agentIndex) {
        AgentThreadMgr agentThreadMgr = new AgentThreadMgr(agentIndex);
        m_agentThreadMgrs.add(agentThreadMgr);
    }

    public void removeAgentThreadMgr(char agentIndex) {
        AgentThreadMgr agentThreadMgr = this.getAgentThreadMgr(agentIndex);
        m_agentThreadMgrs.remove(agentThreadMgr);
    }

    public AgentThreadMgr getAgentThreadMgr(char agentIndex) {
        for (int index = 0; index < m_agentThreadMgrs.size(); ++index) {
            AgentThreadMgr agentThreadMgr = (AgentThreadMgr)m_agentThreadMgrs.elementAt(index);
            if (agentThreadMgr.getAgentIndex() != agentIndex) continue;
            return agentThreadMgr;
        }
        return null;
    }

    public synchronized void addThread(CommKeyClassId vswitchData) {
        if (vswitchData != null) {
            HashSet<Thread> threads = (HashSet<Thread>)this.currentThreads.get(vswitchData);
            if (threads == null) {
                threads = new HashSet<Thread>();
                this.currentThreads.put(vswitchData, threads);
            }
            threads.add(Thread.currentThread());
        }
    }

    public synchronized void removeThread(CommKeyClassId vswitchData) {
        if (vswitchData != null) {
            HashSet vsConfList;
            HashSet threads = (HashSet)this.currentThreads.get(vswitchData);
            boolean notify = false;
            if (threads == null) {
                notify = true;
            } else {
                threads.remove(Thread.currentThread());
                if (threads.isEmpty()) {
                    this.currentThreads.remove(vswitchData);
                    notify = true;
                }
            }
            if (notify && (vsConfList = (HashSet)this.threadNotifiers.remove(vswitchData)) != null) {
                Iterator i = vsConfList.iterator();
                while (i.hasNext()) {
                    VSwitchConfigurator vsConfigurator = (VSwitchConfigurator)i.next();
                    vsConfigurator.notifyVswitchNotBusy();
                }
            }
        }
    }

    public synchronized boolean isVswitchBusy(CommKeyClassId vswitchData) {
        return this.currentThreads.get(vswitchData) != null;
    }

    public synchronized void addVswitchBusyNotifier(CommKeyClassId vswitchData, VSwitchConfigurator conf) {
        if (vswitchData != null) {
            HashSet<VSwitchConfigurator> vsConfList = (HashSet<VSwitchConfigurator>)this.threadNotifiers.get(vswitchData);
            if (vsConfList == null) {
                vsConfList = new HashSet<VSwitchConfigurator>();
                this.threadNotifiers.put(vswitchData, vsConfList);
            }
            vsConfList.add(conf);
        }
    }
}

