/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr.threads;

import com.sanrad.log.LogMgr;
import com.sanrad.nms.server.comm.snmp.exception.SrSnmpTimeoutException;
import com.sanrad.nms.server.event.SnmpErrorEvent;
import com.sanrad.nms.server.event.SrEventHandler;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.threads.AgentThreadMgr;
import com.sanrad.nms.server.mgr.threads.SrThreadCreationException;
import com.sanrad.nms.server.mgr.threads.ThreadMgr;
import com.sanrad.nms.server.mgr.threads.ThreadType;
import com.sanrad.nms.server.util.CommKeyUtil;

public abstract class SrThread
extends Thread {
    protected char INITIAL_AGENT_INDEX = (char)78;
    protected ConfigElementData m_Element = null;
    private static int s_threadIndex = 0;
    private ThreadType m_Type = null;

    public SrThread(ConfigElementData element, String title, ThreadType type) throws SrThreadCreationException {
        super(title + s_threadIndex++);
        this.m_Element = element;
        this.m_Type = type;
        LogMgr.getServerLog().debug("Thread type " + type + " " + title + " for element " + element + " was created");
    }

    public SrThread(String title, ThreadType type) {
        super(title + s_threadIndex++);
        this.m_Type = type;
    }

    public SrThread(ThreadType type) {
        this.m_Type = type;
    }

    protected void sendTimeOutEvent(Object source, SrSnmpTimeoutException e) {
        SnmpErrorEvent event = new SnmpErrorEvent(source, e.getMessage(), e.getVSwitchData(), this.m_Element, 1);
        SrEventHandler.getSnmpErrorMgr().sendSnmpTimeOutEvent(event);
    }

    public ThreadType getType() {
        return this.m_Type;
    }

    public ConfigElementData getCfgElementData() {
        return this.m_Element;
    }

    protected final void operationThreadManageSupportFromThreadMgr() {
        this.operationThreadManageSupportFromThreadMgr(this.m_Element);
        ThreadMgr.getInstance().addThread(CommKeyUtil.getVSwitchData(this.getAgentIndex()));
    }

    protected final void operationThreadManageSupportFromThreadMgr(ConfigElementData element) {
        AgentThreadMgr atm = this.getAgentThreadMgr();
        if (atm != null) {
            atm.manageOperationThread(element.getClassId());
        }
    }

    protected void operationThreadDoneSupportFromThreadMgr() {
        this.operationThreadDoneSupportFromThreadMgr(this.m_Element);
        ThreadMgr.getInstance().removeThread(CommKeyUtil.getVSwitchData(this.getAgentIndex()));
    }

    protected void operationThreadDoneSupportFromThreadMgr(ConfigElementData element) {
        AgentThreadMgr atm = this.getAgentThreadMgr();
        if (atm != null) {
            atm.operationThreadDoneProcess(element.getClassId());
        }
    }

    protected char getAgentIndex() {
        char agentIndex = this.INITIAL_AGENT_INDEX;
        try {
            agentIndex = this.m_Element.getMyFirstSnmpAgentIndex();
        }
        catch (Exception e) {
            try {
                agentIndex = this.m_Element.getSnmpAgentFromParameter();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return agentIndex;
    }

    protected AgentThreadMgr getAgentThreadMgr() {
        AgentThreadMgr atm = null;
        char agentIndex = this.getAgentIndex();
        if (agentIndex != this.INITIAL_AGENT_INDEX && (atm = ThreadMgr.getInstance().getAgentThreadMgr(agentIndex)) == null) {
            LogMgr.getServerLog().warning(this.m_Element.getClassId() + " - AgentThreadMgr is null for agaent " + CommKeyUtil.getVSwitchData(this.getAgentIndex()));
        }
        return atm;
    }
}

