/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr.threads;

import com.sanrad.log.Log;
import com.sanrad.log.LogMgr;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.ConfigElementDataList;
import com.sanrad.nms.server.mgr.threads.SrThread;
import com.sanrad.nms.server.mgr.threads.ThreadType;
import java.util.Iterator;

public abstract class SetElementThread
extends SrThread {
    protected static Log logger = LogMgr.getServerLog();
    protected ConfigElementDataList m_elementList;

    public SetElementThread(String title, ThreadType type) {
        super(title, type);
    }

    public SetElementThread(ConfigElementDataList elementList, String title, ThreadType type) {
        super(title, type);
        this.m_elementList = elementList;
    }

    protected void setElementList(ConfigElementDataList elementList) {
        this.m_elementList = elementList;
    }

    public void run() {
        ConfigElementData element;
        this.m_Element = element = this.m_elementList.getConfigElementDataAt(0);
        this.setOperationProcessStarted();
        try {
            Iterator i = this.m_elementList.iterator();
            while (i.hasNext()) {
                this.runElement((ConfigElementData)i.next());
            }
        }
        catch (Throwable th) {
            logger.error(th);
        }
        this.setOperationProcessDone();
    }

    protected char getAgentIndex() {
        char agentIndex = this.INITIAL_AGENT_INDEX;
        if (this.m_elementList != null && !this.m_elementList.isEmpty()) {
            ConfigElementData element = this.m_elementList.getConfigElementDataAt(0);
            try {
                agentIndex = element.getMyFirstSnmpAgentIndex();
            }
            catch (Exception e) {
                try {
                    agentIndex = element.getSnmpAgentFromParameter();
                }
                catch (Exception eNew) {
                    // empty catch block
                }
            }
        }
        return agentIndex;
    }

    protected abstract void runElement(ConfigElementData var1);

    protected abstract void setOperationProcessStarted();

    protected abstract void setOperationProcessDone();
}

