/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr.threads;

import com.sanrad.log.LogMgr;
import com.sanrad.nms.server.comm.exception.SrCommunicationException;
import com.sanrad.nms.server.comm.snmp.exception.SrSnmpTimeoutException;
import com.sanrad.nms.server.event.SrEventHandler;
import com.sanrad.nms.server.event.SrRemoveElementFailedEvent;
import com.sanrad.nms.server.exception.MissingValueException;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.ConfigElementDataList;
import com.sanrad.nms.server.mgr.DataMgr;
import com.sanrad.nms.server.mgr.ElementConfigurator;
import com.sanrad.nms.server.mgr.threads.SetElementThread;
import com.sanrad.nms.server.mgr.threads.SrThreadCreationException;
import com.sanrad.nms.server.mgr.threads.ThreadMgr;
import com.sanrad.nms.server.mgr.threads.ThreadType;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.CommKeyUtil;
import com.sanrad.nms.server.util.Parameter;
import com.sanrad.nms.server.util.ParameterCode;

public class RemoveElementThread
extends SetElementThread {
    public RemoveElementThread(ConfigElementDataList elementList) {
        super(elementList, "RemoveElement", ThreadType.REMOVE_ELEMENT_THREAD_TYPE);
    }

    public RemoveElementThread(ConfigElementData element) throws SrThreadCreationException {
        super("RemoveElement", ThreadType.REMOVE_ELEMENT_THREAD_TYPE);
        ConfigElementDataList eList = new ConfigElementDataList();
        eList.add(element);
        this.setElementList(eList);
    }

    protected void runElement(ConfigElementData element) {
        ElementConfigurator config = DataMgr.getElementConfigFromElementData(element);
        if (!element.getClassId().equals(ClassID.CLUSTER) && !element.getClassId().equals(ClassID.SITE)) {
            char snmpAgentIndex = element.getMyFirstSnmpAgentIndex();
            CommKeyClassId vSwithcData = CommKeyUtil.getVSwitchData(snmpAgentIndex);
            element.addParameter(new Parameter(ParameterCode.VSWITCH_ID, vSwithcData));
        }
        boolean operationFailed = false;
        try {
            config.internalRemove(element);
        }
        catch (SrSnmpTimeoutException e) {
            LogMgr.getServerLog().error("Timeout while changing " + element.getClassId().toString() + " CommKey is: " + CommKeyUtil.getKeyForMessage(element.getCommKey()));
            this.sendTimeOutEvent(this, e);
            operationFailed = true;
        }
        catch (SrCommunicationException e) {
            LogMgr.getServerLog().debug("Failed to Remove " + element.getClassId().toString() + " CommKey is: " + CommKeyUtil.getKeyForMessage(element.getCommKey()), e);
            operationFailed = true;
        }
        catch (MissingValueException e) {
            LogMgr.getServerLog().warning("ERROR !!!!" + e.getMessage(), e);
            logger.error(e);
            operationFailed = true;
        }
        catch (Exception e) {
            LogMgr.getServerLog().warning("Failed to Remove " + element.getClassId().toString() + " CommKey is: " + CommKeyUtil.getKeyForMessage(element.getCommKey()), e);
            logger.error(e);
            operationFailed = true;
        }
        if (operationFailed) {
            SrRemoveElementFailedEvent event = new SrRemoveElementFailedEvent((Object)this, element);
            SrEventHandler.getEventMgr().sendElementOperationEvent(event);
            return;
        }
        LogMgr.getServerLog().debug("Remove completed for " + element.getClassId().toString() + " CommKey is: " + CommKeyUtil.getKeyForMessage(element.getCommKey()));
        SrEventHandler.getEventMgr().sendRemoveElementEvent(element);
        try {
            config.postSendRemoveEvent(element);
        }
        catch (SrSnmpTimeoutException e) {
            LogMgr.getServerLog().error("Timeout while changing " + element.getClassId().toString() + " CommKey is: " + CommKeyUtil.getKeyForMessage(element.getCommKey()));
            this.sendTimeOutEvent(this, e);
            operationFailed = true;
        }
        catch (SrCommunicationException e) {
            LogMgr.getServerLog().debug("Failed to operate post send remove event operation " + element.getClassId().toString() + " CommKey is: " + CommKeyUtil.getKeyForMessage(element.getCommKey()), e);
        }
    }

    protected void setOperationProcessStarted() {
        if (!this.m_elementList.isEmpty()) {
            boolean isVswitch = false;
            int i = this.m_elementList.size();
            while (i-- > 0) {
                ConfigElementData element = this.m_elementList.getConfigElementDataAt(i);
                if (!element.getClassId().equals(ClassID.VSWITCH)) continue;
                isVswitch = true;
                break;
            }
            if (!isVswitch) {
                ConfigElementData element = this.m_elementList.getConfigElementDataAt(0);
                this.operationThreadManageSupportFromThreadMgr(element);
                ThreadMgr.getInstance().addThread(element.getVswitchId());
            }
        }
    }

    protected void setOperationProcessDone() {
        if (!this.m_elementList.isEmpty()) {
            ConfigElementData vsElement = null;
            int i = this.m_elementList.size();
            while (i-- > 0) {
                ConfigElementData element = this.m_elementList.getConfigElementDataAt(i);
                if (!element.getClassId().equals(ClassID.VSWITCH)) continue;
                vsElement = element;
            }
            if (vsElement != null) {
                ThreadMgr.getInstance().removeAgentThreadMgr(vsElement.getMyFirstSnmpAgentIndex());
            } else {
                ConfigElementData element = this.m_elementList.getConfigElementDataAt(0);
                this.operationThreadDoneSupportFromThreadMgr(element);
                ThreadMgr.getInstance().removeThread(element.getVswitchId());
            }
        }
    }
}

