/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr.threads;

import com.sanrad.log.LogMgr;
import com.sanrad.nms.server.comm.exception.SrCommunicationException;
import com.sanrad.nms.server.comm.snmp.exception.SrSnmpTimeoutException;
import com.sanrad.nms.server.event.SrEventHandler;
import com.sanrad.nms.server.event.SrReadElementFailedEvent;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.ConfigElementDataList;
import com.sanrad.nms.server.mgr.DataMgr;
import com.sanrad.nms.server.mgr.ElementConfigurator;
import com.sanrad.nms.server.mgr.threads.SrThread;
import com.sanrad.nms.server.mgr.threads.SrThreadCreationException;
import com.sanrad.nms.server.mgr.threads.ThreadType;
import com.sanrad.nms.server.util.CommKeyUtil;
import com.sanrad.nms.server.util.SnmpCommKey;

public class RefreshFieldsThread
extends SrThread {
    public RefreshFieldsThread(ConfigElementData element) throws SrThreadCreationException {
        super(element, "RefreshFieldsThread", ThreadType.REFRESH_FIELDS_THREAD_TYPE);
    }

    public void run() {
        this.operationThreadManageSupportFromThreadMgr();
        ElementConfigurator config = DataMgr.getElementConfigFromElementData(this.m_Element);
        boolean operationFailed = false;
        ConfigElementDataList allData = null;
        try {
            allData = config.refreshTableFields(this.m_Element);
        }
        catch (SrSnmpTimeoutException e) {
            LogMgr.getServerLog().error(e.getMessage() + " - Timeout while changing " + this.m_Element.getClassId().toString() + " CommKey is: " + CommKeyUtil.getKeyForMessage(this.m_Element.getCommKey()));
            this.sendTimeOutEvent(this, e);
            this.operationThreadDoneSupportFromThreadMgr();
            return;
        }
        catch (SrCommunicationException e) {
            LogMgr.getServerLog().debug("Failed to Read data of " + this.m_Element.getClassId().toString() + " CommKey is: " + CommKeyUtil.getKeyForMessage(this.m_Element.getCommKey()), e);
            operationFailed = true;
        }
        catch (Exception e) {
            LogMgr.getServerLog().debug("Failed to Read data of " + this.m_Element.getClassId().toString() + " CommKey is: " + CommKeyUtil.getKeyForMessage(this.m_Element.getCommKey()), e);
            LogMgr.getServerLog().error(e);
            operationFailed = true;
        }
        if (operationFailed) {
            this.m_Element.setCommKey(new SnmpCommKey("0", this.m_Element.getSnmpAgentFromParameter()));
            SrReadElementFailedEvent event = new SrReadElementFailedEvent((Object)this, this.m_Element);
            SrEventHandler.getEventMgr().sendElementOperationEvent(event);
        } else {
            SrEventHandler.getEventMgr().sendChangeElementEvent(allData);
        }
        this.operationThreadDoneSupportFromThreadMgr();
    }
}

