/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr.threads;

import com.sanrad.log.LogMgr;
import com.sanrad.nms.server.comm.exception.SrCommunicationException;
import com.sanrad.nms.server.comm.snmp.exception.SrSnmpTimeoutException;
import com.sanrad.nms.server.event.SrEventHandler;
import com.sanrad.nms.server.event.SrReadElementFailedEvent;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.DataMgr;
import com.sanrad.nms.server.mgr.ElementConfigurator;
import com.sanrad.nms.server.mgr.threads.SrThread;
import com.sanrad.nms.server.mgr.threads.SrThreadCreationException;
import com.sanrad.nms.server.mgr.threads.ThreadType;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.CommKeyUtil;
import com.sanrad.nms.server.util.Parameter;
import com.sanrad.nms.server.util.ParameterCode;

public class ReadFieldsThread
extends SrThread {
    public ReadFieldsThread(ConfigElementData element) throws SrThreadCreationException {
        super(element, "ReadFieldsThread", ThreadType.READ_FIELDS_THREAD_TYPE);
        try {
            char agentIndex = this.m_Element.getMyFirstSnmpAgentIndex();
        }
        catch (Exception e) {
            char agentIndex = this.m_Element.getSnmpAgentFromParameter();
        }
    }

    public void run() {
        ClassID classId = this.m_Element.getClassId();
        char snmpAgentIndex = this.getAgentIndex();
        this.operationThreadManageSupportFromThreadMgr();
        CommKeyClassId vSwithcData = CommKeyUtil.getVSwitchData(snmpAgentIndex);
        this.m_Element.addParameter(new Parameter(ParameterCode.VSWITCH_ID, vSwithcData));
        ElementConfigurator config = DataMgr.getElementConfigFromElementData(this.m_Element);
        boolean operationFailed = false;
        try {
            config.internalReadFields(this.m_Element);
        }
        catch (SrSnmpTimeoutException e) {
            LogMgr.getServerLog().error(e.getMessage() + " - Timeout while changing " + this.m_Element.getClassId().toString() + " CommKey is: " + CommKeyUtil.getKeyForMessage(this.m_Element.getCommKey()));
            this.sendTimeOutEvent(this, e);
            operationFailed = true;
        }
        catch (SrCommunicationException e) {
            LogMgr.getServerLog().debug("Failed to Read data of " + this.m_Element.getClassId().toString() + " CommKey is: " + CommKeyUtil.getKeyForMessage(this.m_Element.getCommKey()), e);
            operationFailed = true;
        }
        catch (NullPointerException e) {
            if (vSwithcData != null && CommKeyUtil.getSnmpCommKey(vSwithcData) != null) {
                LogMgr.getServerLog().debug("Failed to Read data of " + this.m_Element.getClassId().toString() + " CommKey is: " + CommKeyUtil.getKeyForMessage(this.m_Element.getCommKey()) + ". Got null value", e);
                LogMgr.getServerLog().error(e);
                operationFailed = true;
            } else {
                LogMgr.getServerLog().error("ReadFieldsThread was called even though " + ClassID.VSWITCH + " " + vSwithcData + " does not exist");
            }
        }
        catch (Exception e) {
            LogMgr.getServerLog().debug("Failed to Read data of " + this.m_Element.getClassId().toString() + " CommKey is: " + CommKeyUtil.getKeyForMessage(this.m_Element.getCommKey()) + ". Got null value", e);
            LogMgr.getServerLog().error(e);
            operationFailed = true;
        }
        if (operationFailed) {
            SrReadElementFailedEvent event = new SrReadElementFailedEvent((Object)this, this.m_Element);
            SrEventHandler.getEventMgr().sendElementOperationEvent(event);
        } else {
            SrEventHandler.getEventMgr().sendReadElementEvent(this.m_Element);
        }
        this.operationThreadDoneSupportFromThreadMgr();
    }
}

