/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr.threads;

import com.sanrad.log.Log;
import com.sanrad.log.LogMgr;
import com.sanrad.nms.server.comm.CommMgr;
import com.sanrad.nms.server.comm.CommVarBindList;
import com.sanrad.nms.server.comm.exception.SrCommunicationException;
import com.sanrad.nms.server.mgr.ElementConfigurator;
import com.sanrad.nms.server.mgr.operation.ElementOperation;
import com.sanrad.nms.server.mgr.operation.ElementOperationList;
import com.sanrad.nms.server.mgr.threads.SrThread;
import com.sanrad.nms.server.mgr.threads.SrThreadCreationException;
import com.sanrad.nms.server.mgr.threads.ThreadType;
import java.util.Vector;

public class MultiOperationsThread
extends SrThread {
    private ElementOperationList operationList;
    static Log logger = LogMgr.getServerLog();

    public MultiOperationsThread(ElementOperationList operationList) throws SrThreadCreationException {
        super("MultiChanges", ThreadType.MULTI_CHANGES_THREAD_TYPE);
        this.operationList = operationList;
    }

    public void run() {
        logger.debug("MultiOperationThread is running.");
        this.operationThreadManageSupportFromThreadMgr(((ElementOperation)this.operationList.get(0)).getElement());
        this.executeOperations();
        this.operationThreadDoneSupportFromThreadMgr(((ElementOperation)this.operationList.get(0)).getElement());
    }

    private CommVarBindList getCommVarBindsList(Vector configurators) {
        CommVarBindList varBinds = new CommVarBindList();
        try {
            for (int i = 0; i < configurators.size(); ++i) {
                ElementConfigurator config = (ElementConfigurator)configurators.get(i);
                ElementOperation operation = (ElementOperation)this.operationList.get(i);
                varBinds.add(operation.getVarBindsForElement(config));
            }
            ElementOperation operation = (ElementOperation)this.operationList.get(0);
            char c = operation.getElement().getMyFirstSnmpAgentIndex();
            this.operationList.setVswitchIndex(c);
            logger.debug("MultiOperationThread- got all varbinds.");
        }
        catch (SrCommunicationException sce) {
            LogMgr.getServerLog().debug(sce);
            return null;
        }
        return varBinds;
    }

    private void executeOperations() {
        boolean operationFailed = false;
        Vector configurators = this.operationList.getAllConfigurators();
        CommVarBindList varBinds = this.getCommVarBindsList(configurators);
        if (varBinds == null) {
            logger.debug("MultiOperationsThread - could not get the varbinds...");
            return;
        }
        try {
            logger.debug("MultiOperationThread- setting the varbinds list.");
            CommMgr.getInstance(this.operationList.getVswitchIndex()).setList(varBinds, this.operationList.getVswitchIndex());
        }
        catch (SrCommunicationException e) {
            logger.debug("Failed to Create multi-operations ", e);
            operationFailed = true;
        }
        catch (Exception e) {
            LogMgr.getServerLog().debug(e);
            operationFailed = true;
        }
        if (operationFailed) {
            return;
        }
        try {
            for (int i = 0; i < configurators.size(); ++i) {
                ElementConfigurator config = (ElementConfigurator)configurators.get(i);
                ElementOperation operation = (ElementOperation)this.operationList.get(i);
                operation.postMultiOperationsExecution(config);
            }
        }
        catch (SrCommunicationException ex) {
            logger.debug("MultiOperationsThread - failed to perform the 'post multi-operations execusion'", ex);
        }
    }
}

