/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr.threads;

import com.sanrad.log.LogMgr;
import com.sanrad.nms.server.comm.exception.SrCommunicationException;
import com.sanrad.nms.server.comm.snmp.exception.SrSnmpTimeoutException;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.DataMgr;
import com.sanrad.nms.server.mgr.ElementConfigurator;
import com.sanrad.nms.server.mgr.threads.SrThread;
import com.sanrad.nms.server.mgr.threads.SrThreadCreationException;
import com.sanrad.nms.server.mgr.threads.ThreadType;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.CommKeyUtil;

public class DiscoverElementThread
extends SrThread {
    public DiscoverElementThread(ConfigElementData element, String name) throws SrThreadCreationException {
        super(element, name, ThreadType.VSWITCH_DISCOVER_THREAD_TYPE);
    }

    public void run() {
        ElementConfigurator config = DataMgr.getElementConfigFromElementData(this.m_Element);
        try {
            CommKeyClassId vSwitchData = new CommKeyClassId(this.m_Element.getCommKey(), ClassID.VSWITCH);
            config.discover(vSwitchData);
        }
        catch (SrSnmpTimeoutException e) {
            LogMgr.getServerLog().error("Timeout while changing " + this.m_Element.getClassId().toString() + " CommKey is: " + CommKeyUtil.getKeyForMessage(this.m_Element.getCommKey()));
            this.sendTimeOutEvent(this, e);
            return;
        }
        catch (SrCommunicationException e) {
            LogMgr.getServerLog().debug("Failed to Discover " + this.m_Element.getClassId().toString() + " CommKey is: " + CommKeyUtil.getKeyForMessage(this.m_Element.getCommKey()), e);
            return;
        }
        LogMgr.getServerLog().debug("Discover completed for " + this.m_Element.getClassId().toString() + " CommKey is: " + CommKeyUtil.getKeyForMessage(this.m_Element.getCommKey()));
    }
}

