/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr.threads;

import com.sanrad.log.LogMgr;
import com.sanrad.nms.server.comm.exception.SrCommunicationException;
import com.sanrad.nms.server.comm.snmp.exception.SrSnmpTimeoutException;
import com.sanrad.nms.server.event.SrCreateElementErrorEvent;
import com.sanrad.nms.server.event.SrCreateElementFailedEvent;
import com.sanrad.nms.server.event.SrEventHandler;
import com.sanrad.nms.server.exception.MissingValueException;
import com.sanrad.nms.server.exception.SrElementOperationErrorException;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.ConfigElementDataList;
import com.sanrad.nms.server.mgr.DataMgr;
import com.sanrad.nms.server.mgr.ElementConfigurator;
import com.sanrad.nms.server.mgr.threads.SetElementThread;
import com.sanrad.nms.server.mgr.threads.ThreadMgr;
import com.sanrad.nms.server.mgr.threads.ThreadType;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyUtil;

public class CreateElementThread
extends SetElementThread {
    public CreateElementThread(ConfigElementDataList elementList) {
        super(elementList, "CreateElement", ThreadType.CREATE_ELEMENT_THREAD_TYPE);
    }

    public CreateElementThread(ConfigElementData element) {
        super("CreateElement", ThreadType.CREATE_ELEMENT_THREAD_TYPE);
        ConfigElementDataList eList = new ConfigElementDataList();
        eList.add(element);
        this.setElementList(eList);
    }

    protected void runElement(ConfigElementData element) {
        ClassID classIdCreated = element.getClassId();
        ElementConfigurator config = DataMgr.getElementConfigFromElementData(element);
        boolean operationFailed = false;
        try {
            config.internalCreate(element);
        }
        catch (SrSnmpTimeoutException e) {
            LogMgr.getServerLog().error("Timeout while changing " + element.getClassId().toString() + " CommKey is: " + CommKeyUtil.getKeyForMessage(element.getCommKey()));
            this.sendTimeOutEvent(this, e);
            return;
        }
        catch (SrCommunicationException e) {
            LogMgr.getServerLog().debug("Failed to Create " + element.getClassId().toString() + " CommKey is: " + CommKeyUtil.getKeyForMessage(element.getCommKey()), e);
            operationFailed = true;
        }
        catch (SrElementOperationErrorException e) {
            LogMgr.getServerLog().debug("Element created with Error " + element.getClassId().toString() + " CommKey is: " + CommKeyUtil.getKeyForMessage(element.getCommKey()));
            SrCreateElementErrorEvent errorInCreateEvent = new SrCreateElementErrorEvent(e.getSource(), e.getElement(), e.getErrorParams());
            SrEventHandler.getEventMgr().sendElementOperationEvent(errorInCreateEvent);
            return;
        }
        catch (MissingValueException e) {
            LogMgr.getServerLog().debug("ERROR !!!!" + e.getMessage(), e);
            logger.error(e);
            operationFailed = true;
        }
        catch (Exception e) {
            logger.error(e);
            LogMgr.getServerLog().warning("Failed to Create " + element.getClassId().toString() + " CommKey is: " + CommKeyUtil.getKeyForMessage(element.getCommKey()), e);
            operationFailed = true;
        }
        if (operationFailed) {
            SrCreateElementFailedEvent event = new SrCreateElementFailedEvent((Object)this, element);
            SrEventHandler.getEventMgr().sendElementOperationEvent(event);
            return;
        }
        boolean isElementSentByEvent = false;
        try {
            isElementSentByEvent = config.readAfterCreate(element);
            if (!isElementSentByEvent) {
                SrEventHandler.getEventMgr().sendAddElementEvent(element);
            }
            config.postSendCreateEvent(element);
        }
        catch (SrSnmpTimeoutException e) {
            LogMgr.getServerLog().error("Timeout while changing " + element.getClassId().toString() + " CommKey is: " + CommKeyUtil.getKeyForMessage(element.getCommKey()));
            this.sendTimeOutEvent(this, e);
            return;
        }
        catch (SrCommunicationException e) {
            LogMgr.getServerLog().debug("Failed to Read data of created element " + element.getClassId().toString() + " CommKey is: " + CommKeyUtil.getKeyForMessage(element.getCommKey()), e);
            return;
        }
        catch (Exception e) {
            LogMgr.getServerLog().debug("Failed to Read data of created element " + element.getClassId().toString() + " CommKey is: " + CommKeyUtil.getKeyForMessage(element.getCommKey()), e);
            logger.error(e);
            return;
        }
        LogMgr.getServerLog().debug("Create completed for " + element.getClassId().toString() + " CommKey is: " + CommKeyUtil.getKeyForMessage(element.getCommKey()));
    }

    protected void setOperationProcessDone() {
        ConfigElementData element;
        ClassID classIdCreated;
        if (!(this.m_elementList.isEmpty() || (classIdCreated = (element = this.m_elementList.getConfigElementDataAt(0)).getClassId()).equals(ClassID.SITE) || classIdCreated.equals(ClassID.CLUSTER) || classIdCreated.equals(ClassID.VSWITCH))) {
            this.operationThreadDoneSupportFromThreadMgr(element);
            ThreadMgr.getInstance().removeThread(element.getVswitchId());
        }
    }

    protected void setOperationProcessStarted() {
        ConfigElementData element;
        ClassID classIdCreated;
        if (!(this.m_elementList.isEmpty() || (classIdCreated = (element = this.m_elementList.getConfigElementDataAt(0)).getClassId()).equals(ClassID.SITE) || classIdCreated.equals(ClassID.CLUSTER) || classIdCreated.equals(ClassID.VSWITCH))) {
            this.operationThreadManageSupportFromThreadMgr(element);
            ThreadMgr.getInstance().addThread(element.getVswitchId());
        }
    }
}

