/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr.threads;

import com.sanrad.log.LogMgr;
import com.sanrad.nms.server.comm.exception.SrCommunicationException;
import com.sanrad.nms.server.comm.snmp.exception.SrSnmpTimeoutException;
import com.sanrad.nms.server.event.SnmpErrorEvent;
import com.sanrad.nms.server.event.SrChangeElementErrorEvent;
import com.sanrad.nms.server.event.SrChangeElementFailedEvent;
import com.sanrad.nms.server.event.SrEventHandler;
import com.sanrad.nms.server.exception.SrElementOperationErrorException;
import com.sanrad.nms.server.exception.SrElementOperationException;
import com.sanrad.nms.server.exception.SrElementOperationFailedException;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.ConfigElementDataList;
import com.sanrad.nms.server.mgr.DataMgr;
import com.sanrad.nms.server.mgr.ElementConfigurator;
import com.sanrad.nms.server.mgr.threads.SetElementThread;
import com.sanrad.nms.server.mgr.threads.SrThreadCreationException;
import com.sanrad.nms.server.mgr.threads.ThreadMgr;
import com.sanrad.nms.server.mgr.threads.ThreadType;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.CommKeyUtil;
import com.sanrad.nms.server.util.Parameter;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.constants.ResetConstant;

public class ChangeElementThread
extends SetElementThread {
    public ChangeElementThread(ConfigElementDataList elementList) {
        super(elementList, "ChangeElement", ThreadType.CHANGE_ELEMENT_THREAD_TYPE);
    }

    public ChangeElementThread(ConfigElementData element) throws SrThreadCreationException {
        super("ChangeElement", ThreadType.CHANGE_ELEMENT_THREAD_TYPE);
        ConfigElementDataList eList = new ConfigElementDataList();
        eList.add(element);
        this.setElementList(eList);
    }

    protected void runElement(ConfigElementData element) {
        ElementConfigurator config = DataMgr.getElementConfigFromElementData(element);
        ClassID classId = element.getClassId();
        if (!(classId.equals(ClassID.CLUSTER) || classId.equals(ClassID.SITE) || classId.equals(ClassID.ALARM_TYPE) || classId.equals(ClassID.EMAIL_CONTACT))) {
            char snmpAgentIndex = element.getMyFirstSnmpAgentIndex();
            CommKeyClassId vSwithcData = CommKeyUtil.getVSwitchData(snmpAgentIndex);
            element.addParameter(new Parameter(ParameterCode.VSWITCH_ID, vSwithcData));
        }
        boolean operationFailed = false;
        try {
            config.internalChange(element);
        }
        catch (SrSnmpTimeoutException e) {
            LogMgr.getServerLog().error("Timeout while changing " + element.getClassId().toString() + " CommKey is: " + CommKeyUtil.getKeyForMessage(element.getCommKey()));
            this.sendTimeOutEvent(this, e);
            operationFailed = true;
        }
        catch (SrCommunicationException e) {
            LogMgr.getServerLog().debug("Failed to Change " + element.getClassId().toString() + " CommKey is: " + CommKeyUtil.getKeyForMessage(element.getCommKey()), e);
            operationFailed = true;
        }
        catch (SrElementOperationErrorException e) {
            LogMgr.getServerLog().debug("Element Changed with Error " + element.getClassId().toString() + " CommKey is: " + CommKeyUtil.getKeyForMessage(element.getCommKey()), e);
            SrChangeElementErrorEvent errorInCreateEvent = new SrChangeElementErrorEvent(e.getSource(), e.getElement(), e.getErrorParams());
            SrEventHandler.getEventMgr().sendElementOperationEvent(errorInCreateEvent);
            return;
        }
        catch (SrElementOperationFailedException e) {
            LogMgr.getServerLog().debug("Element Changed with Error " + element.getClassId().toString() + " CommKey is: " + CommKeyUtil.getKeyForMessage(element.getCommKey()), e);
            SrChangeElementFailedEvent errorInCreateEvent = new SrChangeElementFailedEvent(e.getSource(), e.getElement());
            SrEventHandler.getEventMgr().sendElementOperationEvent(errorInCreateEvent);
            return;
        }
        catch (SrElementOperationException e) {
            LogMgr.getServerLog().debug(e);
            this.setOperationProcessDone();
            throw new UnsupportedOperationException("New type of exception - not supported");
        }
        catch (Exception e) {
            LogMgr.getServerLog().warning("Failed to Change " + element.getClassId().toString() + " CommKey is: " + CommKeyUtil.getKeyForMessage(element.getCommKey()) + " Got null value", e);
            logger.error(e);
            operationFailed = true;
        }
        if (operationFailed) {
            SrChangeElementFailedEvent event = new SrChangeElementFailedEvent((Object)this, element);
            SrEventHandler.getEventMgr().sendElementOperationEvent(event);
            return;
        }
        boolean isElementSentByEvent = false;
        try {
            if (!this.isVSwitchShutdown(element)) {
                isElementSentByEvent = config.readAfterChange(element);
                if (!isElementSentByEvent) {
                    SrEventHandler.getEventMgr().sendChangeElementEvent(element);
                }
                config.postChangeOperation(element);
            }
        }
        catch (SrSnmpTimeoutException te) {
            String msg = "SNMP Timeout during Read data of changed element";
            CommKeyClassId vsData = CommKeyUtil.getVSwitchData(element.getMyFirstSnmpAgentIndex());
            SnmpErrorEvent event = new SnmpErrorEvent((Object)this, msg, vsData, 1);
            SrEventHandler.getSnmpErrorMgr().sendSnmpTimeOutEvent(event);
            LogMgr.getServerLog().debug(te.getMessage() + " Failed to Read data of changed element " + element.getClassId().toString() + " CommKey is: " + CommKeyUtil.getKeyForMessage(element.getCommKey()));
            SrEventHandler.getEventMgr().sendChangeElementEvent(element);
            return;
        }
        catch (SrCommunicationException e) {
            LogMgr.getServerLog().debug("Failed to Read data of changed element " + element.getClassId().toString() + " CommKey is: " + CommKeyUtil.getKeyForMessage(element.getCommKey()), e);
            SrEventHandler.getEventMgr().sendChangeElementEvent(element);
            return;
        }
        LogMgr.getServerLog().debug("Change completed for " + element.getClassId().toString() + " CommKey is: " + CommKeyUtil.getKeyForMessage(element.getCommKey()));
    }

    protected void setOperationProcessDone() {
        if (!this.m_elementList.isEmpty()) {
            ConfigElementData element = this.m_elementList.getConfigElementDataAt(0);
            this.operationThreadDoneSupportFromThreadMgr(element);
            ThreadMgr.getInstance().removeThread(element.getVswitchId());
        }
    }

    protected void setOperationProcessStarted() {
        if (!this.m_elementList.isEmpty()) {
            ConfigElementData element = this.m_elementList.getConfigElementDataAt(0);
            this.operationThreadManageSupportFromThreadMgr(element);
            ThreadMgr.getInstance().addThread(element.getVswitchId());
        }
    }

    private boolean isVSwitchShutdown(ConfigElementData element) {
        ResetConstant val;
        ClassID classId = element.getClassId();
        if (classId != null && classId.equals(ClassID.VSWITCH) && (val = (ResetConstant)element.getValue(ParameterCode.VSWITCH_RESET)) != null) {
            return val.equals(ResetConstant.SHUTDOWN) || val.equals(ResetConstant.RESET_HW);
        }
        return false;
    }
}

