/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr.threads;

import com.sanrad.log.LogMgr;
import com.sanrad.nms.server.mgr.polling.PollingGroupType;
import com.sanrad.nms.server.mgr.polling.PollingMgr;
import com.sanrad.nms.server.mgr.threads.SrThreadCreationException;
import com.sanrad.nms.server.util.ClassID;

public class AgentThreadMgr {
    private boolean m_withThreadMgrSupport = true;
    private boolean m_withDebugInfo = false;
    private static final String VSWITCH_DISCOVERY = "VSwitchDiscovery";
    private static final String VSWITCH_VIRT_VOL_DISCOVERY = "VSwitchVirtVolDiscovery";
    private static final String REBUILD = "Rebuild";
    private static final String VOL_VIRTVOL_OPERATION = "Volume/VirtVol operation";
    private static final String ACL_OPERATION = "Acl operation";
    private static final String ISCSI_TARGET_OPERATION = "IscsiTarget operation";
    private static final String VIRT_VOL_POLLING = "VirtPolling";
    private static final String ACL_POLLING = "AclPolling";
    private static final String GENERAL_POLLING = "General Polling";
    private static final String NET_AND_INT_POLLING = "Networking and Interface Polling";
    private static final String STATISTIC_POLLING = "Statistics Polling";
    private char m_agentIndex;
    private boolean m_isVSwitchDiscoveryOnWait = false;
    private boolean m_isVSwitchDiscoveryActive = false;
    private boolean m_isVSwitchVirtVolDiscoveryOnWait = false;
    private boolean m_isVSwitchVirtVolDiscoveryActive = false;
    private boolean m_isOperationsActive = false;
    private boolean m_isVirVolOperationActive = false;
    private boolean m_isDROperationActive = false;
    private boolean m_isAclOperationActive = false;
    private boolean m_isVolumeOperationActive = false;
    private boolean m_isVirtVolPollingActive = false;
    private boolean m_isAclPollingActive = false;
    private boolean m_isOtherPollingActive = false;
    private boolean m_blockTraps = false;
    private int m_numOfVSwitchDiscoveryRunning = 0;
    private int m_numOfVSwitchVirtVolDiscoveryRunning = 0;
    private int m_numOfOperationsRunning = 0;

    public AgentThreadMgr(char agentIndex) {
        this.m_agentIndex = agentIndex;
    }

    public void setAgentIndex(char agentIndex) {
        this.m_agentIndex = agentIndex;
    }

    public char getAgentIndex() {
        return this.m_agentIndex;
    }

    private void printDebugInfo(String debugInfo) {
        if (this.m_withDebugInfo) {
            System.out.println(debugInfo);
        }
    }

    private boolean isVSwitchDiscoveryOnWait(String asked) {
        Thread currThread = Thread.currentThread();
        StringBuffer sb = new StringBuffer(">>>> ");
        sb.append(asked);
        sb.append(": Is ");
        sb.append(ClassID.VSWITCH);
        sb.append(" discovery on wait ? ");
        sb.append(this.m_isVSwitchDiscoveryOnWait);
        sb.append(". Thread asked: name = ");
        sb.append(currThread.getName());
        this.printDebugInfo(sb.toString());
        return this.m_isVSwitchDiscoveryOnWait;
    }

    private boolean isVSwitchDiscoveryActive(String asked) {
        Thread currThread = Thread.currentThread();
        StringBuffer sb = new StringBuffer(">>>> ");
        sb.append(asked);
        sb.append(": Is ");
        sb.append(ClassID.VSWITCH);
        sb.append(" discovery active ? ");
        sb.append(this.m_isVSwitchDiscoveryActive);
        sb.append(". Thread asked: name = ");
        sb.append(currThread.getName());
        this.printDebugInfo(sb.toString());
        return this.m_isVSwitchDiscoveryActive;
    }

    private boolean isVSwitchVirVolDiscoveryOnWait(String asked) {
        Thread currThread = Thread.currentThread();
        StringBuffer sb = new StringBuffer(">>>> ");
        sb.append(asked);
        sb.append(": Is ");
        sb.append(ClassID.VSWITCH);
        sb.append(" virt vol discovery on wait ? ");
        sb.append(this.m_isVSwitchVirtVolDiscoveryOnWait);
        sb.append(". Thread asked: name = ");
        sb.append(currThread.getName());
        this.printDebugInfo(sb.toString());
        return this.m_isVSwitchVirtVolDiscoveryOnWait;
    }

    private boolean isVSwitchVirVolDiscoveryActive(String asked) {
        Thread currThread = Thread.currentThread();
        StringBuffer sb = new StringBuffer(">>>> ");
        sb.append(asked);
        sb.append(": Is ");
        sb.append(ClassID.VSWITCH);
        sb.append(" virt vol discovery on active ? ");
        sb.append(this.m_isVSwitchVirtVolDiscoveryActive);
        sb.append(". Thread asked: name = ");
        sb.append(currThread.getName());
        this.printDebugInfo(sb.toString());
        return this.m_isVSwitchVirtVolDiscoveryActive;
    }

    private boolean isOperationsActive(String asked) {
        Thread currThread = Thread.currentThread();
        StringBuffer sb = new StringBuffer(">>>> ");
        sb.append(asked);
        sb.append(": Is Operation active ? ");
        sb.append(this.m_isOperationsActive);
        sb.append(". Thread asked: name = ");
        sb.append(currThread.getName());
        this.printDebugInfo(sb.toString());
        return this.m_isOperationsActive;
    }

    private boolean isVirtVolOperationActive(String asked) {
        Thread currThread = Thread.currentThread();
        StringBuffer sb = new StringBuffer(">>>> ");
        sb.append(asked);
        sb.append(": Is Virt Vol Operation active ? ");
        sb.append(this.m_isVirVolOperationActive);
        sb.append(". Thread asked: name = ");
        sb.append(currThread.getName());
        this.printDebugInfo(sb.toString());
        return this.m_isVirVolOperationActive;
    }

    private boolean isDROperationActive(String asked) {
        Thread currThread = Thread.currentThread();
        StringBuffer sb = new StringBuffer(">>>> ");
        sb.append(asked);
        sb.append(": Is DR Operation active ? ");
        sb.append(this.m_isDROperationActive);
        sb.append(". Thread asked: name = ");
        sb.append(currThread.getName());
        this.printDebugInfo(sb.toString());
        return this.m_isDROperationActive;
    }

    private boolean isAclOperationActive(String asked) {
        Thread currThread = Thread.currentThread();
        StringBuffer sb = new StringBuffer(">>>> ");
        sb.append(asked);
        sb.append(": Is Acl Operation active ? ");
        sb.append(this.m_isAclOperationActive);
        sb.append(". Thread asked: name = ");
        sb.append(currThread.getName());
        this.printDebugInfo(sb.toString());
        return this.m_isAclOperationActive;
    }

    private boolean isVirtVolPollingActive(String asked) {
        Thread currThread = Thread.currentThread();
        StringBuffer sb = new StringBuffer(">>>> ");
        sb.append(asked);
        sb.append(": Is Virtualization polling active ? ");
        sb.append(this.m_isVirtVolPollingActive);
        sb.append(". Thread asked: name = ");
        sb.append(currThread.getName());
        this.printDebugInfo(sb.toString());
        return this.m_isVirtVolPollingActive;
    }

    private boolean isAclPollingActive(String asked) {
        Thread currThread = Thread.currentThread();
        StringBuffer sb = new StringBuffer(">>>> ");
        sb.append(asked);
        sb.append(": Is Acl polling active ? ");
        sb.append(this.m_isAclPollingActive);
        sb.append(". Thread asked: name = ");
        sb.append(currThread.getName());
        this.printDebugInfo(sb.toString());
        return this.m_isAclPollingActive;
    }

    private boolean isOtherPollingActive(String asked) {
        Thread currThread = Thread.currentThread();
        StringBuffer sb = new StringBuffer(">>>> ");
        sb.append(asked);
        sb.append(": Is Other polling active ? ");
        sb.append(this.m_isOtherPollingActive);
        sb.append(". Thread asked: name = ");
        sb.append(currThread.getName());
        this.printDebugInfo(sb.toString());
        return this.m_isOtherPollingActive;
    }

    private boolean isPollingActive(String asked) {
        this.printDebugInfo(this.getClass() + "::" + "isPollingActive(" + asked);
        boolean result = this.isVirtVolPollingActive(asked) || this.isAclPollingActive(asked) || this.isOtherPollingActive(asked);
        return result;
    }

    private boolean areTrapsActive(String asked) {
        Thread currThread = Thread.currentThread();
        StringBuffer sb = new StringBuffer(">>>> ");
        sb.append(asked);
        sb.append(": Are Traps active ? ");
        sb.append(!this.m_blockTraps);
        sb.append(". Thread asked: name = ");
        sb.append(currThread.getName());
        this.printDebugInfo(sb.toString());
        return !this.m_blockTraps;
    }

    private boolean allRunningThreadsInactive(String asked) {
        this.printDebugInfo(this.getClass() + "::" + "allRunningThreadsInactive(String asked)");
        boolean result = !this.isOperationsActive(asked) && !this.isPollingActive(asked);
        return result;
    }

    private boolean trapsWaiting(String asked) {
        this.printDebugInfo(this.getClass() + "::" + "trapsWaiting(" + asked);
        boolean result = this.areTrapsActive(asked);
        return result;
    }

    private boolean isVirtVolOperationConcern(ClassID classId) {
        this.printDebugInfo(this.getClass() + "::" + "isVirtVolOperationConcern(" + classId);
        boolean result = classId.getId() == ClassID.LU_IDENTIFIER.getId() || classId.getId() == ClassID.GENERAL_SCSI_DEVICE.getId() || classId.getId() == ClassID.DIRECT_ACCESS_DEVICE.getId() || classId.getId() == ClassID.GENERAL_PHYSICAL_STORAGE.getId() || classId.getId() == ClassID.SUB_DIRECT_ACCESS_DEVICE.getId() || classId.getId() == ClassID.GENERAL_VOLUME.getId() || classId.getId() == ClassID.STRIPE_VOLUME.getId() || classId.getId() == ClassID.SNAPSHOT_VOLUME.getId() || classId.getId() == ClassID.SIMPLE_VOLUME.getId() || classId.getId() == ClassID.MIRROR_VOLUME.getId() || classId.getId() == ClassID.CUBE_VOLUME.getId() || classId.getId() == ClassID.CONCAT_VOLUME.getId() || classId.getId() == ClassID.TRANSPARENT_VOLUME.getId() || classId.getId() == ClassID.LUN.getId() || classId.getId() == ClassID.COPY_OPERATION.getId() || classId.getId() == ClassID.VOLUME_OPERATION.getId();
        return result;
    }

    private boolean isDROperationConcern(ClassID classId) {
        this.printDebugInfo(this.getClass() + "::" + "isDROperationConcern(" + classId);
        boolean result = classId.getId() == ClassID.POLICY_START.getId() || classId.getId() == ClassID.POLICY_PARAMS.getId() || classId.getId() == ClassID.ASYNC_PAIR.getId() || classId.getId() == ClassID.SYNC_PAIR.getId() || classId.getId() == ClassID.CONSISTENCY_GROUP.getId() || classId.getId() == ClassID.DR_ASYNC_PAIR_PIT.getId() || classId.getId() == ClassID.DR_CONSISTENCY_GROUP_PIT.getId();
        return result;
    }

    private boolean isAclOperationConcern(ClassID classId) {
        boolean result = classId.getId() == ClassID.IDENTITY.getId() || classId.getId() == ClassID.IDENTITY_NAME.getId() || classId.getId() == ClassID.CHAP_CREDENTIALS.getId() || classId.getId() == ClassID.SRP_CREDENTIALS.getId() || classId.getId() == ClassID.ACL_ENTRY.getId();
        return result;
    }

    private boolean isIscsiTargetOperationConcern(ClassID classId) {
        this.printDebugInfo(this.getClass() + "::" + "isIscsiTargetOperationConcern(" + classId);
        boolean result = classId.getId() == ClassID.ISCSI_TARGET.getId();
        return result;
    }

    private void reInitPolling(PollingGroupType pollGroupType) {
        PollingMgr.getInstance().startPollingProcess(this.m_agentIndex, pollGroupType, 0L);
    }

    public synchronized boolean allowTraps() {
        Thread currThread = Thread.currentThread();
        StringBuffer sb = new StringBuffer(">>>> Trap handeler ");
        sb.append(currThread.getName());
        sb.append(" check: allow trap ? ");
        sb.append(!this.m_blockTraps);
        this.printDebugInfo(sb.toString());
        return !this.m_blockTraps;
    }

    public synchronized void createVSwitchDiscoveryThreadPossible() throws SrThreadCreationException {
        if (this.m_withThreadMgrSupport) {
            Thread currThread = Thread.currentThread();
            if (currThread.getName().startsWith("Queue") && (this.isVSwitchDiscoveryOnWait(VSWITCH_DISCOVERY) || this.isVSwitchDiscoveryActive(VSWITCH_DISCOVERY))) {
                StringBuffer sb = new StringBuffer(">>>> " + ClassID.VSWITCH + " discovery thread cannot be created: name = ");
                sb.append(currThread.getName());
                this.printDebugInfo(sb.toString());
                throw new SrThreadCreationException(SrThreadCreationException.DISCOVERY_ON_PROCESS);
            }
            this.m_isVSwitchDiscoveryOnWait = true;
            StringBuffer sb = new StringBuffer(">>>> " + ClassID.VSWITCH + " discovery thread created: name = ");
            sb.append(currThread.getName());
            this.printDebugInfo(sb.toString());
        }
    }

    public synchronized void manageVSwitchDiscoveryThread() {
        if (this.m_withThreadMgrSupport) {
            this.waitForVSwitchDiscoveryStartFlag();
            this.vSwitchDiscoveryThreadRun();
        }
    }

    private void waitForVSwitchDiscoveryStartFlag() {
        StringBuffer sb;
        Thread currThread = Thread.currentThread();
        if (this.trapsWaiting(VSWITCH_DISCOVERY)) {
            sb = new StringBuffer(">>>> " + ClassID.VSWITCH + " discovery thread traps blocked: name = ");
            sb.append(currThread.getName());
            this.printDebugInfo(sb.toString());
            this.m_blockTraps = true;
        }
        while (!this.allRunningThreadsInactive(VSWITCH_DISCOVERY)) {
            try {
                sb = new StringBuffer(">>>> " + ClassID.VSWITCH + " discovery thread waiting due to other threads running: name = ");
                sb.append(currThread.getName());
                this.printDebugInfo(sb.toString());
                this.wait();
            }
            catch (InterruptedException e) {
                LogMgr.getServerLog().error(e);
            }
        }
        sb = new StringBuffer(">>>> " + ClassID.VSWITCH + " discovery thread stops polling: name = ");
        sb.append(currThread.getName());
        this.printDebugInfo(sb.toString());
    }

    private void vSwitchDiscoveryThreadRun() {
        this.m_isVSwitchDiscoveryActive = true;
        this.m_isVSwitchDiscoveryOnWait = false;
        ++this.m_numOfVSwitchDiscoveryRunning;
        Thread currThread = Thread.currentThread();
        StringBuffer sb = new StringBuffer(">>>> " + ClassID.VSWITCH + " discovery thread running: name = ");
        sb.append(currThread.getName());
        this.printDebugInfo(sb.toString());
    }

    public synchronized void vSwitchDiscoveryThreadDoneProcess() {
        if (this.m_withThreadMgrSupport) {
            --this.m_numOfVSwitchDiscoveryRunning;
            Thread currThread = Thread.currentThread();
            this.m_blockTraps = false;
            StringBuffer sb = new StringBuffer(">>>> " + ClassID.VSWITCH + " discovery re-init polling: name = ");
            sb.append(currThread.getName());
            this.printDebugInfo(sb.toString());
            this.reInitPolling(PollingGroupType.ALL_GROUP_TYPE);
            sb = new StringBuffer(">>>> " + ClassID.VSWITCH + " discovery done: name = ");
            sb.append(currThread.getName());
            this.printDebugInfo(sb.toString());
            if (this.m_numOfVSwitchDiscoveryRunning == 0) {
                this.m_isVSwitchDiscoveryActive = false;
                sb = new StringBuffer(">>>> There is no " + ClassID.VSWITCH + " discovery running: name = ");
                sb.append(currThread.getName());
                this.printDebugInfo(sb.toString());
                this.notifyAll();
            }
        }
    }

    public synchronized void createVSwitchVirtVolDiscoveryThreadPossible() throws SrThreadCreationException {
        if (this.m_withThreadMgrSupport) {
            Thread currThread = Thread.currentThread();
            if (currThread.getName().startsWith("Queue") && (this.isVSwitchVirVolDiscoveryOnWait(VSWITCH_VIRT_VOL_DISCOVERY) || this.isVSwitchVirVolDiscoveryActive(VSWITCH_VIRT_VOL_DISCOVERY))) {
                StringBuffer sb = new StringBuffer(">>>> Virt Vol discovery thread cannot be created: name = ");
                sb.append(currThread.getName());
                this.printDebugInfo(sb.toString());
                throw new SrThreadCreationException(SrThreadCreationException.DISCOVERY_ON_PROCESS);
            }
            this.m_isVSwitchVirtVolDiscoveryOnWait = true;
            StringBuffer sb = new StringBuffer(">>>> Virt Vol discovery thread created: name = ");
            sb.append(currThread.getName());
            this.printDebugInfo(sb.toString());
        }
    }

    public synchronized void manageVSwitchVirtVolDiscoveryThread() {
        if (this.m_withThreadMgrSupport) {
            this.waitForVSwitchVirtVolDiscoveryStartFlag();
            this.vSwitchVirtVolDiscoveryThreadRun();
        }
    }

    private void waitForVSwitchVirtVolDiscoveryStartFlag() {
        StringBuffer sb;
        Thread currThread = Thread.currentThread();
        if (this.trapsWaiting(VSWITCH_VIRT_VOL_DISCOVERY)) {
            sb = new StringBuffer(">>>> Virt Vol discovery thread traps blocked: name = ");
            sb.append(currThread.getName());
            this.printDebugInfo(sb.toString());
            this.m_blockTraps = true;
        }
        while (!this.allRunningThreadsInactive(VSWITCH_VIRT_VOL_DISCOVERY)) {
            try {
                sb = new StringBuffer(">>>> Virt Vol discovery thread waiting due to other threads running: name = ");
                sb.append(currThread.getName());
                this.printDebugInfo(sb.toString());
                this.wait();
            }
            catch (InterruptedException e) {
                LogMgr.getServerLog().error(e);
            }
        }
        sb = new StringBuffer(">>>> Virt Vol discovery thread stops virt vol polling: name = ");
        sb.append(currThread.getName());
        this.printDebugInfo(sb.toString());
        sb = new StringBuffer(">>>> Virt Vol discovery thread stops acl polling: name = ");
        sb.append(currThread.getName());
        this.printDebugInfo(sb.toString());
    }

    private void vSwitchVirtVolDiscoveryThreadRun() {
        this.m_isVSwitchVirtVolDiscoveryActive = true;
        this.m_isVSwitchVirtVolDiscoveryOnWait = false;
        ++this.m_numOfVSwitchVirtVolDiscoveryRunning;
        Thread currThread = Thread.currentThread();
        StringBuffer sb = new StringBuffer(">>>> Virt Vol discovery thread running: name = ");
        sb.append(currThread.getName());
        this.printDebugInfo(sb.toString());
    }

    public synchronized void vSwitchVirtVolDiscoveryThreadDoneProcess() {
        if (this.m_withThreadMgrSupport) {
            --this.m_numOfVSwitchVirtVolDiscoveryRunning;
            Thread currThread = Thread.currentThread();
            this.m_blockTraps = false;
            StringBuffer sb = new StringBuffer(">>>> Virt Vol discovery re-init virtualization polling: name = ");
            sb.append(currThread.getName());
            this.printDebugInfo(sb.toString());
            this.reInitPolling(PollingGroupType.VIRTUALIZATION_GROUP_TYPE);
            sb = new StringBuffer(">>>> Virt Vol discovery re-init acl polling: name = ");
            sb.append(currThread.getName());
            this.printDebugInfo(sb.toString());
            this.reInitPolling(PollingGroupType.ACL_GROUP_TYPE);
            sb = new StringBuffer(">>>> Virt Vol discovery done: name = ");
            sb.append(currThread.getName());
            this.printDebugInfo(sb.toString());
            if (this.m_numOfVSwitchVirtVolDiscoveryRunning == 0) {
                this.m_isVSwitchVirtVolDiscoveryActive = false;
                sb = new StringBuffer(">>>> There is no virt vol discovery running: name = ");
                sb.append(currThread.getName());
                this.printDebugInfo(sb.toString());
                this.notifyAll();
            }
        }
    }

    public synchronized void manageOperationThread(ClassID classId) {
        if (this.m_withThreadMgrSupport) {
            this.waitForOperationStartFlag(classId);
            this.operationThreadRun(classId);
        }
    }

    private void waitForOperationStartFlag(ClassID classId) {
        boolean isIscsiTargetOperation;
        Thread currThread = Thread.currentThread();
        boolean isOperationThread = currThread.getName().startsWith("VolumeOperation");
        boolean isVirtVolOperation = classId == null ? true : this.isVirtVolOperationConcern(classId);
        boolean isDROperation = classId == null ? true : this.isDROperationConcern(classId);
        boolean isAclOperation = classId == null ? true : this.isAclOperationConcern(classId);
        boolean bl = isIscsiTargetOperation = classId == null ? true : this.isIscsiTargetOperationConcern(classId);
        if (isOperationThread || isVirtVolOperation || isDROperation) {
            StringBuffer sb;
            while (this.isVirtVolPollingActive(VOL_VIRTVOL_OPERATION)) {
                try {
                    sb = new StringBuffer(">>>> Opearion thread on ClassID = ");
                    sb.append(classId);
                    sb.append(" waiting due to virt vol polling: name = ");
                    sb.append(currThread.getName());
                    this.printDebugInfo(sb.toString());
                    this.wait();
                }
                catch (InterruptedException e) {
                    LogMgr.getServerLog().error(e);
                }
            }
            sb = new StringBuffer(">>>> Opearion thread stops virtualization polling: name = ");
            sb.append(currThread.getName());
            this.printDebugInfo(sb.toString());
        } else if (isAclOperation) {
            StringBuffer sb;
            while (this.isAclPollingActive(ACL_OPERATION)) {
                try {
                    sb = new StringBuffer(">>>> Opearion thread on ClassID = ");
                    sb.append(classId);
                    sb.append(" waiting due to Acl polling: name = ");
                    sb.append(currThread.getName());
                    this.printDebugInfo(sb.toString());
                    this.wait();
                }
                catch (InterruptedException e) {
                    LogMgr.getServerLog().error(e);
                }
            }
            sb = new StringBuffer(">>>> Opearion thread stops Acl polling: name = ");
            sb.append(currThread.getName());
            this.printDebugInfo(sb.toString());
        } else if (isIscsiTargetOperation) {
            StringBuffer sb;
            while (this.isVirtVolPollingActive(ISCSI_TARGET_OPERATION) || this.isAclPollingActive(ISCSI_TARGET_OPERATION)) {
                try {
                    sb = new StringBuffer(">>>> IscsiTarget Opearion thread on ClassID = ");
                    sb.append(classId);
                    sb.append(" waiting due to virt vol/acl polling: name = ");
                    sb.append(currThread.getName());
                    this.printDebugInfo(sb.toString());
                    this.wait();
                }
                catch (InterruptedException e) {
                    LogMgr.getServerLog().error(e);
                }
            }
            sb = new StringBuffer(">>>> IscsiTarget Opearion thread stops virtualization polling: name = ");
            sb.append(currThread.getName());
            this.printDebugInfo(sb.toString());
            sb = new StringBuffer(">>>> IscsiTarget Opearion thread stops acl polling: name = ");
            sb.append(currThread.getName());
            this.printDebugInfo(sb.toString());
        }
    }

    private void operationThreadRun(ClassID classId) {
        boolean isIscsiTargetOperation;
        this.m_isOperationsActive = true;
        ++this.m_numOfOperationsRunning;
        boolean isVirtVolOperation = classId == null ? true : this.isVirtVolOperationConcern(classId);
        boolean isDROperation = classId == null ? true : this.isDROperationConcern(classId);
        boolean isAclOperation = classId == null ? true : this.isAclOperationConcern(classId);
        boolean bl = isIscsiTargetOperation = classId == null ? true : this.isIscsiTargetOperationConcern(classId);
        if (isVirtVolOperation || isDROperation || isIscsiTargetOperation) {
            this.m_isVirVolOperationActive = true;
            this.m_isDROperationActive = true;
        }
        if (isAclOperation || isIscsiTargetOperation) {
            this.m_isAclOperationActive = true;
        }
        Thread currThread = Thread.currentThread();
        StringBuffer sb = new StringBuffer(">>>> Operation thread on ClassID = ");
        sb.append(classId);
        sb.append(" running: name = ");
        sb.append(currThread.getName());
        this.printDebugInfo(sb.toString());
    }

    public synchronized void operationThreadDoneProcess(ClassID classId) {
        if (this.m_withThreadMgrSupport) {
            boolean isIscsiTargetOperation;
            boolean isVirtVolOperation = classId == null ? true : this.isVirtVolOperationConcern(classId);
            boolean isDROperation = classId == null ? true : this.isDROperationConcern(classId);
            boolean isAclOperation = classId == null ? true : this.isAclOperationConcern(classId);
            boolean bl = isIscsiTargetOperation = classId == null ? true : this.isIscsiTargetOperationConcern(classId);
            if (isVirtVolOperation || isDROperation || isIscsiTargetOperation) {
                this.m_isVirVolOperationActive = false;
                this.m_isDROperationActive = false;
            }
            if (isAclOperation || isIscsiTargetOperation) {
                this.m_isAclOperationActive = false;
            }
            Thread currThread = Thread.currentThread();
            StringBuffer sb = new StringBuffer(">>>> Opeartion on ClassID = ");
            sb.append(classId);
            sb.append(" re-init virtualization polling: name = ");
            sb.append(currThread.getName());
            this.printDebugInfo(sb.toString());
            this.reInitPolling(PollingGroupType.VIRTUALIZATION_GROUP_TYPE);
            sb = new StringBuffer(">>>> Opeartion on ClassID = ");
            sb.append(classId);
            sb.append(" re-init acl polling: name = ");
            sb.append(currThread.getName());
            this.printDebugInfo(sb.toString());
            this.reInitPolling(PollingGroupType.ACL_GROUP_TYPE);
            sb = new StringBuffer(">>>> Operation on ClassID = ");
            sb.append(classId);
            sb.append(" done: name = ");
            sb.append(currThread.getName());
            this.printDebugInfo(sb.toString());
            --this.m_numOfOperationsRunning;
            if (this.m_numOfOperationsRunning == 0) {
                this.m_isOperationsActive = false;
                sb = new StringBuffer(">>>> There is no operation running: name = ");
                sb.append(currThread.getName());
                this.printDebugInfo(sb.toString());
                this.notifyAll();
            }
        }
    }

    public synchronized void createPollingPossible(PollingGroupType pollingType) throws SrThreadCreationException {
        if (this.m_withThreadMgrSupport) {
            Thread currThread = Thread.currentThread();
            boolean isVirtualizationPolling = pollingType.equals(PollingGroupType.VIRTUALIZATION_GROUP_TYPE);
            boolean isAclPolling = pollingType.equals(PollingGroupType.ACL_GROUP_TYPE);
            boolean isGeneralPolling = pollingType.equals(PollingGroupType.GENERAL_GROUP_TYPE);
            boolean isNetAndIntPolling = pollingType.equals(PollingGroupType.NETWORKING_AND_INTERFACE_GROUP_TYPE);
            if (isGeneralPolling) {
                return;
            }
            String asked = isVirtualizationPolling ? VIRT_VOL_POLLING : (isAclPolling ? ACL_POLLING : (isNetAndIntPolling ? NET_AND_INT_POLLING : STATISTIC_POLLING));
            if (this.isVSwitchDiscoveryOnWait(asked) || this.isVSwitchDiscoveryActive(asked)) {
                StringBuffer sb = new StringBuffer(">>>> Polling on ");
                sb.append(pollingType);
                sb.append(" cannot be created due to " + ClassID.VSWITCH + " discovery: name = ");
                sb.append(currThread.getName());
                this.printDebugInfo(sb.toString());
                throw new SrThreadCreationException(SrThreadCreationException.POLLING_OP_IMPOSSIBLE);
            }
            if ((isVirtualizationPolling || isAclPolling) && (this.isVSwitchVirVolDiscoveryOnWait(asked) || this.isVSwitchVirVolDiscoveryActive(asked))) {
                StringBuffer sb = new StringBuffer(">>>> Polling on ");
                sb.append(pollingType);
                sb.append(" cannot be created due to virt vol discovery: name = ");
                sb.append(currThread.getName());
                this.printDebugInfo(sb.toString());
                throw new SrThreadCreationException(SrThreadCreationException.POLLING_OP_IMPOSSIBLE);
            }
            StringBuffer sb = new StringBuffer(">>>> New polling task on ");
            sb.append(pollingType);
            sb.append(" created: name = ");
            sb.append(currThread.getName());
            this.printDebugInfo(sb.toString());
        }
    }

    public synchronized void managePollingThread(PollingGroupType pollingType) {
        if (this.m_withThreadMgrSupport) {
            this.waitForPollingStartFlag(pollingType);
            this.pollingThreadRun(pollingType);
        }
    }

    private void waitForPollingStartFlag(PollingGroupType pollingType) {
        block8: {
            String asked;
            boolean isAclPolling;
            Thread currThread;
            block7: {
                currThread = Thread.currentThread();
                boolean isVirtualizationPolling = pollingType.equals(PollingGroupType.VIRTUALIZATION_GROUP_TYPE);
                isAclPolling = pollingType.equals(PollingGroupType.ACL_GROUP_TYPE);
                boolean isGeneralPolling = pollingType.equals(PollingGroupType.GENERAL_GROUP_TYPE);
                boolean isNetAndIntPolling = pollingType.equals(PollingGroupType.NETWORKING_AND_INTERFACE_GROUP_TYPE);
                if (isGeneralPolling) {
                    return;
                }
                asked = isVirtualizationPolling ? VIRT_VOL_POLLING : (isAclPolling ? ACL_POLLING : (isGeneralPolling ? GENERAL_POLLING : (isNetAndIntPolling ? NET_AND_INT_POLLING : STATISTIC_POLLING)));
                if (!isVirtualizationPolling) break block7;
                while (this.isVirtVolOperationActive(asked)) {
                    try {
                        StringBuffer sb = new StringBuffer(">>>> New polling task on ");
                        sb.append(pollingType);
                        sb.append(" waiting due to volume/virt vol operation: name = ");
                        sb.append(currThread.getName());
                        this.printDebugInfo(sb.toString());
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        LogMgr.getServerLog().error(e);
                    }
                }
                break block8;
            }
            if (!isAclPolling) break block8;
            while (this.isAclOperationActive(asked)) {
                try {
                    StringBuffer sb = new StringBuffer(">>>> Polling on ");
                    sb.append(pollingType);
                    sb.append(" waiting due to Acl operation: name = ");
                    sb.append(currThread.getName());
                    this.printDebugInfo(sb.toString());
                    this.wait();
                }
                catch (InterruptedException e) {
                    LogMgr.getServerLog().error(e);
                }
            }
        }
    }

    private void pollingThreadRun(PollingGroupType pollingType) {
        if (this.m_withThreadMgrSupport) {
            boolean isVirtualizationPolling = pollingType.equals(PollingGroupType.VIRTUALIZATION_GROUP_TYPE);
            boolean isAclPolling = pollingType.equals(PollingGroupType.ACL_GROUP_TYPE);
            if (isVirtualizationPolling) {
                this.m_isVirtVolPollingActive = true;
            } else if (isAclPolling) {
                this.m_isAclPollingActive = true;
            } else {
                this.m_isOtherPollingActive = true;
            }
            Thread currThread = Thread.currentThread();
            StringBuffer sb = new StringBuffer(">>>> Polling on ");
            sb.append(pollingType);
            sb.append(" running: name = ");
            sb.append(currThread.getName());
            this.printDebugInfo(sb.toString());
        }
    }

    public synchronized void pollingThreadDoneProcess(PollingGroupType pollingType) {
        if (this.m_withThreadMgrSupport) {
            if (pollingType.equals(PollingGroupType.VIRTUALIZATION_GROUP_TYPE)) {
                this.m_isVirtVolPollingActive = false;
            } else if (pollingType.equals(PollingGroupType.ACL_GROUP_TYPE)) {
                this.m_isAclPollingActive = false;
            } else {
                this.m_isOtherPollingActive = false;
            }
            Thread currThread = Thread.currentThread();
            StringBuffer sb = new StringBuffer(">>>> Polling on ");
            sb.append(pollingType);
            sb.append(" done: name = ");
            sb.append(currThread.getName());
            this.printDebugInfo(sb.toString());
            this.notifyAll();
        }
    }
}

