/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr.target;

import com.sanrad.log.LogMgr;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.comm.CommItem;
import com.sanrad.nms.server.comm.CommMgr;
import com.sanrad.nms.server.comm.CommVarBind;
import com.sanrad.nms.server.comm.CommVarBindList;
import com.sanrad.nms.server.comm.exception.SrCommunicationException;
import com.sanrad.nms.server.comm.snmp.MibItem;
import com.sanrad.nms.server.comm.snmp.SrOid;
import com.sanrad.nms.server.comm.snmp.SrSnmpVarBind;
import com.sanrad.nms.server.comm.snmp.trap.SrTrap;
import com.sanrad.nms.server.event.SrEventHandler;
import com.sanrad.nms.server.exception.MissingValueException;
import com.sanrad.nms.server.exception.SrElementOperationException;
import com.sanrad.nms.server.mgr.CheckListConfigElementData;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.ConfigElementDataList;
import com.sanrad.nms.server.mgr.ScsiPortConfigurator;
import com.sanrad.nms.server.mgr.ScsiTargetDeviceConfigurator;
import com.sanrad.nms.server.mgr.ScsiTransportConfigurator;
import com.sanrad.nms.server.mgr.acl.TargetAuthorizationConfigurator;
import com.sanrad.nms.server.mgr.identity.CHAPCredAttrExtentConfigurator;
import com.sanrad.nms.server.mgr.identity.CHAPCredentialsConfigurator;
import com.sanrad.nms.server.mgr.identity.CHAPCredentialsExtensionConfigurator;
import com.sanrad.nms.server.mgr.identity.IdentityConfigurator;
import com.sanrad.nms.server.mgr.identity.IdentityXConfigurator;
import com.sanrad.nms.server.mgr.target.IscsiTargetLoginFailureConfigurator;
import com.sanrad.nms.server.mgr.target.TargetConfigurator;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKey;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.CommKeyUtil;
import com.sanrad.nms.server.util.Parameter;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.SnmpCommKey;
import com.sanrad.nms.server.util.types.SrInteger;
import com.sanrad.nms.server.util.types.SrOidType;
import com.sanrad.nms.server.util.types.SrString;
import com.sanrad.nms.server.util.types.SrTimeTicks;
import java.util.HashMap;
import java.util.Iterator;

public class IscsiTargetConfigurator
extends TargetConfigurator {
    public IscsiTargetConfigurator() {
        super(ClassID.ISCSI_TARGET, "srIscsiTgtTable", MibItem.ISCSI_TARGET_RS, MibItem.ISCSI_TARGET_TBL_LAST_UPDATE);
    }

    public void internalCreate(ConfigElementData element) throws SrCommunicationException, SrElementOperationException {
        if (element.getValue(ParameterCode.ISCSI_TARGET_NAME) == null) {
            throw new MissingValueException("IscsI Target must have a target WWUI name");
        }
        char snmpAgentIndex = element.getSnmpAgentFromParameter();
        SrOid nextIndexOid = new SrOid(MibItem.ISCSI_TARGET_NEXT_INDEX.toString(), "0");
        SrSnmpVarBind nextIndexVarBind = new SrSnmpVarBind(nextIndexOid, null);
        CommVarBindList vbList = new CommVarBindList();
        vbList.add(nextIndexVarBind);
        CommMgr.getInstance(snmpAgentIndex).getList(vbList, snmpAgentIndex);
        int index = vbList.indexOf(nextIndexVarBind);
        Integer nextIndex = (Integer)((SrInteger)((SrSnmpVarBind)vbList.elementAt(index)).getValue()).value();
        SnmpCommKey key = new SnmpCommKey("1.1." + nextIndex.toString(), snmpAgentIndex);
        element.setCommKey(key);
        Object alias = element.getValue(ParameterCode.ISCSI_TARGET_ALIAS);
        if (alias == null || alias.equals("")) {
            SrString newAlias = new SrString("Tgt_" + key.toString().substring(key.toString().lastIndexOf(".") + 1));
            element.setValue(ParameterCode.ISCSI_TARGET_ALIAS, newAlias);
        }
        Object defaultAccess = element.removeParameter(ParameterCode.ISCSI_TARGET_DEFAULT_ACCESS);
        super.internalCreate(element);
        if (defaultAccess != null) {
            element.addParameter(new Parameter(ParameterCode.ISCSI_TARGET_DEFAULT_ACCESS, defaultAccess));
        }
    }

    public HashMap getListOfParams() {
        HashMap<ParameterCode, Object> paramList = new HashMap<ParameterCode, Object>(5);
        paramList.put(ParameterCode.ISCSI_TARGET_ALIAS, null);
        paramList.put(ParameterCode.ISCSI_TARGET_DEFAULT_EXPOSE_ON, null);
        paramList.put(ParameterCode.ISCSI_TARGET_NAME, null);
        return paramList;
    }

    public boolean readAfterCreate(ConfigElementData element) throws SrCommunicationException {
        if (element.getClassId().equals(ClassID.ISCSI_TARGET)) {
            SrLogger logger = LogMgr.getServerLog();
            super.readAfterCreate(element);
            this.readSCSITargetId(element);
            this.readSCSITargetData(element);
            this.readTargetLoginFailureData(element);
            Object vswitchId = element.getValue(ParameterCode.VSWITCH_ID);
            ConfigElementData identityParent = this.readTargetCredIdentity(element);
            if (identityParent != null) {
                identityParent.addParameter(new Parameter(ParameterCode.VSWITCH_ID, vswitchId));
                ConfigElementData credentials = this.readTargetCredentials(identityParent);
                credentials.addParameter(new Parameter(ParameterCode.VSWITCH_ID, vswitchId));
                ConfigElementData targetSCSIPort = this.readTargetPort(element);
                SrEventHandler.getEventMgr().sendAddElementEvent(element);
                SrEventHandler.getEventMgr().sendAddElementEvent(targetSCSIPort);
                SrEventHandler.getEventMgr().sendAddElementEvent(identityParent);
                SrEventHandler.getEventMgr().sendAddElementEvent(credentials);
            }
            char agentIndex = element.getMyFirstSnmpAgentIndex();
            SnmpCommKey targetCommKeys = CommKeyUtil.getSpecificSnmpKey(element.getCommKey(), agentIndex);
            String targetKey = targetCommKeys.getKey();
            String prefix = targetKey.substring(targetKey.indexOf(".") + 1);
            CommVarBindList list = new CommVarBindList();
            list.add(new SrSnmpVarBind(MibItem.ACL_ENTRY_POSITION.toString()));
            CommVarBindList[] varBinds = CommMgr.getInstance(agentIndex).getListsByKeyPrefix(list, prefix, agentIndex);
            String key = null;
            if (varBinds != null && varBinds.length > 0) {
                for (int i = 0; i < varBinds.length; ++i) {
                    CommVarBind varBind = (CommVarBind)varBinds[i].elementAt(0);
                    SrInteger value = (SrInteger)varBind.getValue();
                    if (value.intValue() != 0) continue;
                    key = varBind.getIndexForCommKey();
                    break;
                }
            }
            if (key == null) {
                logger.error("Default ACL entry not found for target " + targetCommKeys);
            } else {
                SnmpCommKey defAclEntryCommKey = new SnmpCommKey(key, agentIndex);
                logger.debug("Trying to read default acl entry: " + key);
                ConfigElementData aclElement = new ConfigElementData(defAclEntryCommKey, ClassID.ACL_ENTRY);
                aclElement.addParameter(new Parameter(ParameterCode.VSWITCH_ID, element.getValue(ParameterCode.VSWITCH_ID)));
                TargetAuthorizationConfigurator configurator = new TargetAuthorizationConfigurator();
                configurator.readAfterCreate(aclElement);
                if (element.containParameter(ParameterCode.ISCSI_TARGET_DEFAULT_ACCESS)) {
                    boolean success = configurator.createDefaultAccessForTarget(element, aclElement);
                    if (success) {
                        logger.debug("Default Acl entry was read for new target.");
                    } else {
                        logger.debug("FAILED to read default acl entry for new target.");
                    }
                }
                SrEventHandler.getEventMgr().sendAddElementEvent(aclElement);
            }
        }
        return true;
    }

    private void readSCSITargetId(ConfigElementData element) throws SrCommunicationException {
        String iscsiNodeKey = element.getCommKeyClassId().getCommKeys()[0].getKey().substring(2);
        SnmpCommKey iscsiNodeCommKey = new SnmpCommKey(iscsiNodeKey, element.getSnmpAgentFromParameter());
        ConfigElementData tempElementForReadOnly = new ConfigElementData(iscsiNodeCommKey, element.getClassId());
        tempElementForReadOnly.addParameter(new Parameter(ParameterCode.ISCSI_TARGET_TRANSPORT_TYPE));
        this.internalReadFields(tempElementForReadOnly);
        SrOidType scsiOidOfTarget = (SrOidType)tempElementForReadOnly.getValue(ParameterCode.ISCSI_TARGET_TRANSPORT_TYPE);
        String scsiTargetTransportKey = scsiOidOfTarget.getIndexFromOidType(ScsiTransportConfigurator.SCSI_NODE_INDEX_OID);
        String scsiTargetKey = scsiTargetTransportKey.substring(0, scsiTargetTransportKey.lastIndexOf("."));
        CommKeyClassId scsiTargetCommKeyClassId = new CommKeyClassId(new SnmpCommKey(scsiTargetKey, element.getSnmpAgentFromParameter()), ClassID.SCSI_TARGET);
        element.addParameter(new Parameter(ParameterCode.SCSI_DEVICE_ID, scsiTargetCommKeyClassId));
    }

    private ConfigElementData readTargetCredIdentity(ConfigElementData element) throws SrCommunicationException {
        IdentityConfigurator identConfig = new IdentityConfigurator();
        ConfigElementDataList identities = identConfig.getAll(element.getSnmpAgentFromParameter(), null, null);
        IdentityXConfigurator identxConfig = new IdentityXConfigurator();
        ConfigElementDataList identitiesExtensions = identxConfig.getAll(element.getSnmpAgentFromParameter(), null, null);
        super.mergeElementLists(identities, identitiesExtensions, true);
        int listSize = identities.size();
        SrString targetAlias = (SrString)element.getValue(ParameterCode.ISCSI_TARGET_ALIAS);
        for (int i = 0; i < listSize; ++i) {
            ConfigElementData identElement = (ConfigElementData)identities.get(i);
            SrString alias = (SrString)identElement.getValue(ParameterCode.IDENTITY_ALIAS);
            if (alias == null || targetAlias == null || !alias.equals(targetAlias)) continue;
            identElement.setClassId(ClassID.IDENTITY);
            return identElement;
        }
        logger.info("Couldn't find the target credentials for target - " + element);
        return null;
    }

    private void readSCSITargetData(ConfigElementData element) throws SrCommunicationException {
        CommKeyClassId scsiTargetCommKeyClassID = (CommKeyClassId)element.getValue(ParameterCode.SCSI_DEVICE_ID);
        ConfigElementData scsiTargetElement = new ConfigElementData(scsiTargetCommKeyClassID);
        ScsiTargetDeviceConfigurator scsiTargetConfigurator = new ScsiTargetDeviceConfigurator();
        scsiTargetConfigurator.internalReadOnTargetCreation(scsiTargetElement);
        element.addParameter(scsiTargetElement.getParametersList());
    }

    private void readTargetLoginFailureData(ConfigElementData element) throws SrCommunicationException {
        IscsiTargetLoginFailureConfigurator loginFailureConfigurator = new IscsiTargetLoginFailureConfigurator();
        ConfigElementDataList loginFailuresElements = loginFailureConfigurator.getAll(element.getSnmpAgentFromParameter(), null, null);
        for (int i = 0; i < loginFailuresElements.size(); ++i) {
            ConfigElementData loginFailureElement = loginFailuresElements.getConfigElementDataAt(i);
            String loginFailureElementKey = loginFailureElement.getSnmpKey().getKey();
            String targetKey = element.getSnmpKey().getKey();
            if (!targetKey.endsWith(loginFailureElementKey)) continue;
            element.addParameter(loginFailureElement.getParametersList());
            return;
        }
    }

    private ConfigElementData readTargetPort(ConfigElementData element) throws SrCommunicationException {
        CommKeyClassId scsiTargetCommKeyClassId = (CommKeyClassId)element.getValue(ParameterCode.SCSI_DEVICE_ID);
        String scsiTargetKey = scsiTargetCommKeyClassId.getCommKeys()[0].getKey();
        ScsiPortConfigurator portConfig = new ScsiPortConfigurator();
        ConfigElementDataList ports = portConfig.getAllExtended(element.getSnmpAgentFromParameter(), null, null);
        ConfigElementDataList targetPorts = new ConfigElementDataList();
        for (int index = 0; index < ports.size(); ++index) {
            String portTargetKey;
            String portTargetKeyParent;
            ConfigElementData portElement = (ConfigElementData)ports.elementAt(index);
            if (!portElement.getClassId().equals(ClassID.SCSI_TARGET_PORT) || !(portTargetKeyParent = (portTargetKey = portElement.getCommKeyClassId().getCommKeys()[0].getKey()).substring(0, portTargetKey.lastIndexOf(46))).equals(scsiTargetKey)) continue;
            targetPorts.add(portElement);
        }
        return (ConfigElementData)targetPorts.elementAt(0);
    }

    private ConfigElementData readTargetCredentials(ConfigElementData identElement) throws SrCommunicationException {
        CommKey[] commkeys = identElement.getCommKey();
        SnmpCommKey commKey = new SnmpCommKey(commkeys[0].getKey() + ".1", identElement.getSnmpAgentFromParameter());
        ConfigElementData credElement = new ConfigElementData(commKey, ClassID.CHAP_CREDENTIALS);
        CHAPCredentialsConfigurator chapConfig = new CHAPCredentialsConfigurator();
        credElement.setClassId(ClassID.CHAP_CREDENTIALS);
        chapConfig.readAfterCreate(credElement);
        CHAPCredentialsExtensionConfigurator chapXConfig = new CHAPCredentialsExtensionConfigurator();
        chapXConfig.readAfterCreate(credElement);
        CHAPCredAttrExtentConfigurator attrConfig = new CHAPCredAttrExtentConfigurator();
        attrConfig.readAfterCreate(credElement);
        return credElement;
    }

    public boolean readAfterChange(ConfigElementData element) throws SrCommunicationException {
        return super.readAfterChange(element);
    }

    public void refreshElement(ConfigElementData element, ConfigElementDataList retrievedElements) throws SrCommunicationException {
        super.refreshElement(element, retrievedElements);
        this.readAfterCreate(element);
    }

    public ConfigElementDataList refreshTable(char snmpAgentIndex, SrTimeTicks lastUpdate, CheckListConfigElementData checkListElement) throws SrCommunicationException {
        ConfigElementDataList targets = this.getAllExtended(snmpAgentIndex, lastUpdate, checkListElement);
        if (targets != null) {
            Iterator itr = targets.iterator();
            while (itr.hasNext()) {
                ConfigElementData current = (ConfigElementData)itr.next();
                this.readAfterCreate(current);
            }
        }
        return targets;
    }

    public void discover(CommKeyClassId vSwitchData) throws SrCommunicationException {
        char snmpAgentIndex = vSwitchData.getMyFirstSnmpAgentIndex();
        ConfigElementDataList targetsList = this.getAllExtended(snmpAgentIndex, null, null);
        if (targetsList.size() > 0) {
            this.sendDiscoveredElementsToEventMgr(targetsList, vSwitchData);
        }
    }

    public ConfigElementDataList getAllExtended(char snmpAgentIndex, SrTimeTicks lastUpdate, CheckListConfigElementData checkListElement) throws SrCommunicationException {
        ConfigElementDataList targetsList = this.getAll(snmpAgentIndex, lastUpdate, checkListElement);
        if (targetsList != null && targetsList.size() > 0) {
            IscsiTargetLoginFailureConfigurator loginFailureConfigurator = new IscsiTargetLoginFailureConfigurator();
            ConfigElementDataList loginFailureTargetsList = loginFailureConfigurator.getAll(snmpAgentIndex, lastUpdate, checkListElement);
            this.mergeElementLists(targetsList, loginFailureTargetsList, false);
        }
        return targetsList;
    }

    protected void mergeElementLists(ConfigElementDataList mainList, ConfigElementDataList secondList, boolean setClassId) {
        try {
            Iterator secondItr = secondList.iterator();
            while (secondItr.hasNext()) {
                ConfigElementData secondElem = (ConfigElementData)secondItr.next();
                String secondElemKey = secondElem.getSnmpKey().getKey();
                String keyWithStorageDomain = "1." + secondElemKey;
                Iterator mainItr = mainList.iterator();
                ConfigElementData mainElem = null;
                while (mainItr.hasNext() && mainElem == null) {
                    ConfigElementData currentMainElem = (ConfigElementData)mainItr.next();
                    String mainElemKey = currentMainElem.getSnmpKey().getKey();
                    if (!mainElemKey.equals(keyWithStorageDomain)) continue;
                    mainElem = currentMainElem;
                    break;
                }
                if (mainElem == null) {
                    SrEventHandler.getErrorMgr().sendConfigurationError("Misconfigured " + secondElem.getClassId().toString() + " index: " + secondElem.getSnmpKey().toDisplayString(), secondElem.getSnmpKey().getSnmpAgentIndex());
                    continue;
                }
                mainElem.addParameter(secondElem.getParametersList());
                if (!setClassId) continue;
                mainElem.setClassId(this.myClassId);
            }
        }
        catch (RuntimeException e) {
            String msg = "Merge Failed at: " + CommKeyUtil.getKeyForMessage(((ConfigElementData)mainList.get(0)).getCommKey());
            LogMgr.getServerLog().debug(msg, e);
            throw e;
        }
    }

    protected CommItem getCommItemForTrapCommKey(SrTrap trap) {
        switch (trap.getTrapType().getTrapId()) {
            case 22: {
                return MibItem.ISCSI_TARGET_LAST_INITIATOR_FAILURE_NAME;
            }
        }
        return super.getCommItemForTrapCommKey(trap);
    }

    protected void trapProccessingPostOperation(ConfigElementData element, SrTrap trap) {
        if (trap.getTrapType().getTrapId() == 22) {
            LogMgr.getServerLog().debug("IscsiTargetConfigurator: Remote Initiator failed to login to a local target!");
            SrString remoteInitiatorName = (SrString)element.getValue(ParameterCode.ISCSI_TARGET_LAST_INITIATOR_FAILURE_NAME);
            try {
                ConfigElementDataList elements = this.getAllExtended(element.getSnmpAgentFromParameter(), null, null);
                ConfigElementData remoteInitiatorElement = this.getRemoteInitiatorElementByName(elements, remoteInitiatorName.toString());
                SrEventHandler.getEventMgr().sendChangeElementEvent(remoteInitiatorElement);
            }
            catch (SrCommunicationException ce) {
                LogMgr.getServerLog().debug("IscsiTargetConfigurator: Failed to read remote initiator login failure!");
            }
        } else {
            throw new UnsupportedOperationException("Operation not supported for trap " + trap.toString());
        }
    }

    private ConfigElementData getRemoteInitiatorElementByName(ConfigElementDataList elements, String remoteInitiatorName) {
        for (int index = 0; index < elements.size(); ++index) {
            SrString currentRemoteInitiatorName;
            ConfigElementData element = (ConfigElementData)elements.elementAt(index);
            ClassID classId = element.getClassId();
            if (!classId.equals(ClassID.ISCSI_REMOTE_INITIATOR) || !(currentRemoteInitiatorName = (SrString)element.getValue(ParameterCode.ISCSI_REMOTE_INITIATOR_NAME)).toString().equals(remoteInitiatorName)) continue;
            return element;
        }
        return null;
    }
}

