/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr.target;

import com.sanrad.nms.server.comm.CommVarBindList;
import com.sanrad.nms.server.comm.exception.SrCommunicationException;
import com.sanrad.nms.server.comm.snmp.MibItem;
import com.sanrad.nms.server.comm.snmp.SrOid;
import com.sanrad.nms.server.comm.snmp.SrSnmpVarBind;
import com.sanrad.nms.server.exception.MissingValueException;
import com.sanrad.nms.server.exception.SrElementOperationException;
import com.sanrad.nms.server.mgr.CheckListConfigElementData;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.ConfigElementDataList;
import com.sanrad.nms.server.mgr.ElementConfigurator;
import com.sanrad.nms.server.mgr.SCSIRemoteTargetConfigurator;
import com.sanrad.nms.server.mgr.target.IscsiTgtPortalConfigurator;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.Parameter;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.SnmpCommKey;
import com.sanrad.nms.server.util.types.SrBITS;
import com.sanrad.nms.server.util.types.SrTimeTicks;
import com.sanrad.nms.server.util.types.SrType;
import java.util.HashMap;

public class IscsiPortalConfigurator
extends ElementConfigurator {
    private static final String TARGET_ROLE_BITS_CONST = "10000000";
    static Integer[] lastPortalIndex = new Integer[0];

    public IscsiPortalConfigurator() {
        super(ClassID.PORTAL, "iscsiPortalAttributesTable", MibItem.ISCSI_PORTAL_RS, MibItem.ISCSI_TARGET_TBL_LAST_UPDATE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readDiscoverPostOperation(ConfigElementData element, CommVarBindList list) throws SrCommunicationException {
        String portalIndices = element.getSnmpKey().toString();
        Integer portalIndex = new Integer(portalIndices.substring(portalIndices.lastIndexOf(".") + 1));
        char agentIndex = element.getMyFirstSnmpAgentIndex();
        Integer[] integerArray = lastPortalIndex;
        synchronized (lastPortalIndex) {
            if (lastPortalIndex.length <= agentIndex) {
                Integer[] newArray = new Integer[agentIndex + '\u0001'];
                System.arraycopy(lastPortalIndex, 0, newArray, 0, lastPortalIndex.length);
                newArray[agentIndex] = portalIndex;
                lastPortalIndex = newArray;
            } else if (lastPortalIndex[agentIndex] == null || portalIndex > lastPortalIndex[agentIndex]) {
                IscsiPortalConfigurator.lastPortalIndex[agentIndex] = portalIndex;
            }
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void internalCreate(ConfigElementData element) throws SrCommunicationException, SrElementOperationException {
        SrType portNumber = (SrType)element.getValue(ParameterCode.ISCSI_PORTAL_PORT);
        if (portNumber == null) {
            throw new MissingValueException("Portal creation: Missing value for Port number");
        }
        Integer[] integerArray = lastPortalIndex;
        synchronized (lastPortalIndex) {
            char agentIndex = element.getSnmpAgentFromParameter();
            if (lastPortalIndex.length <= agentIndex) {
                Integer[] newArray = new Integer[agentIndex + '\u0001'];
                System.arraycopy(lastPortalIndex, 0, newArray, 0, lastPortalIndex.length);
                newArray[agentIndex] = new Integer(0);
                lastPortalIndex = newArray;
            } else if (lastPortalIndex[agentIndex] == null) {
                IscsiPortalConfigurator.lastPortalIndex[agentIndex] = new Integer(0);
            }
            this.getAll(agentIndex, null, null);
            Integer newIndex = new Integer(lastPortalIndex[agentIndex] + 1);
            element.setCommKey(new SnmpCommKey("1." + newIndex.toString(), agentIndex));
            element.removeParameter(ParameterCode.ISCSI_PORTAL_PORT);
            super.internalCreate(element);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            ConfigElementData exData = new ConfigElementData(element.getCommKey(), element.getClassId());
            exData.addParameter(new Parameter(ParameterCode.ISCSI_PORTAL_PORT, portNumber));
            IscsiTgtPortalConfigurator tgtPortalConfig = new IscsiTgtPortalConfigurator();
            try {
                tgtPortalConfig.internalChange(exData);
            }
            catch (SrCommunicationException e) {
                logger.debug(e);
                this.internalRemove(element);
                throw new SrCommunicationException(e.getMessage());
            }
            return;
        }
    }

    protected void addCommVarBindsToCreateList(CommVarBindList list, ConfigElementData element) {
        SnmpCommKey portalSnmpKey = element.getSnmpKey();
        SrOid portalRolesOid = new SrOid(MibItem.ISCSI_PORTAL_ROLES.toString(), portalSnmpKey.toString());
        SrBITS role = new SrBITS(TARGET_ROLE_BITS_CONST);
        list.add(new SrSnmpVarBind(portalRolesOid, (SrType)role));
    }

    public void discover(CommKeyClassId vSwitchData) throws SrCommunicationException {
        char snmpAgentIndex = vSwitchData.getMyFirstSnmpAgentIndex();
        ConfigElementDataList elementsList = this.getAllExtended(snmpAgentIndex, null, null);
        this.sendDiscoveredElementsToEventMgr(elementsList, vSwitchData);
    }

    public ConfigElementDataList getAllExtended(char snmpAgentIndex, SrTimeTicks lastUpdate, CheckListConfigElementData checkListElement) throws SrCommunicationException {
        ConfigElementDataList elementsList = this.getAll(snmpAgentIndex, lastUpdate, checkListElement);
        if (elementsList != null && elementsList.size() > 0) {
            IscsiTgtPortalConfigurator tgtPortalConfig = new IscsiTgtPortalConfigurator();
            ConfigElementDataList tgtPortalList = tgtPortalConfig.getAll(snmpAgentIndex, lastUpdate, null);
            this.mergeElementLists(elementsList, tgtPortalList, true);
        }
        return elementsList;
    }

    public HashMap getListOfParams() {
        HashMap<ParameterCode, Object> paramList = new HashMap<ParameterCode, Object>(5);
        paramList.put(ParameterCode.ISCSI_PORTAL_IP_ADDRESS, null);
        paramList.put(ParameterCode.ISCSI_PORTAL_PORT, null);
        paramList.put(ParameterCode.ISCSI_PORTAL_ROLE, null);
        return paramList;
    }

    private void refreshDependedTables(char snmpAgent) throws SrCommunicationException {
        SCSIRemoteTargetConfigurator remoteTargetCfg = new SCSIRemoteTargetConfigurator();
        remoteTargetCfg.refreshRemoteTargetsForDependantOnOperations(snmpAgent);
    }

    public void postSendCreateEvent(ConfigElementData element) throws SrCommunicationException {
        char snmpAgent = element.getSnmpAgentFromParameter();
        this.refreshDependedTables(snmpAgent);
    }

    public void postSendRemoveEvent(ConfigElementData element) throws SrCommunicationException {
        char snmpAgent = element.getMyFirstSnmpAgentIndex();
        this.refreshDependedTables(snmpAgent);
    }
}

