/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr.storage;

import com.sanrad.log.LogMgr;
import com.sanrad.nms.server.comm.CommMgr;
import com.sanrad.nms.server.comm.CommVarBindList;
import com.sanrad.nms.server.comm.exception.SrCommunicationException;
import com.sanrad.nms.server.comm.snmp.MibItem;
import com.sanrad.nms.server.comm.snmp.SrOid;
import com.sanrad.nms.server.comm.snmp.SrSnmpVarBind;
import com.sanrad.nms.server.comm.snmp.trap.SrTrap;
import com.sanrad.nms.server.event.SrEventHandler;
import com.sanrad.nms.server.exception.MissingValueException;
import com.sanrad.nms.server.exception.SrElementOperationException;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.ConfigElementDataList;
import com.sanrad.nms.server.mgr.discover.DiscoverMgr;
import com.sanrad.nms.server.mgr.storage.PhysicalStorageConfigurator;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKey;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.CommKeyFetcher;
import com.sanrad.nms.server.util.CommKeyUtil;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.SnmpCommKey;
import com.sanrad.nms.server.util.types.SrLunFormat;
import com.sanrad.nms.server.util.types.SrString;
import com.sanrad.nms.server.util.types.SrType;
import java.util.Collection;
import java.util.HashMap;

public class SubDirectAccessDeviceConfigurator
extends PhysicalStorageConfigurator {
    public SubDirectAccessDeviceConfigurator() {
        super(ClassID.SUB_DIRECT_ACCESS_DEVICE, "srPhysDiskSplitTable", MibItem.SUB_DIRECT_ACCESS_DEVICE_RS, MibItem.SUB_DIRECT_ACCESS_DEVICE_TABLE_LAST_UPDATE, true);
    }

    void discover(ConfigElementDataList elementsList, CommKeyClassId vSwitchData) throws SrCommunicationException {
        ConfigElementDataList subDiskList = this.getAll(vSwitchData.getMyFirstSnmpAgentIndex(), null, null);
        elementsList.addAll((Collection)subDiskList);
    }

    private CommKey[] createDiskKeyFromSubDiskKey(CommKey[] subDiskKey) {
        CommKey[] newKey = new CommKey[subDiskKey.length];
        int newKeyIndex = 0;
        String diskKey = null;
        for (int i = 0; i < subDiskKey.length; ++i) {
            if (((CommKeyFetcher)((Object)subDiskKey[i])).getSnmpCommKey() == null) continue;
            String indices = subDiskKey[i].getKey();
            int firstDot = indices.indexOf(".");
            String tmp = indices.substring(firstDot + 1);
            int secondDot = tmp.indexOf(".");
            diskKey = indices.substring(0, firstDot + secondDot + 1);
            newKey[newKeyIndex++] = new SnmpCommKey(diskKey, ((CommKeyFetcher)((Object)subDiskKey[i])).getSnmpCommKey().getSnmpAgentIndex());
        }
        if (newKeyIndex == subDiskKey.length) {
            return newKey;
        }
        if (newKeyIndex > 0) {
            CommKey[] resizedNewKey = new CommKey[newKeyIndex];
            System.arraycopy(newKey, 0, resizedNewKey, 0, newKey.length);
            return resizedNewKey;
        }
        return null;
    }

    public void internalCreate(ConfigElementData element) throws SrCommunicationException, SrElementOperationException {
        this.updateCedAfterCreate(element);
        char snmpAgentIndex = element.getSnmpAgentFromParameter();
        SrLunFormat endAddress = (SrLunFormat)element.getValue(ParameterCode.SUB_DIRECT_ACCESS_DEVICE_END_ADDR);
        CommKeyClassId diskData = (CommKeyClassId)element.getValue(ParameterCode.SUB_DIRECT_ACCESS_DEVICE_DISK_ID);
        CommKeyClassId diskSpecificData = CommKeyUtil.getSpecificCommKeyClassId(diskData, snmpAgentIndex);
        if (diskSpecificData == null) {
            throw new MissingValueException("SubDisk Create - Missing Data of Physical Storage for Agent: " + CommKeyUtil.getIpFromIndex(snmpAgentIndex));
        }
        this.removeSimpleVolume(diskSpecificData, snmpAgentIndex);
        CommKey[] diskKeys = diskSpecificData.getCommKeys();
        SnmpCommKey snmpKey = CommKeyUtil.getSnmpCommKey(diskKeys);
        SnmpCommKey snmpSubDiskKey = new SnmpCommKey(snmpKey.toString() + "." + endAddress.toSNMPIndexString(), snmpAgentIndex);
        element.setCommKey(snmpSubDiskKey);
        Object alias = element.getValue(ParameterCode.SUB_DIRECT_ACCESS_DEVICE_ALIAS);
        if (alias == null || alias.equals("")) {
            String subDiskIndex = endAddress.toString();
            for (int i = 0; i < subDiskIndex.length(); ++i) {
                if (subDiskIndex.charAt(i) == '0') continue;
                subDiskIndex = subDiskIndex.substring(i);
                break;
            }
            String tmpStr = snmpSubDiskKey.toString().substring(snmpSubDiskKey.toString().indexOf(".") + 1);
            String parentIndex = tmpStr.substring(0, tmpStr.indexOf("."));
            SrString newAlias = new SrString("Split_" + subDiskIndex + "_disk" + parentIndex);
            element.setValue(ParameterCode.SUB_DIRECT_ACCESS_DEVICE_ALIAS, newAlias);
        }
        CommVarBindList varBindList = new CommVarBindList();
        CommKey[] commKeys = element.getCommKey();
        if (CommKeyUtil.isNullKeys(commKeys)) {
            throw new NullPointerException("Try to create element " + element.getClassId().toString() + " with no CommKey");
        }
        for (int i = 0; i < commKeys.length; ++i) {
            if (((CommKeyFetcher)((Object)commKeys[i])).getSnmpCommKey() == null) continue;
            varBindList = this.addRowStatusVarBind(varBindList, commKeys[i]);
            break;
        }
        this.convertParamsToVarBinds(element, varBindList);
        this.addCommVarBindsToCreateList(varBindList, element);
        try {
            CommMgr.getInstance(element.getMyFirstSnmpAgentIndex()).setList(varBindList, element.getMyFirstSnmpAgentIndex());
        }
        catch (SrCommunicationException ce) {
            logger.debug(ce);
            ce.setElement(element);
            throw ce;
        }
    }

    public HashMap getListOfParams() {
        HashMap<ParameterCode, Object> paramList = new HashMap<ParameterCode, Object>(5);
        paramList.put(ParameterCode.SUB_DIRECT_ACCESS_DEVICE_INFO, null);
        paramList.put(ParameterCode.SUB_DIRECT_ACCESS_DEVICE_LENGTH, null);
        paramList.put(ParameterCode.SUB_DIRECT_ACCESS_DEVICE_ALIAS, null);
        paramList.put(ParameterCode.SUB_DIRECT_ACCESS_DEVICE_OPER_STATUS, null);
        paramList.put(ParameterCode.SUB_DIRECT_ACCESS_DEVICE_LAST_UPDATE, null);
        return paramList;
    }

    protected void readDiscoverPostOperation(ConfigElementData element, CommVarBindList rowList) throws SrCommunicationException {
        String endAddress = null;
        CommKey[] diskKeys = this.createDiskKeyFromSubDiskKey(element.getCommKey());
        for (int i = 0; i < diskKeys.length; ++i) {
            if (((CommKeyFetcher)((Object)diskKeys[i])).getSnmpCommKey() == null) continue;
            int diskIndexLen = diskKeys[i].toString().length();
            endAddress = element.getCommKey()[i].getKey().substring(diskIndexLen + 1);
        }
        element.setValue(ParameterCode.SUB_DIRECT_ACCESS_DEVICE_DISK_ID, new CommKeyClassId(diskKeys, ClassID.DIRECT_ACCESS_DEVICE));
        SrLunFormat endAddressInLunFormat = new SrLunFormat();
        endAddressInLunFormat.setValWithIntDotString(endAddress);
        element.setValue(ParameterCode.SUB_DIRECT_ACCESS_DEVICE_END_ADDR, endAddressInLunFormat);
        SrType volId = this.getVarBindValueFromList(rowList, MibItem.SUB_DIRECT_ACCESS_DEVICE_VOL_ID);
        if (volId != null) {
            CommKeyClassId physStorData = new CommKeyClassId(element.getCommKey(), element.getClassId());
            DiscoverMgr.getInstance().addEntryToVolPhysStorMap("1." + volId.toString(), physStorData);
        }
    }

    protected void trapProccessingPostOperation(ConfigElementData element, SrTrap trap) {
        switch (trap.getTrapType().getTrapId()) {
            case 11: {
                try {
                    this.internalRead(element);
                }
                catch (SrCommunicationException e) {
                    Object vSwitchData = element.getValue(ParameterCode.VSWITCH_ID);
                    LogMgr.getServerLog().warning("Failed to get new SubDisk data from VSwitch " + vSwitchData.toString(), e);
                    return;
                }
                LogMgr.getServerLog().debug("Added by Trap for " + element.getClassId().toString() + " CommKey is: " + CommKeyUtil.getKeyForMessage(element.getCommKey()));
                SrEventHandler.getEventMgr().sendAddElementEvent(element);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Operation not supported for trap ID " + trap.getTrapType().getTrapId());
            }
        }
    }

    protected void addCommVarBindsToReadList(CommVarBindList list, ConfigElementData element) {
        super.addCommVarBindsToReadList(list, element);
        SnmpCommKey snmpKey = element.getSnmpKey();
        SrOid oid = new SrOid(MibItem.SUB_DIRECT_ACCESS_DEVICE_LENGTH.toString(), snmpKey.toString());
        list.add(new SrSnmpVarBind(oid, null));
        oid = new SrOid(MibItem.SUB_DIRECT_ACCESS_DEVICE_INFO.toString(), snmpKey.toString());
        list.add(new SrSnmpVarBind(oid, null));
        oid = new SrOid(MibItem.SUB_DIRECT_ACCESS_DEVICE_ALIAS.toString(), snmpKey.toString());
        list.add(new SrSnmpVarBind(oid, null));
        oid = new SrOid(MibItem.SUB_DIRECT_ACCESS_DEVICE_VOL_ID.toString(), snmpKey.toString());
        list.add(new SrSnmpVarBind(oid, null));
    }

    protected void internalReadExtentionTable(ConfigElementData element, ConfigElementDataList retrievedElements) throws SrCommunicationException {
    }
}

