/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr.storage;

import com.sanrad.log.LogMgr;
import com.sanrad.nms.server.comm.CommItem;
import com.sanrad.nms.server.comm.CommVarBindList;
import com.sanrad.nms.server.comm.exception.SrCommunicationException;
import com.sanrad.nms.server.comm.snmp.MibItem;
import com.sanrad.nms.server.comm.snmp.SrOid;
import com.sanrad.nms.server.comm.snmp.SrSnmpVarBind;
import com.sanrad.nms.server.comm.snmp.trap.SrTrap;
import com.sanrad.nms.server.event.SrEventHandler;
import com.sanrad.nms.server.exception.SrElementOperationException;
import com.sanrad.nms.server.mgr.CheckListConfigElementData;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.ConfigElementDataList;
import com.sanrad.nms.server.mgr.DataMgr;
import com.sanrad.nms.server.mgr.ElementConfigurator;
import com.sanrad.nms.server.mgr.SCSIRemoteTargetConfigurator;
import com.sanrad.nms.server.mgr.discover.DiscoverMgr;
import com.sanrad.nms.server.mgr.storage.DirectAccessDeviceConfigurator;
import com.sanrad.nms.server.mgr.storage.LUIdentifierConfigurator;
import com.sanrad.nms.server.mgr.storage.PhysicalStorageCommandConfigurator;
import com.sanrad.nms.server.mgr.storage.SubDirectAccessDeviceConfigurator;
import com.sanrad.nms.server.mgr.volume.SimpleVolumeConfigurator;
import com.sanrad.nms.server.mgr.volume.VolumeOperationConfigurator;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKey;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.CommKeyFetcher;
import com.sanrad.nms.server.util.CommKeyUtil;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.SnmpCommKey;
import com.sanrad.nms.server.util.types.SrString;
import com.sanrad.nms.server.util.types.SrType;
import com.sanrad.nms.server.util.types.constants.PhysicalStorageTypeConstant;
import com.sanrad.nms.server.util.types.constants.VolumeTypeConstants;
import java.util.HashMap;
import java.util.Vector;

public class PhysicalStorageConfigurator
extends ElementConfigurator {
    private static final Object s_createLock = new Object();
    private static final HashMap paramList = new HashMap(10);

    public PhysicalStorageConfigurator() {
        this(ClassID.GENERAL_PHYSICAL_STORAGE, "srPhysStorTable", MibItem.PHYSICAL_STORAGE_RS, MibItem.PHYSICAL_STORAGE_TBL_LAST_UPDATE, true);
    }

    protected PhysicalStorageConfigurator(ClassID classId, String tableName, MibItem rs) {
        this(classId, tableName, rs, MibItem.PHYSICAL_STORAGE_LAST_UPDATE, true);
    }

    protected PhysicalStorageConfigurator(ClassID classId, String tableName, MibItem rsMib, MibItem luMib, boolean hasLastUpdateForEntry) {
        super(classId, tableName, rsMib, luMib, hasLastUpdateForEntry);
    }

    protected void internalReadExtentionTable(ConfigElementData element, ConfigElementDataList retrievedElements) throws SrCommunicationException {
        SnmpCommKey elementCommKey = element.getSnmpKey();
        ConfigElementData physicalStorageComElement = new ConfigElementData(elementCommKey, ClassID.GENERAL_PHYSICAL_STORAGE);
        PhysicalStorageCommandConfigurator physicalStorageComConfigurator = new PhysicalStorageCommandConfigurator();
        physicalStorageComConfigurator.internalRead(physicalStorageComElement);
        element.addParameter(physicalStorageComElement.getParametersList());
        if (element.getClassId().equals(ClassID.DIRECT_ACCESS_DEVICE)) {
            DirectAccessDeviceConfigurator directAccessDeviceCfg = new DirectAccessDeviceConfigurator();
            ConfigElementData directAccessDeviceElement = new ConfigElementData(elementCommKey, ClassID.DIRECT_ACCESS_DEVICE);
            directAccessDeviceCfg.internalRead(directAccessDeviceElement);
            element.addParameter(directAccessDeviceElement.getParametersList());
        }
        if (retrievedElements != null && !retrievedElements.contains(element)) {
            retrievedElements.add(element);
        }
    }

    public void discover(CommKeyClassId vSwitchData) throws SrCommunicationException {
        char snmpAgentIndex = vSwitchData.getMyFirstSnmpAgentIndex();
        LUIdentifierConfigurator luIdConfig = new LUIdentifierConfigurator();
        luIdConfig.discover(vSwitchData);
        ConfigElementDataList physicalStorageList = this.getAll(snmpAgentIndex, null, null);
        if (physicalStorageList.size() > 0) {
            PhysicalStorageCommandConfigurator physicalStorageComConfigurator = new PhysicalStorageCommandConfigurator();
            ConfigElementDataList physStorComList = physicalStorageComConfigurator.getAll(snmpAgentIndex, null, null);
            this.mergeElementLists(physicalStorageList, physStorComList, false);
        }
        DirectAccessDeviceConfigurator directAccessConfig = new DirectAccessDeviceConfigurator();
        SubDirectAccessDeviceConfigurator subDiskConfig = new SubDirectAccessDeviceConfigurator();
        directAccessConfig.discover(physicalStorageList, vSwitchData);
        subDiskConfig.discover(physicalStorageList, vSwitchData);
        this.sendDiscoveredElementsToEventMgr(physicalStorageList, vSwitchData);
    }

    public HashMap getListOfParams() {
        return paramList;
    }

    protected void readDiscoverPostOperation(ConfigElementData element, CommVarBindList rowList) throws SrCommunicationException {
        SrType storageType = (SrType)element.getValue(ParameterCode.PHYSICAL_STORAGE_TYPE);
        if (storageType != null) {
            if (storageType.equals(PhysicalStorageTypeConstant.PHYS_STOR_TYPE_DIRECT_ACCESS_DEVICE)) {
                element.setClassId(ClassID.DIRECT_ACCESS_DEVICE);
            } else if (storageType.equals(PhysicalStorageTypeConstant.PHYS_STOR_TYPE_SEQUENTIAL_ACCESS_DEVICE)) {
                element.setClassId(ClassID.SEQUENTIAL_ACCESS_DEVICE);
            } else {
                element.setClassId(ClassID.GENERAL_SCSI_DEVICE);
            }
        } else {
            logger.warning("Storage type is null " + element);
        }
        SrType volId = this.getVarBindValueFromList(rowList, MibItem.PHYSICAL_STORAGE_VOL_ID);
        if (volId != null) {
            CommKeyClassId physStorData;
            String volumeIndex = "1." + volId.toString();
            SrType[] volType = this.readTableCells(new MibItem[]{MibItem.VIRTUAL_VOLUME_TYPE}, volumeIndex, element.getMyFirstSnmpAgentIndex());
            if (VolumeTypeConstants.VOLUME_TYPE_SIMPLE.equals(volType[0])) {
                physStorData = new CommKeyClassId(element.getCommKey(), element.getClassId());
                DiscoverMgr.getInstance().addEntryToVolPhysStorMap(volumeIndex, physStorData);
            } else if (VolumeTypeConstants.VOLUME_TYPE_TRANSPARENT.equals(volType[0])) {
                physStorData = new CommKeyClassId(element.getCommKey(), element.getClassId());
                DiscoverMgr.getInstance().getDiscoveryMgr(physStorData.getMyFirstSnmpAgentIndex()).addDiscoveredTransparentStorage(volumeIndex, physStorData);
            }
        }
        CommKeyClassId physStorCommKeyClassId = new CommKeyClassId(element.getCommKey(), element.getClassId());
        Vector luIds = DiscoverMgr.getInstance().getEntryFromLUIdPhysStorMap(physStorCommKeyClassId);
        if (luIds != null) {
            SrType[] luIdCommKeyClassIds = new CommKeyClassId[luIds.size()];
            luIds.toArray(luIdCommKeyClassIds);
            element.setValues(ParameterCode.PHYSICAL_STORAGE_LU_IDENTIFIER, luIdCommKeyClassIds);
        } else {
            logger.debug("LU IDs of " + physStorCommKeyClassId.getClassID() + " CommKey " + physStorCommKeyClassId.getCommKeys()[0] + " is null");
        }
        DiscoverMgr.getInstance().clearLUIdPhysStorMap(physStorCommKeyClassId);
    }

    protected CommItem getCommItemForTrapCommKey(SrTrap trap) {
        switch (trap.getTrapType().getTrapId()) {
            case 0: 
            case 1: 
            case 2: {
                return MibItem.PHYSICAL_STORAGE_TYPE;
            }
            case 12: {
                return MibItem.PHYSICAL_STORAGE_COM_OPER_STATUS;
            }
            case 11: {
                return MibItem.SUB_DIRECT_ACCESS_DEVICE_RS;
            }
        }
        throw new UnsupportedOperationException("Operation not supported for trap " + trap.getTrapType().toString());
    }

    protected void trapProccessingPostOperation(ConfigElementData element, SrTrap trap) {
        try {
            this.readDiscoverPostOperation(element, trap.getVarBindList());
            switch (trap.getTrapType().getTrapId()) {
                case 1: {
                    this.physStorAddedByTrap(element);
                    break;
                }
                case 0: {
                    LogMgr.getServerLog().debug("Removed by Trap for " + element.getClassId().toString() + " CommKey is: " + CommKeyUtil.getKeyForMessage(element.getCommKey()));
                    SrEventHandler.getEventMgr().sendRemoveElementEvent(element);
                    break;
                }
                case 2: 
                case 12: {
                    LogMgr.getServerLog().debug("Changed by Trap for " + element.getClassId().toString() + " CommKey is: " + CommKeyUtil.getKeyForMessage(element.getCommKey()));
                    ElementConfigurator specificConfig = DataMgr.getElementConfigFromClassID(element.getClassId());
                    ConfigElementData specificDevice = new ConfigElementData(element.getCommKeyClassId());
                    specificDevice.addParameter(specificConfig.getListOfParams());
                    this.internalRead(specificDevice);
                    SrEventHandler.getEventMgr().sendChangeElementEvent(specificDevice);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Operation not supported for trap ID " + trap.getTrapType().getTrapId());
                }
            }
        }
        catch (SrCommunicationException e) {
            LogMgr.getServerLog().warning(e);
            return;
        }
    }

    void physStorAddedByTrap(ConfigElementData element) {
        ElementConfigurator specificConfig = DataMgr.getElementConfigFromClassID(element.getClassId());
        try {
            specificConfig.internalRead(element);
        }
        catch (SrCommunicationException e) {
            LogMgr.getServerLog().warning("Faild to get new Physical Storage data from the VSwitch", e);
            return;
        }
        LogMgr.getServerLog().debug("Added by Trap for " + element.getClassId().toString() + " CommKey is: " + CommKeyUtil.getKeyForMessage(element.getCommKey()));
        SrEventHandler.getEventMgr().sendAddElementEvent(element);
    }

    protected String[] getTablesOfElement(ConfigElementData element) {
        String[] tableName = new String[]{"srPhysStorTable"};
        return tableName;
    }

    public void internalChange(ConfigElementData element) throws SrCommunicationException, SrElementOperationException {
        SimpleVolumeConfigurator simpleConfig = new SimpleVolumeConfigurator();
        HashMap mirrVolParams = simpleConfig.getListOfParamsForMirror();
        this.splitParameterListOfDifferentElement(element, mirrVolParams);
        if (mirrVolParams.size() > 0) {
            char snmpAgentIndex = element.getMyFirstSnmpAgentIndex();
            CommKeyClassId thisPhysStor = new CommKeyClassId(element.getCommKey(), element.getClassId());
            String volId = DiscoverMgr.getInstance().getVolIdForPhysStor(thisPhysStor, snmpAgentIndex);
            SnmpCommKey volKey = new SnmpCommKey("1." + volId, snmpAgentIndex);
            ConfigElementData mirrVolData = new ConfigElementData(volKey, ClassID.GENERAL_VOLUME, mirrVolParams);
            simpleConfig.internalChange(mirrVolData);
        }
        if (element.getParametersList().size() > 0) {
            super.internalChange(element);
        }
    }

    public static CommKey[] getDeviceKeyFromMyKey(CommKey[] myKey) {
        CommKey[] newKey = new CommKey[myKey.length];
        int newKeyIndex = 0;
        String deviceKey = null;
        for (int i = 0; i < myKey.length; ++i) {
            if (((CommKeyFetcher)((Object)myKey[i])).getSnmpCommKey() == null) continue;
            String indices = myKey[i].getKey();
            int firstDot = indices.indexOf(".");
            String tmp = indices.substring(firstDot + 1);
            int secondDot = tmp.indexOf(".");
            deviceKey = indices.substring(0, firstDot + secondDot + 1);
            newKey[newKeyIndex++] = new SnmpCommKey(deviceKey, ((CommKeyFetcher)((Object)myKey[i])).getSnmpCommKey().getSnmpAgentIndex());
        }
        if (newKeyIndex == myKey.length) {
            return newKey;
        }
        if (newKeyIndex > 0) {
            CommKey[] resizedNewKey = new CommKey[newKeyIndex];
            System.arraycopy(newKey, 0, resizedNewKey, 0, newKey.length);
            return resizedNewKey;
        }
        return null;
    }

    protected void addCommVarBindsToReadList(CommVarBindList list, ConfigElementData element) {
        super.addCommVarBindsToReadList(list, element);
        SrOid oid = new SrOid(MibItem.PHYSICAL_STORAGE_TYPE.toString(), element.getSnmpKey().toString());
        list.add(new SrSnmpVarBind(oid, null));
        oid = new SrOid(MibItem.PHYSICAL_STORAGE_VOL_ID.toString(), element.getSnmpKey().toString());
        list.add(new SrSnmpVarBind(oid, null));
    }

    public void internalRemove(ConfigElementData element) throws SrCommunicationException {
        CommKeyClassId physStorData = new CommKeyClassId(element.getCommKey(), element.getClassId());
        this.removeSimpleVolume(physStorData, element.getMyFirstSnmpAgentIndex());
        super.internalRemove(element);
        VolumeOperationConfigurator volumeOperCfg = new VolumeOperationConfigurator();
        volumeOperCfg.refreshTable(element.getMyFirstSnmpAgentIndex(), null, new CheckListConfigElementData(ClassID.COPY_OPERATION));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void internalCreate(ConfigElementData element) throws SrCommunicationException, SrElementOperationException {
        Object object = s_createLock;
        synchronized (object) {
            char snmpAgentIndex = element.getSnmpAgentFromParameter();
            SnmpCommKey key = this.getPhysicalStorageIndexNext(snmpAgentIndex);
            element.setCommKey(key);
            SrString sn = (SrString)element.getValue(ParameterCode.PHYSICAL_STORAGE_SERIAL_NUMBER);
            if (sn != null && sn.value().equals("")) {
                element.removeParameter(ParameterCode.PHYSICAL_STORAGE_SERIAL_NUMBER);
            }
            ParameterCode[] createCodes = PhysicalStorageConfigurator.getCreateParams();
            ConfigElementData createElement = new ConfigElementData(element.getCommKeyClassId());
            int i = createCodes.length;
            while (i-- > 0) {
                createElement.addParameterToElement(element, createCodes[i]);
            }
            super.internalCreate(createElement);
            ParameterCode[] changeCodes = this.getChangeParams();
            ConfigElementData changeElement = new ConfigElementData(element.getCommKeyClassId());
            int i2 = changeCodes.length;
            while (i2-- > 0) {
                changeElement.addParameterToElement(element, changeCodes[i2]);
            }
            super.internalChange(changeElement);
        }
    }

    public static ParameterCode[] getCreateParams() {
        ParameterCode[] codes = new ParameterCode[]{ParameterCode.PHYSICAL_STORAGE_ALIAS, ParameterCode.PHYSICAL_STORAGE_ENTITY_NAME, ParameterCode.PHYSICAL_STORAGE_LUN, ParameterCode.PHYSICAL_STORAGE_TYPE, ParameterCode.PHYSICAL_STORAGE_TRANSPORT_TYPE, ParameterCode.PHYSICAL_STORAGE_SERIAL_NUMBER};
        return codes;
    }

    public ParameterCode[] getChangeParams() {
        return new ParameterCode[0];
    }

    public SnmpCommKey getPhysicalStorageIndexNext(char agentIndex) throws SrCommunicationException {
        String indexNext = super.getIndexNext(this.myTableName, "1.1", null, false, agentIndex);
        return new SnmpCommKey(indexNext, agentIndex);
    }

    public void postCreateEvent(ConfigElementData myElement) {
        DataMgr.getInstance().waitForDataUpdatesInVSwitches(4000L);
        SCSIRemoteTargetConfigurator remoteTargetConf = new SCSIRemoteTargetConfigurator();
        remoteTargetConf.refreshRemoteTargetsForDependantOnOperations(myElement.getSnmpAgentFromParameter());
    }

    public void postRemoveOperation(ConfigElementData element) throws SrCommunicationException {
        SCSIRemoteTargetConfigurator remoteTargetsCfg = new SCSIRemoteTargetConfigurator();
        remoteTargetsCfg.refreshRemoteTargetsForDependantOnOperations(element.getMyFirstSnmpAgentIndex());
    }

    static {
        paramList.put(ParameterCode.PHYSICAL_STORAGE_ALIAS, null);
        paramList.put(ParameterCode.PHYSICAL_STORAGE_ENTITY_NAME, null);
        paramList.put(ParameterCode.PHYSICAL_STORAGE_INFO, null);
        paramList.put(ParameterCode.PHYSICAL_STORAGE_LUN, null);
        paramList.put(ParameterCode.PHYSICAL_STORAGE_OPERATIONAL_STATUS, null);
        paramList.put(ParameterCode.PHYSICAL_STORAGE_VENDOR_NAME, null);
        paramList.put(ParameterCode.PHYSICAL_STORAGE_COM_ADMIN_STATUS, null);
        paramList.put(ParameterCode.PHYSICAL_STORAGE_COM_DURATION, null);
        paramList.put(ParameterCode.PHYSICAL_STORAGE_COM_OPER_STATUS, null);
        paramList.put(ParameterCode.PHYSICAL_STORAGE_SERIAL_NUMBER, null);
        paramList.put(ParameterCode.PHYSICAL_STORAGE_PRODUCT_ID, null);
        paramList.put(ParameterCode.PHYSICAL_STORAGE_REVISION_LEVEL, null);
        paramList.put(ParameterCode.PHYSICAL_STORAGE_SCSI_VER, null);
        paramList.put(ParameterCode.PHYSICAL_STORAGE_LAST_UPDATE, null);
        paramList.put(ParameterCode.PHYSICAL_STORAGE_TRANSPORT_TYPE, null);
    }
}

