/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr.storage;

import com.sanrad.log.LogMgr;
import com.sanrad.nms.server.comm.CommVarBind;
import com.sanrad.nms.server.comm.CommVarBindKey;
import com.sanrad.nms.server.comm.CommVarBindList;
import com.sanrad.nms.server.comm.exception.SrCommunicationException;
import com.sanrad.nms.server.comm.snmp.MibItem;
import com.sanrad.nms.server.comm.snmp.SrOid;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.ConfigElementDataList;
import com.sanrad.nms.server.mgr.storage.PhysicalStorageConfigurator;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.CommKeyUtil;
import com.sanrad.nms.server.util.Parameter;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.SnmpCommKey;
import com.sanrad.nms.server.util.types.SrInteger;
import com.sanrad.nms.server.util.types.constants.BlockSizeConstant;
import com.sanrad.nms.server.util.types.constants.RowStatusConstants;
import java.util.HashMap;
import java.util.Iterator;

public class DirectAccessDeviceConfigurator
extends PhysicalStorageConfigurator {
    private static final ParameterCode[] m_codesForChange = new ParameterCode[]{ParameterCode.DIRECT_ACCESS_DEVICE_BLOCK_NUM, ParameterCode.DIRECT_ACCESS_DEVICE_BLOCK_SIZE, ParameterCode.DIRECT_ACCESS_DEVICE_WCE_STATE_ENABLE, ParameterCode.DIRECT_ACCESS_DEVICE_ALLOCABLE};

    public DirectAccessDeviceConfigurator() {
        super(ClassID.DIRECT_ACCESS_DEVICE, "srPhysDiskTable", MibItem.DIRECT_ACCESS_DEVICE_RS);
    }

    public void discover(ConfigElementDataList elementsList, CommKeyClassId vSwitchData) throws SrCommunicationException {
        ConfigElementDataList diskList = this.getAll(vSwitchData.getMyFirstSnmpAgentIndex(), null, null);
        this.mergeElementLists(elementsList, diskList, false);
    }

    public HashMap getListOfParams() {
        HashMap paramList = super.getListOfParams();
        paramList.put(ParameterCode.DIRECT_ACCESS_DEVICE_BLOCK_NUM, null);
        paramList.put(ParameterCode.DIRECT_ACCESS_DEVICE_BLOCK_SIZE, null);
        paramList.put(ParameterCode.DIRECT_ACCESS_DEVICE_WCE_STATE, null);
        paramList.put(ParameterCode.DIRECT_ACCESS_DEVICE_WP, null);
        paramList.put(ParameterCode.DIRECT_ACCESS_DEVICE_ALLOCABLE, null);
        return paramList;
    }

    public ParameterCode[] getChangeParams() {
        return m_codesForChange;
    }

    protected String[] getTablesOfElement(ConfigElementData element) {
        String[] superTableList = super.getTablesOfElement(element);
        String[] tableName = new String[superTableList.length + 1];
        System.arraycopy(superTableList, 0, tableName, 0, superTableList.length);
        tableName[superTableList.length] = this.myTableName;
        return tableName;
    }

    protected void readDiscoverPostOperation(ConfigElementData element, CommVarBindList list) throws SrCommunicationException {
        SrInteger blockSize = (SrInteger)element.getValue(ParameterCode.DIRECT_ACCESS_DEVICE_BLOCK_SIZE);
        if (blockSize != null) {
            BlockSizeConstant bSize = BlockSizeConstant.getType(blockSize);
            if (blockSize.intValue() < 1 && bSize != null) {
                SrInteger newSize = new SrInteger(BlockSizeConstant.getType(blockSize).getBlockSize());
                element.setValue(ParameterCode.DIRECT_ACCESS_DEVICE_BLOCK_SIZE, newSize);
            }
        }
    }

    protected void internalReadExtentionTable(ConfigElementData element, ConfigElementDataList retrievedElements) throws SrCommunicationException {
    }

    protected ConfigElementData createConfigElementFromTableRow(CommVarBindList rowList, char agentIndex) throws SrCommunicationException {
        String key = ((CommVarBind)rowList.elementAt(0)).getIndexForCommKey();
        SnmpCommKey commKey = new SnmpCommKey(key, agentIndex);
        ConfigElementData element = new ConfigElementData(commKey, this.myClassId);
        Iterator rowItr = rowList.iterator();
        while (rowItr.hasNext()) {
            Parameter param;
            String strKey;
            CommVarBind varBind = (CommVarBind)rowItr.next();
            CommVarBindKey vbKey = varBind.getVarBindKey();
            if (vbKey instanceof SrOid && (strKey = ((SrOid)vbKey).getOid()).equals(this.myRowStatusMib.toString())) {
                try {
                    if (varBind.getValue().equals(RowStatusConstants.ROW_STATUS_DESTROY)) {
                        return null;
                    }
                }
                catch (Exception e) {
                    LogMgr.getServerLog().error(e);
                }
            }
            if ((param = this.convertVarBindToParam(varBind)) == null) continue;
            element.addParameter(param);
            rowItr.remove();
        }
        CommKeyClassId vSwitch = CommKeyUtil.getVSwitchData(agentIndex);
        element.setValue(ParameterCode.VSWITCH_ID, vSwitch);
        rowList.setSnmpAgentIndex(agentIndex);
        this.readDiscoverPostOperation(element, rowList);
        this.discoveryPostDiscoverOpration(element, rowList);
        return element;
    }
}

