/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr.srv.radius;

import com.sanrad.nms.server.comm.CommVarBindList;
import com.sanrad.nms.server.comm.exception.SrCommunicationException;
import com.sanrad.nms.server.comm.snmp.MibItem;
import com.sanrad.nms.server.exception.SrElementOperationException;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.srv.ExternalServerConfigurator;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.SnmpCommKey;
import java.util.Vector;

public class RadiusServerConfigurator
extends ExternalServerConfigurator {
    static Vector lastRadiusIndex = new Vector(2);

    public RadiusServerConfigurator() {
        super(ClassID.RADIUS_SERVER, "srRadiusAuthServerTable", MibItem.RADIUS_SERVER_RS, MibItem.RADIUS_SERVER_TBL_LAST_UPDATE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void internalCreate(ConfigElementData element) throws SrCommunicationException, SrElementOperationException {
        Vector vector = lastRadiusIndex;
        synchronized (vector) {
            char agentIndex = element.getSnmpAgentFromParameter();
            while (lastRadiusIndex.size() <= agentIndex) {
                lastRadiusIndex.addElement(new Integer(-1));
            }
            this.getAll(agentIndex, null, null);
            Integer last = (Integer)lastRadiusIndex.get(agentIndex);
            int index = last == null || last == -1 ? 0 : last;
            Integer newIndex = new Integer(index + 1);
            element.setCommKey(new SnmpCommKey(newIndex.toString(), agentIndex));
            super.internalCreate(element);
        }
    }

    protected void readDiscoverPostOperation(ConfigElementData element, CommVarBindList list) throws SrCommunicationException {
        this.keepTrackOfLastIndex(element, list);
    }

    private void keepTrackOfLastIndex(ConfigElementData element, CommVarBindList list) {
        String index = element.getSnmpKey().toString();
        Integer radiusIndex = new Integer(index);
        char agentIndex = element.getMyFirstSnmpAgentIndex();
        if (lastRadiusIndex.size() <= agentIndex) {
            lastRadiusIndex.addElement(new Integer(-1));
        } else {
            Integer recent = (Integer)lastRadiusIndex.get(agentIndex);
            if (recent == null || recent < radiusIndex) {
                lastRadiusIndex.remove(agentIndex);
                lastRadiusIndex.add(agentIndex, radiusIndex);
            }
        }
    }
}

