/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr.srv.isns;

import com.sanrad.nms.server.comm.CommVarBindList;
import com.sanrad.nms.server.comm.exception.SrCommunicationException;
import com.sanrad.nms.server.comm.snmp.MibItem;
import com.sanrad.nms.server.exception.SrElementOperationException;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.srv.ExternalServerConfigurator;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.SnmpCommKey;
import java.util.Vector;

public class ISNSServerConfigurator
extends ExternalServerConfigurator {
    static Vector lastISNSIndex = new Vector(2);

    public ISNSServerConfigurator() {
        super(ClassID.ISNS_SERVER, "srIsnsLocalAddrCfgTable", MibItem.ISNS_SERVER_RS, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void internalCreate(ConfigElementData element) throws SrCommunicationException, SrElementOperationException {
        Vector vector = lastISNSIndex;
        synchronized (vector) {
            char agentIndex = element.getSnmpAgentFromParameter();
            while (lastISNSIndex.size() <= agentIndex) {
                lastISNSIndex.addElement(new Integer(-1));
            }
            this.getAll(agentIndex, null, null);
            Integer last = (Integer)lastISNSIndex.get(agentIndex);
            int index = last == null || last == -1 ? 0 : last;
            Integer newIndex = new Integer(index + 1);
            element.setCommKey(new SnmpCommKey(newIndex.toString(), agentIndex));
            super.internalCreate(element);
        }
    }

    protected void readDiscoverPostOperation(ConfigElementData element, CommVarBindList list) throws SrCommunicationException {
        this.keepTrackOfLastIndex(element, list);
    }

    private void keepTrackOfLastIndex(ConfigElementData element, CommVarBindList list) {
        String index = element.getSnmpKey().toString();
        Integer radiusIndex = new Integer(index);
        char agentIndex = element.getMyFirstSnmpAgentIndex();
        if (lastISNSIndex.size() <= agentIndex) {
            lastISNSIndex.addElement(new Integer(-1));
        } else {
            Integer recent = (Integer)lastISNSIndex.get(agentIndex);
            if (recent == null || recent < radiusIndex) {
                lastISNSIndex.remove(agentIndex);
                lastISNSIndex.add(agentIndex, radiusIndex);
            }
        }
    }
}

