/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr.polling.groups;

import com.sanrad.nms.server.comm.exception.SrCommunicationException;
import com.sanrad.nms.server.comm.snmp.MibItem;
import com.sanrad.nms.server.mgr.ConfigElementDataList;
import com.sanrad.nms.server.mgr.polling.LastChangedTableEntryItem;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.ParameterCode;
import java.util.Vector;

public class PollAuthIdentTblItem
extends LastChangedTableEntryItem {
    private static final String[] TABLE_NAMES = new String[]{"ipsAuthIdentAttributesTable"};
    private static final ClassID[] CLASS_IDS = new ClassID[]{ClassID.IDENTITY};
    private static int numOfIndexes = 0;
    private static final int IDENTITY_CHECK_LIST_INDEX = numOfIndexes++;
    private static final int IDENTITY_NAMES_CHECK_LIST_INDEX = numOfIndexes++;
    private static final int IDENTITY_CHAP_CHECK_LIST_INDEX = numOfIndexes++;
    private static final int IDENTITY_SRP_CHECK_LIST_INDEX = numOfIndexes++;

    public PollAuthIdentTblItem(char agentIndex) {
        super(agentIndex, MibItem.IDENTITY_EXTENTION_TBL_LAST_UPDATE, MibItem.IDENTITY_ENTRY_LAST_UPDATED, TABLE_NAMES, CLASS_IDS);
    }

    protected void refresh() throws SrCommunicationException {
        this.refresh(ParameterCode.IDENTITY_LAST_UPDATE);
    }

    protected void operateLogicAllCheckLists(Vector checkListTopTable, ConfigElementDataList elementsList) {
        this.operateLogicCheckList(checkListTopTable);
        if (elementsList.size() > 0) {
            Object[] checkListsVectors = this.sortElementsListToCheckLists(elementsList);
            Vector listOfPrefixes = (Vector)checkListsVectors[IDENTITY_CHECK_LIST_INDEX];
            Vector currCheckList = null;
            for (int index = 1; index < checkListsVectors.length; ++index) {
                currCheckList = (Vector)checkListsVectors[index];
                ClassID currClassId = index == IDENTITY_NAMES_CHECK_LIST_INDEX ? ClassID.IDENTITY_NAME : (index == IDENTITY_CHAP_CHECK_LIST_INDEX ? ClassID.CHAP_CREDENTIALS : ClassID.SRP_CREDENTIALS);
                this.operateLogicCheckList(currClassId, currCheckList, listOfPrefixes);
            }
        }
    }

    protected Object[] reorderByClassIdsCheckLists(Vector source) {
        Object[] reorderedVecs = new Object[numOfIndexes];
        reorderedVecs[PollAuthIdentTblItem.IDENTITY_CHECK_LIST_INDEX] = source.elementAt(0);
        for (int index = 1; index < source.size(); ++index) {
            Vector currVec = (Vector)source.elementAt(index);
            if (currVec == null || currVec.size() <= 0) continue;
            ClassID currVecClassId = ((CommKeyClassId)currVec.elementAt(0)).getClassID();
            if (currVecClassId.getId() == ClassID.IDENTITY_NAME.getId()) {
                reorderedVecs[PollAuthIdentTblItem.IDENTITY_NAMES_CHECK_LIST_INDEX] = currVec;
                continue;
            }
            if (currVecClassId.getId() == ClassID.CHAP_CREDENTIALS.getId()) {
                reorderedVecs[PollAuthIdentTblItem.IDENTITY_CHAP_CHECK_LIST_INDEX] = currVec;
                continue;
            }
            reorderedVecs[PollAuthIdentTblItem.IDENTITY_SRP_CHECK_LIST_INDEX] = currVec;
        }
        return reorderedVecs;
    }
}

