/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr.polling;

import com.sanrad.nms.server.comm.CommVarBindList;
import com.sanrad.nms.server.comm.snmp.MibItem;
import com.sanrad.nms.server.comm.snmp.SrOid;
import com.sanrad.nms.server.comm.snmp.SrSnmpVarBind;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.polling.AgentPollingElement;
import com.sanrad.nms.server.mgr.polling.PollingGroupType;
import java.util.HashMap;
import java.util.Vector;

public class PollingMgr {
    public static final boolean START_POLLING = true;
    public static final boolean STOP_POLLING = false;
    private static PollingMgr m_theInstance = new PollingMgr();
    private static HashMap m_agentPollingElementsList = new HashMap();

    public static PollingMgr getInstance() {
        return m_theInstance;
    }

    public void addAgent(ConfigElementData element) {
        char agentIndex = element.getSnmpAgentFromParameter();
        Character agentIndexChar = new Character(agentIndex);
        if (!this.isAgentExisted(agentIndexChar)) {
            PollingGroupType[] groups = new PollingGroupType[]{PollingGroupType.GENERAL_GROUP_TYPE, PollingGroupType.VIRTUALIZATION_GROUP_TYPE, PollingGroupType.ACL_GROUP_TYPE, PollingGroupType.NETWORKING_AND_INTERFACE_GROUP_TYPE, PollingGroupType.ISCSI_GROUP_TYPE, PollingGroupType.INTERFACE_GROUP_TYPE, PollingGroupType.IP_GROUP_TYPE, PollingGroupType.ICMP_GROUP_TYPE, PollingGroupType.TCP_GROUP_TYPE, PollingGroupType.UDP_GROUP_TYPE, PollingGroupType.ISCSI_REMOTE_INITIATOR_STATISTICS_GROUP_TYPE, PollingGroupType.ISCSI_SESSIONS_STATISTICS_GROUP_TYPE, PollingGroupType.SCSI_TARGET_PORT_STATISTICS_GROUP_TYPE, PollingGroupType.SCSI_INITIATOR_PORT_STATISTICS_GROUP_TYPE};
            AgentPollingElement newAgentPollingElement = new AgentPollingElement(groups, element, agentIndex);
            m_agentPollingElementsList.put(new Character(agentIndex), newAgentPollingElement);
        }
    }

    public void removeAgent(ConfigElementData element) {
        char agentIndex = element.getSnmpAgentFromParameter();
        this.stopPollingProcess(agentIndex, PollingGroupType.ALL_GROUP_TYPE, true);
        m_agentPollingElementsList.remove(new Character(agentIndex));
    }

    private boolean isAgentExisted(Character agentIndexChar) {
        Object obj = m_agentPollingElementsList.get(agentIndexChar);
        return obj != null;
    }

    public void addListOfAgents(Vector elementList) {
        for (int index = 0; index < elementList.size(); ++index) {
            ConfigElementData element = (ConfigElementData)elementList.get(index);
            this.addAgent(element);
        }
    }

    public AgentPollingElement getAgentPollingElement(char agentIndex) {
        Character c = new Character(agentIndex);
        AgentPollingElement agentPollingElement = (AgentPollingElement)m_agentPollingElementsList.get(c);
        return agentPollingElement;
    }

    public void startPollingProcess(char agentIndex, PollingGroupType groupType, long delay) {
        AgentPollingElement pollingElement = this.getAgentPollingElement(agentIndex);
        if (pollingElement != null) {
            pollingElement.handlePollingProcess(groupType, true, delay, true);
        }
    }

    public void stopPollingProcess(char agentIndex, PollingGroupType groupType, boolean resetParameters) {
        AgentPollingElement pollingElement = this.getAgentPollingElement(agentIndex);
        if (pollingElement != null) {
            pollingElement.handlePollingProcess(groupType, false, 0L, resetParameters);
        }
    }

    public static synchronized CommVarBindList convertMibItemsListToVarBindList(Vector mibItemsList) {
        CommVarBindList vbList = new CommVarBindList();
        for (int index = 0; index < mibItemsList.size(); ++index) {
            MibItem mibItem = (MibItem)mibItemsList.get(index);
            SrOid oid = new SrOid(mibItem.toString(), "0");
            SrSnmpVarBind vb = new SrSnmpVarBind(oid, null);
            vbList.add(vb);
        }
        return vbList;
    }

    public static synchronized CommVarBindList convertMibItemsListToVarBindList(MibItem[] mibItemsList) {
        CommVarBindList vbList = new CommVarBindList();
        for (int index = 0; index < mibItemsList.length; ++index) {
            SrOid oid = new SrOid(mibItemsList[index].toString(), "0");
            SrSnmpVarBind vb = new SrSnmpVarBind(oid, null);
            vbList.add(vb);
        }
        return vbList;
    }

    public synchronized void agentPollintElementState(int messageType) {
    }
}

