/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr.polling;

import com.sanrad.log.Log;
import com.sanrad.log.LogMgr;
import com.sanrad.nms.server.comm.CommMgr;
import com.sanrad.nms.server.comm.CommVarBindList;
import com.sanrad.nms.server.comm.exception.SrCommunicationException;
import com.sanrad.nms.server.comm.snmp.exception.SrSnmpTimeoutException;
import com.sanrad.nms.server.mgr.polling.AgentPollingElement;
import com.sanrad.nms.server.mgr.polling.GroupPollingIfc;
import com.sanrad.nms.server.mgr.polling.PollItem;
import com.sanrad.nms.server.mgr.polling.PollSingleItem;
import com.sanrad.nms.server.mgr.polling.PollingGroupState;
import com.sanrad.nms.server.mgr.polling.PollingGroupType;
import com.sanrad.nms.server.mgr.polling.PollingMgr;
import com.sanrad.nms.server.mgr.polling.PollingMultiItems;
import com.sanrad.nms.server.mgr.threads.SrThreadCreationException;
import com.sanrad.nms.server.mgr.threads.ThreadMgr;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.CommKeyUtil;
import com.sanrad.nms.server.util.types.SrDouble;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;

public abstract class PollingGroup
implements GroupPollingIfc {
    private static Log logger = LogMgr.getServerLog();
    private static final int MULTIPLE_FACTOR = 60000;
    private static final double DEFAULT_POLL_INTERVAL = 1.0;
    private PollingGroupType m_type = null;
    private AgentPollingElement m_agentPollElement = null;
    private Vector m_pollSingleItemList = new Vector();
    private Vector m_pollMultiItemsList = new Vector();
    private Timer m_pollTimer = null;
    private SrDouble m_pollInterval = null;
    private PollingGroupState m_state = PollingGroupState.INACTIVE;
    protected String m_name = "";

    protected PollingGroup(AgentPollingElement agentPollElement, PollingGroupType groupType, SrDouble groupPollInterval, String name) {
        this.m_agentPollElement = agentPollElement;
        this.m_type = groupType;
        this.initPollSingleItemsList();
        this.initPollMultiItemsList();
        this.m_name = name;
        this.m_pollInterval = groupPollInterval;
        if (this.m_pollInterval == null) {
            this.m_pollInterval = new SrDouble(1.0);
        }
    }

    protected abstract void initPollSingleItemsList();

    protected abstract void initPollMultiItemsList();

    protected char getAgentIndex() {
        return this.m_agentPollElement.getAgentIndex();
    }

    protected void addPollSingleItemToList(PollSingleItem item) {
        if (this.m_pollSingleItemList != null) {
            this.m_pollSingleItemList.add(item);
        }
    }

    protected void addPollMultiItemToList(PollingMultiItems item) {
        if (this.m_pollMultiItemsList != null) {
            this.m_pollMultiItemsList.add(item);
        }
    }

    protected Vector getPollSingleItemList() {
        return this.m_pollSingleItemList;
    }

    protected Vector getPollMultiItemsList() {
        return this.m_pollMultiItemsList;
    }

    protected int pollSingleItemListSize() {
        return this.m_pollSingleItemList.size();
    }

    protected int pollMultiItemsListSize() {
        return this.m_pollMultiItemsList.size();
    }

    protected PollSingleItem getPollSingleItemAt(int index) {
        return (PollSingleItem)this.m_pollSingleItemList.get(index);
    }

    protected PollingMultiItems getPollMultiItemsAt(int index) {
        return (PollingMultiItems)this.m_pollMultiItemsList.get(index);
    }

    public PollingGroupState getState() {
        return this.m_state;
    }

    private Vector getListOfMibItemsToSnmpGet() {
        Vector listOfMibItemsToSnmpGet = new Vector();
        for (int index = 0; index < this.pollSingleItemListSize(); ++index) {
            PollSingleItem item = this.getPollSingleItemAt(index);
            item.addMibItemsToList(listOfMibItemsToSnmpGet);
        }
        return listOfMibItemsToSnmpGet;
    }

    protected void operateUpdateCheck(CommVarBindList vbList) {
        PollItem item;
        int index;
        for (index = 0; index < this.pollSingleItemListSize(); ++index) {
            item = this.getPollSingleItemAt(index);
            ((PollSingleItem)item).poll(vbList);
        }
        for (index = 0; index < this.pollMultiItemsListSize(); ++index) {
            item = this.getPollMultiItemsAt(index);
            ((PollingMultiItems)item).poll(vbList);
        }
    }

    public void resetParameters() {
        for (int index = 0; index < this.pollSingleItemListSize(); ++index) {
            PollSingleItem item = this.getPollSingleItemAt(index);
            item.resetParameters();
        }
    }

    public void startPolling(long delay) {
        double interval = 0.0;
        long wait = 0L;
        if (this.m_pollTimer == null) {
            this.m_pollTimer = new Timer(false);
            PollingTask pt = null;
            try {
                pt = new PollingTask();
                if (delay == 0L) {
                    if (this.m_pollInterval != null) {
                        interval = this.m_pollInterval.doubleValue();
                        wait = (long)interval;
                    }
                } else {
                    interval = delay;
                }
                if (interval > 0.0) {
                    long inter = (long)(interval * 60000.0);
                    this.m_pollTimer.schedule((TimerTask)pt, wait * 60000L, inter);
                }
            }
            catch (SrThreadCreationException e) {
                this.m_pollTimer.cancel();
                this.m_pollTimer = null;
            }
        }
    }

    public void stopPolling(boolean resetParameters) {
        if (this.m_pollTimer != null) {
            this.m_pollTimer.cancel();
            this.m_pollTimer = null;
            LogMgr.getServerLog().debug("Stop Poll for group " + this.m_name);
        }
        if (resetParameters) {
            this.resetParameters();
        }
    }

    public void setGroupState(PollingGroupState state) {
        this.m_state = state;
        this.m_agentPollElement.groupStateChanged(this, this.m_state);
    }

    public final void poll() throws SrCommunicationException {
        LogMgr.getServerLog().debug("Start Poll for group " + this.m_name);
        Vector listOfMibItemsToSnmpGet = this.getListOfMibItemsToSnmpGet();
        CommVarBindList vbList = null;
        vbList = PollingMgr.convertMibItemsListToVarBindList(listOfMibItemsToSnmpGet);
        CommMgr.getInstance(this.m_agentPollElement.getAgentIndex()).getList(vbList, this.m_agentPollElement.getAgentIndex());
        this.operateUpdateCheck(vbList);
    }

    public String toString() {
        return CommKeyUtil.getIpFromIndex(this.m_agentPollElement.getAgentIndex()) + ": " + this.m_type;
    }

    protected boolean isPollingPossible() {
        return !this.m_agentPollElement.isTimeoutDisconnected();
    }

    class PollingTask
    extends TimerTask {
        private int numOfPoll = 0;

        public PollingTask() throws SrThreadCreationException {
            ThreadMgr.getInstance().getAgentThreadMgr(PollingGroup.this.m_agentPollElement.getAgentIndex()).createPollingPossible(PollingGroup.this.m_type);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Thread currentThread = Thread.currentThread();
            currentThread.setPriority(1);
            if (PollingGroup.this.m_agentPollElement == null) {
                return;
            }
            CommKeyClassId vswitchData = CommKeyUtil.getVSwitchData(PollingGroup.this.m_agentPollElement.getAgentIndex());
            if (vswitchData == null) {
                return;
            }
            ThreadMgr.getInstance().addThread(vswitchData);
            ThreadMgr.getInstance().getAgentThreadMgr(PollingGroup.this.m_agentPollElement.getAgentIndex()).managePollingThread(PollingGroup.this.m_type);
            if (this.numOfPoll == 0) {
                String ip = CommKeyUtil.getIpFromIndex(PollingGroup.this.m_agentPollElement.getAgentIndex());
                currentThread.setName(currentThread.getName() + " used by: " + PollingGroup.this.m_type.toString() + ", BOX_PRODUCT_NAME: " + ip);
            }
            ++this.numOfPoll;
            PollingGroup.this.setGroupState(PollingGroupState.ACTIVE);
            Object object = PollingGroup.this.m_agentPollElement.getAgentPollingLock();
            synchronized (object) {
                try {
                    if (PollingGroup.this.isPollingPossible()) {
                        PollingGroup.this.m_agentPollElement.operateSysTimeUpCheck();
                        PollingGroup.this.m_agentPollElement.setTimeoutDisconnected(false);
                        PollingGroup.this.poll();
                    }
                }
                catch (SrSnmpTimeoutException sste) {
                    PollingGroup.this.m_agentPollElement.setTimeoutDisconnected(true);
                    logger.error(sste.getMessage());
                    PollingGroup.this.m_agentPollElement.sendTimeOutEvent(this, sste);
                }
                catch (Throwable th) {
                    logger.error(th);
                }
            }
            PollingGroup.this.setGroupState(PollingGroupState.INACTIVE);
            ThreadMgr.getInstance().getAgentThreadMgr(PollingGroup.this.m_agentPollElement.getAgentIndex()).pollingThreadDoneProcess(PollingGroup.this.m_type);
            ThreadMgr.getInstance().removeThread(CommKeyUtil.getVSwitchData(PollingGroup.this.m_agentPollElement.getAgentIndex()));
        }
    }
}

