/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr.polling;

import com.sanrad.log.LogMgr;
import com.sanrad.nms.server.comm.CommVarBind;
import com.sanrad.nms.server.comm.CommVarBindList;
import com.sanrad.nms.server.comm.exception.SrCommunicationException;
import com.sanrad.nms.server.comm.snmp.MibItem;
import com.sanrad.nms.server.comm.snmp.exception.SrSnmpTimeoutException;
import com.sanrad.nms.server.mgr.polling.PollItem;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.types.SrTimeTicks;
import java.util.Vector;

public abstract class PollSingleItem
extends PollItem {
    protected MibItem m_tableLastUpdatedMibItem = null;
    protected SrTimeTicks m_tableLastUpdatedMibValue = null;
    protected ClassID m_classId = null;

    protected PollSingleItem(char agentIndex, MibItem tableLastUpdatedMibItem) {
        super(agentIndex);
        this.m_tableLastUpdatedMibItem = tableLastUpdatedMibItem;
        this.m_tableLastUpdatedMibValue = this.m_tableLastUpdatedMibItem == null ? null : new SrTimeTicks(0);
    }

    protected PollSingleItem(char agentIndex, MibItem tableLastUpdatedMibItem, ClassID classId) {
        this(agentIndex, tableLastUpdatedMibItem);
        this.m_classId = classId;
    }

    protected PollSingleItem(char agentIndex, ClassID classId) {
        super(agentIndex);
        this.m_tableLastUpdatedMibItem = null;
        this.m_tableLastUpdatedMibValue = null;
        this.m_classId = classId;
    }

    protected MibItem getTableLastUpdateMibItem() {
        return this.m_tableLastUpdatedMibItem;
    }

    public void addMibItemsToList(Vector list) {
        if (this.m_tableLastUpdatedMibItem != null) {
            list.add(this.m_tableLastUpdatedMibItem);
        }
    }

    public void poll(CommVarBindList vbList) {
        SrTimeTicks readTableLastUpdateValue = null;
        if (this.m_tableLastUpdatedMibItem != null) {
            CommVarBind vb = (CommVarBind)vbList.elementAt(0);
            readTableLastUpdateValue = (SrTimeTicks)vb.getValue();
            if (readTableLastUpdateValue == null) {
                Object item = this.m_classId == null ? this.m_tableLastUpdatedMibItem : this.m_classId;
                LogMgr.getServerLog().error("LastUpdate value of " + item + " is not supported (for polling)");
            }
            vbList.remove(0);
        }
        if (this.m_tableLastUpdatedMibValue == null || readTableLastUpdateValue != null && readTableLastUpdateValue.compareLongValueTo(this.m_tableLastUpdatedMibValue) > 0) {
            try {
                this.refresh();
                if (this.m_tableLastUpdatedMibItem != null) {
                    this.m_tableLastUpdatedMibValue = readTableLastUpdateValue;
                }
            }
            catch (SrSnmpTimeoutException sste) {
                LogMgr.getServerLog().error(sste.getMessage());
            }
            catch (SrCommunicationException sce) {
                LogMgr.getServerLog().error(sce);
            }
        }
    }

    protected void refresh() throws SrCommunicationException {
    }

    public void resetParameters() {
        this.m_tableLastUpdatedMibValue = new SrTimeTicks(0);
    }
}

