/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr.polling;

import com.sanrad.nms.server.comm.CommMgr;
import com.sanrad.nms.server.comm.CommVarBind;
import com.sanrad.nms.server.comm.CommVarBindList;
import com.sanrad.nms.server.comm.exception.SrCommunicationException;
import com.sanrad.nms.server.comm.snmp.MibItem;
import com.sanrad.nms.server.comm.snmp.SrOid;
import com.sanrad.nms.server.comm.snmp.SrSnmpVarBind;
import com.sanrad.nms.server.mgr.CheckListConfigElementData;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.ConfigElementDataList;
import com.sanrad.nms.server.mgr.DataMgr;
import com.sanrad.nms.server.mgr.ElementConfigurator;
import com.sanrad.nms.server.mgr.polling.LastChangedTableItem;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.CommKeyUtil;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.SnmpCommKey;
import com.sanrad.nms.server.util.types.SrTimeTicks;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;

public class LastChangedTableEntryItem
extends LastChangedTableItem {
    private MibItem m_tableEntryLastUpdateMibItem = null;

    public LastChangedTableEntryItem(char agentIndex, MibItem tableLastUpdateMibItem, MibItem tableEntryLastUpdateMibItem, String[] tableNames, ClassID[] classIdsList) {
        super(agentIndex, tableLastUpdateMibItem, tableNames, classIdsList);
        this.m_tableEntryLastUpdateMibItem = tableEntryLastUpdateMibItem;
    }

    protected void refresh() throws SrCommunicationException {
        this.refresh(ParameterCode.LAST_UPDATE);
    }

    protected void refresh(ParameterCode lastUpdateParameterCode) throws SrCommunicationException {
        CommVarBindList lastUpdateVarBindList = this.getLastUpdateVarBindList();
        CommVarBindList[] lastUpdateVarBinds = CommMgr.getInstance(this.getAgentIndex()).snmpGetBulk(lastUpdateVarBindList, this.getAgentIndex());
        if (lastUpdateVarBinds != null) {
            ElementConfigurator elementCfg = DataMgr.getElementConfigFromClassID(this.m_ClassIdList[0]);
            ConfigElementDataList elementsList = new ConfigElementDataList();
            ConfigElementDataList retrievedElementsList = new ConfigElementDataList();
            Vector checkListTopTable = new Vector();
            for (int index = 0; index < lastUpdateVarBinds.length; ++index) {
                this.setCommKeyDataToCheckList(checkListTopTable, lastUpdateVarBinds[index]);
                CommVarBindList rowList = lastUpdateVarBinds[index];
                String currCommKey = ((CommVarBind)rowList.elementAt(0)).getIndexForCommKey();
                SrTimeTicks newLastUpdateOfEntryVal = (SrTimeTicks)rowList.getValue(lastUpdateParameterCode);
                if (this.m_tableLastUpdatedMibValue != null && newLastUpdateOfEntryVal.compareLongValueTo(this.m_tableLastUpdatedMibValue) <= 0) continue;
                ConfigElementData cfgElemData = new ConfigElementData(new SnmpCommKey(currCommKey, this.getAgentIndex()), this.m_ClassIdList[0]);
                elementCfg.refreshElement(cfgElemData, retrievedElementsList);
                if (!this.filterElementForRefresh(cfgElemData)) {
                    if (!retrievedElementsList.contains(cfgElemData)) {
                        elementsList.add(cfgElemData);
                    }
                    elementsList.addAll((Collection)retrievedElementsList);
                }
                retrievedElementsList.removeAllElements();
            }
            if (elementsList.size() > 0) {
                this.sendLogicRefreshElementEvent(elementsList);
            }
            this.operateLogicAllCheckLists(checkListTopTable, elementsList);
        }
    }

    protected void operateLogicAllCheckLists(Vector checkListTopTable, ConfigElementDataList elementsList) {
        if (checkListTopTable != null) {
            this.operateLogicCheckList(checkListTopTable);
        }
    }

    protected Object[] sortElementsListToCheckLists(ConfigElementDataList elementsList) {
        Iterator elementIter = elementsList.iterator();
        Vector<ClassID> classIdsList = new Vector<ClassID>();
        Vector checkListsVectors = new Vector();
        while (elementIter.hasNext()) {
            ConfigElementData currElement = (ConfigElementData)elementIter.next();
            ClassID currElementClassId = currElement.getClassId();
            int indexOfClassId = classIdsList.indexOf(currElementClassId);
            if (indexOfClassId < 0) {
                classIdsList.add(currElementClassId);
                indexOfClassId = classIdsList.indexOf(currElementClassId);
            }
            this.addElementToCheckList(checkListsVectors, indexOfClassId, currElement);
        }
        Object[] reorderedCheckListsVectors = this.reorderByClassIdsCheckLists(checkListsVectors);
        return reorderedCheckListsVectors;
    }

    protected Object[] reorderByClassIdsCheckLists(Vector source) {
        Object[] retArray = new Object[]{source};
        return retArray;
    }

    private void addElementToCheckList(Vector checkListsVectors, int indexOfClassId, ConfigElementData element) {
        Vector checkList = null;
        if (indexOfClassId > checkListsVectors.size() - 1) {
            checkList = new Vector();
            checkListsVectors.add(checkList);
        } else {
            checkList = (Vector)checkListsVectors.elementAt(indexOfClassId);
        }
        CommKeyClassId commKeyClassId = element.getCommKeyClassId();
        checkList.add(commKeyClassId);
    }

    private void setCommKeyDataToCheckList(Vector checkList, CommVarBindList vbList) {
        String key = ((CommVarBind)vbList.elementAt(0)).getIndexForCommKey();
        SnmpCommKey commKey = new SnmpCommKey(key, this.getAgentIndex());
        checkList.add(new CommKeyClassId(commKey, this.m_ClassIdList[0]));
    }

    protected void operateLogicCheckList(Vector checkListTopTable) {
        if (checkListTopTable != null) {
            this.operateLogicCheckList(this.m_ClassIdList[0], checkListTopTable, null);
        }
    }

    protected void operateLogicCheckList(ClassID currClassId, Vector currChecklist, Vector listOfPrefixes) {
        CheckListConfigElementData checkListElement = new CheckListConfigElementData(currClassId);
        checkListElement.setValue(ParameterCode.LAST_UPDATE, this.m_tableLastUpdatedMibValue);
        checkListElement.setValue(ParameterCode.VSWITCH_ID, CommKeyUtil.getVSwitchData(this.getAgentIndex()));
        checkListElement.setCheckList(currChecklist);
        checkListElement.setSuperTblCheckList(listOfPrefixes);
        this.sendLogicCheckListElementEvent(checkListElement);
    }

    private CommVarBindList getLastUpdateVarBindList() {
        CommVarBindList varBindsToGet = new CommVarBindList();
        SrOid oid = new SrOid(this.m_tableEntryLastUpdateMibItem.toString(), "0");
        SrSnmpVarBind varBind = new SrSnmpVarBind(oid, null);
        varBindsToGet.add(varBind);
        return varBindsToGet;
    }

    protected boolean filterElementForRefresh(ConfigElementData element) {
        return false;
    }
}

