/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr.polling;

import com.sanrad.nms.server.comm.CommMgr;
import com.sanrad.nms.server.comm.CommVarBind;
import com.sanrad.nms.server.comm.CommVarBindList;
import com.sanrad.nms.server.comm.exception.SrCommunicationException;
import com.sanrad.nms.server.comm.snmp.MibItem;
import com.sanrad.nms.server.comm.snmp.exception.SrSnmpTimeoutException;
import com.sanrad.nms.server.event.SnmpErrorEvent;
import com.sanrad.nms.server.event.SrEventHandler;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.polling.PollingGroup;
import com.sanrad.nms.server.mgr.polling.PollingGroupState;
import com.sanrad.nms.server.mgr.polling.PollingGroupType;
import com.sanrad.nms.server.mgr.polling.PollingMgr;
import com.sanrad.nms.server.util.CommKeyUtil;
import com.sanrad.nms.server.util.types.SrTimeTicks;
import com.sanrad.nms.server.util.types.SrType;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

public class AgentPollingElement {
    private char m_agentIndex;
    private HashMap m_pollGroupsList = new HashMap();
    private SrTimeTicks m_lastSysUpTime = null;
    private boolean m_isTimeoutDisconnected = false;
    private Object m_agentPollingLock = new Object();
    static /* synthetic */ Class class$com$sanrad$nms$server$mgr$polling$AgentPollingElement;
    static /* synthetic */ Class class$com$sanrad$nms$server$util$types$SrDouble;

    public AgentPollingElement(PollingGroupType[] groups, ConfigElementData element, char agentIndex) {
        this.m_agentIndex = agentIndex;
        for (int i = 0; i < groups.length; ++i) {
            this.initPollingGroup(groups[i], element);
        }
    }

    private void initPollingGroup(PollingGroupType groupType, ConfigElementData element) {
        Class groupClass = groupType.getPollingClass();
        if (groupClass == null) {
            return;
        }
        SrType groupInterval = (SrType)element.getValue(groupType.getPollingIntervalCode());
        Object pollingGroupInstance = null;
        try {
            pollingGroupInstance = groupClass.getConstructor(class$com$sanrad$nms$server$mgr$polling$AgentPollingElement == null ? (class$com$sanrad$nms$server$mgr$polling$AgentPollingElement = AgentPollingElement.class$("com.sanrad.nms.server.mgr.polling.AgentPollingElement")) : class$com$sanrad$nms$server$mgr$polling$AgentPollingElement, class$com$sanrad$nms$server$util$types$SrDouble == null ? (class$com$sanrad$nms$server$util$types$SrDouble = AgentPollingElement.class$("com.sanrad.nms.server.util.types.SrDouble")) : class$com$sanrad$nms$server$util$types$SrDouble).newInstance(this, groupInterval);
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Failed to initialize " + groupType, e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Failed to initialize " + groupType, e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Failed to initialize " + groupType, e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Failed to initialize " + groupType, e);
        }
        if (pollingGroupInstance != null) {
            this.m_pollGroupsList.put(groupType, pollingGroupInstance);
        }
    }

    public void resetPollingLastUpdatedValues() {
        this.resetLastSysUpTime();
        this.handlePollingResetOnGroup(PollingGroupType.VIRTUALIZATION_GROUP_TYPE);
        this.handlePollingResetOnGroup(PollingGroupType.ACL_GROUP_TYPE);
        this.handlePollingResetOnGroup(PollingGroupType.NETWORKING_AND_INTERFACE_GROUP_TYPE);
        this.handlePollingResetOnGroup(PollingGroupType.GENERAL_GROUP_TYPE);
        this.handlePollingResetOnGroup(PollingGroupType.ISCSI_GROUP_TYPE);
    }

    public void resetLastSysUpTime() {
        this.m_lastSysUpTime = new SrTimeTicks(0);
    }

    public void handlePollingProcessOnGroup(PollingGroupType groupType, boolean operateStart, long delay, boolean resetParameters) {
        PollingGroup group = (PollingGroup)this.m_pollGroupsList.get(groupType);
        if (group == null) {
            new IllegalArgumentException(groupType + " not found in m_pollGroupsList - no polling handling for that group").printStackTrace();
        } else if (operateStart) {
            group.startPolling(delay);
        } else {
            group.stopPolling(resetParameters);
        }
    }

    public void handlePollingResetOnGroup(PollingGroupType groupType) {
        PollingGroup group = (PollingGroup)this.m_pollGroupsList.get(groupType);
        if (group == null) {
            new IllegalArgumentException(groupType + " not found in m_pollGroupsList - no polling handling for that group").printStackTrace();
        }
        group.resetParameters();
    }

    public void handlePollingProcess(PollingGroupType groupType, boolean pollingStatus, long delay, boolean resetParameters) {
        if (groupType.equals(PollingGroupType.ALL_GROUP_TYPE)) {
            this.handlePollingProcessOnGroup(PollingGroupType.GENERAL_GROUP_TYPE, pollingStatus, delay, resetParameters);
            this.handlePollingProcessOnGroup(PollingGroupType.VIRTUALIZATION_GROUP_TYPE, pollingStatus, delay, resetParameters);
            this.handlePollingProcessOnGroup(PollingGroupType.ACL_GROUP_TYPE, pollingStatus, delay, resetParameters);
            this.handlePollingProcessOnGroup(PollingGroupType.NETWORKING_AND_INTERFACE_GROUP_TYPE, pollingStatus, delay, resetParameters);
            this.handlePollingProcessOnGroup(PollingGroupType.ISCSI_GROUP_TYPE, pollingStatus, delay, resetParameters);
        } else {
            this.handlePollingProcessOnGroup(groupType, pollingStatus, delay, resetParameters);
        }
    }

    public char getAgentIndex() {
        return this.m_agentIndex;
    }

    public void addSysUpTimeMibItem(Vector listOfMibItemsToSnmpGet) {
        listOfMibItemsToSnmpGet.add(MibItem.VSWITCH_SYS_UP_TIME);
    }

    public void operateSysTimeUpCheck() throws SrCommunicationException {
        Vector<MibItem> mibItemsList = new Vector<MibItem>();
        mibItemsList.add(MibItem.VSWITCH_SYS_UP_TIME);
        CommVarBindList vbList = PollingMgr.convertMibItemsListToVarBindList(mibItemsList);
        CommMgr.getInstance(this.m_agentIndex).getList(vbList, this.m_agentIndex);
        CommVarBind vb = (CommVarBind)vbList.elementAt(0);
        SrTimeTicks readNewSysUpTime = (SrTimeTicks)vb.getValue();
        vbList.remove(0);
        if (this.m_lastSysUpTime == null || this.m_lastSysUpTime.equals(0) || readNewSysUpTime.compareLongValueTo(this.m_lastSysUpTime) > 0) {
            this.m_lastSysUpTime = readNewSysUpTime;
            return;
        }
        if (readNewSysUpTime.compareLongValueTo(this.m_lastSysUpTime) < 0) {
            this.resetPollingLastUpdatedValues();
        }
    }

    public synchronized void groupStateChanged(PollingGroup group, PollingGroupState state) {
        if (this.allGroupsState(state)) {
            // empty if block
        }
    }

    private boolean allGroupsState(PollingGroupState state) {
        Iterator i = this.m_pollGroupsList.values().iterator();
        while (i.hasNext()) {
            PollingGroup group = (PollingGroup)i.next();
            PollingGroupState curState = group.getState();
            if (state.equals(curState)) continue;
            return false;
        }
        return true;
    }

    public synchronized void handleLogicUpdate() {
    }

    public void sendTimeOutEvent(Object source, SrSnmpTimeoutException e) {
        SnmpErrorEvent event = new SnmpErrorEvent(source, "SNMP Timeout during polling", CommKeyUtil.getVSwitchData(this.m_agentIndex), 1);
        SrEventHandler.getSnmpErrorMgr().sendSnmpTimeOutEvent(event);
    }

    public void setTimeoutDisconnected(boolean isDisconnected) {
        this.m_isTimeoutDisconnected = isDisconnected;
    }

    public boolean isTimeoutDisconnected() {
        return this.m_isTimeoutDisconnected;
    }

    public synchronized Object getAgentPollingLock() {
        return this.m_agentPollingLock;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

