/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr.policy;

import com.sanrad.nms.server.comm.exception.SrCommunicationException;
import com.sanrad.nms.server.comm.snmp.MibItem;
import com.sanrad.nms.server.comm.snmp.SrOid;
import com.sanrad.nms.server.event.SrEventHandler;
import com.sanrad.nms.server.exception.SrElementOperationException;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.policy.PolicyConfigurator;
import com.sanrad.nms.server.mgr.policy.PolicyParamConfigurator;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKey;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.CommKeyUtil;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.SrDateAndTime;
import com.sanrad.nms.server.util.types.SrInteger;
import com.sanrad.nms.server.util.types.SrOctetStringFormat;
import com.sanrad.nms.server.util.types.SrOidType;
import com.sanrad.nms.server.util.types.SrType;
import com.sanrad.nms.server.util.types.constants.PolicyTypeConstant;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class PolicyTablesConfigurator {
    public void updatePolicies(ConfigElementData[] policies) throws SrCommunicationException, SrElementOperationException {
        char agentIndex = '\u0000';
        HashMap<PolicyParamCreateRequest, PolicyParamCreateRequest> policyParamRequests = new HashMap<PolicyParamCreateRequest, PolicyParamCreateRequest>();
        int i = policies.length;
        while (i-- > 0) {
            if (i == 0) {
                agentIndex = policies[i].getSnmpAgentFromParameter();
            }
            PolicyParamCreateRequest policyParamReq = this.createPolicyParamRequest(policies[i]);
            PolicyCreateRequest policyReq = this.createPolicyRequest(policies[i]);
            if (!policyParamRequests.keySet().contains(policyParamReq)) {
                policyParamRequests.put(policyParamReq, policyParamReq);
                policyParamReq.addPolicyCreateRequest(policyReq, policies[i]);
                continue;
            }
            ((PolicyParamCreateRequest)policyParamRequests.get(policyParamReq)).addPolicyCreateRequest(policyReq, policies[i]);
        }
        Iterator i2 = policyParamRequests.values().iterator();
        while (i2.hasNext()) {
            ((PolicyParamCreateRequest)i2.next()).create(agentIndex);
        }
    }

    private PolicyParamCreateRequest createPolicyParamRequest(ConfigElementData element) {
        PolicyTypeConstant type = (PolicyTypeConstant)element.getValue(ParameterCode.POLICY_PARAM_TYPE);
        PolicyParamConfigurator.convertRunEveryToParam1And2(element);
        SrInteger param1 = (SrInteger)element.getValue(ParameterCode.POLICY_PARAM_PARAM1);
        SrInteger param2 = (SrInteger)element.getValue(ParameterCode.POLICY_PARAM_PARAM2);
        CommKeyClassId key = (CommKeyClassId)element.getValue(ParameterCode.POLICY_PARAM_ID);
        CommKeyClassId vSwitch = (CommKeyClassId)element.getValue(ParameterCode.VSWITCH_ID);
        return new PolicyParamCreateRequest(type, param1, param2, key, vSwitch);
    }

    private PolicyCreateRequest createPolicyRequest(ConfigElementData element) {
        CommKeyClassId id = (CommKeyClassId)element.getValue(ParameterCode.POLICY_ID);
        SrDateAndTime startAt = (SrDateAndTime)element.getValue(ParameterCode.POLICY_START_AT);
        CommKeyClassId paramId = (CommKeyClassId)element.getValue(ParameterCode.POLICY_PARAM_ID);
        CommKeyClassId vSwitch = (CommKeyClassId)element.getValue(ParameterCode.VSWITCH_ID);
        return new PolicyCreateRequest(startAt, paramId, id, vSwitch);
    }

    private static class PolicyCreateRequest {
        ArrayList elements;
        CommKeyClassId policyId;
        CommKeyClassId paramId;
        SrType startAt;
        SrOidType paramIdValue;
        CommKeyClassId vSwitch;

        PolicyCreateRequest(SrDateAndTime startAt, CommKeyClassId paramId, CommKeyClassId policyId, CommKeyClassId vSwitch) {
            this.policyId = policyId;
            if (startAt != null) {
                this.startAt = (Long)startAt.value() > 0L ? startAt : new SrOctetStringFormat(this, 1, new BigInteger(new byte[]{0})){
                    private final /* synthetic */ PolicyCreateRequest this$0;
                    {
                        this.this$0 = this$0;
                    }
                };
            }
            this.vSwitch = vSwitch;
            if (paramId != null && CommKeyUtil.getSpecificCommKey(paramId, vSwitch.getMyFirstSnmpAgentIndex()) != null) {
                this.setParamID(paramId);
            }
        }

        public boolean equals(Object o) {
            PolicyCreateRequest other = (PolicyCreateRequest)o;
            boolean isEqualsStarts = this.startAt.equals(other.startAt);
            boolean isEqualsParamId = this.paramIdValue != null ? this.paramIdValue.equals(other.paramIdValue) : this.paramIdValue == null && other.paramIdValue == null;
            return isEqualsStarts && isEqualsParamId;
        }

        public int hashCode() {
            return (String.valueOf(this.startAt) + String.valueOf(this.paramId)).hashCode();
        }

        void setParamID(CommKeyClassId paramId) {
            this.paramId = paramId;
            CommKey paramKey = CommKeyUtil.getSpecificCommKey(paramId, this.vSwitch.getMyFirstSnmpAgentIndex());
            if (paramKey != null) {
                SrOid paramOid = new SrOid(MibItem.DR_POLICY_PARAM_INX.toString(), paramKey.getKey());
                this.paramIdValue = new SrOidType(paramOid.getComponents());
            }
        }

        void addElementData(ConfigElementData element) {
            if (this.elements == null) {
                this.elements = new ArrayList();
            }
            this.elements.add(element);
        }

        void create(char agentIndex) throws SrCommunicationException, SrElementOperationException {
            if (this.policyId == null || CommKeyUtil.getSpecificCommKey(this.policyId, agentIndex) == null) {
                ConfigElementData element = new ConfigElementData(ClassID.POLICY_START);
                element.setValue(ParameterCode.VSWITCH_ID, this.vSwitch);
                element.setValue(ParameterCode.POLICY_START_AT, this.startAt);
                element.setValue(ParameterCode.POLICY_POINTER_TO_PARAM, this.paramIdValue);
                PolicyConfigurator conf = new PolicyConfigurator();
                conf.internalCreate(element);
                conf.internalRead(element);
                SrEventHandler.getEventMgr().sendAddElementEvent(element);
                this.policyId = element.getCommKeyClassId();
            }
            if (this.elements != null) {
                Iterator i = this.elements.iterator();
                while (i.hasNext()) {
                    ConfigElementData transferredElement = (ConfigElementData)i.next();
                    transferredElement.setValue(ParameterCode.POLICY_ID, this.policyId);
                }
            }
        }
    }

    private static class PolicyParamCreateRequest {
        HashMap policyList;
        SrInteger param1;
        SrInteger param2;
        PolicyTypeConstant type;
        CommKeyClassId paramId;
        CommKeyClassId vSwitch;

        PolicyParamCreateRequest(PolicyTypeConstant type, SrInteger param1, SrInteger param2, CommKeyClassId paramId, CommKeyClassId vSwitch) {
            this.type = type;
            this.param1 = param1;
            this.param2 = param2;
            this.paramId = paramId;
            this.vSwitch = vSwitch;
        }

        public boolean equals(Object o) {
            PolicyParamCreateRequest other = (PolicyParamCreateRequest)o;
            if (this.paramId != null) {
                return this.paramId.equals(other.paramId);
            }
            return this.type == other.type && this.param1.intValue() == other.param1.intValue() && this.param2.intValue() == other.param2.intValue();
        }

        public int hashCode() {
            return (String.valueOf(this.paramId) + String.valueOf(this.type) + String.valueOf(this.param1) + String.valueOf(this.param2)).hashCode();
        }

        void addPolicyCreateRequest(PolicyCreateRequest req, ConfigElementData element) {
            if (this.policyList == null) {
                this.policyList = new HashMap();
            }
            if (!this.policyList.keySet().contains(req)) {
                this.policyList.put(req, req);
                req.addElementData(element);
            } else {
                ((PolicyCreateRequest)this.policyList.get(req)).addElementData(element);
            }
        }

        void create(char agentIndex) throws SrCommunicationException, SrElementOperationException {
            if (this.paramId == null || CommKeyUtil.getSpecificCommKey(this.paramId, agentIndex) == null) {
                ConfigElementData element = new ConfigElementData(ClassID.POLICY_PARAMS);
                element.setValue(ParameterCode.VSWITCH_ID, this.vSwitch);
                element.setValue(ParameterCode.POLICY_PARAM_TYPE, this.type);
                element.setValue(ParameterCode.POLICY_PARAM_PARAM1, this.param1);
                element.setValue(ParameterCode.POLICY_PARAM_PARAM2, this.param2);
                PolicyParamConfigurator conf = new PolicyParamConfigurator();
                conf.internalCreate(element);
                conf.internalRead(element);
                SrEventHandler.getEventMgr().sendAddElementEvent(element);
                this.paramId = element.getCommKeyClassId();
            }
            if (this.policyList != null) {
                Iterator i = this.policyList.values().iterator();
                while (i.hasNext()) {
                    PolicyCreateRequest req = (PolicyCreateRequest)i.next();
                    req.setParamID(this.paramId);
                    req.create(agentIndex);
                }
            }
        }
    }
}

