/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr.policy;

import com.sanrad.nms.server.comm.CommVarBindList;
import com.sanrad.nms.server.comm.exception.SrCommunicationException;
import com.sanrad.nms.server.comm.snmp.DsnmpUtil;
import com.sanrad.nms.server.comm.snmp.MibItem;
import com.sanrad.nms.server.exception.SrElementOperationException;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.ElementConfigurator;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.SnmpCommKey;
import com.sanrad.nms.server.util.types.SrOidType;
import java.util.HashMap;

public class PolicyConfigurator
extends ElementConfigurator {
    private static final HashMap listOfParams = new HashMap();

    public PolicyConfigurator() {
        super(ClassID.POLICY_START, "srPolicyTable", MibItem.DR_POLICY_ROW_STATUS, MibItem.DR_POLICY_TABLE_LAST_UPDATE);
    }

    SnmpCommKey getPolicyIndexNext(char agentIndex) throws SrCommunicationException, SrElementOperationException {
        String nextIndex = super.getIndexNext(this.myTableName, "1", null, true, agentIndex);
        return new SnmpCommKey(nextIndex, agentIndex);
    }

    public void internalCreate(ConfigElementData element) throws SrCommunicationException, SrElementOperationException {
        element.setCommKey(this.getPolicyIndexNext(element.getSnmpAgentFromParameter()));
        if (element.getValue(ParameterCode.POLICY_START_AT) == null) {
            element.removeParameter(ParameterCode.POLICY_START_AT);
        }
        super.internalCreate(element);
    }

    public HashMap getListOfParams() {
        return listOfParams;
    }

    protected void readDiscoverPostOperation(ConfigElementData element, CommVarBindList list) throws SrCommunicationException {
        char agentIndex = element.getMyFirstSnmpAgentIndex();
        SrOidType paramOid = (SrOidType)element.getValue(ParameterCode.POLICY_POINTER_TO_PARAM);
        String index = DsnmpUtil.getRowIndexFromOidComponents((long[])paramOid.value());
        CommKeyClassId paramKey = new CommKeyClassId(new SnmpCommKey(index, agentIndex), ClassID.POLICY_PARAMS);
        element.setValue(ParameterCode.POLICY_PARAM_ID, paramKey);
    }

    public void stimulateRefreshPolicyElements(char agentIndex) throws SrCommunicationException {
        super.stimulateRefresh(agentIndex);
    }

    static {
        listOfParams.put(ParameterCode.POLICY_POINTER_TO_PARAM, null);
        listOfParams.put(ParameterCode.POLICY_START_AT, null);
    }
}

