/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr.lu;

import com.sanrad.nms.server.comm.CommVarBindList;
import com.sanrad.nms.server.comm.exception.SrCommunicationException;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.ConfigElementDataList;
import com.sanrad.nms.server.mgr.ElementConfigurator;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.CommKeyUtil;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.SnmpCommKey;
import com.sanrad.nms.server.util.types.SrGauge;
import com.sanrad.nms.server.util.types.SrScsiLUNFormat;
import com.sanrad.nms.server.util.types.SrString;
import com.sanrad.nms.server.util.types.constants.SCSILunStateConstant;
import java.util.HashMap;

public class SCSILunConfigurator
extends ElementConfigurator {
    private static HashMap parameterList = new HashMap();

    public SCSILunConfigurator() {
        super(ClassID.SCSI_LUN, "scsiLuTable", null, null);
    }

    public HashMap getListOfParams() {
        return parameterList;
    }

    public void readDiscoverPostOperation(ConfigElementData element, CommVarBindList list) {
        char agent = element.getMyFirstSnmpAgentIndex();
        String rowIndex = element.getSnmpKey().toString();
        int cutFrom = 0;
        int cutTo = rowIndex.lastIndexOf(46);
        SnmpCommKey key = new SnmpCommKey(rowIndex.substring(cutFrom, cutTo), agent);
        element.setValue(ParameterCode.SCSI_DEVICE_ID, new CommKeyClassId(key, ClassID.SCSI_TARGET));
        SrString state = (SrString)element.getValue(ParameterCode.SCSI_LUN_STATE);
        if (state != null) {
            element.setValue(ParameterCode.SCSI_LUN_STATE, SCSILunStateConstant.valueOf(state.toString()));
        }
    }

    public void internalCreate(ConfigElementData element) throws SrCommunicationException {
        CommKeyClassId scsiTargetID = (CommKeyClassId)element.removeParameter(ParameterCode.SCSI_DEVICE_ID);
        if (scsiTargetID != null) {
            char agentIndex = element.getSnmpAgentFromParameter();
            long lun = ((SrGauge)element.removeParameter(ParameterCode.LU_LUN_NUMBER)).longValue();
            SnmpCommKey scsiTargetKey = CommKeyUtil.getSpecificSnmpKey(scsiTargetID, agentIndex);
            if (scsiTargetKey != null) {
                ConfigElementDataList scsiLuns = new SCSILunConfigurator().getAllByPrefix(agentIndex, scsiTargetKey.getKey());
                int i = scsiLuns.size();
                while (i-- > 0) {
                    ConfigElementData scsiLine = scsiLuns.getConfigElementDataAt(i);
                    SrScsiLUNFormat scsiLunFormat = (SrScsiLUNFormat)scsiLine.getValue(ParameterCode.SCSI_LUN_LU_NUMBER);
                    int scsiLunNumber = scsiLunFormat.toInt();
                    if (lun != (long)scsiLunNumber) continue;
                    element.removeAll();
                    element.setCommKeyClassId(scsiLine.getCommKeyClassId());
                    return;
                }
            }
        }
    }

    public boolean readAfterCreate(ConfigElementData element) throws SrCommunicationException {
        if (element.getCommKey() != null) {
            return super.readAfterCreate(element);
        }
        return true;
    }

    static {
        parameterList.put(ParameterCode.SCSI_LUN_LU_NUMBER, null);
        parameterList.put(ParameterCode.SCSI_LUN_REVISION_ID, null);
        parameterList.put(ParameterCode.SCSI_LUN_STATE, null);
        parameterList.put(ParameterCode.SCSI_LUN_STATUS, null);
    }
}

