/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr.identity;

import com.sanrad.log.LogMgr;
import com.sanrad.nms.server.comm.CommVarBindList;
import com.sanrad.nms.server.comm.exception.SrCommunicationException;
import com.sanrad.nms.server.comm.snmp.MibItem;
import com.sanrad.nms.server.event.SrCreateElementErrorEvent;
import com.sanrad.nms.server.event.SrCreateElementFailedEvent;
import com.sanrad.nms.server.event.SrEventHandler;
import com.sanrad.nms.server.exception.SrElementOperationException;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.ElementConfigurator;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKey;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.CommKeyUtil;
import com.sanrad.nms.server.util.Parameter;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.SnmpCommKey;
import com.sanrad.nms.server.util.types.SrString;
import java.util.HashMap;
import java.util.Vector;

public class IdentityNameConfigurator
extends ElementConfigurator {
    private static final Object s_createLock = new Object();
    static Vector lastNameIndex = new Vector(2);

    public IdentityNameConfigurator() {
        super(ClassID.IDENTITY_NAME, "ipsAuthIdentNameAttributesTable", MibItem.IDENTITY_NAME_RS, MibItem.IDENTITY_EXTENTION_TBL_LAST_UPDATE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void internalCreate(ConfigElementData element) throws SrCommunicationException, SrElementOperationException {
        Object object = s_createLock;
        synchronized (object) {
            char agentIndex = element.getSnmpAgentFromParameter();
            if (lastNameIndex.size() <= agentIndex) {
                lastNameIndex.addElement(this.initializeArray());
            }
            this.getAll(agentIndex, null, null);
            HashMap indexMap = (HashMap)lastNameIndex.get(agentIndex);
            Object commKeyClassId = element.removeParameter(ParameterCode.IDENTITY_NAME_PARENT);
            String identIndex = CommKeyUtil.getSpecificCommKey((CommKeyClassId)commKeyClassId, agentIndex).getKey();
            int pos = identIndex.lastIndexOf(".") + 1;
            String identityIndex = identIndex.substring(pos);
            Integer lastName = (Integer)indexMap.get(new Integer(identityIndex));
            int index = lastName == null ? 0 : lastName;
            Integer newIndex = new Integer(index + 1);
            element.setCommKey(new SnmpCommKey(identIndex + "." + newIndex.toString(), agentIndex));
            element.addParameter(new Parameter(ParameterCode.IDENTITY_NAME_PARENT, commKeyClassId));
            super.internalCreate(element);
        }
    }

    protected void readDiscoverPostOperation(ConfigElementData element, CommVarBindList list) throws SrCommunicationException {
        this.keepTrackOfLastIndex(element, list);
        Object parent = element.getValue(ParameterCode.IDENTITY_NAME_PARENT);
        if (parent == null) {
            CommKey[] commKey = element.getCommKey();
            String key = commKey[0].getKey();
            int pos = key.lastIndexOf(".");
            key = key.substring(0, pos);
            ClassID classId = ClassID.IDENTITY;
            char snmpAgent = element.getMyFirstSnmpAgentIndex();
            if (snmpAgent >= lastNameIndex.size()) {
                lastNameIndex.addElement(this.initializeArray());
            }
            SnmpCommKey identCommKey = new SnmpCommKey(key, element.getMyFirstSnmpAgentIndex());
            CommKeyClassId commKeyClassId = new CommKeyClassId(identCommKey, classId);
            element.setValue(ParameterCode.IDENTITY_NAME_PARENT, commKeyClassId);
        }
    }

    private void keepTrackOfLastIndex(ConfigElementData element, CommVarBindList list) {
        String index = element.getSnmpKey().toString();
        int pos = index.lastIndexOf(".") + 1;
        String ind = index.substring(pos);
        Integer nameIndex = new Integer(ind);
        String identIndex = index.substring(0, pos - 1);
        pos = identIndex.lastIndexOf(".") + 1;
        identIndex = identIndex.substring(pos);
        Integer identityIndex = new Integer(identIndex);
        char agentIndex = element.getMyFirstSnmpAgentIndex();
        if (lastNameIndex.size() <= agentIndex) {
            lastNameIndex.addElement(this.initializeArray());
        } else {
            HashMap map = (HashMap)lastNameIndex.get(agentIndex);
            Object recentLastName = map.get(identityIndex);
            if (recentLastName == null || (Integer)recentLastName < nameIndex) {
                map.put(identityIndex, nameIndex);
            }
        }
    }

    protected HashMap initializeArray() {
        HashMap<Integer[], Integer[]> map = new HashMap<Integer[], Integer[]>();
        Integer[] initial = new Integer[]{new Integer(0), new Integer(0)};
        map.put(initial, initial);
        return map;
    }

    public HashMap getListOfParams() {
        HashMap paramList = super.getListOfParams();
        paramList.put(ParameterCode.IDENTITY_NAME_VALUE, null);
        return paramList;
    }

    public void addNamesToIdentityElement(ConfigElementData identityElement, SrString[] names) {
        for (int index = 0; index < names.length; ++index) {
            this.addNameToIdentityElement(identityElement, names[index]);
        }
    }

    public void addNameToIdentityElement(ConfigElementData identityElement, SrString name) {
        CommKeyClassId vswitchId = (CommKeyClassId)identityElement.getValue(ParameterCode.VSWITCH_ID);
        ConfigElementData element = new ConfigElementData(ClassID.IDENTITY_NAME);
        element.setValue(ParameterCode.VSWITCH_ID, vswitchId);
        element.setValue(ParameterCode.IDENTITY_NAME_VALUE, name);
        CommKeyClassId identCommKeyClassId = new CommKeyClassId(identityElement.getCommKeyClassId());
        element.setValue(ParameterCode.IDENTITY_NAME_PARENT, identCommKeyClassId);
        try {
            this.internalCreate(element);
            this.readAfterCreate(element);
            SrEventHandler.getEventMgr().sendAddElementEvent(element);
        }
        catch (SrCommunicationException e) {
            LogMgr.getServerLog().debug("Failed to Create " + element.getClassId().toString() + " CommKey is: " + CommKeyUtil.getKeyForMessage(element.getCommKey()), e);
            SrCreateElementFailedEvent event = new SrCreateElementFailedEvent((Object)this, element);
            SrEventHandler.getEventMgr().sendElementOperationEvent(event);
            return;
        }
        catch (SrElementOperationException e) {
            LogMgr.getServerLog().debug("Element created with Error " + element.getClassId().toString() + " CommKey is: " + CommKeyUtil.getKeyForMessage(element.getCommKey()), e);
            SrCreateElementErrorEvent errorInCreateEvent = new SrCreateElementErrorEvent(e.getSource(), e.getElement(), e.getErrorParams());
            SrEventHandler.getEventMgr().sendElementOperationEvent(errorInCreateEvent);
            return;
        }
    }
}

