/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr.identity;

import com.sanrad.nms.server.comm.CommVarBindList;
import com.sanrad.nms.server.comm.exception.SrCommunicationException;
import com.sanrad.nms.server.comm.snmp.MibItem;
import com.sanrad.nms.server.mgr.CheckListConfigElementData;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.ConfigElementDataList;
import com.sanrad.nms.server.mgr.ElementConfigurator;
import com.sanrad.nms.server.mgr.identity.CredentialsExtentionConfigurator;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKey;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.Parameter;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.SnmpCommKey;
import com.sanrad.nms.server.util.types.SrOidType;
import com.sanrad.nms.server.util.types.SrTimeTicks;
import com.sanrad.nms.server.util.types.SrType;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

public abstract class CredentialsConfigurator
extends ElementConfigurator {
    public static Vector lastNameIndex = new Vector(2);
    public static SrOidType SRP_OID = new SrOidType("1.3.6.1.4.1.10059.1.11.4.1.1.1.2");
    public static SrOidType CHAP_OID = new SrOidType("1.3.6.1.4.1.10059.1.11.4.1.1.1.3");
    protected SrOidType myOidType;
    protected CredentialsExtentionConfigurator extentionConfigurator;

    public CredentialsConfigurator(ClassID classId) {
        super(classId, "ipsAuthCredentialAttributesTable", MibItem.CREDENTIALS_RS, MibItem.IDENTITY_EXTENTION_TBL_LAST_UPDATE);
        this.initExtentionConfigurator();
    }

    protected abstract void initExtentionConfigurator();

    public CredentialsConfigurator(ClassID classId, String tableName, MibItem rowStatus) {
        super(classId, tableName, rowStatus, MibItem.IDENTITY_EXTENTION_TBL_LAST_UPDATE);
    }

    protected void readDiscoverPostOperation(ConfigElementData element, CommVarBindList list) throws SrCommunicationException {
        this.keepTrackOfLastIndex(element, list);
        Object parent = element.getValue(ParameterCode.CREDENTIALS_PARENT);
        if (parent == null) {
            CommKey[] commKey = element.getCommKey();
            String key = commKey[0].getKey();
            int pos = key.lastIndexOf(".");
            key = key.substring(0, pos);
            ClassID classId = ClassID.IDENTITY;
            char snmpAgent = element.getMyFirstSnmpAgentIndex();
            if (snmpAgent >= lastNameIndex.size()) {
                lastNameIndex.addElement(this.initializeArray());
            }
            SnmpCommKey identCommKey = new SnmpCommKey(key, element.getMyFirstSnmpAgentIndex());
            CommKeyClassId commKeyClassId = new CommKeyClassId(identCommKey, classId);
            element.setValue(ParameterCode.CREDENTIALS_PARENT, commKeyClassId);
        }
    }

    private void keepTrackOfLastIndex(ConfigElementData element, CommVarBindList list) {
        String index = element.getSnmpKey().toString();
        int pos = index.lastIndexOf(".") + 1;
        String ind = index.substring(pos);
        Integer nameIndex = new Integer(ind);
        String identIndex = index.substring(0, pos - 1);
        pos = identIndex.lastIndexOf(".") + 1;
        identIndex = identIndex.substring(pos);
        Integer identityIndex = new Integer(identIndex);
        char agentIndex = element.getMyFirstSnmpAgentIndex();
        if (lastNameIndex.size() <= agentIndex) {
            lastNameIndex.addElement(this.initializeArray());
        } else {
            HashMap map = (HashMap)lastNameIndex.get(agentIndex);
            Object recentLastCred = map.get(identityIndex);
            if (recentLastCred == null || (Integer)recentLastCred < nameIndex) {
                map.put(identityIndex, nameIndex);
            }
        }
    }

    protected HashMap initializeArray() {
        HashMap<Integer[], Integer[]> map = new HashMap<Integer[], Integer[]>();
        Integer[] initial = new Integer[]{new Integer(0), new Integer(0)};
        map.put(initial, initial);
        return map;
    }

    public void discover(CommKeyClassId vSwitchData) throws SrCommunicationException {
        char snmpAgentIndex = vSwitchData.getMyFirstSnmpAgentIndex();
        ConfigElementDataList credList = this.getAllExtended(snmpAgentIndex, null, null);
        this.sendDiscoveredElementsToEventMgr(credList, vSwitchData);
    }

    public ConfigElementDataList getAllExtended(char snmpAgentIndex, SrTimeTicks lastUpdate, CheckListConfigElementData checkListElement) throws SrCommunicationException {
        ConfigElementDataList credList = this.getAll(snmpAgentIndex, lastUpdate, checkListElement);
        if (credList.size() > 0) {
            for (int i = credList.size() - 1; i >= 0; --i) {
                ConfigElementData element = (ConfigElementData)credList.get(i);
                Object value = element.getValue(ParameterCode.CREDENTIALS_AUTH_METHOD);
                if (value.equals(this.myOidType)) continue;
                credList.remove(element);
            }
        }
        return credList;
    }

    protected void convertParamsToVarBinds(ConfigElementData element, CommVarBindList list) {
        if (list.isEmpty()) {
            super.convertParamsToVarBinds(element, list);
            return;
        }
        CommKey[] commKeys = element.getCommKey();
        HashMap map = element.getParametersList();
        Iterator paramIter = map.keySet().iterator();
        while (paramIter.hasNext()) {
            ParameterCode code = (ParameterCode)paramIter.next();
            Object tmpObj = map.get(code);
            if (tmpObj != null) {
                SrType value = null;
                try {
                    value = (SrType)tmpObj;
                }
                catch (ClassCastException e) {
                    continue;
                }
                Parameter tmpParam = new Parameter(code, value);
                if (code.equals(ParameterCode.CREDENTIALS_AUTH_METHOD)) {
                    list.add(1, this.createCommVarBinds(commKeys, tmpParam).get(0));
                    continue;
                }
                list.add(this.createCommVarBinds(commKeys, tmpParam));
                continue;
            }
            Parameter tmpParam = new Parameter(code, null);
            list.add(this.createCommVarBinds(commKeys, tmpParam));
        }
    }
}

