/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr.dr.cf;

import com.sanrad.nms.server.comm.CommVarBindList;
import com.sanrad.nms.server.comm.exception.SrCommunicationException;
import com.sanrad.nms.server.comm.snmp.DsnmpUtil;
import com.sanrad.nms.server.comm.snmp.MibItem;
import com.sanrad.nms.server.comm.snmp.trap.SrTrap;
import com.sanrad.nms.server.mgr.CodeToKeyMap;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.ConfigElementDataList;
import com.sanrad.nms.server.mgr.ElementConfigurator;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.Parameter;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.SrOidType;
import com.sanrad.nms.server.util.types.constants.DRInitialSyncStateConstant;
import java.util.HashMap;

public abstract class ControlFunctionsConfigurator
extends ElementConfigurator {
    public ControlFunctionsConfigurator() {
        super(ClassID.ASYNC_PAIR, "srAsyncPairSendCFTable", null, null);
    }

    public ControlFunctionsConfigurator(ClassID classId, String tableName, MibItem rowStatusMib, MibItem lastUpdateMib) {
        super(classId, tableName, rowStatusMib, lastUpdateMib);
    }

    public void discover(CommKeyClassId vSwitchData, ClassID classId) throws SrCommunicationException {
        CommKeyClassId elementData = new CommKeyClassId(vSwitchData.getCommKeys(), classId);
        ConfigElementData element = new ConfigElementData(elementData.getCommKeys(), this.myClassId);
        element.addParameter(new Parameter(ParameterCode.VSWITCH_ID, vSwitchData));
        HashMap params = this.getListOfParams();
        element.addParameter(params);
        this.readDiscoverPostOperation(element, null);
        ConfigElementDataList list = new ConfigElementDataList();
        list.add(element);
        this.sendDiscoveredElementsToEventMgr(list, vSwitchData);
    }

    protected void readDiscoverPostOperation(ConfigElementData element, CommVarBindList list) throws SrCommunicationException {
        SrOidType changedFieldOid = (SrOidType)element.getValue(this.getOidParameterCode());
        long[] oidComps = (long[])changedFieldOid.value();
        String changedFieldName = DsnmpUtil.getMIBNameFromOidComponents(oidComps);
        ParameterCode code = CodeToKeyMap.getInstance().getParamCodeBySnmpKey(changedFieldName);
        element.addParameter(new Parameter(code, element.getValue(this.getCodeForCFAction())));
        if (element.getParametersList().containsKey(ParameterCode.DR_PAIR_INITIAL_SYNC_STATE)) {
            this.changeStateInActivate(element);
        }
    }

    protected void changeStateInActivate(ConfigElementData element) {
        Parameter param = new Parameter(ParameterCode.DR_PAIR_INITIAL_SYNC_STATE, element.getValue(ParameterCode.DR_PAIR_INITIAL_SYNC_STATE));
        Parameter act = ((DRInitialSyncStateConstant)param.getValue()).getParameterActivate();
        element.removeParameter(ParameterCode.DR_PAIR_INITIAL_SYNC_STATE);
        element.addParameter(new Parameter(act.getCode(), act.getValue()));
    }

    protected void trapProccessingPostOperation(ConfigElementData element, SrTrap trap) {
        try {
            this.readDiscoverPostOperation(element, null);
        }
        catch (SrCommunicationException e) {
            e.printStackTrace();
        }
        ConfigElementDataList list = new ConfigElementDataList();
        list.add(0, element);
        this.sendRefreshedElementsToEventMgr(list, element.getCommKeyClassId());
    }

    protected abstract ParameterCode getCodeForCFAction();

    protected abstract ParameterCode getOidParameterCode();
}

