/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr.dr;

import com.sanrad.log.LogMgr;
import com.sanrad.nms.server.comm.snmp.MibItem;
import com.sanrad.nms.server.event.SrEventHandler;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.ConfigElementDataList;
import com.sanrad.nms.server.mgr.ElementConfigurator;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.CommKeyUtil;
import com.sanrad.nms.server.util.Parameter;
import com.sanrad.nms.server.util.ParameterCode;
import java.util.Iterator;

public class VirtGroupConfigurator
extends ElementConfigurator {
    public VirtGroupConfigurator() {
        super(ClassID.CONSISTENCY_GROUP, "srVirtGroupTable", null, null);
    }

    public VirtGroupConfigurator(ClassID classId, String tableName, MibItem rowStatusMib, MibItem lastUpdateMib) {
        super(classId, tableName, rowStatusMib, lastUpdateMib);
    }

    final ConfigElementData addParamentersForVirtGroup(ConfigElementData src, ConfigElementData dest) {
        dest.addParameterToElement(src, ParameterCode.VSWITCH_ID);
        dest.addParameterToElement(src, ParameterCode.DR_VIRT_GROUP_ALIAS);
        dest.addParameterToElement(src, ParameterCode.DR_VIRT_GROUP_TYPE);
        return dest;
    }

    protected void sendRefreshedElementsToEventMgr(ConfigElementDataList list, CommKeyClassId vSwitchData) {
        for (int i = 0; i < list.size(); ++i) {
            if (vSwitchData != null) {
                ((ConfigElementData)list.elementAt(i)).addParameter(new Parameter(ParameterCode.VSWITCH_ID, vSwitchData));
            }
            LogMgr.getServerLog().debug("Refresh: " + ((ConfigElementData)list.elementAt(i)).getClassId().toString() + " CommKey is:" + CommKeyUtil.getKeyForMessage(((ConfigElementData)list.elementAt(i)).getCommKey()));
        }
        Iterator i = list.iterator();
        while (i.hasNext()) {
            SrEventHandler.getEventMgr().sendRefreshElementEvent((ConfigElementData)i.next());
        }
    }

    protected void sendDiscoveredElementsToEventMgr(ConfigElementDataList list, CommKeyClassId vSwitchData) {
        for (int i = 0; i < list.size(); ++i) {
            if (vSwitchData != null) {
                ((ConfigElementData)list.elementAt(i)).addParameter(new Parameter(ParameterCode.VSWITCH_ID, vSwitchData));
            }
            LogMgr.getServerLog().debug("Discover: " + ((ConfigElementData)list.elementAt(i)).getClassId().toString() + " CommKey is:" + CommKeyUtil.getKeyForMessage(((ConfigElementData)list.elementAt(i)).getCommKey()));
        }
        Iterator i = list.iterator();
        while (i.hasNext()) {
            SrEventHandler.getEventMgr().sendAddElementEvent((ConfigElementData)i.next());
        }
    }
}

