/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr.dr;

import com.sanrad.log.LogMgr;
import com.sanrad.nms.server.Server;
import com.sanrad.nms.server.comm.exception.SrCommunicationException;
import com.sanrad.nms.server.comm.snmp.MibItem;
import com.sanrad.nms.server.comm.snmp.trap.SrTrap;
import com.sanrad.nms.server.comm.snmp.trap.SrTrapType;
import com.sanrad.nms.server.event.SrEventHandler;
import com.sanrad.nms.server.exception.SrElementOperationException;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.dr.PairConfigurator;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyUtil;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.SnmpCommKey;
import com.sanrad.nms.server.util.types.constants.DRPairTypeConstant;
import com.sanrad.nms.server.util.types.constants.RowStatusConstants;
import com.sanrad.util.SrConstantsBundleKeys;
import java.util.HashMap;

public class SyncPairConfigurator
extends PairConfigurator {
    private static final HashMap listOfParams = new HashMap();

    public SyncPairConfigurator() {
        super(ClassID.SYNC_PAIR, "srSynchPairTable", MibItem.DR_PAIR_ROW_STATUS, MibItem.DR_SYNC_PAIR_TABLE_LAST_UPDATE);
    }

    public HashMap getListOfParams() {
        return listOfParams;
    }

    public void internalCreate(ConfigElementData element) throws SrCommunicationException, SrElementOperationException {
        element.setValue(ParameterCode.DR_PAIR_TYPE, DRPairTypeConstant.SYNC);
        char agentIndex = element.getSnmpAgentFromParameter();
        SnmpCommKey newPairIndex = super.getPairIndexNext(agentIndex);
        ConfigElementData pairElement = new ConfigElementData(newPairIndex, null);
        super.addParametersForCreate(element, pairElement);
        ConfigElementData syncPairElement = new ConfigElementData(newPairIndex, null);
        this.addParametersForCreate(element, syncPairElement);
        super.internalCreate(pairElement);
        this.internalChange(syncPairElement);
        element.removeAll();
        element.setCommKey(newPairIndex);
    }

    ConfigElementData addParametersForCreate(ConfigElementData src, ConfigElementData dest) {
        dest.addParameterToElement(src, ParameterCode.VSWITCH_ID);
        dest.addParameterToElement(src, ParameterCode.DR_SYNC_PAIR_ROLE);
        return dest;
    }

    protected void trapProccessingPostOperation(ConfigElementData element, SrTrap trap) {
        element.setClassId(this.myClassId);
        SrTrapType trapType = trap.getTrapType();
        if (trapType == SrTrapType.SYNC_PAIR_STATE_CHANGED) {
            if (element.getSnmpKey() == null || element.getSnmpKey() != null && element.getSnmpKey().getKey() != null) {
                try {
                    ConfigElementData fullInfoElement = new ConfigElementData(element.getCommKeyClassId());
                    this.internalRead(fullInfoElement);
                    SrEventHandler.getEventMgr().sendChangeElementEvent(fullInfoElement);
                }
                catch (SrCommunicationException e) {
                    SrEventHandler.getEventMgr().sendChangeElementEvent(element);
                }
            }
        } else if (trapType == SrTrapType.PAIR_CREATED) {
            this.handleCreateTrap(element);
        } else if (trapType == SrTrapType.PAIR_DELETED) {
            SrEventHandler.getEventMgr().sendRemoveElementEvent(element);
        }
    }

    private void handleCreateTrap(ConfigElementData element) {
        RowStatusConstants rowStatus = (RowStatusConstants)element.getValue(ParameterCode.DR_PAIR_ROW_STATUS);
        if (rowStatus.equals(RowStatusConstants.ROW_STATUS_ACTIVE)) {
            try {
                this.internalRead(element);
                SrEventHandler.getEventMgr().sendAddElementEvent(element);
            }
            catch (SrCommunicationException e) {
                e.printStackTrace();
                element.setClassId(this.myClassId);
                LogMgr.getServerLog().debug("Trap on creation of " + element.getClassId().toString() + " CommKey is: " + CommKeyUtil.getKeyForMessage(element.getCommKey()) + ": failed to read new element.");
            }
        }
    }

    public void internalChange(ConfigElementData element) throws SrCommunicationException, SrElementOperationException {
        super.internalChange(element);
        if (element.containParameter(ParameterCode.DR_SYNC_PAIR_ACTIVATE)) {
            try {
                Thread.sleep(Integer.parseInt(Server.CONSTANSTS_BUNDLE.getString(SrConstantsBundleKeys.WAIT_FOR_ACTIVATE_COMMAND)));
            }
            catch (InterruptedException e) {
                logger.error(e);
            }
        }
    }

    static {
        listOfParams.put(ParameterCode.DR_PAIR_TYPE, null);
        listOfParams.put(ParameterCode.DR_PAIR_PRIMARY_ID, null);
        listOfParams.put(ParameterCode.DR_PAIR_SECONDARY_ID, null);
        listOfParams.put(ParameterCode.DR_PAIR_INITIAL_SYNC_TYPE, null);
        listOfParams.put(ParameterCode.DR_PAIR_MODE, null);
        listOfParams.put(ParameterCode.DR_PAIR_STATE, null);
        listOfParams.put(ParameterCode.DR_PAIR_INITIAL_SYNC_STATE, null);
        listOfParams.put(ParameterCode.DR_PAIR_ONLINE_INIT_SYNC_DATA_TRANSFFERED, null);
        listOfParams.put(ParameterCode.DR_SYNC_PAIR_ROLE, null);
        listOfParams.put(ParameterCode.DR_SYNC_PAIR_REPLICATION_STATE, null);
        listOfParams.put(ParameterCode.DR_SYNC_PAIR_ACTIVATE, null);
    }
}

