/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr.dr;

import com.sanrad.log.LogMgr;
import com.sanrad.nms.server.comm.CommItem;
import com.sanrad.nms.server.comm.CommVarBindList;
import com.sanrad.nms.server.comm.exception.SrCommunicationException;
import com.sanrad.nms.server.comm.snmp.MibItem;
import com.sanrad.nms.server.comm.snmp.SrOid;
import com.sanrad.nms.server.comm.snmp.SrSnmpVarBind;
import com.sanrad.nms.server.comm.snmp.trap.SrTrap;
import com.sanrad.nms.server.comm.snmp.trap.SrTrapType;
import com.sanrad.nms.server.event.EventMgr;
import com.sanrad.nms.server.event.SrEventHandler;
import com.sanrad.nms.server.exception.ConfigurationErrorException;
import com.sanrad.nms.server.exception.SrElementOperationException;
import com.sanrad.nms.server.mgr.CheckListConfigElementData;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.ConfigElementDataList;
import com.sanrad.nms.server.mgr.DataMgr;
import com.sanrad.nms.server.mgr.ElementConfigurator;
import com.sanrad.nms.server.mgr.LUNConfigurator;
import com.sanrad.nms.server.mgr.discover.DiscoverMgr;
import com.sanrad.nms.server.mgr.dr.AsyncPairConfigurator;
import com.sanrad.nms.server.mgr.dr.SyncPairConfigurator;
import com.sanrad.nms.server.mgr.storage.PhysicalStorageConfigurator;
import com.sanrad.nms.server.mgr.volume.VolumeConfigurator;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKey;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.CommKeyUtil;
import com.sanrad.nms.server.util.Parameter;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.SnmpCommKey;
import com.sanrad.nms.server.util.types.SrGauge;
import com.sanrad.nms.server.util.types.SrInteger;
import com.sanrad.nms.server.util.types.SrString;
import com.sanrad.nms.server.util.types.SrTimeTicks;
import com.sanrad.nms.server.util.types.SrType;
import com.sanrad.nms.server.util.types.constants.DRPairTypeConstant;
import com.sanrad.nms.server.util.types.constants.PhysStorTransportTypeConstant;
import com.sanrad.nms.server.util.types.constants.PhysicalStorageTypeConstant;
import com.sanrad.nms.server.util.types.constants.RowStatusConstants;
import java.util.HashMap;
import java.util.Iterator;

public class PairConfigurator
extends ElementConfigurator {
    public PairConfigurator() {
        super(ClassID.GENERAL_PAIR, "srPairTable", null, null);
    }

    public PairConfigurator(ClassID classId, String tableName, MibItem rowStatusMib, MibItem lastUpdateMib) {
        super(classId, tableName, rowStatusMib, lastUpdateMib);
    }

    protected void sendRefreshedElementsToEventMgr(ConfigElementDataList list, CommKeyClassId vSwitchData) {
        for (int i = 0; i < list.size(); ++i) {
            if (vSwitchData != null) {
                ((ConfigElementData)list.elementAt(i)).addParameter(new Parameter(ParameterCode.VSWITCH_ID, vSwitchData));
            }
            LogMgr.getServerLog().debug("Refresh: " + ((ConfigElementData)list.elementAt(i)).getClassId().toString() + " CommKey is:" + CommKeyUtil.getKeyForMessage(((ConfigElementData)list.elementAt(i)).getCommKey()));
        }
        Iterator i = list.iterator();
        while (i.hasNext()) {
            SrEventHandler.getEventMgr().sendRefreshElementEvent((ConfigElementData)i.next());
        }
    }

    protected void sendDiscoveredElementsToEventMgr(ConfigElementDataList list, CommKeyClassId vSwitchData) {
        for (int i = 0; i < list.size(); ++i) {
            if (vSwitchData != null) {
                ((ConfigElementData)list.elementAt(i)).addParameter(new Parameter(ParameterCode.VSWITCH_ID, vSwitchData));
            }
            LogMgr.getServerLog().debug("Discover: " + ((ConfigElementData)list.elementAt(i)).getClassId().toString() + " CommKey is:" + CommKeyUtil.getKeyForMessage(((ConfigElementData)list.elementAt(i)).getCommKey()));
        }
        Iterator i = list.iterator();
        while (i.hasNext()) {
            SrEventHandler.getEventMgr().sendAddElementEvent((ConfigElementData)i.next());
        }
    }

    SnmpCommKey getPairIndexNext(char agentIndex) throws SrCommunicationException, SrElementOperationException {
        Integer nextIndex = (Integer)this.getScalarFromComm(MibItem.DR_PAIR_INDEX_NEXT, agentIndex).value();
        return new SnmpCommKey(nextIndex.toString(), agentIndex);
    }

    public void internalCreate(ConfigElementData element) throws SrCommunicationException, SrElementOperationException {
        this.updateCedAfterCreate(element);
        this.prepareVolumeIDsForMIB(element);
        CommKeyClassId luID = (CommKeyClassId)element.removeParameter(ParameterCode.VIRTUAL_VOLUME_LU);
        SrString serialNumber = (SrString)element.removeParameter(ParameterCode.LU_SERIAL_NUMBER);
        if (luID != null && serialNumber != null) {
            CommKeyClassId luIDSpecific = CommKeyUtil.getSpecificCommKeyClassId(luID, element.getSnmpAgentFromParameter());
            ConfigElementData luData = new ConfigElementData(luIDSpecific);
            luData.setValue(ParameterCode.LU_SERIAL_NUMBER, serialNumber);
            LUNConfigurator luConfigurator = new LUNConfigurator();
            luConfigurator.internalChange(luData);
            luConfigurator.internalRead(luData);
            EventMgr.getInstance().sendChangeElementEvent(luData);
        }
        super.internalCreate(element);
    }

    public void internalChange(ConfigElementData element) throws SrCommunicationException, SrElementOperationException {
        this.prepareVolumeIDsForMIB(element);
        super.internalChange(element);
    }

    public void postSendRemoveEvent(ConfigElementData element) throws SrCommunicationException {
        String volId;
        CommKeyClassId primaryID = (CommKeyClassId)element.getValue(ParameterCode.DR_PAIR_PRIMARY_ID);
        CommKeyClassId secondaryID = (CommKeyClassId)element.getValue(ParameterCode.DR_PAIR_SECONDARY_ID);
        char agentIndex = element.getSnmpAgentFromParameter();
        if (primaryID != null) {
            volId = DiscoverMgr.getInstance().getVolIdForPhysStor(primaryID, agentIndex);
            DiscoverMgr.getInstance().removeVolumeFromInvolvedList(volId, agentIndex);
            this.removeSimpleVolume(primaryID, agentIndex);
        }
        if (secondaryID != null) {
            volId = DiscoverMgr.getInstance().getVolIdForPhysStor(secondaryID, agentIndex);
            DiscoverMgr.getInstance().removeVolumeFromInvolvedList(volId, agentIndex);
            this.removeSimpleVolume(secondaryID, agentIndex);
        }
    }

    protected void readDiscoverPostOperation(ConfigElementData element, CommVarBindList list) throws SrCommunicationException {
        char agentIndex = element.getMyFirstSnmpAgentIndex();
        SrGauge primaryID = (SrGauge)element.getValue(ParameterCode.DR_PAIR_PRIMARY_ID);
        SrGauge secondaryID = (SrGauge)element.getValue(ParameterCode.DR_PAIR_SECONDARY_ID);
        if (primaryID != null) {
            element.setValue(ParameterCode.DR_PAIR_PRIMARY_ID, this.getCommKeyClassIdFromVolumeID(primaryID, agentIndex));
        }
        if (secondaryID != null) {
            element.setValue(ParameterCode.DR_PAIR_SECONDARY_ID, this.getCommKeyClassIdFromVolumeID(secondaryID, agentIndex));
        }
    }

    private CommKeyClassId getCommKeyClassIdFromVolumeID(SrGauge volumeId, char agentIndex) throws SrCommunicationException {
        VolumeConfigurator volCongo = new VolumeConfigurator();
        ConfigElementData volData = new ConfigElementData(new SnmpCommKey("1." + volumeId, agentIndex), null);
        volCongo.readOneRowFromTable(volData);
        CommKeyClassId volID = volData.getCommKeyClassId();
        if (!ClassID.SIMPLE_VOLUME.equals(volID.getClassID())) {
            return volData.getCommKeyClassId();
        }
        CommKeyClassId physID = DiscoverMgr.getInstance().getPhysStorOfVolId("1." + volumeId.toString(), agentIndex);
        if (physID != null) {
            return physID;
        }
        ConfigElementDataList simpleChilds = this.readTableRowsByValue("srPhysDiskSplitTable", MibItem.SUB_DIRECT_ACCESS_DEVICE_VOL_ID, new SrInteger(volumeId.toString()), agentIndex);
        if (simpleChilds.size() > 0) {
            ConfigElementData simpleVolChild = simpleChilds.getConfigElementDataAt(0);
            return new CommKeyClassId(simpleVolChild.getSnmpKey(), ClassID.SUB_DIRECT_ACCESS_DEVICE);
        }
        simpleChilds = this.readTableRowsByValue("srPhysStorTable", MibItem.PHYSICAL_STORAGE_VOL_ID, new SrInteger(volumeId.toString()), agentIndex);
        if (simpleChilds.size() > 0) {
            ConfigElementData simpleVolChild = simpleChilds.getConfigElementDataAt(0);
            return new CommKeyClassId(simpleVolChild.getSnmpKey(), ClassID.DIRECT_ACCESS_DEVICE);
        }
        CommKeyClassId vs = CommKeyUtil.getVSwitchData(agentIndex);
        System.err.println("DR Bug of SIMPLE VOLUME: DiscoverMgr doesn't contain info about a SIMPLE Volume child disk. Volume index = " + volumeId + ", " + ClassID.VSWITCH + " = " + vs);
        throw new ConfigurationErrorException("Could not match DR pair volume ID to any volume");
    }

    private void prepareVolumeIDsForMIB(ConfigElementData element) throws SrCommunicationException, SrElementOperationException {
        CommKeyClassId storageKey;
        ConfigElementData storageElement;
        CommKeyClassId primaryID = (CommKeyClassId)element.getValue(ParameterCode.DR_PAIR_PRIMARY_ID);
        CommKeyClassId secondaryID = (CommKeyClassId)element.getValue(ParameterCode.DR_PAIR_SECONDARY_ID);
        CommKeyClassId vSwitchID = (CommKeyClassId)element.getValue(ParameterCode.VSWITCH_ID);
        if (primaryID != null) {
            SrGauge primaryVol = this.createVolumeIDForPair(primaryID, vSwitchID);
            element.setValue(ParameterCode.DR_PAIR_PRIMARY_ID, primaryVol);
            if (secondaryID == null) {
                storageElement = this.createISCSIStorage(element);
                storageKey = storageElement.getCommKeyClassId();
                element.setValue(ParameterCode.DR_PAIR_LOCAL_SECONDARY_ID, storageKey);
                SrGauge secondaryVol = this.createVolumeIDForPair(storageKey, vSwitchID);
                element.setValue(ParameterCode.DR_PAIR_SECONDARY_ID, secondaryVol);
            }
        }
        if (secondaryID != null) {
            SrGauge secondaryVol = this.createVolumeIDForPair(secondaryID, vSwitchID);
            element.setValue(ParameterCode.DR_PAIR_SECONDARY_ID, secondaryVol);
            if (primaryID == null) {
                storageElement = this.createISCSIStorage(element);
                storageKey = storageElement.getCommKeyClassId();
                element.setValue(ParameterCode.DR_PAIR_REMOTE_PRIMARY_ID, storageKey);
                SrGauge primaryVol = this.createVolumeIDForPair(storageElement.getCommKeyClassId(), vSwitchID);
                element.setValue(ParameterCode.DR_PAIR_PRIMARY_ID, primaryVol);
            }
        }
        CommKeyClassId configuredDisk = null;
        configuredDisk = (CommKeyClassId)element.removeParameter(ParameterCode.DR_PAIR_LOCAL_SECONDARY_ID);
        if (configuredDisk == null) {
            configuredDisk = (CommKeyClassId)element.removeParameter(ParameterCode.DR_PAIR_REMOTE_PRIMARY_ID);
        }
        if (configuredDisk != null) {
            CommKeyClassId configuredDiskSpecific = CommKeyUtil.getSpecificCommKeyClassId(configuredDisk, vSwitchID);
            SrType blockSize = (SrType)element.removeParameter(ParameterCode.DIRECT_ACCESS_DEVICE_BLOCK_SIZE);
            SrType blocksNum = (SrType)element.removeParameter(ParameterCode.DIRECT_ACCESS_DEVICE_BLOCK_NUM);
            ConfigElementData storageElement2 = new ConfigElementData(configuredDiskSpecific);
            storageElement2.setValue(ParameterCode.DIRECT_ACCESS_DEVICE_BLOCK_SIZE, blockSize);
            storageElement2.setValue(ParameterCode.DIRECT_ACCESS_DEVICE_BLOCK_NUM, blocksNum);
            new PhysicalStorageConfigurator().internalChange(storageElement2);
        }
    }

    private ConfigElementData createISCSIStorage(ConfigElementData dataSource) throws SrCommunicationException, SrElementOperationException {
        SrType target = (SrType)dataSource.removeParameter(ParameterCode.PHYSICAL_STORAGE_ENTITY_NAME);
        SrType lun = (SrType)dataSource.removeParameter(ParameterCode.PHYSICAL_STORAGE_LUN);
        PhysicalStorageConfigurator physConf = new PhysicalStorageConfigurator();
        ConfigElementData storageElement = null;
        boolean isStorageAlreadyExists = false;
        ConfigElementDataList disks = physConf.getAll(dataSource.getSnmpAgentFromParameter(), null, null);
        int i = disks.size();
        while (i-- > 0) {
            ConfigElementData disk = disks.getConfigElementDataAt(i);
            SrType diskTarget = (SrType)disk.getValue(ParameterCode.PHYSICAL_STORAGE_ENTITY_NAME);
            SrType diskLun = (SrType)disk.getValue(ParameterCode.PHYSICAL_STORAGE_LUN);
            if (!diskTarget.equals(target) || !diskLun.equals(lun)) continue;
            isStorageAlreadyExists = true;
            storageElement = disk;
        }
        if (!isStorageAlreadyExists) {
            storageElement = new ConfigElementData(ClassID.DIRECT_ACCESS_DEVICE);
            storageElement.addParameterToElement(dataSource, ParameterCode.VSWITCH_ID);
            storageElement.setValue(ParameterCode.PHYSICAL_STORAGE_ENTITY_NAME, target);
            storageElement.setValue(ParameterCode.PHYSICAL_STORAGE_LUN, lun);
            storageElement.setValue(ParameterCode.PHYSICAL_STORAGE_TYPE, PhysicalStorageTypeConstant.PHYS_STOR_TYPE_DIRECT_ACCESS_DEVICE);
            storageElement.setValue(ParameterCode.PHYSICAL_STORAGE_TRANSPORT_TYPE, PhysStorTransportTypeConstant.PHYS_STOR_TRANS_TYPE_ISCSI);
            physConf.internalCreate(storageElement);
            physConf.internalRead(storageElement);
            EventMgr.getInstance().sendAddElementEvent(storageElement);
            physConf.postCreateEvent(storageElement);
        } else {
            EventMgr.getInstance().sendRefreshElementEvent(storageElement);
        }
        return storageElement;
    }

    private SrGauge createVolumeIDForPair(CommKeyClassId storageId, CommKeyClassId vSwitchData) throws SrCommunicationException, SrElementOperationException {
        String volDomainKey = null;
        if (storageId.getClassID().isVolume()) {
            volDomainKey = CommKeyUtil.getSpecificCommKey(storageId, vSwitchData.getMyFirstSnmpAgentIndex()).getKey();
        } else if (storageId.getClassID().isStorage()) {
            volDomainKey = this.createSimpleVolume(storageId, vSwitchData)[0].getKey();
        }
        if (volDomainKey != null) {
            return new SrGauge(volDomainKey.substring(volDomainKey.indexOf(46) + 1));
        }
        return null;
    }

    ConfigElementData addParametersForCreate(ConfigElementData src, ConfigElementData dest) {
        dest.addParameterToElement(src, ParameterCode.VSWITCH_ID);
        dest.addParameterToElement(src, ParameterCode.DR_PAIR_TYPE);
        dest.addParameterToElement(src, ParameterCode.DR_PAIR_PRIMARY_ID);
        dest.addParameterToElement(src, ParameterCode.DR_PAIR_SECONDARY_ID);
        dest.addParameterToElement(src, ParameterCode.DR_PAIR_INITIAL_SYNC_TYPE);
        dest.addParameterToElement(src, ParameterCode.PHYSICAL_STORAGE_ENTITY_NAME);
        dest.addParameterToElement(src, ParameterCode.PHYSICAL_STORAGE_LUN);
        dest.addParameterToElement(src, ParameterCode.DIRECT_ACCESS_DEVICE_BLOCK_SIZE);
        dest.addParameterToElement(src, ParameterCode.DIRECT_ACCESS_DEVICE_BLOCK_NUM);
        dest.addParameterToElement(src, ParameterCode.LU_SERIAL_NUMBER);
        dest.addParameterToElement(src, ParameterCode.VIRTUAL_VOLUME_LU);
        dest.addParameterToElement(src, ParameterCode.DR_PAIR_LOCAL_SECONDARY_ID);
        dest.addParameterToElement(src, ParameterCode.DR_PAIR_REMOTE_PRIMARY_ID);
        return dest;
    }

    protected SrSnmpVarBind createRowStatusVarBind(CommKey commKey) {
        SrOid oid = new SrOid(this.myRowStatusMib.toString(), commKey.getKey());
        SrSnmpVarBind srVarBind = new SrSnmpVarBind(oid, (SrType)RowStatusConstants.ROW_STATUS_CREATE_AND_WAIT);
        return srVarBind;
    }

    protected void trapProccessingPostOperation(ConfigElementData element, SrTrap trap) {
        SrTrapType type = trap.getTrapType();
        if (type == SrTrapType.PAIR_CREATED || type == SrTrapType.PAIR_DELETED) {
            DRPairTypeConstant pType = (DRPairTypeConstant)element.getValue(ParameterCode.DR_PAIR_TYPE);
            if (pType == DRPairTypeConstant.SYNC) {
                element.setClassId(ClassID.SYNC_PAIR);
                new SyncPairConfigurator().trapProccessingPostOperation(element, trap);
            } else if (pType == DRPairTypeConstant.ASYNC) {
                element.setClassId(ClassID.ASYNC_PAIR);
                new AsyncPairConfigurator().trapProccessingPostOperation(element, trap);
            }
        }
    }

    protected CommItem getCommItemForTrapCommKey(SrTrap trap) {
        SrTrapType trapType = trap.getTrapType();
        if (trapType == SrTrapType.PAIR_CREATED || trapType == SrTrapType.PAIR_DELETED) {
            return MibItem.DR_PAIR_ROW_STATUS;
        }
        if (trapType == SrTrapType.ASYNC_PAIR_STATE_CHANGED || trapType == SrTrapType.SYNC_PAIR_STATE_CHANGED) {
            return MibItem.DR_PAIR_MODE;
        }
        return null;
    }

    public boolean readAfterCreate(ConfigElementData element) throws SrCommunicationException {
        boolean ret = super.readAfterCreate(element);
        char snmpAgent = element.getMyFirstSnmpAgentIndex();
        DataMgr.getInstance().postPairCreationRefreshOperation(snmpAgent);
        return ret;
    }

    public ConfigElementDataList getAllExtended(char snmpAgentIndex, SrTimeTicks lastUpdate, CheckListConfigElementData checkListElement) throws SrCommunicationException {
        ConfigElementDataList generalPairList = this.getAll("srPairTable", snmpAgentIndex, lastUpdate, null);
        ConfigElementDataList specificPairList = this.getAll(this.myTableName, snmpAgentIndex, lastUpdate, null);
        ConfigElementDataList mergedList = new ConfigElementDataList();
        HashMap generalPairMap = this.createMapFromList(generalPairList);
        HashMap specificPairMap = this.createMapFromList(specificPairList);
        Iterator i = generalPairMap.keySet().iterator();
        while (i.hasNext()) {
            Object key = i.next();
            ConfigElementData generalPairElement = (ConfigElementData)generalPairMap.get(key);
            ConfigElementData specificPairElement = (ConfigElementData)specificPairMap.get(key);
            if (specificPairElement == null) continue;
            specificPairElement.addParameter(generalPairElement.getParametersList());
            mergedList.add(specificPairElement);
        }
        if (checkListElement != null) {
            this.buildCheckListElement(mergedList, checkListElement, snmpAgentIndex, lastUpdate);
        }
        return mergedList;
    }
}

