/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr.dr;

import com.sanrad.log.LogMgr;
import com.sanrad.nms.server.Server;
import com.sanrad.nms.server.comm.CommItem;
import com.sanrad.nms.server.comm.CommVarBindList;
import com.sanrad.nms.server.comm.exception.SrCommunicationException;
import com.sanrad.nms.server.comm.snmp.DsnmpUtil;
import com.sanrad.nms.server.comm.snmp.MibItem;
import com.sanrad.nms.server.comm.snmp.SrOid;
import com.sanrad.nms.server.comm.snmp.trap.SrTrap;
import com.sanrad.nms.server.comm.snmp.trap.SrTrapType;
import com.sanrad.nms.server.event.EventMgr;
import com.sanrad.nms.server.event.SrEventHandler;
import com.sanrad.nms.server.exception.SrElementOperationException;
import com.sanrad.nms.server.mgr.CheckListConfigElementData;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.ConfigElementDataList;
import com.sanrad.nms.server.mgr.dr.AsyncPairConfigurator;
import com.sanrad.nms.server.mgr.dr.VirtGroupConfigurator;
import com.sanrad.nms.server.mgr.policy.PolicyConfigurator;
import com.sanrad.nms.server.mgr.policy.PolicyParamConfigurator;
import com.sanrad.nms.server.mgr.policy.PolicyTablesConfigurator;
import com.sanrad.nms.server.mgr.volume.JournalVolumeConfigurator;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.CommKeyUtil;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.SnmpCommKey;
import com.sanrad.nms.server.util.types.SrOidType;
import com.sanrad.nms.server.util.types.SrTimeTicks;
import com.sanrad.nms.server.util.types.SrType;
import com.sanrad.nms.server.util.types.constants.DRGroupOwnedByConstant;
import com.sanrad.nms.server.util.types.constants.RowStatusConstants;
import com.sanrad.util.SrConstantsBundleKeys;
import java.util.ArrayList;
import java.util.HashMap;

public class ConsistencyGroupConfigurator
extends VirtGroupConfigurator {
    private static final String NO_POLICY_INDEX = "0";
    private static final HashMap listOfParams = new HashMap();

    public ConsistencyGroupConfigurator() {
        super(ClassID.CONSISTENCY_GROUP, "srDRGroupTable", MibItem.DR_GROUP_ROW_STATUS, null);
    }

    protected ConsistencyGroupConfigurator(ClassID classId) {
        super(classId, "srDRGroupTable", MibItem.DR_GROUP_ROW_STATUS, null);
    }

    public HashMap getListOfParams() {
        return listOfParams;
    }

    public void internalCreate(ConfigElementData element) throws SrCommunicationException, SrElementOperationException {
        this.updateCedAfterCreate(element);
        this.handlePolicyUpdates(element, element.getSnmpAgentFromParameter());
        SnmpCommKey newPairIndex = null;
        char agentIndex = element.getSnmpAgentFromParameter();
        SnmpCommKey newCGIndex = this.getConsistencyGroupIndexNext(agentIndex);
        ConfigElementData drGroupElement = new ConfigElementData(newCGIndex, null);
        this.addParamentersForCreate(element, drGroupElement);
        ConfigElementData virtGroupElement = new ConfigElementData(newCGIndex, null);
        super.addParamentersForVirtGroup(element, virtGroupElement);
        super.internalCreate(drGroupElement);
        super.internalChange(virtGroupElement);
        if (element.getValue(ParameterCode.DR_PAIR_PRIMARY_ID) != null || element.getValue(ParameterCode.DR_PAIR_SECONDARY_ID) != null) {
            element.setValue(ParameterCode.DR_ASYNC_PAIR_GROUP_ID, new CommKeyClassId(newCGIndex, ClassID.CONSISTENCY_GROUP));
            new AsyncPairConfigurator().internalCreate(element);
            newPairIndex = element.getSnmpKey();
        }
        element.removeAll();
        if (newPairIndex != null) {
            element.setValue(ParameterCode.DR_ASYNC_PAIR_ID, new CommKeyClassId(newPairIndex, ClassID.ASYNC_PAIR));
        }
        element.setClassId(ClassID.CONSISTENCY_GROUP);
        element.setCommKey(newCGIndex);
    }

    public void internalChange(ConfigElementData element) throws SrCommunicationException, SrElementOperationException {
        this.handlePolicyUpdates(element, element.getMyFirstSnmpAgentIndex());
        ConfigElementData cgData = new ConfigElementData(element.getCommKeyClassId());
        this.addParamentersForChange(element, cgData);
        super.internalChange(cgData);
        if (element.containParameter(ParameterCode.DR_CONSISTENCY_GROUP_ACTIVATE)) {
            try {
                Thread.sleep(Integer.parseInt(Server.CONSTANSTS_BUNDLE.getString(SrConstantsBundleKeys.WAIT_FOR_ACTIVATE_COMMAND)));
            }
            catch (InterruptedException e) {
                logger.error(e);
            }
        }
        new PolicyConfigurator().stimulateRefreshPolicyElements(element.getSnmpAgentFromParameter());
        new PolicyParamConfigurator().stimulateRefreshPolicyParamsElements(element.getSnmpAgentFromParameter());
    }

    public void postSendRemoveEvent(ConfigElementData element) throws SrCommunicationException {
        new PolicyConfigurator().stimulateRefreshPolicyElements(element.getSnmpAgentFromParameter());
        new PolicyParamConfigurator().stimulateRefreshPolicyParamsElements(element.getSnmpAgentFromParameter());
    }

    public boolean readAfterCreate(ConfigElementData element) throws SrCommunicationException {
        CommKeyClassId pairKey = (CommKeyClassId)element.getValue(ParameterCode.DR_ASYNC_PAIR_ID);
        if (pairKey != null) {
            ConfigElementData asyncPairElement = new ConfigElementData(pairKey);
            new AsyncPairConfigurator().internalRead(asyncPairElement);
            asyncPairElement.setValue(ParameterCode.DR_ASYNC_PAIR_GROUP_ID, element.getCommKeyClassId());
            SrEventHandler.getEventMgr().sendAddElementEvent(asyncPairElement);
            this.postSendCreateEvent(asyncPairElement);
        }
        ConfigElementData cgElement = new ConfigElementData(element.getCommKeyClassId());
        this.internalRead(cgElement);
        SrEventHandler.getEventMgr().sendAddElementEvent(cgElement);
        return true;
    }

    protected void readDiscoverPostOperation(ConfigElementData element, CommVarBindList list) throws SrCommunicationException {
        char agentIndex = element.getMyFirstSnmpAgentIndex();
        this.prepareGroupElementClassID(element);
        PolicyConfigurator policyConf = new PolicyConfigurator();
        this.readPostOperationOfPolicy(element, ParameterCode.DR_CONSISTENCY_GROUP_PIT_POLICY_ID, ParameterCode.DR_CONSISTENCY_GROUP_PIT_POLICY_PARAM_ID, policyConf, agentIndex);
        this.readPostOperationOfPolicy(element, ParameterCode.DR_CONSISTENCY_GROUP_TRANS_POLICY_ID, ParameterCode.DR_CONSISTENCY_GROUP_TRANS_POLICY_PARAM_ID, policyConf, agentIndex);
        this.readPostOperationOfPolicy(element, ParameterCode.DR_CONSISTENCY_GROUP_MERGE_POLICY_ID, ParameterCode.DR_CONSISTENCY_GROUP_MERGE_POLICY_PARAM_ID, policyConf, agentIndex);
    }

    private void readPostOperationOfPolicy(ConfigElementData element, ParameterCode policyCode, ParameterCode policyParamCode, PolicyConfigurator policyConf, char agentIndex) throws SrCommunicationException {
        SrOidType policyMibVal = (SrOidType)element.getValue(policyCode);
        if (policyMibVal != null) {
            String policyIndex = DsnmpUtil.getRowIndexFromOidComponents((long[])policyMibVal.value());
            if (!policyIndex.equals(NO_POLICY_INDEX)) {
                CommKeyClassId policyKey = new CommKeyClassId(new SnmpCommKey(policyIndex, agentIndex), ClassID.POLICY_START);
                element.setValue(policyCode, policyKey);
                ConfigElementData policyElement = new ConfigElementData(policyKey);
                policyConf.internalRead(policyElement);
                EventMgr.getInstance().sendRefreshElementEvent(policyElement);
                CommKeyClassId policyParamKey = (CommKeyClassId)policyElement.getValue(ParameterCode.POLICY_PARAM_ID);
                ConfigElementData policyParamElement = new ConfigElementData(policyParamKey);
                new PolicyParamConfigurator().internalRead(policyParamElement);
                EventMgr.getInstance().sendRefreshElementEvent(policyParamElement);
                element.setValue(policyParamCode, policyParamKey);
            } else {
                element.setValue(policyCode, (SrType)null);
                element.setValue(policyParamCode, (SrType)null);
            }
        }
    }

    SnmpCommKey getConsistencyGroupIndexNext(char agentIndex) throws SrCommunicationException, SrElementOperationException {
        Integer nextIndex = (Integer)this.getScalarFromComm(MibItem.DR_VIRT_GROUP_INDEX_NEXT, agentIndex).value();
        return new SnmpCommKey(nextIndex.toString(), agentIndex);
    }

    ConfigElementData addParamentersForCreate(ConfigElementData src, ConfigElementData dest) {
        dest.addParameterToElement(src, ParameterCode.VSWITCH_ID);
        dest.addParameterToElement(src, ParameterCode.DR_CONSISTENCY_GROUP_ROLE);
        dest.addParameterToElement(src, ParameterCode.DR_CONSISTENCY_GROUP_PIT_POLICY_ID);
        dest.addParameterToElement(src, ParameterCode.DR_CONSISTENCY_GROUP_TRANS_POLICY_ID);
        dest.addParameterToElement(src, ParameterCode.DR_CONSISTENCY_GROUP_MERGE_POLICY_ID);
        return dest;
    }

    ConfigElementData addParamentersForChange(ConfigElementData src, ConfigElementData dest) {
        dest.addParameterToElement(src, ParameterCode.VSWITCH_ID);
        dest.addParameterToElement(src, ParameterCode.DR_VIRT_GROUP_ALIAS);
        dest.addParameterToElement(src, ParameterCode.DR_CONSISTENCY_GROUP_PIT_POLICY_ID);
        dest.addParameterToElement(src, ParameterCode.DR_CONSISTENCY_GROUP_TRANS_POLICY_ID);
        dest.addParameterToElement(src, ParameterCode.DR_CONSISTENCY_GROUP_MERGE_POLICY_ID);
        dest.addParameterToElement(src, ParameterCode.DR_CONSISTENCY_GROUP_ACTIVATE);
        dest.addParameterToElement(src, ParameterCode.DR_CONSISTENCY_GROUP_ROLE);
        return dest;
    }

    public ConfigElementDataList getAllExtended(char snmpAgentIndex, SrTimeTicks lastUpdate, CheckListConfigElementData checkListElement) throws SrCommunicationException {
        ConfigElementDataList cgList = this.getAll(snmpAgentIndex, lastUpdate, checkListElement);
        ConfigElementDataList virtGroupList = new VirtGroupConfigurator().getAll(snmpAgentIndex, null, null);
        this.mergeElementLists(cgList, virtGroupList, false);
        return cgList;
    }

    protected void trapProccessingPostOperation(ConfigElementData element, SrTrap trap) {
        SrTrapType trapType = trap.getTrapType();
        if (trapType == SrTrapType.DR_GROUP_CREATED) {
            this.handleCreateTrap(element);
        } else if (trapType == SrTrapType.DR_GROUP_DELETED) {
            this.handleDeleteTrap(element);
        } else if (trapType == SrTrapType.DR_GROUP_STATE_CHANGED) {
            this.handleStateChangedTrap(element);
        }
    }

    protected CommItem getCommItemForTrapCommKey(SrTrap trap) {
        SrTrapType trapType = trap.getTrapType();
        if (trapType == SrTrapType.DR_GROUP_CREATED || trapType == SrTrapType.DR_GROUP_DELETED) {
            return MibItem.DR_GROUP_ROW_STATUS;
        }
        if (trapType == SrTrapType.DR_GROUP_STATE_CHANGED) {
            return MibItem.DR_GROUP_MODE;
        }
        return null;
    }

    private void handleCreateTrap(ConfigElementData element) {
        RowStatusConstants rowStatus = (RowStatusConstants)element.getValue(ParameterCode.DR_CONSISTENCY_GROUP_ROW_STATUS);
        if (rowStatus != null && rowStatus.equals(RowStatusConstants.ROW_STATUS_ACTIVE)) {
            try {
                this.internalRead(element);
                SrEventHandler.getEventMgr().sendAddElementEvent(element);
            }
            catch (SrCommunicationException e) {
                LogMgr.getServerLog().debug("Trap on creation of " + element.getClassId().toString() + " CommKey is: " + CommKeyUtil.getKeyForMessage(element.getCommKey()) + ": failed to read new element.", e);
            }
        } else if (rowStatus == null) {
            logger.warning("Row status of " + element + " is null in handleCreateTrap");
        }
    }

    private void handleStateChangedTrap(ConfigElementData element) {
        try {
            this.internalRead(element);
            SrEventHandler.getEventMgr().sendChangeElementEvent(element);
        }
        catch (SrCommunicationException e) {
            LogMgr.getServerLog().debug("Trap on change at " + element.getClassId().toString() + " CommKey is: " + CommKeyUtil.getKeyForMessage(element.getCommKey()) + ": failed to read changed element.", e);
        }
    }

    private void handleDeleteTrap(ConfigElementData element) {
        this.prepareGroupElementClassID(element);
        SrEventHandler.getEventMgr().sendRemoveElementEvent(element);
    }

    private void prepareGroupElementClassID(ConfigElementData element) {
        DRGroupOwnedByConstant ownedBy = (DRGroupOwnedByConstant)element.getValue(ParameterCode.DR_CONSISTENCY_GROUP_OWNED_BY);
        if (ownedBy == DRGroupOwnedByConstant.SYSTEM) {
            element.setClassId(ClassID.EXTENDED_PAIR);
        } else if (ownedBy == DRGroupOwnedByConstant.USER) {
            element.setClassId(ClassID.CONSISTENCY_GROUP);
        }
    }

    private void handlePolicyUpdates(ConfigElementData element, char agentIndex) throws SrCommunicationException, SrElementOperationException {
        SrOid policyOid;
        SnmpCommKey policyKey;
        ConfigElementData pitPolicy = this.createPITPolicyData(element);
        ConfigElementData transPolicy = this.createTransPolicyData(element);
        ConfigElementData mergePolicy = this.createMergePolicyData(element);
        ArrayList<ConfigElementData> policiesArray = new ArrayList<ConfigElementData>();
        if (pitPolicy != null) {
            policiesArray.add(pitPolicy);
        }
        if (transPolicy != null) {
            policiesArray.add(transPolicy);
        }
        if (mergePolicy != null) {
            policiesArray.add(mergePolicy);
        }
        new PolicyTablesConfigurator().updatePolicies(policiesArray.toArray(new ConfigElementData[policiesArray.size()]));
        if (pitPolicy != null) {
            policyKey = CommKeyUtil.getSpecificSnmpKey((CommKeyClassId)pitPolicy.getValue(ParameterCode.POLICY_ID), agentIndex);
            policyOid = new SrOid(MibItem.DR_POLICY_INDEX.toString(), policyKey.getKey());
            element.setValue(ParameterCode.DR_CONSISTENCY_GROUP_PIT_POLICY_ID, new SrOidType(policyOid.getComponents()));
        }
        if (transPolicy != null) {
            policyKey = CommKeyUtil.getSpecificSnmpKey((CommKeyClassId)transPolicy.getValue(ParameterCode.POLICY_ID), agentIndex);
            policyOid = new SrOid(MibItem.DR_POLICY_INDEX.toString(), policyKey.getKey());
            element.setValue(ParameterCode.DR_CONSISTENCY_GROUP_TRANS_POLICY_ID, new SrOidType(policyOid.getComponents()));
        }
        if (mergePolicy != null) {
            policyKey = CommKeyUtil.getSpecificSnmpKey((CommKeyClassId)mergePolicy.getValue(ParameterCode.POLICY_ID), agentIndex);
            policyOid = new SrOid(MibItem.DR_POLICY_INDEX.toString(), policyKey.getKey());
            element.setValue(ParameterCode.DR_CONSISTENCY_GROUP_MERGE_POLICY_ID, new SrOidType(policyOid.getComponents()));
        }
    }

    private ConfigElementData createPITPolicyData(ConfigElementData src) {
        if (src.getValue(ParameterCode.DR_CONSISTENCY_GROUP_PIT_POLICY_ID) == null && src.getValue(ParameterCode.DR_CONSISTENCY_GROUP_PIT_POLICY_TYPE) == null && src.getValue(ParameterCode.DR_CONSISTENCY_GROUP_PIT_POLICY_PARAM_ID) == null && src.getValue(ParameterCode.DR_CONSISTENCY_GROUP_PIT_POLICY_START_AT) == null) {
            return null;
        }
        ConfigElementData dest = new ConfigElementData(ClassID.POLICY_START);
        dest.addParameterToElement(src, ParameterCode.VSWITCH_ID);
        dest.addParameterToElement(src, ParameterCode.DR_CONSISTENCY_GROUP_PIT_POLICY_ID, ParameterCode.POLICY_ID);
        dest.addParameterToElement(src, ParameterCode.DR_CONSISTENCY_GROUP_PIT_POLICY_PARAM_ID, ParameterCode.POLICY_PARAM_ID);
        dest.addParameterToElement(src, ParameterCode.DR_CONSISTENCY_GROUP_PIT_POLICY_START_AT, ParameterCode.POLICY_START_AT);
        dest.addParameterToElement(src, ParameterCode.DR_CONSISTENCY_GROUP_PIT_POLICY_TYPE, ParameterCode.POLICY_PARAM_TYPE);
        dest.addParameterToElement(src, ParameterCode.DR_CONSISTENCY_GROUP_PIT_POLICY_RUN_EVERY, ParameterCode.POLICY_PARAM_RUN_EVERY);
        return dest;
    }

    private ConfigElementData createTransPolicyData(ConfigElementData src) {
        if (src.getValue(ParameterCode.DR_CONSISTENCY_GROUP_TRANS_POLICY_ID) == null && src.getValue(ParameterCode.DR_CONSISTENCY_GROUP_TRANS_POLICY_TYPE) == null && src.getValue(ParameterCode.DR_CONSISTENCY_GROUP_TRANS_POLICY_PARAM_ID) == null && src.getValue(ParameterCode.DR_CONSISTENCY_GROUP_TRANS_POLICY_START_AT) == null) {
            return null;
        }
        ConfigElementData dest = new ConfigElementData(ClassID.POLICY_START);
        dest.addParameterToElement(src, ParameterCode.VSWITCH_ID);
        dest.addParameterToElement(src, ParameterCode.DR_CONSISTENCY_GROUP_TRANS_POLICY_ID, ParameterCode.POLICY_ID);
        dest.addParameterToElement(src, ParameterCode.DR_CONSISTENCY_GROUP_TRANS_POLICY_PARAM_ID, ParameterCode.POLICY_PARAM_ID);
        dest.addParameterToElement(src, ParameterCode.DR_CONSISTENCY_GROUP_TRANS_POLICY_START_AT, ParameterCode.POLICY_START_AT);
        dest.addParameterToElement(src, ParameterCode.DR_CONSISTENCY_GROUP_TRANS_POLICY_TYPE, ParameterCode.POLICY_PARAM_TYPE);
        dest.addParameterToElement(src, ParameterCode.DR_CONSISTENCY_GROUP_TRANS_POLICY_RUN_EVERY, ParameterCode.POLICY_PARAM_RUN_EVERY);
        return dest;
    }

    private ConfigElementData createMergePolicyData(ConfigElementData src) {
        if (src.getValue(ParameterCode.DR_CONSISTENCY_GROUP_MERGE_POLICY_ID) == null && src.getValue(ParameterCode.DR_CONSISTENCY_GROUP_MERGE_POLICY_TYPE) == null && src.getValue(ParameterCode.DR_CONSISTENCY_GROUP_MERGE_POLICY_PARAM_ID) == null) {
            return null;
        }
        ConfigElementData dest = new ConfigElementData(ClassID.POLICY_START);
        dest.addParameterToElement(src, ParameterCode.VSWITCH_ID);
        dest.addParameterToElement(src, ParameterCode.DR_CONSISTENCY_GROUP_MERGE_POLICY_ID, ParameterCode.POLICY_ID);
        dest.addParameterToElement(src, ParameterCode.DR_CONSISTENCY_GROUP_MERGE_POLICY_PARAM_ID, ParameterCode.POLICY_PARAM_ID);
        dest.addParameterToElement(src, ParameterCode.DR_CONSISTENCY_GROUP_MERGE_POLICY_TYPE, ParameterCode.POLICY_PARAM_TYPE);
        return dest;
    }

    public void postSendCreateEvent(ConfigElementData myElement) throws SrCommunicationException {
        char snmpAgent = myElement.getMyFirstSnmpAgentIndex();
        super.postSendCreateEvent(myElement);
        JournalVolumeConfigurator journalVolumesConfigurator = new JournalVolumeConfigurator();
        ConfigElementDataList journalVolList = journalVolumesConfigurator.refreshJournalVolumesTable(snmpAgent);
        SrEventHandler.getEventMgr().sendRefreshElementEvent(journalVolList);
    }

    private void checkCGData(ConfigElementData cg) {
        ParameterCode[] codes = new ParameterCode[]{ParameterCode.DR_CONSISTENCY_GROUP_PIT_POLICY_ID, ParameterCode.DR_CONSISTENCY_GROUP_PIT_POLICY_PARAM_ID, ParameterCode.DR_CONSISTENCY_GROUP_TRANS_POLICY_ID, ParameterCode.DR_CONSISTENCY_GROUP_TRANS_POLICY_PARAM_ID, ParameterCode.DR_CONSISTENCY_GROUP_MERGE_POLICY_ID, ParameterCode.DR_CONSISTENCY_GROUP_MERGE_POLICY_PARAM_ID};
        this.printMissingData(cg, codes);
    }

    private void printMissingData(ConfigElementData element, ParameterCode[] codes) {
        for (int i = 0; i < codes.length; ++i) {
            if (element.getValue(codes[i]) != null) continue;
            System.out.println("ElementConfigurator: missing value for " + codes[i]);
        }
    }

    static {
        listOfParams.put(ParameterCode.DR_VIRT_GROUP_TYPE, null);
        listOfParams.put(ParameterCode.DR_VIRT_GROUP_ELEMENTS_COUNT, null);
        listOfParams.put(ParameterCode.DR_VIRT_GROUP_ALIAS, null);
        listOfParams.put(ParameterCode.DR_VIRT_GROUP_STATE, null);
        listOfParams.put(ParameterCode.DR_CONSISTENCY_GROUP_ROLE, null);
        listOfParams.put(ParameterCode.DR_CONSISTENCY_GROUP_PIT_POLICY_ID, null);
        listOfParams.put(ParameterCode.DR_CONSISTENCY_GROUP_TRANS_POLICY_ID, null);
        listOfParams.put(ParameterCode.DR_CONSISTENCY_GROUP_MERGE_POLICY_ID, null);
        listOfParams.put(ParameterCode.DR_CONSISTENCY_GROUP_MODE, null);
        listOfParams.put(ParameterCode.DR_CONSISTENCY_GROUP_OWNED_BY, null);
        listOfParams.put(ParameterCode.DR_CONSISTENCY_GROUP_REPLICATION_STATE, null);
        listOfParams.put(ParameterCode.DR_CONSISTENCY_GROUP_PENDING_DATA, null);
        listOfParams.put(ParameterCode.DR_CONSISTENCY_GROUP_PENDING_PITS, null);
        listOfParams.put(ParameterCode.DR_CONSISTENCY_GROUP_INITIAL_SYNC_STATE, null);
        listOfParams.put(ParameterCode.DR_CONSISTENCY_GROUP_ROW_STATUS, null);
        listOfParams.put(ParameterCode.DR_CONSISTENCY_GROUP_NEXT_REPLICATION_SCHEDULE, null);
        listOfParams.put(ParameterCode.DR_CONSISTENCY_GROUP_LAST_PIT_MERGE, null);
    }
}

