/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr.dr;

import com.sanrad.log.LogMgr;
import com.sanrad.nms.server.comm.CommVarBindList;
import com.sanrad.nms.server.comm.exception.SrCommunicationException;
import com.sanrad.nms.server.comm.snmp.MibItem;
import com.sanrad.nms.server.comm.snmp.SrOid;
import com.sanrad.nms.server.comm.snmp.SrSnmpVarBind;
import com.sanrad.nms.server.comm.snmp.trap.SrTrap;
import com.sanrad.nms.server.comm.snmp.trap.SrTrapType;
import com.sanrad.nms.server.event.SrEventHandler;
import com.sanrad.nms.server.exception.SrElementOperationException;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.dr.ConsistencyGroupConfigurator;
import com.sanrad.nms.server.mgr.dr.PairConfigurator;
import com.sanrad.nms.server.mgr.volume.SnapshotVolumeConfigurator;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKey;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.CommKeyUtil;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.SnmpCommKey;
import com.sanrad.nms.server.util.types.SrGauge;
import com.sanrad.nms.server.util.types.SrType;
import com.sanrad.nms.server.util.types.constants.DRGroupOwnedByConstant;
import com.sanrad.nms.server.util.types.constants.DRPairInitialSyncTypeConstant;
import com.sanrad.nms.server.util.types.constants.DRPairTypeConstant;
import com.sanrad.nms.server.util.types.constants.RowStatusConstants;
import java.util.HashMap;

public class AsyncPairConfigurator
extends PairConfigurator {
    private static final HashMap listOfParams = new HashMap();

    public AsyncPairConfigurator() {
        super(ClassID.ASYNC_PAIR, "srAsyncPairTable", MibItem.DR_PAIR_ROW_STATUS, MibItem.DR_ASYNC_PAIR_TABLE_LAST_UPDATE);
    }

    public HashMap getListOfParams() {
        return listOfParams;
    }

    public void internalCreate(ConfigElementData element) throws SrCommunicationException, SrElementOperationException {
        this.updateCedAfterCreate(element);
        element.setValue(ParameterCode.DR_PAIR_TYPE, DRPairTypeConstant.ASYNC);
        char agentIndex = element.getSnmpAgentFromParameter();
        SnmpCommKey newPairIndex = super.getPairIndexNext(agentIndex);
        ConfigElementData pairElement = new ConfigElementData(newPairIndex, this.myClassId);
        super.addParametersForCreate(element, pairElement);
        ConfigElementData asyncPairElement = new ConfigElementData(newPairIndex, this.myClassId);
        this.addParametersForCreate(element, asyncPairElement);
        this.prepareJournalID(asyncPairElement, agentIndex);
        this.prepareSnapshotID(asyncPairElement, agentIndex);
        this.prepareGroupID(asyncPairElement, agentIndex);
        super.internalCreate(pairElement);
        super.internalChange(asyncPairElement);
        element.setCommKey(newPairIndex);
    }

    public void internalChange(ConfigElementData element) throws SrCommunicationException, SrElementOperationException {
        char agentIndex = element.getMyFirstSnmpAgentIndex();
        this.prepareJournalID(element, agentIndex);
        this.prepareSnapshotID(element, agentIndex);
        super.internalChange(element);
    }

    public boolean readAfterCreate(ConfigElementData element) throws SrCommunicationException {
        element.removeAll();
        return super.readAfterCreate(element);
    }

    public void postSendRemoveEvent(ConfigElementData element) throws SrCommunicationException {
        super.postSendRemoveEvent(element);
        CommKeyClassId groupID = (CommKeyClassId)element.getValue(ParameterCode.DR_ASYNC_PAIR_GROUP_ID);
        if (groupID != null && groupID.getClassID().equals(ClassID.EXTENDED_PAIR)) {
            ConsistencyGroupConfigurator cgConfig = new ConsistencyGroupConfigurator();
            cgConfig.stimulateRefresh(element.getSnmpAgentFromParameter());
            cgConfig.postSendRemoveEvent(element);
        }
    }

    ConfigElementData addParametersForCreate(ConfigElementData src, ConfigElementData dest) {
        dest.addParameterToElement(src, ParameterCode.VSWITCH_ID);
        dest.addParameterToElement(src, ParameterCode.DR_ASYNC_PAIR_JOURNAL_ID);
        dest.addParameterToElement(src, ParameterCode.DR_ASYNC_PAIR_GROUP_ID);
        dest.addParameterToElement(src, ParameterCode.DR_ASYNC_PAIR_SNAPSHOT_ID);
        return dest;
    }

    ConfigElementData addParametersForChange(ConfigElementData src, ConfigElementData dest) {
        dest.addParameterToElement(src, ParameterCode.VSWITCH_ID);
        dest.addParameterToElement(src, ParameterCode.DR_ASYNC_PAIR_JOURNAL_ID);
        dest.addParameterToElement(src, ParameterCode.DR_ASYNC_PAIR_GROUP_ID);
        dest.addParameterToElement(src, ParameterCode.DR_ASYNC_PAIR_SNAPSHOT_ID);
        dest.addParameterToElement(src, ParameterCode.DR_ASYNC_PAIR_ACTIVATE);
        return dest;
    }

    protected SrSnmpVarBind createRowStatusVarBind(CommKey commKey) {
        SrOid oid = new SrOid(this.myRowStatusMib.toString(), commKey.getKey());
        SrSnmpVarBind srVarBind = new SrSnmpVarBind(oid, (SrType)RowStatusConstants.ROW_STATUS_CREATE_AND_WAIT);
        return srVarBind;
    }

    protected void readDiscoverPostOperation(ConfigElementData element, CommVarBindList list) throws SrCommunicationException {
        char agentIndex = element.getMyFirstSnmpAgentIndex();
        Object groupID = element.getValue(ParameterCode.DR_ASYNC_PAIR_GROUP_ID);
        if (groupID != null) {
            String groupIndex = element.getValue(ParameterCode.DR_ASYNC_PAIR_GROUP_ID).toString();
            SrType[] ownedBy = this.readTableCells(new MibItem[]{MibItem.DR_GROUP_OWNED_BY}, groupIndex, agentIndex);
            SnmpCommKey groupKey = new SnmpCommKey(groupIndex, agentIndex);
            ClassID groupClass = ownedBy[0] == DRGroupOwnedByConstant.USER ? ClassID.CONSISTENCY_GROUP : ClassID.EXTENDED_PAIR;
            element.setValue(ParameterCode.DR_ASYNC_PAIR_GROUP_ID, new CommKeyClassId(groupKey, groupClass));
        } else {
            logger.warning("Could not match DR Group ID for AsyncPair " + element.getCommKeyClassId() + ", " + ClassID.VSWITCH + " " + CommKeyUtil.getIpFromIndex(agentIndex));
        }
        Object jourID = element.getValue(ParameterCode.DR_ASYNC_PAIR_JOURNAL_ID);
        if (jourID != null) {
            SnmpCommKey jourKey = new SnmpCommKey("1." + jourID.toString(), agentIndex);
            element.setValue(ParameterCode.DR_ASYNC_PAIR_JOURNAL_ID, new CommKeyClassId(jourKey, ClassID.JOURNAL_VOLUME));
        }
        if (element.containParameter(ParameterCode.DR_ASYNC_PAIR_SNAPSHOT_ID)) {
            Object snapID = element.getValue(ParameterCode.DR_ASYNC_PAIR_SNAPSHOT_ID);
            if (snapID != null && !((SrGauge)snapID).equals(0)) {
                SnmpCommKey snapKey = new SnmpCommKey("1." + snapID.toString(), agentIndex);
                CommKeyClassId snapshotCommkeyClassId = new CommKeyClassId(snapKey, ClassID.SNAPSHOT_VOLUME);
                element.setValue(ParameterCode.DR_ASYNC_PAIR_SNAPSHOT_ID, snapshotCommkeyClassId);
                this.readSnapshotVolumeData(snapshotCommkeyClassId);
            } else {
                element.setValue(ParameterCode.DR_ASYNC_PAIR_SNAPSHOT_ID, (SrType)null);
            }
        }
        super.readDiscoverPostOperation(element, list);
    }

    protected void trapProccessingPostOperation(ConfigElementData element, SrTrap trap) {
        element.setClassId(this.myClassId);
        SrTrapType trapType = trap.getTrapType();
        if (trapType == SrTrapType.ASYNC_PAIR_STATE_CHANGED) {
            if (element.getSnmpKey() == null || element.getSnmpKey() != null && element.getSnmpKey().getKey() != null) {
                try {
                    ConfigElementData fullInfoElement = new ConfigElementData(element.getCommKeyClassId());
                    this.internalRead(fullInfoElement);
                    SrEventHandler.getEventMgr().sendChangeElementEvent(fullInfoElement);
                }
                catch (SrCommunicationException e) {
                    SrEventHandler.getEventMgr().sendChangeElementEvent(element);
                }
            }
        } else if (trapType == SrTrapType.PAIR_CREATED) {
            this.handleCreateTrap(element);
        } else if (trapType == SrTrapType.PAIR_DELETED) {
            SrEventHandler.getEventMgr().sendRemoveElementEvent(element);
        }
    }

    private void handleCreateTrap(ConfigElementData element) {
        RowStatusConstants rowStatus = (RowStatusConstants)element.getValue(ParameterCode.DR_PAIR_ROW_STATUS);
        if (rowStatus.equals(RowStatusConstants.ROW_STATUS_ACTIVE)) {
            try {
                this.internalRead(element);
                SrEventHandler.getEventMgr().sendAddElementEvent(element);
            }
            catch (SrCommunicationException e) {
                e.printStackTrace();
                element.setClassId(this.myClassId);
                LogMgr.getServerLog().debug("Trap on creation of " + element.getClassId().toString() + " CommKey is: " + CommKeyUtil.getKeyForMessage(element.getCommKey()) + ": failed to read new element.");
            }
        }
    }

    private void prepareJournalID(ConfigElementData element, char agentIndex) {
        CommKeyClassId journalKey = (CommKeyClassId)element.getValue(ParameterCode.DR_ASYNC_PAIR_JOURNAL_ID);
        if (journalKey != null) {
            String jourIndex = CommKeyUtil.getSpecificCommKey(journalKey, agentIndex).getKey();
            SrGauge id = new SrGauge(jourIndex.substring(jourIndex.indexOf(46) + 1));
            element.setValue(ParameterCode.DR_ASYNC_PAIR_JOURNAL_ID, id);
        }
    }

    private void prepareSnapshotID(ConfigElementData element, char agentIndex) {
        CommKeyClassId snapKey = (CommKeyClassId)element.getValue(ParameterCode.DR_ASYNC_PAIR_SNAPSHOT_ID);
        if (snapKey != null) {
            String snapIndex = CommKeyUtil.getSpecificCommKey(snapKey, agentIndex).getKey();
            SrGauge id = new SrGauge(snapIndex.substring(snapIndex.indexOf(46) + 1));
            element.setValue(ParameterCode.DR_ASYNC_PAIR_SNAPSHOT_ID, id);
        }
        if (DRPairInitialSyncTypeConstant.NONE.equals(element.getValue(ParameterCode.DR_PAIR_INITIAL_SYNC_TYPE))) {
            element.setValue(ParameterCode.DR_ASYNC_PAIR_SNAPSHOT_ID, new SrGauge(0));
        }
    }

    private void prepareGroupID(ConfigElementData element, char agentIndex) {
        CommKeyClassId groupKey = (CommKeyClassId)element.getValue(ParameterCode.DR_ASYNC_PAIR_GROUP_ID);
        if (groupKey != null) {
            String cgIndex = CommKeyUtil.getSpecificCommKey(groupKey, agentIndex).getKey();
            element.setValue(ParameterCode.DR_ASYNC_PAIR_GROUP_ID, new SrGauge(cgIndex));
        }
    }

    private void readSnapshotVolumeData(CommKeyClassId snapshotCommkeyClassId) throws SrCommunicationException {
        ConfigElementData snapshotElement = new ConfigElementData(snapshotCommkeyClassId);
        SnapshotVolumeConfigurator snapshotCfg = new SnapshotVolumeConfigurator();
        snapshotCfg.internalRead(snapshotElement);
        SrEventHandler.getEventMgr().sendRefreshElementEvent(snapshotElement);
    }

    static {
        listOfParams.put(ParameterCode.DR_PAIR_TYPE, null);
        listOfParams.put(ParameterCode.DR_PAIR_PRIMARY_ID, null);
        listOfParams.put(ParameterCode.DR_PAIR_SECONDARY_ID, null);
        listOfParams.put(ParameterCode.DR_PAIR_INITIAL_SYNC_TYPE, null);
        listOfParams.put(ParameterCode.DR_PAIR_MODE, null);
        listOfParams.put(ParameterCode.DR_PAIR_STATE, null);
        listOfParams.put(ParameterCode.DR_PAIR_INITIAL_SYNC_STATE, null);
        listOfParams.put(ParameterCode.DR_PAIR_ONLINE_INIT_SYNC_DATA_TRANSFFERED, null);
        listOfParams.put(ParameterCode.DR_ASYNC_PAIR_JOURNAL_ID, null);
        listOfParams.put(ParameterCode.DR_ASYNC_PAIR_GROUP_ID, null);
        listOfParams.put(ParameterCode.DR_ASYNC_PAIR_REPLICATION_STATE, null);
        listOfParams.put(ParameterCode.DR_ASYNC_PAIR_PENDING_DATA, null);
        listOfParams.put(ParameterCode.DR_ASYNC_PAIR_PENDING_PITS, null);
        listOfParams.put(ParameterCode.DR_ASYNC_PAIR_SNAPSHOT_ID, null);
        listOfParams.put(ParameterCode.DR_ASYNC_PAIR_LAST_PIT_MERGE, null);
    }
}

