/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr.discover;

import com.sanrad.log.LogMgr;
import com.sanrad.nms.server.comm.exception.SrCommunicationException;
import com.sanrad.nms.server.event.SrEventHandler;
import com.sanrad.nms.server.exception.InitializationException;
import com.sanrad.nms.server.mgr.AlarmTypeConfigurator;
import com.sanrad.nms.server.mgr.ClusterConfigurator;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.ConfigElementDataList;
import com.sanrad.nms.server.mgr.EmailContactConfigurator;
import com.sanrad.nms.server.mgr.SiteConfigurator;
import com.sanrad.nms.server.mgr.VSwitchConfigurator;
import com.sanrad.nms.server.mgr.discover.DefaultVSwitchDiscoveryMgr;
import com.sanrad.nms.server.mgr.polling.PollingMgr;
import com.sanrad.nms.server.mgr.threads.SrThread;
import com.sanrad.nms.server.mgr.threads.ThreadType;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.CommKeyUtil;
import java.util.Vector;

public class DiscoverMgr {
    private DefaultVSwitchDiscoveryMgr[] discoverMgrs = new DefaultVSwitchDiscoveryMgr[0];
    private static DiscoverMgr theInstance = new DiscoverMgr();

    public synchronized void addDiscoverMgr(CommKeyClassId vSwitchData) throws InitializationException {
        char indexToAdd = vSwitchData.getMyFirstSnmpAgentIndex();
        if (indexToAdd <= this.discoverMgrs.length - 1) {
            if (this.discoverMgrs[indexToAdd] != null) {
                throw new InitializationException("The index of the Snmp Agent is invalid");
            }
        } else {
            DefaultVSwitchDiscoveryMgr[] newArray = new DefaultVSwitchDiscoveryMgr[indexToAdd + '\u0001'];
            System.arraycopy(this.discoverMgrs, 0, newArray, 0, this.discoverMgrs.length);
            this.discoverMgrs = newArray;
        }
        this.discoverMgrs[indexToAdd] = new DefaultVSwitchDiscoveryMgr(vSwitchData);
    }

    public synchronized DefaultVSwitchDiscoveryMgr getDiscoveryMgr(char snmpAgentIndex) {
        return this.discoverMgrs[snmpAgentIndex];
    }

    public synchronized void removeDiscoverMgr(char SnmpAgentIndex) {
        this.discoverMgrs[SnmpAgentIndex] = null;
    }

    private DiscoverMgr() {
    }

    public static DiscoverMgr getInstance() {
        return theInstance;
    }

    public synchronized CommKeyClassId getPhysStorOfVolId(String volId, char snmpAgentIndex) {
        return this.getDiscoveryMgr(snmpAgentIndex).getPhysStorOfVolId(volId);
    }

    public synchronized void removePhysStorOfVolId(String volId, char snmpAgentIndex) {
        this.getDiscoveryMgr(snmpAgentIndex).removePhysStorOfVolId(volId);
    }

    public synchronized void addEntryToVolPhysStorMap(String volId, CommKeyClassId physStorData) {
        this.getDiscoveryMgr(physStorData.getMyFirstSnmpAgentIndex()).addEntryToVolPhysStorMap(volId, physStorData);
    }

    public synchronized String getVolIdForPhysStor(CommKeyClassId physStor) {
        return this.getDiscoveryMgr(physStor.getMyFirstSnmpAgentIndex()).getVolIdForPhysStor(physStor);
    }

    public synchronized String getVolIdForPhysStor(CommKeyClassId physStor, char snmpAgentIndex) {
        return this.getDiscoveryMgr(snmpAgentIndex).getVolIdForPhysStor(physStor);
    }

    public synchronized CommKeyClassId getAndRemovePhysStorData(String volId, char snmpAgentIndex) {
        return this.getDiscoveryMgr(snmpAgentIndex).getAndRemovePhysStorData(volId);
    }

    public synchronized ConfigElementData getOneVolumeData(String volumeId, char snmpAgentIndex) throws SrCommunicationException {
        return this.getDiscoveryMgr(snmpAgentIndex).getOneVolumeData(volumeId);
    }

    public synchronized void discover(CommKeyClassId vSwitch) {
        char snmpAgentIndex = vSwitch.getMyFirstSnmpAgentIndex();
        this.getDiscoveryMgr(snmpAgentIndex).virtualizationDiscovery();
    }

    public synchronized void systemDiscovery() {
        Thread systemDiscovery = new Thread("SystemDiscovery-" + this.getClass()){

            public void run() {
                try {
                    SiteConfigurator site = new SiteConfigurator();
                    site.getAll();
                }
                catch (SrCommunicationException e) {
                    LogMgr.getServerLog().debug(e);
                }
                SrEventHandler.getEventMgr().sendEndOfSystemDiscovery();
            }
        };
        systemDiscovery.start();
    }

    public synchronized void clusterDiscovevry() {
        this.clusterDiscovevry(null);
    }

    public synchronized void siteDiscovevry(Integer siteId) {
        SrThread siteDiscovery = new SrThread("SiteDiscovery", ThreadType.VSWITCH_DISCOVER_THREAD_TYPE){

            public void run() {
                try {
                    ClusterConfigurator cluster = new ClusterConfigurator();
                    cluster.getAll();
                    DiscoverMgr.this.clusterDiscovevry(null);
                }
                catch (SrCommunicationException e) {
                    LogMgr.getServerLog().debug(e);
                }
                SrEventHandler.getEventMgr().sendEndOfSiteDiscovery();
            }
        };
        siteDiscovery.start();
    }

    public synchronized void clusterDiscovevry(final Integer clusterId) {
        SrThread clusterDiscovery = new SrThread("ClusterDiscovery", ThreadType.VSWITCH_DISCOVER_THREAD_TYPE){

            public void run() {
                try {
                    VSwitchConfigurator vSwitch = new VSwitchConfigurator();
                    ConfigElementDataList allvSwitches = vSwitch.getAll(clusterId, null, null);
                    for (int i = 0; i < allvSwitches.size(); ++i) {
                        ConfigElementData element = (ConfigElementData)allvSwitches.elementAt(i);
                        CommKeyClassId vSwtichData = new CommKeyClassId(element.getCommKey(), ClassID.VSWITCH);
                        DiscoverMgr.this.addDiscoverMgr(vSwtichData);
                        CommKeyUtil.addVSwitch(vSwtichData);
                        PollingMgr.getInstance().addAgent(element);
                    }
                    AlarmTypeConfigurator alramTypesConfig = new AlarmTypeConfigurator();
                    alramTypesConfig.getAll();
                    EmailContactConfigurator emailContactConfig = new EmailContactConfigurator();
                    emailContactConfig.getAll();
                }
                catch (SrCommunicationException e) {
                    LogMgr.getServerLog().debug(e);
                }
                catch (InitializationException e) {
                    LogMgr.getServerLog().debug(e);
                }
                SrEventHandler.getEventMgr().sendEndOfClusterDiscovery();
            }
        };
        clusterDiscovery.start();
    }

    public synchronized void vSwitchDiscovery(CommKeyClassId vSwitch) {
        this.getDiscoveryMgr(vSwitch.getMyFirstSnmpAgentIndex()).vSwitchDiscovery();
    }

    public synchronized void addEntryToLUIdPhysStorMap(CommKeyClassId physStorCommKey, CommKeyClassId luId) {
        this.getDiscoveryMgr(physStorCommKey.getMyFirstSnmpAgentIndex()).addEntryToLUIdPhysStorMap(physStorCommKey, luId);
    }

    public synchronized Vector getEntryFromLUIdPhysStorMap(CommKeyClassId physStorCommKey) {
        return this.getDiscoveryMgr(physStorCommKey.getMyFirstSnmpAgentIndex()).getEntryFromLUIdPhysStorMap(physStorCommKey);
    }

    public synchronized void clearLUIdPhysStorMap(CommKeyClassId physStorCommKey) {
        this.getDiscoveryMgr(physStorCommKey.getMyFirstSnmpAgentIndex()).clearLUIdPhysStorMap(physStorCommKey);
    }

    public synchronized void addVolumeToInvolvedList(String volId, char agentIndex) {
        this.getDiscoveryMgr(agentIndex).addVolumeToInvolvedList(volId);
    }

    public synchronized void addVolumeToInvolvedList(CommKeyClassId volId, char agentIndex) {
        this.getDiscoveryMgr(agentIndex).addVolumeToInvolvedList(volId);
    }

    public synchronized boolean isVolInvolvedInOtherOper(String volId, char agentIndex) {
        return this.getDiscoveryMgr(agentIndex).isVolInvolvedInOtherOper(volId);
    }

    public synchronized void removeVolumeFromInvolvedList(String volId, char agentIndex) {
        this.getDiscoveryMgr(agentIndex).removeVolumeFromInvolvedList(volId);
    }

    public synchronized void removeVolumeFromInvolvedList(CommKeyClassId volId, char agentIndex) {
        this.getDiscoveryMgr(agentIndex).removeVolumeFromInvolvedList(volId);
    }

    public synchronized void replaceVolInInvolvedList(String oldVol, String newVol, char agentIndex) {
        this.getDiscoveryMgr(agentIndex).replaceVolInInvolvedList(oldVol, newVol);
    }

    public synchronized void replaceVolInInvolvedList(CommKeyClassId oldVol, CommKeyClassId newVol, char agentIndex) {
        this.getDiscoveryMgr(agentIndex).replaceVolInInvolvedList(oldVol, newVol);
    }
}

