/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr.discover;

import com.sanrad.log.LogMgr;
import com.sanrad.nms.server.comm.CommMgr;
import com.sanrad.nms.server.comm.exception.SrCommunicationException;
import com.sanrad.nms.server.comm.snmp.SrSnmpTable;
import com.sanrad.nms.server.comm.snmp.exception.SrSnmpTimeoutException;
import com.sanrad.nms.server.event.SnmpErrorEvent;
import com.sanrad.nms.server.event.SrEventHandler;
import com.sanrad.nms.server.exception.ConfigurationErrorException;
import com.sanrad.nms.server.exception.MissingValueException;
import com.sanrad.nms.server.exception.TypeMismatchException;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.DataMgr;
import com.sanrad.nms.server.mgr.FCNodeConfigurator;
import com.sanrad.nms.server.mgr.HardwareConfigurator;
import com.sanrad.nms.server.mgr.IScsiInstanceConfigurator;
import com.sanrad.nms.server.mgr.IScsiSessionConfigurator;
import com.sanrad.nms.server.mgr.IfConfigurator;
import com.sanrad.nms.server.mgr.IfStatisticConfigurator;
import com.sanrad.nms.server.mgr.IpRouteConfigurator;
import com.sanrad.nms.server.mgr.LUNConfigurator;
import com.sanrad.nms.server.mgr.NetConfigConfigurator;
import com.sanrad.nms.server.mgr.ScsiDeviceConfigurator;
import com.sanrad.nms.server.mgr.SnmpManagerConfigurator;
import com.sanrad.nms.server.mgr.SnmpTargetAddressConfigurator;
import com.sanrad.nms.server.mgr.StatisticConfigurator;
import com.sanrad.nms.server.mgr.TcpConnectionConfigurator;
import com.sanrad.nms.server.mgr.UDPListenerConfigurator;
import com.sanrad.nms.server.mgr.VSwitchConfigurator;
import com.sanrad.nms.server.mgr.acl.TargetAuthorizationConfigurator;
import com.sanrad.nms.server.mgr.discover.DiscoverMgr;
import com.sanrad.nms.server.mgr.discover.VSwitchDiscoveryMgr;
import com.sanrad.nms.server.mgr.dr.DRDiscoveryConfigurator;
import com.sanrad.nms.server.mgr.identity.CHAPCredentialsConfigurator;
import com.sanrad.nms.server.mgr.identity.IdentityConfigurator;
import com.sanrad.nms.server.mgr.identity.IdentityNameConfigurator;
import com.sanrad.nms.server.mgr.identity.SRPCredentialsConfigurator;
import com.sanrad.nms.server.mgr.lu.SCSILunConfigurator;
import com.sanrad.nms.server.mgr.srv.isns.ISNSServerConfigurator;
import com.sanrad.nms.server.mgr.srv.radius.RadiusServerConfigurator;
import com.sanrad.nms.server.mgr.storage.PhysicalStorageConfigurator;
import com.sanrad.nms.server.mgr.target.IscsiPortalConfigurator;
import com.sanrad.nms.server.mgr.target.IscsiTargetConfigurator;
import com.sanrad.nms.server.mgr.threads.SrThread;
import com.sanrad.nms.server.mgr.threads.SrThreadCreationException;
import com.sanrad.nms.server.mgr.threads.ThreadMgr;
import com.sanrad.nms.server.mgr.threads.ThreadType;
import com.sanrad.nms.server.mgr.volume.JournalVolumeConfigurator;
import com.sanrad.nms.server.mgr.volume.SnapshotVolumeConfigurator;
import com.sanrad.nms.server.mgr.volume.VolumeChildrenConfigurator;
import com.sanrad.nms.server.mgr.volume.VolumeConfigurator;
import com.sanrad.nms.server.mgr.volume.VolumeOperationConfigurator;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.CommKeyUtil;
import com.sanrad.nms.server.util.Parameter;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.SnmpCommKey;
import com.sanrad.nms.server.util.types.SrGauge;
import com.sanrad.nms.server.util.types.SrInteger;
import com.sanrad.nms.server.util.types.SrType;
import com.sanrad.util.Util;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public class AbstractVSwitchDiscoveryMgr
implements VSwitchDiscoveryMgr {
    private boolean m_sessionDiscoveryActivated = false;
    private char m_agentIndex;
    private CommKeyClassId m_vSwitchData;
    private HashMap m_simpleVolToPhysStorMap = new HashMap();
    private HashMap m_transVolToPhysStorMap = new HashMap();
    private Object[][] m_parentChildVolumesData = null;
    private SrSnmpTable m_volumesTable = null;
    private SrSnmpTable m_stripVolumeTable = null;
    private SrSnmpTable m_snapshotVolumeTable = null;
    private SrSnmpTable m_journalVolumeTable = null;
    private Vector m_involvedInOtherOperationVolumeList = new Vector();
    private Vector m_snapshotVolumes = new Vector();
    private Vector m_journalVolumes = new Vector();
    private Hashtable m_physStorToLUIdMap = new Hashtable();
    protected static final int DISCOVER_CONTEXT = 1;
    protected static final int REBUILD_CONTEXT = 2;

    public AbstractVSwitchDiscoveryMgr(CommKeyClassId vSwitchData) {
        this.m_agentIndex = vSwitchData.getMyFirstSnmpAgentIndex();
        this.m_vSwitchData = vSwitchData;
    }

    public CommKeyClassId getVSwitchData() {
        return (CommKeyClassId)this.m_vSwitchData.clone();
    }

    public char getAgentIndex() {
        return this.m_agentIndex;
    }

    public synchronized void clearStructures() {
        this.m_parentChildVolumesData = null;
        this.m_stripVolumeTable = null;
        this.m_simpleVolToPhysStorMap.clear();
        this.m_transVolToPhysStorMap.clear();
        this.m_volumesTable = null;
        this.m_involvedInOtherOperationVolumeList.clear();
        this.m_snapshotVolumes.clear();
        this.m_journalVolumes.clear();
        this.m_physStorToLUIdMap.clear();
        this.m_snapshotVolumeTable = null;
        this.m_journalVolumeTable = null;
    }

    private void setSessionDiscoveryActivated(boolean activate) {
        this.m_sessionDiscoveryActivated = activate;
    }

    public void addVolumeToInvolvedList(CommKeyClassId vol) {
        if (vol == null) {
            return;
        }
        ClassID classId = vol.getClassID();
        String simpleVolId = null;
        if (classId.equals(ClassID.DIRECT_ACCESS_DEVICE) || classId.equals(ClassID.SUB_DIRECT_ACCESS_DEVICE)) {
            simpleVolId = this.getVolIdForPhysStor(vol);
        } else if (classId.equals(ClassID.SIMPLE_VOLUME)) {
            simpleVolId = CommKeyUtil.getSpecificSnmpKey(vol, this.m_agentIndex).getKey();
        } else {
            return;
        }
        this.addVolumeToInvolvedList(simpleVolId);
    }

    public void addVolumeToInvolvedList(String volId) {
        String id = volId;
        if (volId.indexOf(".") >= 0) {
            id = volId.substring(volId.indexOf(".") + 1);
        }
        this.m_involvedInOtherOperationVolumeList.add(id);
    }

    public void replaceVolInInvolvedList(String oldVol, String newVol) {
        if (oldVol != null) {
            this.removeVolumeFromInvolvedList(oldVol);
        }
        if (newVol != null) {
            this.addVolumeToInvolvedList(newVol);
        }
    }

    public void replaceVolInInvolvedList(CommKeyClassId oldVol, CommKeyClassId newVol) {
        if (oldVol == null || newVol == null) {
            return;
        }
        ClassID classIdOld = oldVol.getClassID();
        String simpleVolIdOld = null;
        if (classIdOld.equals(ClassID.DIRECT_ACCESS_DEVICE) || classIdOld.equals(ClassID.SUB_DIRECT_ACCESS_DEVICE)) {
            simpleVolIdOld = this.getVolIdForPhysStor(oldVol);
        } else if (classIdOld.equals(ClassID.SIMPLE_VOLUME)) {
            simpleVolIdOld = CommKeyUtil.getSpecificSnmpKey(oldVol, this.m_agentIndex).getKey();
        }
        ClassID classIdNew = newVol.getClassID();
        String simpleVolIdNew = null;
        if (classIdNew.equals(ClassID.DIRECT_ACCESS_DEVICE) || classIdNew.equals(ClassID.SUB_DIRECT_ACCESS_DEVICE)) {
            simpleVolIdNew = this.getVolIdForPhysStor(newVol);
        } else if (classIdNew.equals(ClassID.SIMPLE_VOLUME)) {
            simpleVolIdNew = CommKeyUtil.getSpecificSnmpKey(newVol, this.m_agentIndex).getKey();
        }
        this.replaceVolInInvolvedList(simpleVolIdOld, simpleVolIdNew);
    }

    public void removeVolumeFromInvolvedList(String volId) {
        String id = volId;
        if (volId.indexOf(".") >= 0) {
            id = volId.substring(volId.indexOf(".") + 1);
        }
        this.m_involvedInOtherOperationVolumeList.remove(id);
    }

    public void removeVolumeFromInvolvedList(CommKeyClassId vol) {
        if (vol == null) {
            return;
        }
        ClassID classId = vol.getClassID();
        String simpleVolId = null;
        if (classId.equals(ClassID.DIRECT_ACCESS_DEVICE) || classId.equals(ClassID.SUB_DIRECT_ACCESS_DEVICE)) {
            simpleVolId = this.getVolIdForPhysStor(vol);
        } else if (classId.equals(ClassID.SIMPLE_VOLUME)) {
            simpleVolId = CommKeyUtil.getSpecificSnmpKey(vol, this.m_agentIndex).getKey();
        } else {
            return;
        }
        if (simpleVolId != null) {
            this.removeVolumeFromInvolvedList(simpleVolId);
        }
    }

    public boolean isVolInvolvedInOtherOper(String volId) {
        String id = volId;
        if (volId.indexOf(".") >= 0) {
            id = volId.substring(volId.indexOf(".") + 1);
        }
        return this.m_involvedInOtherOperationVolumeList.contains(id);
    }

    public synchronized CommKeyClassId getPhysStorOfVolId(String volId) {
        CommKeyClassId commKeyClassId = (CommKeyClassId)this.m_simpleVolToPhysStorMap.get(volId);
        return commKeyClassId;
    }

    public synchronized void removePhysStorOfVolId(String volId) {
        CommKeyClassId physStorData = this.getPhysStorOfVolId(volId);
        ConfigElementData physStorElement = new ConfigElementData(physStorData.getCommKeys(), physStorData.getClassID());
        physStorElement.setValue(ParameterCode.VSWITCH_ID, this.m_vSwitchData);
        physStorElement.setValue(ParameterCode.VOLUME_STATE, (SrType)null);
        SrEventHandler.getEventMgr().sendChangeElementEvent(physStorElement);
        this.m_simpleVolToPhysStorMap.remove(volId);
        this.removeVolumeFromInvolvedList(volId);
    }

    public synchronized void addEntryToVolPhysStorMap(String volId, CommKeyClassId physStorData) {
        if (volId.equals("1.0")) {
            return;
        }
        try {
            CommKeyClassId physStorSpecificData = CommKeyUtil.getSpecificCommKeyClassId(physStorData, this.m_agentIndex);
            if (physStorSpecificData != null) {
                this.m_simpleVolToPhysStorMap.put(volId, physStorSpecificData);
            } else {
                LogMgr.getServerLog().error("PhyStor Discovery Error at Agent" + this.m_agentIndex);
            }
        }
        catch (Exception e) {
            LogMgr.getServerLog().error("PhyStor Discovery Error at Agent" + this.m_agentIndex, e);
        }
    }

    public synchronized void addDiscoveredTransparentStorage(String transVolIndex, CommKeyClassId physStor) {
        if (transVolIndex.equals("1.0")) {
            return;
        }
        this.m_transVolToPhysStorMap.put(transVolIndex, physStor);
    }

    public synchronized String getVolIdForPhysStor(CommKeyClassId physStorData) {
        CommKeyClassId physStor = CommKeyUtil.getSpecificCommKeyClassId(physStorData, this.m_agentIndex);
        if (physStor == null || !this.m_simpleVolToPhysStorMap.containsValue(physStor)) {
            return null;
        }
        Iterator volumePhysStor = this.m_simpleVolToPhysStorMap.keySet().iterator();
        while (volumePhysStor.hasNext()) {
            String volumeId = (String)volumePhysStor.next();
            if (!this.getPhysStorOfVolId(volumeId).equals(physStor)) continue;
            return volumeId;
        }
        return null;
    }

    public synchronized CommKeyClassId getAndRemovePhysStorData(String volId) {
        try {
            CommKeyClassId physStor = (CommKeyClassId)this.m_simpleVolToPhysStorMap.get(volId);
            this.m_simpleVolToPhysStorMap.remove(volId);
            return physStor;
        }
        catch (Exception e) {
            LogMgr.getServerLog().debug("Error in voluemToPhysStorMap. Agent: " + this.m_agentIndex, e);
            return null;
        }
    }

    public void virtualizationDiscovery() {
        this.clearStructures();
        try {
            DiscoveryThread discoverVirt = new DiscoveryThread("Virtualization Discovery " + this.m_vSwitchData.getCommKeys()[0].getKey(), ThreadType.VSWITCH_VIRT_VOL_DISCOVER_THREAD_TYPE){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    block15: {
                        ThreadMgr.getInstance().getAgentThreadMgr(AbstractVSwitchDiscoveryMgr.this.m_agentIndex).manageVSwitchVirtVolDiscoveryThread();
                        try {
                            try {
                                AbstractVSwitchDiscoveryMgr.this.identitiesDiscovery();
                                this.initiatorAndTargetDiscovery();
                                AbstractVSwitchDiscoveryMgr.this.physStorAndVolumesDiscovery();
                                AbstractVSwitchDiscoveryMgr.this.policyDiscovery();
                                if (!AbstractVSwitchDiscoveryMgr.this.m_sessionDiscoveryActivated) {
                                    AbstractVSwitchDiscoveryMgr.this.setSessionDiscoveryActivated(true);
                                } else {
                                    AbstractVSwitchDiscoveryMgr.this.sessionDiscovery();
                                }
                                AbstractVSwitchDiscoveryMgr.this.disasterRecoveryDiscovery();
                                AbstractVSwitchDiscoveryMgr.this.simpleVolumesDiscovery(1);
                            }
                            catch (SrSnmpTimeoutException sste) {
                                LogMgr.getServerLog().error(sste.getMessage());
                                SnmpErrorEvent event = new SnmpErrorEvent((Object)this, "SNMP Timeout during virtualization discovery of " + ClassID.VSWITCH + " " + this.myIp, CommKeyUtil.getVSwitchData(AbstractVSwitchDiscoveryMgr.this.m_agentIndex), 1);
                                SrEventHandler.getSnmpErrorMgr().sendSnmpTimeOutEvent(event);
                                Object var4_2 = null;
                                LogMgr.getServerLog().debug(ClassID.VSWITCH + " discovery completed for " + this.myIp);
                                SrEventHandler.getEventMgr().sendEndOfVirtualizationDiscovery(AbstractVSwitchDiscoveryMgr.this.m_vSwitchData);
                                if (ThreadMgr.getInstance().getAgentThreadMgr(AbstractVSwitchDiscoveryMgr.this.m_agentIndex) != null) {
                                    ThreadMgr.getInstance().getAgentThreadMgr(AbstractVSwitchDiscoveryMgr.this.m_agentIndex).vSwitchVirtVolDiscoveryThreadDoneProcess();
                                }
                                break block15;
                            }
                            catch (SrCommunicationException e) {
                                LogMgr.getServerLog().debug(e);
                                Object var4_3 = null;
                                LogMgr.getServerLog().debug(ClassID.VSWITCH + " discovery completed for " + this.myIp);
                                SrEventHandler.getEventMgr().sendEndOfVirtualizationDiscovery(AbstractVSwitchDiscoveryMgr.this.m_vSwitchData);
                                if (ThreadMgr.getInstance().getAgentThreadMgr(AbstractVSwitchDiscoveryMgr.this.m_agentIndex) != null) {
                                    ThreadMgr.getInstance().getAgentThreadMgr(AbstractVSwitchDiscoveryMgr.this.m_agentIndex).vSwitchVirtVolDiscoveryThreadDoneProcess();
                                }
                                break block15;
                            }
                            catch (ConfigurationErrorException e) {
                                LogMgr.getServerLog().debug("Virtualization Discovery Error at: " + this.myIp);
                                LogMgr.getServerLog().debug(e);
                                Object var4_4 = null;
                                LogMgr.getServerLog().debug(ClassID.VSWITCH + " discovery completed for " + this.myIp);
                                SrEventHandler.getEventMgr().sendEndOfVirtualizationDiscovery(AbstractVSwitchDiscoveryMgr.this.m_vSwitchData);
                                if (ThreadMgr.getInstance().getAgentThreadMgr(AbstractVSwitchDiscoveryMgr.this.m_agentIndex) != null) {
                                    ThreadMgr.getInstance().getAgentThreadMgr(AbstractVSwitchDiscoveryMgr.this.m_agentIndex).vSwitchVirtVolDiscoveryThreadDoneProcess();
                                }
                                break block15;
                            }
                            catch (NullPointerException e) {
                                StringBuffer msg = new StringBuffer();
                                msg.append("This exception may occured when you delete V-Switch/Cluster during discovery\n");
                                msg.append(Util.getStackTraceOutput(e));
                                LogMgr.getServerLog().debug(msg.toString());
                                Object var4_5 = null;
                                LogMgr.getServerLog().debug(ClassID.VSWITCH + " discovery completed for " + this.myIp);
                                SrEventHandler.getEventMgr().sendEndOfVirtualizationDiscovery(AbstractVSwitchDiscoveryMgr.this.m_vSwitchData);
                                if (ThreadMgr.getInstance().getAgentThreadMgr(AbstractVSwitchDiscoveryMgr.this.m_agentIndex) != null) {
                                    ThreadMgr.getInstance().getAgentThreadMgr(AbstractVSwitchDiscoveryMgr.this.m_agentIndex).vSwitchVirtVolDiscoveryThreadDoneProcess();
                                }
                            }
                            Object var4_1 = null;
                            LogMgr.getServerLog().debug(ClassID.VSWITCH + " discovery completed for " + this.myIp);
                            SrEventHandler.getEventMgr().sendEndOfVirtualizationDiscovery(AbstractVSwitchDiscoveryMgr.this.m_vSwitchData);
                            if (ThreadMgr.getInstance().getAgentThreadMgr(AbstractVSwitchDiscoveryMgr.this.m_agentIndex) != null) {
                                ThreadMgr.getInstance().getAgentThreadMgr(AbstractVSwitchDiscoveryMgr.this.m_agentIndex).vSwitchVirtVolDiscoveryThreadDoneProcess();
                            }
                        }
                        catch (Throwable throwable) {
                            Object var4_6 = null;
                            LogMgr.getServerLog().debug(ClassID.VSWITCH + " discovery completed for " + this.myIp);
                            SrEventHandler.getEventMgr().sendEndOfVirtualizationDiscovery(AbstractVSwitchDiscoveryMgr.this.m_vSwitchData);
                            if (ThreadMgr.getInstance().getAgentThreadMgr(AbstractVSwitchDiscoveryMgr.this.m_agentIndex) != null) {
                                ThreadMgr.getInstance().getAgentThreadMgr(AbstractVSwitchDiscoveryMgr.this.m_agentIndex).vSwitchVirtVolDiscoveryThreadDoneProcess();
                            }
                            throw throwable;
                        }
                    }
                }

                private void initiatorAndTargetDiscovery() throws SrSnmpTimeoutException {
                    ScsiDeviceConfigurator deviceConfig = new ScsiDeviceConfigurator();
                    try {
                        deviceConfig.discover(AbstractVSwitchDiscoveryMgr.this.m_vSwitchData);
                    }
                    catch (SrSnmpTimeoutException e) {
                        LogMgr.getServerLog().error("Failed At initiator and target discovery - " + e.getMessage());
                        throw e;
                    }
                    catch (SrCommunicationException e) {
                        LogMgr.getServerLog().debug("Failed At initiator and target discovery", e);
                    }
                }
            };
            discoverVirt.start();
        }
        catch (SrThreadCreationException e) {
            LogMgr.getServerLog().error(e);
        }
        catch (Exception e) {
            LogMgr.getServerLog().error(e);
        }
    }

    private void sessionDiscovery() throws SrSnmpTimeoutException {
        IScsiSessionConfigurator iscsiSsnConfig = new IScsiSessionConfigurator();
        IScsiInstanceConfigurator iscsiInstConfig = new IScsiInstanceConfigurator();
        try {
            iscsiInstConfig.discover(this.m_vSwitchData);
            iscsiSsnConfig.discover(this.m_vSwitchData);
        }
        catch (SrSnmpTimeoutException e) {
            LogMgr.getServerLog().error("Failed At session discovery - " + e.getMessage());
            throw e;
        }
        catch (SrCommunicationException e) {
            LogMgr.getServerLog().debug("Failed At session discovery", e);
        }
        this.setSessionDiscoveryActivated(false);
    }

    private void identitiesDiscovery() throws SrSnmpTimeoutException {
        IdentityConfigurator identConfig = new IdentityConfigurator();
        IdentityNameConfigurator identNameConfig = new IdentityNameConfigurator();
        SRPCredentialsConfigurator srpCredConfig = new SRPCredentialsConfigurator();
        CHAPCredentialsConfigurator chapCredConfig = new CHAPCredentialsConfigurator();
        try {
            identConfig.discover(this.m_vSwitchData);
            identNameConfig.discover(this.m_vSwitchData);
            srpCredConfig.discover(this.m_vSwitchData);
            chapCredConfig.discover(this.m_vSwitchData);
        }
        catch (SrSnmpTimeoutException e) {
            LogMgr.getServerLog().error("Failed At identities discovery - " + e.getMessage());
            throw e;
        }
        catch (SrCommunicationException e) {
            LogMgr.getServerLog().debug("Failed At identities discovery", e);
        }
    }

    private void physStorAndVolumesDiscovery() throws SrCommunicationException {
        CommMgr commMgr = CommMgr.getInstance(this.m_agentIndex);
        this.m_volumesTable = commMgr.createTableRef("srVirtVolTable", this.m_agentIndex);
        VolumeConfigurator volConfig = new VolumeConfigurator();
        volConfig.removeNotReadyRows(this.m_volumesTable, this.m_vSwitchData);
        PhysicalStorageConfigurator physStorConfig = new PhysicalStorageConfigurator();
        physStorConfig.discover(this.m_vSwitchData);
        VolumeChildrenConfigurator volChildConfig = new VolumeChildrenConfigurator();
        this.m_parentChildVolumesData = volChildConfig.getAllForRebuild(this.m_agentIndex, null);
        this.m_stripVolumeTable = commMgr.createTableRef("srVirtVolSpecStrippedTable", this.m_agentIndex);
        this.m_snapshotVolumeTable = commMgr.createTableRef("srVirtVolSpecSnapshotTable", this.m_agentIndex);
        this.m_journalVolumeTable = commMgr.createTableRef("srVirtVolSpecJournalTable", this.m_agentIndex);
        commMgr.refreshTable(this.m_volumesTable);
        commMgr.refreshTable(this.m_stripVolumeTable);
        commMgr.refreshTable(this.m_snapshotVolumeTable);
        commMgr.refreshTable(this.m_journalVolumeTable);
        for (int i = 0; i < this.m_parentChildVolumesData.length; ++i) {
            if (this.m_parentChildVolumesData[i][0] == null) continue;
            this.createVolume((String)this.m_parentChildVolumesData[i][0], 1);
        }
        VolumeOperationConfigurator volOperConfig = new VolumeOperationConfigurator();
        volOperConfig.discover(this.m_vSwitchData);
        this.snapshotAndSourceDiscovery();
        this.journalDiscovery();
        this.transparentVolumesDiscovery(1);
        LUNConfigurator luConfig = new LUNConfigurator();
        luConfig.discover(this.m_vSwitchData);
        new SCSILunConfigurator().discover(this.m_vSwitchData);
    }

    private void snapshotAndSourceDiscovery() throws SrCommunicationException {
        Iterator itr = this.m_snapshotVolumes.iterator();
        while (itr.hasNext()) {
            CommKeyClassId source;
            String volumeId = (String)itr.next();
            SnapshotVolumeConfigurator snapshotConfig = (SnapshotVolumeConfigurator)DataMgr.getElementConfigFromClassID(ClassID.SNAPSHOT_VOLUME);
            ConfigElementData snapData = snapshotConfig.getTableRow(this.m_snapshotVolumeTable, new SnmpCommKey("1." + volumeId, this.m_agentIndex), this.m_vSwitchData);
            if (snapData == null) {
                SrEventHandler.getErrorMgr().sendConfigurationError("Misconfigured Snapshot Volume " + volumeId, this.m_vSwitchData);
            } else {
                LogMgr.getServerLog().debug("Update Snapshot Volume source to " + volumeId + this.m_vSwitchData);
                SrEventHandler.getEventMgr().sendChangeElementEvent(snapData);
            }
            if ((source = (CommKeyClassId)snapData.getValue(ParameterCode.SNAPSHOT_VOLUME_SOURCE)) == null) continue;
            DiscoverMgr.getInstance().addVolumeToInvolvedList(source, this.m_agentIndex);
        }
    }

    private void journalDiscovery() throws SrCommunicationException {
        Iterator itr = this.m_journalVolumes.iterator();
        while (itr.hasNext()) {
            String volumeId = (String)itr.next();
            JournalVolumeConfigurator journalConfig = (JournalVolumeConfigurator)DataMgr.getElementConfigFromClassID(ClassID.JOURNAL_VOLUME);
            ConfigElementData journalData = journalConfig.getTableRow(this.m_journalVolumeTable, new SnmpCommKey("1." + volumeId, this.m_agentIndex), this.m_vSwitchData);
            if (journalData == null) {
                SrEventHandler.getErrorMgr().sendConfigurationError("Misconfigured Journal Volume " + volumeId, this.m_vSwitchData);
                continue;
            }
            SrEventHandler.getEventMgr().sendChangeElementEvent(journalData);
        }
    }

    private void simpleVolumesDiscovery(int createContext) throws SrCommunicationException {
        if (this.m_simpleVolToPhysStorMap.size() == 0) {
            return;
        }
        Iterator volumeInxIterator = this.m_simpleVolToPhysStorMap.keySet().iterator();
        while (volumeInxIterator.hasNext()) {
            String volumeId = (String)volumeInxIterator.next();
            CommKeyClassId[] physStor = new CommKeyClassId[]{this.getPhysStorOfVolId(volumeId)};
            VolumeConfigurator volumeConfig = new VolumeConfigurator();
            ConfigElementData newVolume = volumeConfig.getTableRow(this.m_volumesTable, new SnmpCommKey(volumeId, this.m_agentIndex), this.m_vSwitchData);
            if (newVolume.getClassId().equals(ClassID.SIMPLE_VOLUME)) {
                CommKeyClassId volParent = (CommKeyClassId)newVolume.getValue(ParameterCode.VIRTUAL_VOLUME_PARENT);
                String parentIndex = volParent.getCommKeys()[0].getKey();
                String parentId = parentIndex.substring(parentIndex.indexOf(".") + 1);
                SrGauge luId = (SrGauge)newVolume.getValue(ParameterCode.VIRTUAL_VOLUME_LU_ID);
                BigInteger luIdVal = (BigInteger)luId.value();
                if (parentId.equals("0") && !this.isVolInvolvedInOtherOper(volumeId) && luIdVal.compareTo(BigInteger.ZERO) == 0) {
                    try {
                        volumeConfig.removeSimpleVolume(volumeId, this.getAgentIndex(), true);
                        volumeInxIterator.remove();
                    }
                    catch (Exception e) {
                        LogMgr.getServerLog().debug(e);
                    }
                    continue;
                }
                volumeConfig.sendSimpleVolumeDataInPhysStor(newVolume);
                continue;
            }
            if (newVolume.getClassId().equals(ClassID.TRANSPARENT_VOLUME)) continue;
            String message = "Physical Storage " + CommKeyUtil.getKeyForMessage(physStor[0].getCommKeys()) + " has a Volume (VolumeId = " + volumeId + ") of illegal type";
            throw new TypeMismatchException(message);
        }
    }

    private void transparentVolumesDiscovery(int createContext) throws SrCommunicationException {
        if (this.m_transVolToPhysStorMap.size() == 0) {
            return;
        }
        Iterator volInxIterator = this.m_transVolToPhysStorMap.keySet().iterator();
        while (volInxIterator.hasNext()) {
            String volumeId = (String)volInxIterator.next();
            CommKeyClassId[] physStor = new CommKeyClassId[]{(CommKeyClassId)this.m_transVolToPhysStorMap.get(volumeId)};
            VolumeConfigurator volumeConfig = new VolumeConfigurator();
            ConfigElementData newVolume = volumeConfig.getTableRow(this.m_volumesTable, new SnmpCommKey(volumeId, this.m_agentIndex), this.m_vSwitchData);
            if (newVolume.getClassId().equals(ClassID.TRANSPARENT_VOLUME)) {
                this.sendTransparentVolumeDataInPhysStor(newVolume);
                LogMgr.getServerLog().debug("Discover: " + newVolume.getClassId().toString() + " CommKey is:" + CommKeyUtil.getKeyForMessage(newVolume.getCommKey()));
                switch (createContext) {
                    case 1: {
                        SrEventHandler.getEventMgr().sendAddElementEvent(newVolume);
                        break;
                    }
                    case 2: {
                        SrEventHandler.getEventMgr().sendRefreshElementEvent(newVolume);
                    }
                }
                continue;
            }
            if (newVolume.getClassId().equals(ClassID.SIMPLE_VOLUME)) continue;
            String message = "Physical Storage " + CommKeyUtil.getKeyForMessage(physStor[0].getCommKeys()) + " has a Volume (VolumeId = " + volumeId + ") of illegal type";
            throw new TypeMismatchException(message);
        }
    }

    private void luAndTargetDiscovery() throws SrCommunicationException {
        IscsiTargetConfigurator tgtConfig = new IscsiTargetConfigurator();
        tgtConfig.discover(this.m_vSwitchData);
    }

    private void disasterRecoveryDiscovery() throws SrCommunicationException {
        new DRDiscoveryConfigurator().discover(this.m_vSwitchData);
    }

    private void luAndTargetRebuild() throws SrCommunicationException {
        IscsiTargetConfigurator tgtConfig = new IscsiTargetConfigurator();
        tgtConfig.refreshAll(this.m_vSwitchData);
        LUNConfigurator luConfig = new LUNConfigurator();
        luConfig.refreshAll(this.m_vSwitchData);
    }

    private CommKeyClassId createVolume(String volumeId, int createContext) throws SrCommunicationException {
        int i;
        VolumeConfigurator volumeConfig = new VolumeConfigurator();
        ConfigElementData newVolume = volumeConfig.getTableRow(this.m_volumesTable, new SnmpCommKey("1." + volumeId, this.m_agentIndex), this.m_vSwitchData);
        if (newVolume == null) {
            SrEventHandler.getErrorMgr().sendFatalConfigurationError("Misconfigured volume", this.m_vSwitchData);
            StringBuffer msg = new StringBuffer("Missing data for volume 1.");
            msg.append(volumeId);
            msg.append(" agent ");
            msg.append(CommKeyUtil.getDbCommKey(this.m_vSwitchData.getCommKeys()).getKey());
            LogMgr.getServerLog().fatal(msg.toString());
            throw new ConfigurationErrorException(msg.toString());
        }
        if (newVolume.getClassId().equals(ClassID.SIMPLE_VOLUME)) {
            return null;
        }
        this.removeVolumeFromInvolvedList(volumeId);
        if (newVolume.getClassId().equals(ClassID.STRIPE_VOLUME)) {
            ConfigElementData stripData = null;
            stripData = volumeConfig.getTableRow(this.m_stripVolumeTable, new SnmpCommKey("1." + volumeId, this.m_agentIndex), this.m_vSwitchData);
            if (stripData == null) {
                SrEventHandler.getErrorMgr().sendConfigurationError("Misconfigured Stripe Volume " + newVolume.getValue(ParameterCode.VOLUME_ALIAS), this.m_vSwitchData);
            } else {
                newVolume.addParameter(stripData.getParametersList());
            }
        } else if (newVolume.getClassId().equals(ClassID.SNAPSHOT_VOLUME)) {
            this.m_snapshotVolumes.add(volumeId);
        } else if (newVolume.getClassId().equals(ClassID.JOURNAL_VOLUME)) {
            this.m_journalVolumes.add(volumeId);
        }
        Vector<CommKeyClassId> childrenVector = new Vector<CommKeyClassId>();
        for (i = 0; !(i >= this.m_parentChildVolumesData.length || this.m_parentChildVolumesData[i][0] != null && this.m_parentChildVolumesData[i][0].equals(volumeId)); ++i) {
        }
        while (i < this.m_parentChildVolumesData.length && this.m_parentChildVolumesData[i][0] != null && this.m_parentChildVolumesData[i][0].equals(volumeId)) {
            String childId = (String)this.m_parentChildVolumesData[i][1];
            CommKeyClassId childData = this.createVolume(childId, createContext);
            if (childData == null && (childData = (CommKeyClassId)this.m_simpleVolToPhysStorMap.get("1." + childId)) == null) {
                SrEventHandler.getErrorMgr().sendFatalConfigurationError("Misconfigured volume", this.m_vSwitchData);
                StringBuffer msg = new StringBuffer("Have a Simple Volume with no PhysStor point on it. Volume ID: 1.");
                msg.append(childId);
                LogMgr.getServerLog().fatal(msg.toString());
                throw new MissingValueException(msg.toString());
            }
            childrenVector.add(childData);
            this.updateChildPosition(childData, (SrInteger)this.m_parentChildVolumesData[i][2]);
            this.m_parentChildVolumesData[i][1] = null;
            this.m_parentChildVolumesData[i][0] = null;
            ++i;
        }
        CommKeyClassId myData = new CommKeyClassId(newVolume.getCommKey(), newVolume.getClassId());
        if (childrenVector.size() == 0) {
            return myData;
        }
        CommKeyClassId[] childrenData = new CommKeyClassId[childrenVector.size()];
        for (int j = 0; j < childrenVector.size(); ++j) {
            childrenData[j] = (CommKeyClassId)childrenVector.elementAt(j);
        }
        newVolume.addParameter(new Parameter(ParameterCode.VOLUME_CHILDREN, childrenData));
        StringBuffer msg = new StringBuffer("Discover: ");
        msg.append(newVolume.getClassId().toString());
        msg.append(" CommKey is: ");
        msg.append(CommKeyUtil.getKeyForMessage(newVolume.getCommKey()));
        LogMgr.getServerLog().debug(msg.toString());
        newVolume.addParameter(new Parameter(ParameterCode.VSWITCH_ID, this.m_vSwitchData));
        newVolume.removeParameter(ParameterCode.VIRTUAL_VOLUME_PARENT);
        switch (createContext) {
            case 1: {
                SrEventHandler.getEventMgr().sendAddElementEvent(newVolume);
                break;
            }
            case 2: {
                SrEventHandler.getEventMgr().sendRefreshElementEvent(newVolume);
            }
        }
        return myData;
    }

    public void vSwitchDiscovery() {
        try {
            DiscoveryThread vSwitchDiscoveryThread = new DiscoveryThread("VSwitch Discovery ", ThreadType.VSWITCH_DISCOVER_THREAD_TYPE){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run() {
                    ThreadMgr.getInstance().getAgentThreadMgr(AbstractVSwitchDiscoveryMgr.this.m_agentIndex).manageVSwitchDiscoveryThread();
                    VSwitchConfigurator vSwitchConfig = new VSwitchConfigurator();
                    HardwareConfigurator hardwareConfig = new HardwareConfigurator();
                    StatisticConfigurator statisticConfig = new StatisticConfigurator();
                    IfStatisticConfigurator ifStatConfig = new IfStatisticConfigurator();
                    TcpConnectionConfigurator tcpConConfig = new TcpConnectionConfigurator();
                    UDPListenerConfigurator udpConConfig = new UDPListenerConfigurator();
                    NetConfigConfigurator ipConfig = new NetConfigConfigurator();
                    IfConfigurator ifConfig = new IfConfigurator();
                    IscsiPortalConfigurator portalConfig = new IscsiPortalConfigurator();
                    IpRouteConfigurator ipRouteConfig = new IpRouteConfigurator();
                    SnmpTargetAddressConfigurator tgtAddressConfig = new SnmpTargetAddressConfigurator();
                    SnmpManagerConfigurator mngConfig = new SnmpManagerConfigurator();
                    RadiusServerConfigurator radiusServerConfig = new RadiusServerConfigurator();
                    ISNSServerConfigurator isnsServerConfig = new ISNSServerConfigurator();
                    FCNodeConfigurator fcNodeConfigurator = new FCNodeConfigurator();
                    try {
                        try {
                            vSwitchConfig.discover(AbstractVSwitchDiscoveryMgr.this.m_vSwitchData);
                            ifConfig.discover(AbstractVSwitchDiscoveryMgr.this.m_vSwitchData);
                            ipConfig.discover(AbstractVSwitchDiscoveryMgr.this.m_vSwitchData);
                            ipRouteConfig.discover(AbstractVSwitchDiscoveryMgr.this.m_vSwitchData);
                            portalConfig.discover(AbstractVSwitchDiscoveryMgr.this.m_vSwitchData);
                            tgtAddressConfig.discover(AbstractVSwitchDiscoveryMgr.this.m_vSwitchData);
                            mngConfig.discover(AbstractVSwitchDiscoveryMgr.this.m_vSwitchData);
                            radiusServerConfig.discover(AbstractVSwitchDiscoveryMgr.this.m_vSwitchData);
                            isnsServerConfig.discover(AbstractVSwitchDiscoveryMgr.this.m_vSwitchData);
                            fcNodeConfigurator.discover(AbstractVSwitchDiscoveryMgr.this.m_vSwitchData);
                            hardwareConfig.discover(AbstractVSwitchDiscoveryMgr.this.m_vSwitchData);
                            statisticConfig.discover(AbstractVSwitchDiscoveryMgr.this.m_vSwitchData, ClassID.STATISTIC_IP);
                            statisticConfig.discover(AbstractVSwitchDiscoveryMgr.this.m_vSwitchData, ClassID.STATISTIC_ICMP);
                            statisticConfig.discover(AbstractVSwitchDiscoveryMgr.this.m_vSwitchData, ClassID.STATISTIC_TCP);
                            statisticConfig.discover(AbstractVSwitchDiscoveryMgr.this.m_vSwitchData, ClassID.STATISTIC_UDP);
                            ifStatConfig.discover(AbstractVSwitchDiscoveryMgr.this.m_vSwitchData);
                            tcpConConfig.discover(AbstractVSwitchDiscoveryMgr.this.m_vSwitchData);
                            udpConConfig.discover(AbstractVSwitchDiscoveryMgr.this.m_vSwitchData);
                            if (!AbstractVSwitchDiscoveryMgr.this.m_sessionDiscoveryActivated) {
                                AbstractVSwitchDiscoveryMgr.this.setSessionDiscoveryActivated(true);
                            } else {
                                AbstractVSwitchDiscoveryMgr.this.sessionDiscovery();
                            }
                        }
                        catch (SrSnmpTimeoutException e) {
                            LogMgr.getServerLog().error("Snmp timeout - Discovery for: " + ClassID.VSWITCH + " " + this.myIp);
                            SnmpErrorEvent event = new SnmpErrorEvent((Object)this, "SNMP Timeout during " + ClassID.VSWITCH + " " + this.myIp + " discovery", CommKeyUtil.getVSwitchData(AbstractVSwitchDiscoveryMgr.this.m_agentIndex), 1);
                            SrEventHandler.getSnmpErrorMgr().sendSnmpTimeOutEvent(event);
                            Object var19_17 = null;
                            LogMgr.getServerLog().debug(ClassID.VSWITCH + " discovery completed for " + this.myIp);
                            SrEventHandler.getEventMgr().sendEndOfvSwitchDiscovery(AbstractVSwitchDiscoveryMgr.this.m_vSwitchData);
                            try {
                                ThreadMgr.getInstance().getAgentThreadMgr(AbstractVSwitchDiscoveryMgr.this.m_agentIndex).vSwitchDiscoveryThreadDoneProcess();
                                return;
                            }
                            catch (NullPointerException e2) {
                                System.out.println(" vswitch is null, OK if you remove the cluster");
                                LogMgr.getServerLog().debug(e2);
                                return;
                            }
                        }
                        catch (SrCommunicationException e) {
                            LogMgr.getServerLog().debug("Failed At " + ClassID.VSWITCH + " Discovery For: " + this.myIp, e);
                            Object var19_18 = null;
                            LogMgr.getServerLog().debug(ClassID.VSWITCH + " discovery completed for " + this.myIp);
                            SrEventHandler.getEventMgr().sendEndOfvSwitchDiscovery(AbstractVSwitchDiscoveryMgr.this.m_vSwitchData);
                            try {}
                            catch (NullPointerException e2) {
                                System.out.println(" vswitch is null, OK if you remove the cluster");
                                LogMgr.getServerLog().debug(e2);
                                return;
                            }
                            ThreadMgr.getInstance().getAgentThreadMgr(AbstractVSwitchDiscoveryMgr.this.m_agentIndex).vSwitchDiscoveryThreadDoneProcess();
                            return;
                        }
                        Object var19_16 = null;
                        LogMgr.getServerLog().debug(ClassID.VSWITCH + " discovery completed for " + this.myIp);
                        SrEventHandler.getEventMgr().sendEndOfvSwitchDiscovery(AbstractVSwitchDiscoveryMgr.this.m_vSwitchData);
                    }
                    catch (Throwable throwable) {
                        Object var19_19 = null;
                        LogMgr.getServerLog().debug(ClassID.VSWITCH + " discovery completed for " + this.myIp);
                        SrEventHandler.getEventMgr().sendEndOfvSwitchDiscovery(AbstractVSwitchDiscoveryMgr.this.m_vSwitchData);
                        try {}
                        catch (NullPointerException e2) {
                            System.out.println(" vswitch is null, OK if you remove the cluster");
                            LogMgr.getServerLog().debug(e2);
                            return;
                        }
                        ThreadMgr.getInstance().getAgentThreadMgr(AbstractVSwitchDiscoveryMgr.this.m_agentIndex).vSwitchDiscoveryThreadDoneProcess();
                        throw throwable;
                    }
                    try {}
                    catch (NullPointerException e2) {
                        System.out.println(" vswitch is null, OK if you remove the cluster");
                        LogMgr.getServerLog().debug(e2);
                        return;
                    }
                    ThreadMgr.getInstance().getAgentThreadMgr(AbstractVSwitchDiscoveryMgr.this.m_agentIndex).vSwitchDiscoveryThreadDoneProcess();
                }
            };
            vSwitchDiscoveryThread.start();
        }
        catch (SrThreadCreationException e) {
            LogMgr.getServerLog().error(e);
        }
    }

    private void policyDiscovery() throws SrSnmpTimeoutException {
        TargetAuthorizationConfigurator targetAuthConfig = new TargetAuthorizationConfigurator();
        try {
            targetAuthConfig.discover(this.m_vSwitchData);
        }
        catch (SrSnmpTimeoutException e) {
            LogMgr.getServerLog().error("Failed At Policy Discovery - " + e.getMessage());
            throw e;
        }
        catch (SrCommunicationException e) {
            LogMgr.getServerLog().debug("Failed At Policy Discovery ", e);
        }
    }

    private void sendSimpleVolumeDataInPhysStor(ConfigElementData simpleVol) throws SrCommunicationException {
        String volIndex = simpleVol.getSnmpKey().getKey();
        CommKeyClassId physStorData = (CommKeyClassId)this.m_simpleVolToPhysStorMap.get(volIndex);
        ConfigElementData physStor = new ConfigElementData(physStorData.getCommKeys(), physStorData.getClassID());
        physStor.setValue(ParameterCode.VOLUME_STATE, (SrType)simpleVol.getValue(ParameterCode.VOLUME_STATE));
        physStor.setValue(ParameterCode.VSWITCH_ID, (SrType)simpleVol.getValue(ParameterCode.VSWITCH_ID));
        physStor.setValue(ParameterCode.VIRTUAL_VOLUME_PARENT, (SrType)simpleVol.getValue(ParameterCode.VIRTUAL_VOLUME_PARENT));
        LogMgr.getServerLog().debug("Update Simple Volume State in PhysStor. Vol: " + volIndex + physStorData);
        SrEventHandler.getEventMgr().sendChangeElementEvent(physStor);
    }

    private void sendTransparentVolumeDataInPhysStor(ConfigElementData transVol) throws SrCommunicationException {
        String volIndex = transVol.getSnmpKey().getKey();
        CommKeyClassId physStorData = (CommKeyClassId)this.m_transVolToPhysStorMap.get(volIndex);
        CommKeyClassId transVolCommKeyClassId = new CommKeyClassId(transVol.getCommKey(), transVol.getClassId());
        ConfigElementData physStor = new ConfigElementData(physStorData.getCommKeys(), physStorData.getClassID());
        physStor.setValue(ParameterCode.VSWITCH_ID, (SrType)transVol.getValue(ParameterCode.VSWITCH_ID));
        physStor.setValue(ParameterCode.VIRTUAL_VOLUME_PARENT, transVolCommKeyClassId);
        LogMgr.getServerLog().debug("Update Transparent Volume ID in PhysStor. Vol: " + volIndex + physStorData);
        SrEventHandler.getEventMgr().sendChangeElementEvent(physStor);
    }

    public ConfigElementData getOneVolumeData(String volumeId) throws SrCommunicationException {
        VolumeConfigurator volumeConfig = new VolumeConfigurator();
        CommMgr.getInstance(this.m_agentIndex).refreshTable(this.m_volumesTable);
        return volumeConfig.getTableRow(this.m_volumesTable, new SnmpCommKey("1." + volumeId, this.m_agentIndex), this.m_vSwitchData);
    }

    private void updateChildPosition(CommKeyClassId childData, SrInteger position) {
        ConfigElementData childElement = new ConfigElementData(childData.getCommKeys(), childData.getClassID());
        childElement.setValue(ParameterCode.VOLUME_POSITION, position);
        childElement.setValue(ParameterCode.VSWITCH_ID, this.m_vSwitchData);
        SrEventHandler.getEventMgr().sendChangeElementEvent(childElement);
    }

    public synchronized void addEntryToLUIdPhysStorMap(CommKeyClassId physStorCommKey, CommKeyClassId luId) {
        try {
            Vector<CommKeyClassId> currentLUIds = this.getEntryFromLUIdPhysStorMap(physStorCommKey);
            if (currentLUIds == null) {
                currentLUIds = new Vector<CommKeyClassId>();
            }
            if (!currentLUIds.contains(luId)) {
                currentLUIds.addElement(luId);
            }
            this.m_physStorToLUIdMap.put(physStorCommKey, currentLUIds);
        }
        catch (Exception e) {
            LogMgr.getServerLog().error("LU ID Discovery Error at Agent" + this.m_agentIndex, e);
        }
    }

    public synchronized Vector getEntryFromLUIdPhysStorMap(CommKeyClassId physStorCommKey) {
        Vector result = (Vector)this.m_physStorToLUIdMap.get(physStorCommKey);
        return result;
    }

    public synchronized void clearLUIdPhysStorMap(CommKeyClassId physStorCommKey) {
        if (this.m_physStorToLUIdMap.remove(physStorCommKey) != null) {
            LogMgr.getServerLog().debug("Remove " + physStorCommKey + " from physStorToLUIdMap");
        } else {
            LogMgr.getServerLog().debug("No entry for " + physStorCommKey + " in physStorToLUIdMap when trying to remove");
        }
    }

    private void physStorAndVolumesRebuild() throws SrCommunicationException {
        CommMgr commMgr = CommMgr.getInstance(this.m_agentIndex);
        this.m_volumesTable = commMgr.createTableRef("srVirtVolTable", this.m_agentIndex);
        VolumeConfigurator volConfig = new VolumeConfigurator();
        volConfig.removeNotReadyRows(this.m_volumesTable, this.m_vSwitchData);
        PhysicalStorageConfigurator physStorConfig = new PhysicalStorageConfigurator();
        physStorConfig.refreshAll(this.m_vSwitchData);
        VolumeChildrenConfigurator volChildConfig = new VolumeChildrenConfigurator();
        this.m_parentChildVolumesData = volChildConfig.getAllForRebuild(this.m_agentIndex, null);
        this.m_stripVolumeTable = commMgr.createTableRef("srVirtVolSpecStrippedTable", this.m_agentIndex);
        this.m_snapshotVolumeTable = commMgr.createTableRef("srVirtVolSpecSnapshotTable", this.m_agentIndex);
        commMgr.refreshTable(this.m_volumesTable);
        commMgr.refreshTable(this.m_stripVolumeTable);
        commMgr.refreshTable(this.m_snapshotVolumeTable);
        for (int i = 0; i < this.m_parentChildVolumesData.length; ++i) {
            if (this.m_parentChildVolumesData[i][0] == null) continue;
            this.createVolume((String)this.m_parentChildVolumesData[i][0], 2);
        }
        VolumeOperationConfigurator volOperConfig = new VolumeOperationConfigurator();
        volOperConfig.refreshAll(this.m_vSwitchData);
        this.snapshotAndSourceDiscovery();
        this.transparentVolumesDiscovery(2);
        this.simpleVolumesDiscovery(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void virtualizationRebuild() {
        this.clearStructures();
        try {
            try {
                this.physStorAndVolumesRebuild();
                this.luAndTargetRebuild();
            }
            catch (SrCommunicationException e) {
                LogMgr.getServerLog().debug(e);
                Object var3_2 = null;
                LogMgr.getServerLog().debug("Virtualization Rebuild completed for " + this.m_vSwitchData.getCommKeys()[0].getKey());
                return;
            }
            catch (ConfigurationErrorException e) {
                LogMgr.getServerLog().debug("Virtualization Rebuild Error at: " + this.m_vSwitchData.getCommKeys()[0].getKey());
                LogMgr.getServerLog().debug(e);
                Object var3_3 = null;
                LogMgr.getServerLog().debug("Virtualization Rebuild completed for " + this.m_vSwitchData.getCommKeys()[0].getKey());
                return;
            }
            Object var3_1 = null;
            LogMgr.getServerLog().debug("Virtualization Rebuild completed for " + this.m_vSwitchData.getCommKeys()[0].getKey());
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            LogMgr.getServerLog().debug("Virtualization Rebuild completed for " + this.m_vSwitchData.getCommKeys()[0].getKey());
            throw throwable;
        }
    }

    private class DiscoveryThread
    extends SrThread {
        CommKeyClassId vSwitchData;
        String myIp;

        DiscoveryThread(String name, ThreadType type) throws SrThreadCreationException {
            super(type);
            if (type.equals(ThreadType.VSWITCH_DISCOVER_THREAD_TYPE)) {
                ThreadMgr.getInstance().getAgentThreadMgr(AbstractVSwitchDiscoveryMgr.this.m_agentIndex).createVSwitchDiscoveryThreadPossible();
            } else if (type.equals(ThreadType.VSWITCH_VIRT_VOL_DISCOVER_THREAD_TYPE)) {
                ThreadMgr.getInstance().getAgentThreadMgr(AbstractVSwitchDiscoveryMgr.this.m_agentIndex).createVSwitchVirtVolDiscoveryThreadPossible();
            }
            this.vSwitchData = AbstractVSwitchDiscoveryMgr.this.m_vSwitchData;
            this.myIp = AbstractVSwitchDiscoveryMgr.this.m_vSwitchData.getCommKeys()[0].getKey();
            super.setName(name + this.myIp);
        }
    }
}

