/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr;

import com.sanrad.log.LogMgr;
import com.sanrad.nms.server.comm.CommItem;
import com.sanrad.nms.server.comm.CommMgr;
import com.sanrad.nms.server.comm.CommVarBindList;
import com.sanrad.nms.server.comm.database.exception.SrDatabaseException;
import com.sanrad.nms.server.comm.exception.SrCommunicationException;
import com.sanrad.nms.server.comm.snmp.MibItem;
import com.sanrad.nms.server.comm.snmp.SrOid;
import com.sanrad.nms.server.comm.snmp.SrSnmpVarBind;
import com.sanrad.nms.server.comm.snmp.exception.SnmpInitializationException;
import com.sanrad.nms.server.comm.snmp.exception.SrSnmpTimeoutException;
import com.sanrad.nms.server.comm.snmp.exception.SrSnmpTrapPortIsBusyException;
import com.sanrad.nms.server.comm.snmp.trap.SrTrap;
import com.sanrad.nms.server.event.SrCreateElementErrorEvent;
import com.sanrad.nms.server.event.SrEventHandler;
import com.sanrad.nms.server.exception.InitializationException;
import com.sanrad.nms.server.exception.MissingValueException;
import com.sanrad.nms.server.exception.SrElementOperationErrorException;
import com.sanrad.nms.server.exception.SrElementOperationException;
import com.sanrad.nms.server.mgr.CheckListConfigElementData;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.ConfigElementDataList;
import com.sanrad.nms.server.mgr.DataMgr;
import com.sanrad.nms.server.mgr.ElementConfigurator;
import com.sanrad.nms.server.mgr.StorageDomainConfigurator;
import com.sanrad.nms.server.mgr.discover.DiscoverMgr;
import com.sanrad.nms.server.mgr.polling.PollingMgr;
import com.sanrad.nms.server.mgr.threads.ThreadMgr;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKey;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.CommKeyUtil;
import com.sanrad.nms.server.util.DataBaseCommKey;
import com.sanrad.nms.server.util.Parameter;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.SnmpCommKey;
import com.sanrad.nms.server.util.types.SrBoolean;
import com.sanrad.nms.server.util.types.SrDateAndTime;
import com.sanrad.nms.server.util.types.SrInteger;
import com.sanrad.nms.server.util.types.SrIpAddress;
import com.sanrad.nms.server.util.types.SrOidType;
import com.sanrad.nms.server.util.types.SrTAddress;
import com.sanrad.nms.server.util.types.SrTimeTicks;
import com.sanrad.nms.server.util.types.constants.TempetureUnitConstant;
import com.sanrad.nms.server.util.types.constants.VSwitchSysOID;
import com.sanrad.util.BooleanLock;
import java.util.HashMap;

public class VSwitchConfigurator
extends ElementConfigurator {
    private static String storDomainKey = "1";
    private BooleanLock locker = new BooleanLock();

    public VSwitchConfigurator() {
        super(ClassID.VSWITCH, "", null, null);
        this.locker.setLock(true);
    }

    public void internalCreate(ConfigElementData element) throws SrCommunicationException, MissingValueException, SrElementOperationException {
        SrIpAddress ip = (SrIpAddress)element.getValue(ParameterCode.VSWITCH_IP_ADDRESS);
        DataBaseCommKey dbKey = new DataBaseCommKey(ip.toString());
        CommKey[] key = new CommKey[]{dbKey};
        element.setCommKeys(key);
        CommVarBindList varBindList = new CommVarBindList();
        this.convertParamsToVarBinds(element, varBindList);
        char newVSwitchSnmpAgentIndex = 'd';
        ParameterCode[] errorParam = null;
        try {
            CommMgr.addSnmpAgent(varBindList);
        }
        catch (SnmpInitializationException e) {
            logger.debug(e);
            throw new SrCommunicationException("Failed to add new vSwitch");
        }
        catch (SrSnmpTrapPortIsBusyException e) {
            logger.debug(e);
            errorParam = new ParameterCode[]{ParameterCode.VSWITCH_TRAP_UDP_PORT};
        }
        newVSwitchSnmpAgentIndex = varBindList.getSnmpAgentIndex();
        SnmpCommKey snmpKey = new SnmpCommKey("0", newVSwitchSnmpAgentIndex);
        CommKey[] newKeys = new CommKey[]{dbKey, snmpKey};
        element.setCommKeys(newKeys);
        CommKeyClassId vSwitchId = new CommKeyClassId(newKeys, ClassID.VSWITCH);
        element.addParameter(new Parameter(ParameterCode.VSWITCH_ID, vSwitchId));
        try {
            ThreadMgr.getInstance().addAgentThreadMgr(element.getSnmpAgentFromParameter());
            DiscoverMgr.getInstance().addDiscoverMgr(vSwitchId);
            CommKeyUtil.addVSwitch(vSwitchId);
            PollingMgr.getInstance().addAgent(element);
        }
        catch (InitializationException e) {
            logger.debug(e);
            throw new SrCommunicationException("Failed to add new vSwitch");
        }
        if (errorParam != null) {
            throw new SrElementOperationErrorException(this, element, errorParam);
        }
    }

    public void internalRemove(ConfigElementData element) throws SrCommunicationException {
        if (ThreadMgr.getInstance().isVswitchBusy(element.getCommKeyClassId())) {
            ThreadMgr.getInstance().addVswitchBusyNotifier(element.getCommKeyClassId(), this);
            this.locker.lock();
            this.locker.waitForLockToRelease();
        }
        char snmpAgentIndex = element.getMyFirstSnmpAgentIndex();
        CommMgr.getInstance(snmpAgentIndex).removeSnmpAgent(snmpAgentIndex);
        DiscoverMgr.getInstance().removeDiscoverMgr(snmpAgentIndex);
        CommKeyUtil.removeVSwitch(snmpAgentIndex);
        PollingMgr.getInstance().removeAgent(element);
    }

    public ConfigElementDataList getAll() throws SrCommunicationException {
        return this.getAll(null, null, null);
    }

    public ConfigElementDataList getAll(Integer clusterId, SrTimeTicks lastUpdate, CheckListConfigElementData checkListElement) throws SrCommunicationException {
        HashMap trapPortErrorData = new HashMap(0);
        ConfigElementDataList allvSwitches = new ConfigElementDataList();
        VSwitchDataContainer dataContainer = new VSwitchDataContainer();
        try {
            if (clusterId == null) {
                CommMgr.getAllvSwitchesData(dataContainer);
            } else {
                CommMgr.getAllvSwitchesData(clusterId, dataContainer);
            }
        }
        catch (SrDatabaseException e) {
            logger.debug(e);
            return allvSwitches;
        }
        catch (SrSnmpTrapPortIsBusyException e) {
            logger.debug(e);
            trapPortErrorData = e.getErrorData();
        }
        CommVarBindList[] vSwitchesTable = dataContainer.getVSwitchesData();
        if (vSwitchesTable == null || vSwitchesTable.length == 0) {
            return allvSwitches;
        }
        int numOfRows = vSwitchesTable.length;
        for (int i = 0; i < numOfRows; ++i) {
            if (vSwitchesTable[i] == null) continue;
            ConfigElementData element = this.createConfigElementFromTableRow(vSwitchesTable[i]);
            SrIpAddress ip = (SrIpAddress)element.getValue(ParameterCode.VSWITCH_IP_ADDRESS);
            if (ip == null) {
                throw new MissingValueException("Missing IP for the new vSwitch");
            }
            ThreadMgr.getInstance().addAgentThreadMgr(vSwitchesTable[i].getSnmpAgentIndex());
            DataBaseCommKey dbKey = new DataBaseCommKey(ip.toString());
            SnmpCommKey snmpKey = new SnmpCommKey("0", vSwitchesTable[i].getSnmpAgentIndex());
            CommKey[] allKeys = new CommKey[]{dbKey, snmpKey};
            element.setCommKeys(allKeys);
            CommKeyClassId vSwitchId = new CommKeyClassId(allKeys, ClassID.VSWITCH);
            element.addParameter(new Parameter(ParameterCode.VSWITCH_ID, vSwitchId));
            if (trapPortErrorData.containsKey(ip)) {
                ParameterCode[] errorParam = new ParameterCode[]{ParameterCode.VSWITCH_TRAP_UDP_PORT};
                SrCreateElementErrorEvent errorInCreateEvent = new SrCreateElementErrorEvent((Object)this, element, errorParam);
                SrEventHandler.getEventMgr().sendElementOperationEvent(errorInCreateEvent);
            } else {
                SrEventHandler.getEventMgr().sendAddElementEvent(element);
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.changeElementUDPTrapPort(element);
            allvSwitches.add(element);
        }
        return allvSwitches;
    }

    public HashMap getListOfParams() {
        HashMap<ParameterCode, Object> paramList = new HashMap<ParameterCode, Object>(20);
        paramList.put(ParameterCode.VSWITCH_IP_MASK, null);
        paramList.put(ParameterCode.VSWITCH_MAX_RETRIES, null);
        paramList.put(ParameterCode.VSWITCH_READ_COMMUNITY, null);
        paramList.put(ParameterCode.VSWITCH_SNMP_UDP_PORT, null);
        paramList.put(ParameterCode.VSWITCH_SNMP_VERSION, null);
        paramList.put(ParameterCode.VSWITCH_TIMEOUT, null);
        paramList.put(ParameterCode.VSWITCH_TRAP_UDP_PORT, null);
        paramList.put(ParameterCode.VSWITCH_CONTACT, null);
        paramList.put(ParameterCode.VSWITCH_DATE_AND_TIME, null);
        paramList.put(ParameterCode.VSWITCH_DESCRIPTION, null);
        paramList.put(ParameterCode.VSWITCH_LAST_RESET, null);
        paramList.put(ParameterCode.VSWITCH_LOCATION, null);
        paramList.put(ParameterCode.VSWITCH_NAME, null);
        paramList.put(ParameterCode.VSWITCH_TELNET_PORT, null);
        paramList.put(ParameterCode.VSWITCH_TADDRESS, null);
        paramList.put(ParameterCode.VSWITCH_SYS_OID, null);
        paramList.put(ParameterCode.TEMPERATURE_UNITS, null);
        return paramList;
    }

    protected void addCommVarBindsToReadList(CommVarBindList list, ConfigElementData element) {
        super.addCommVarBindsToReadList(list, element);
        if (element.containParameter(ParameterCode.VSWITCH_LAST_RESET) || element.containParameter(ParameterCode.VSWITCH_LAST_KEEPALIVE) || element.containParameter(ParameterCode.VSWITCH_DATE_AND_TIME)) {
            SnmpCommKey snmpKey = element.getSnmpKey();
            SrOid sysUpTime = new SrOid(MibItem.VSWITCH_SYS_UP_TIME.toString(), snmpKey.toString());
            list.add(new SrSnmpVarBind(sysUpTime, null));
            SrOid datAndTime = new SrOid(MibItem.VSWITCH_DATE_AND_TIME.toString(), snmpKey.toString());
            list.add(new SrSnmpVarBind(datAndTime, null));
        }
    }

    protected void readDiscoverPostOperation(ConfigElementData element, CommVarBindList list) throws SrCommunicationException {
        SrOidType vSwitchSysOID;
        SrTAddress tAddress = (SrTAddress)element.getValue(ParameterCode.VSWITCH_TADDRESS);
        if (tAddress != null) {
            SrIpAddress ip = tAddress.getIp();
            element.setValue(ParameterCode.VSWITCH_MGM_IP_ADDRESS, ip);
            element.removeParameter(ParameterCode.VSWITCH_TADDRESS);
        }
        if ((vSwitchSysOID = (SrOidType)element.getValue(ParameterCode.VSWITCH_SYS_OID)) != null) {
            VSwitchSysOID vSwitchType = VSwitchSysOID.fromOidToConst(vSwitchSysOID);
            element.setValue(ParameterCode.VSWITCH_SYS_OID, vSwitchType);
        }
        SrDateAndTime currentTime = (SrDateAndTime)element.getValue(ParameterCode.VSWITCH_DATE_AND_TIME);
        SrTimeTicks sysUpTime = (SrTimeTicks)this.getVarBindValueFromList(list, MibItem.VSWITCH_SYS_UP_TIME);
        SrDateAndTime time = this.getLastReset(currentTime, sysUpTime);
        element.addParameter(new Parameter(ParameterCode.VSWITCH_LAST_RESET, time));
        SrInteger tempUnitInteger = (SrInteger)element.getValue(ParameterCode.TEMPERATURE_UNITS);
        if (tempUnitInteger != null) {
            TempetureUnitConstant tempUnit = TempetureUnitConstant.getTempUnitStat(tempUnitInteger.intValue());
            element.setValue(ParameterCode.TEMPERATURE_UNITS, tempUnit);
        }
    }

    public void discover(CommKeyClassId vSwitchData) throws SrCommunicationException {
        ConfigElementData vSwitch = new ConfigElementData(vSwitchData.getCommKeys(), vSwitchData.getClassID());
        vSwitch.addParameter(new Parameter(ParameterCode.VSWITCH_ID, vSwitchData));
        try {
            this.internalRead(vSwitch);
        }
        catch (SrSnmpTimeoutException e) {
            logger.error(e.getMessage());
            throw e;
        }
        catch (SrCommunicationException e) {
            LogMgr.getServerLog().warning("Failed to Read data of " + vSwitch.getClassId().toString() + " CommKey is: " + CommKeyUtil.getKeyForMessage(vSwitch.getCommKey()), e);
            throw e;
        }
        SrEventHandler.getEventMgr().sendChangeElementEvent(vSwitch);
    }

    public void internalChange(ConfigElementData element) throws SrCommunicationException, SrElementOperationException {
        StorageDomainConfigurator storDomainConfig = new StorageDomainConfigurator();
        HashMap storDoaminParams = storDomainConfig.getListOfParams();
        this.splitParameterListOfDifferentElement(element, storDoaminParams);
        if (storDoaminParams.size() > 0) {
            SnmpCommKey storDomainCommKey = new SnmpCommKey(storDomainKey, element.getMyFirstSnmpAgentIndex());
            ConfigElementData storDomainElement = new ConfigElementData(storDomainCommKey, ClassID.STORAGE_DOMAIN, storDoaminParams);
            DataMgr.getInstance().changeElement(storDomainElement);
        }
        CommVarBindList varBindList = new CommVarBindList();
        this.convertParamsToVarBinds(element, varBindList);
        this.addCommVarBindsToChangeList(varBindList, element);
        try {
            CommMgr.getInstance(element.getMyFirstSnmpAgentIndex()).setSnmpList(varBindList, element.getMyFirstSnmpAgentIndex());
        }
        catch (SrSnmpTimeoutException sste) {
            logger.debug(sste.getMessage());
        }
        try {
            CommMgr.getInstance(element.getMyFirstSnmpAgentIndex()).changeSnmpAgentParams(varBindList, element.getMyFirstSnmpAgentIndex());
        }
        catch (SrSnmpTrapPortIsBusyException e) {
            logger.debug(e);
            ParameterCode[] errorParam = new ParameterCode[]{ParameterCode.VSWITCH_TRAP_UDP_PORT};
            throw new SrElementOperationErrorException(this, element, errorParam);
        }
    }

    private void changeElementUDPTrapPort(ConfigElementData element) throws SrCommunicationException {
        ConfigElementData newElement = new ConfigElementData(element.getCommKeyClassId());
        SrInteger currentTrapPort = (SrInteger)element.getValue(ParameterCode.VSWITCH_TRAP_UDP_PORT);
        newElement.setValue(ParameterCode.VSWITCH_TRAP_UDP_PORT, currentTrapPort);
        try {
            this.internalChange(newElement);
        }
        catch (SrElementOperationException e) {
            LogMgr.getServerLog().debug(e);
        }
    }

    public boolean readAfterCreate(ConfigElementData element) throws SrCommunicationException {
        return false;
    }

    public boolean readAfterChange(ConfigElementData element) throws SrCommunicationException {
        this.read(element);
        return false;
    }

    public void internalRead(ConfigElementData element) throws SrCommunicationException {
        super.internalRead(element);
        char snmpAgentIndex = element.getMyFirstSnmpAgentIndex();
        SnmpCommKey storDomainKey = new SnmpCommKey("1", snmpAgentIndex);
        StorageDomainConfigurator storDomainConfig = new StorageDomainConfigurator();
        ConfigElementData storDomainElem = new ConfigElementData(storDomainKey, ClassID.STORAGE_DOMAIN);
        storDomainElem.addParameter(storDomainConfig.getListOfParams());
        storDomainConfig.internalRead(storDomainElem);
        SrDateAndTime lastReset = (SrDateAndTime)element.getValue(ParameterCode.VSWITCH_LAST_RESET);
        if (lastReset != null) {
            SrTimeTicks lastKeepAlive = (SrTimeTicks)storDomainElem.getValue(ParameterCode.VSWITCH_LAST_KEEPALIVE);
            storDomainElem.setValue(ParameterCode.VSWITCH_LAST_KEEPALIVE, this.getDate(lastReset, lastKeepAlive));
        } else {
            storDomainElem.removeParameter(ParameterCode.VSWITCH_LAST_KEEPALIVE);
        }
        element.addParameter(storDomainElem.getParametersList());
    }

    public void internalReadFields(ConfigElementData element) throws SrCommunicationException {
        StorageDomainConfigurator storDomainConfig = new StorageDomainConfigurator();
        HashMap storDoaminParams = storDomainConfig.getListOfParams();
        this.splitParameterListOfDifferentElement(element, storDoaminParams);
        if (element.containParameter(ParameterCode.VSWITCH_MGM_IP_ADDRESS)) {
            element.addParameter(new Parameter(ParameterCode.VSWITCH_TADDRESS, null));
        }
        if (storDoaminParams.containsKey(ParameterCode.VSWITCH_LAST_KEEPALIVE)) {
            element.addParameter(new Parameter(ParameterCode.VSWITCH_LAST_RESET, null));
        }
        super.internalReadFields(element);
        if (storDoaminParams.size() > 0) {
            SnmpCommKey storDomainCommKey = new SnmpCommKey(storDomainKey, element.getMyFirstSnmpAgentIndex());
            ConfigElementData storDomainElement = new ConfigElementData(storDomainCommKey, ClassID.STORAGE_DOMAIN, storDoaminParams);
            storDomainConfig.internalReadFields(storDomainElement);
            SrDateAndTime lastReset = (SrDateAndTime)element.getValue(ParameterCode.VSWITCH_LAST_RESET);
            SrTimeTicks lastKeepAlive = (SrTimeTicks)storDomainElement.getValue(ParameterCode.VSWITCH_LAST_KEEPALIVE);
            storDomainElement.setValue(ParameterCode.VSWITCH_LAST_KEEPALIVE, this.getDate(lastReset, lastKeepAlive));
            element.addParameter(storDomainElement.getParametersList());
        }
    }

    protected CommItem getCommItemForTrapCommKey(SrTrap trap) {
        throw new UnsupportedOperationException("Operation not supported for trap " + trap.toString());
    }

    protected void trapProccessingPostOperation(ConfigElementData element, SrTrap trap) {
        CommKeyClassId vSwitchData = (CommKeyClassId)element.getValue(ParameterCode.VSWITCH_ID);
        element.setCommKeys(vSwitchData.getCommKeys());
        switch (trap.getTrapType().getTrapId()) {
            case 9: {
                element.setValue(ParameterCode.VSWITCH_COLD_START, new SrBoolean(true));
                PollingMgr.getInstance().getAgentPollingElement(CommKeyUtil.getSnmpAgentIndex(vSwitchData.getCommKeys())).resetPollingLastUpdatedValues();
                break;
            }
            case 8: {
                break;
            }
            case 14: {
                break;
            }
            default: {
                return;
            }
        }
        LogMgr.getServerLog().debug("Changed by Trap for " + element.getClassId().toString() + " CommKey is: " + CommKeyUtil.getKeyForMessage(element.getCommKey()));
        SrEventHandler.getEventMgr().sendChangeElementEvent(element);
    }

    public ConfigElementData refreshFields(ConfigElementData element) {
        return null;
    }

    public void notifyVswitchNotBusy() {
        this.locker.releaseLock();
    }

    public static class VSwitchDataContainer {
        CommVarBindList[] vSwitchesList = null;

        VSwitchDataContainer() {
        }

        public void setVSwitchesData(CommVarBindList[] theList) {
            this.vSwitchesList = theList;
        }

        CommVarBindList[] getVSwitchesData() {
            return this.vSwitchesList;
        }

        public void setVSwitchDataNull(int agentIndex) {
            if (this.vSwitchesList.length > agentIndex) {
                this.vSwitchesList[agentIndex] = null;
            }
        }
    }
}

