/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr;

import com.sanrad.log.LogMgr;
import com.sanrad.nms.server.comm.snmp.trap.SrTrap;
import com.sanrad.nms.server.comm.snmp.trap.SrTrapType;
import com.sanrad.nms.server.mgr.DataMgr;
import com.sanrad.nms.server.mgr.ElementConfigurator;
import com.sanrad.nms.server.mgr.threads.ThreadMgr;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.util.Queue;

class TrapHandler
extends Queue {
    private static boolean blockTraps = false;
    private static TrapHandler theInstance = null;
    private static TrapInvoker trapInvoker = null;

    private TrapHandler() {
        trapInvoker = new TrapInvoker(this);
        trapInvoker.start();
    }

    public static TrapHandler getInstance() {
        if (theInstance == null) {
            theInstance = new TrapHandler();
        }
        return theInstance;
    }

    public synchronized void blockTraps() {
        blockTraps = true;
    }

    public synchronized void unBlockTraps() {
        blockTraps = false;
        this.notifyAll();
    }

    public void addTrap(SrTrap trapThread) {
        this.addElement(trapThread);
    }

    public void clearTrapsQueue() {
        this.clear();
    }

    public synchronized Object removeHead() {
        while (this.queue.isEmpty() || blockTraps) {
            try {
                this.wait();
            }
            catch (InterruptedException ie) {
                LogMgr.getServerLog().debug(ie);
            }
            if (blockTraps || this.queue.isEmpty()) continue;
            Object value = this.queue.remove(0);
            return value;
        }
        Object value = this.queue.remove(0);
        return value;
    }

    private ClassID getClassIdFromTrapType(SrTrapType trapType) {
        switch (trapType.getTrapId()) {
            case 0: 
            case 1: 
            case 2: 
            case 12: {
                return ClassID.GENERAL_SCSI_DEVICE;
            }
            case 11: {
                return ClassID.SUB_DIRECT_ACCESS_DEVICE;
            }
            case 5: {
                return ClassID.MIRROR_SYNC;
            }
            case 4: {
                return ClassID.VOLUME_OPERATION;
            }
            case 3: {
                return ClassID.GENERAL_VOLUME;
            }
            case 6: {
                return ClassID.LUN;
            }
            case 7: {
                return ClassID.NEIGHBORE;
            }
            case 8: 
            case 9: 
            case 14: {
                return ClassID.VSWITCH;
            }
            case 15: 
            case 16: {
                return ClassID.INTERFACE;
            }
            case 13: {
                return ClassID.SNAPSHOT_VOLUME;
            }
            case 17: {
                return ClassID.HARDWARE;
            }
            case 18: {
                return ClassID.HARDWARE;
            }
            case 19: {
                return ClassID.HARDWARE;
            }
            case 23: {
                return ClassID.ISCSI_INITIATOR;
            }
            case 22: {
                return ClassID.ISCSI_TARGET;
            }
            case 21: {
                return ClassID.ISCSI_INSTANCE;
            }
            case 20: {
                return ClassID.HARDWARE;
            }
            case 24: {
                return ClassID.JOURNAL_VOLUME;
            }
            case 25: 
            case 26: {
                return ClassID.GENERAL_PAIR;
            }
            case 27: {
                return ClassID.SYNC_PAIR;
            }
            case 28: {
                return ClassID.ASYNC_PAIR;
            }
            case 29: 
            case 30: 
            case 31: {
                return ClassID.CONSISTENCY_GROUP;
            }
        }
        return null;
    }

    class TrapInvoker
    extends Thread {
        private Queue theQueue = null;

        TrapInvoker(Queue trapQueue) {
            super("Trap Queue Thread");
            this.theQueue = trapQueue;
        }

        public void run() {
            while (true) {
                SrTrap headTrap = (SrTrap)this.theQueue.removeHead();
                try {
                    ClassID classId = TrapHandler.this.getClassIdFromTrapType(headTrap.getTrapType());
                    ElementConfigurator elementConfigurator = DataMgr.getElementConfigFromClassID(classId);
                    char agentIndex = headTrap.getSourceIndex();
                    if (!ThreadMgr.getInstance().getAgentThreadMgr(agentIndex).allowTraps()) continue;
                    LogMgr.getTrapsLog().debug("Handling trap: " + headTrap.getVarBindList().toString());
                    elementConfigurator.handleTrap(headTrap);
                    continue;
                }
                catch (NullPointerException e) {
                    if (ThreadMgr.getInstance().getAgentThreadMgr(headTrap.getSourceIndex()) == null) {
                        LogMgr.getServerLog().warning("ReadFieldsThread was called even though " + ClassID.VSWITCH + " " + headTrap.getHost() + " does not exist");
                        continue;
                    }
                    LogMgr.getTrapsLog().debug("Error Handeling Trap!", e);
                    LogMgr.getServerLog().info("Error Handeling Trap! " + headTrap.getTrapType().toString());
                    continue;
                }
                catch (Exception e) {
                    LogMgr.getTrapsLog().debug("Error Handeling Trap!", e);
                    LogMgr.getServerLog().info("Error Handeling Trap! " + headTrap.getTrapType().toString());
                    continue;
                }
                break;
            }
        }
    }
}

