/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr;

import com.sanrad.log.LogMgr;
import com.sanrad.nms.server.comm.CommVarBindList;
import com.sanrad.nms.server.comm.exception.SrCommunicationException;
import com.sanrad.nms.server.event.SrEventHandler;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.ConfigElementDataList;
import com.sanrad.nms.server.mgr.ElementConfigurator;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKey;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.CommKeyUtil;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.SnmpCommKey;
import com.sanrad.nms.server.util.types.SrOidType;
import com.sanrad.nms.server.util.types.constants.RemoteTargetFailureTypeConstant;
import java.util.Collection;
import java.util.HashMap;

public class SrSCSIRemoteTargetConfigurator
extends ElementConfigurator {
    private static final String IDENTITY_INDEX_OID = "1.3.6.1.4.1.10059.1.11.4.1.3.1.1.1";

    public SrSCSIRemoteTargetConfigurator() {
        super(ClassID.ISCSI_REMOTE_TARGET, "srRemoteTgtTable", null, null);
    }

    public HashMap getListOfParams() {
        HashMap<ParameterCode, Object> paramList = new HashMap<ParameterCode, Object>(5);
        paramList.put(ParameterCode.SCSI_REMOTE_TARGET_ALIAS, null);
        paramList.put(ParameterCode.SCSI_REMOTE_TARGET_LOGIN_STATUS, null);
        paramList.put(ParameterCode.ISCSI_REMOTE_TARGET_NUM_OF_PORTALS, null);
        paramList.put(ParameterCode.IDENTITY_ID, null);
        paramList.put(ParameterCode.SCSI_REMOTE_TARGET_FAILURE_TYPE, null);
        return paramList;
    }

    protected void readDiscoverPostOperation(ConfigElementData element, CommVarBindList list) throws SrCommunicationException {
        String elementKey = element.getSnmpKey().getKey();
        String remoteTargetPortKey = elementKey.substring(0, elementKey.lastIndexOf("."));
        String localInitiatorKey = elementKey.substring(0, remoteTargetPortKey.lastIndexOf("."));
        CommKeyClassId initiatorCommKeyClassId = new CommKeyClassId(new SnmpCommKey(localInitiatorKey, element.getMyFirstSnmpAgentIndex()), ClassID.SCSI_INITIATOR);
        element.setValue(ParameterCode.SCSI_INITIATOR_ID, initiatorCommKeyClassId);
        SrOidType remoteTargetIdentityOid = (SrOidType)element.getValue(ParameterCode.IDENTITY_ID);
        String identityKey = remoteTargetIdentityOid.toDisplayString().substring(IDENTITY_INDEX_OID.length() + 1);
        CommKeyClassId identityCommKeyClassId = new CommKeyClassId(new SnmpCommKey(identityKey, element.getMyFirstSnmpAgentIndex()), ClassID.IDENTITY);
        element.setValue(ParameterCode.IDENTITY_ID, identityCommKeyClassId);
        SrOidType remoteTargetFailureTypeOid = (SrOidType)element.getValue(ParameterCode.SCSI_REMOTE_TARGET_FAILURE_TYPE);
        RemoteTargetFailureTypeConstant remoteTargetFailureTypeConst = RemoteTargetFailureTypeConstant.getFailureType(remoteTargetFailureTypeOid);
        element.setValue(ParameterCode.SCSI_REMOTE_TARGET_FAILURE_TYPE, remoteTargetFailureTypeConst);
    }

    protected void mergeElementLists(ConfigElementDataList remoteTargetList, ConfigElementDataList srRemoteTargetList, boolean setClassId) {
        Integer[] indexNotToRemove = new Integer[remoteTargetList.size()];
        try {
            for (int index1 = 0; index1 < srRemoteTargetList.size(); ++index1) {
                int index2;
                ConfigElementData secondElem = (ConfigElementData)srRemoteTargetList.elementAt(index1);
                CommKey[] secondElemKey = secondElem.getCommKey();
                ConfigElementData mainElem = null;
                for (index2 = 0; index2 < remoteTargetList.size(); ++index2) {
                    ConfigElementData currentMainElem = (ConfigElementData)remoteTargetList.elementAt(index2);
                    CommKey[] mainElemKey = currentMainElem.getCommKey();
                    if (CommKey.compare(secondElemKey, mainElemKey)) {
                        mainElem = currentMainElem;
                        break;
                    }
                    if (index2 == remoteTargetList.size() - 1) break;
                }
                if (mainElem == null) {
                    SrEventHandler.getErrorMgr().sendConfigurationError("Misconfigured " + secondElem.getClassId().toString() + " index: " + secondElem.getSnmpKey().toDisplayString(), secondElem.getSnmpKey().getSnmpAgentIndex());
                    indexNotToRemove[index2] = null;
                    continue;
                }
                mainElem.addParameter(secondElem.getParametersList());
                if (setClassId) {
                    mainElem.setClassId(this.myClassId);
                }
                indexNotToRemove[index2] = new Integer(index2);
            }
            ConfigElementDataList leftList = this.removeNonISCSIRemoteTargets(remoteTargetList, indexNotToRemove);
            remoteTargetList.removeAllElements();
            remoteTargetList.addAll((Collection)leftList);
        }
        catch (RuntimeException e) {
            String msg = "Merge Failed at: " + CommKeyUtil.getKeyForMessage(((ConfigElementData)remoteTargetList.get(0)).getCommKey());
            LogMgr.getServerLog().debug(msg, e);
            throw e;
        }
    }

    private ConfigElementDataList removeNonISCSIRemoteTargets(ConfigElementDataList remoteTargetList, Integer[] indexNotToRemove) {
        ConfigElementDataList retList = new ConfigElementDataList();
        for (int index = 0; index < indexNotToRemove.length; ++index) {
            if (indexNotToRemove[index] == null) continue;
            retList.add(remoteTargetList.elementAt(index));
        }
        return retList;
    }
}

