/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr;

import com.sanrad.log.LogMgr;
import com.sanrad.nms.server.comm.CommItem;
import com.sanrad.nms.server.comm.CommVarBindList;
import com.sanrad.nms.server.comm.exception.SrCommunicationException;
import com.sanrad.nms.server.comm.snmp.MibItem;
import com.sanrad.nms.server.comm.snmp.SrOid;
import com.sanrad.nms.server.comm.snmp.SrSnmpVarBind;
import com.sanrad.nms.server.comm.snmp.trap.SrTrap;
import com.sanrad.nms.server.event.SrEventHandler;
import com.sanrad.nms.server.exception.SrElementOperationException;
import com.sanrad.nms.server.mgr.CheckListConfigElementData;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.ConfigElementDataList;
import com.sanrad.nms.server.mgr.ElementConfigurator;
import com.sanrad.nms.server.mgr.NeighborConfigurator;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.CommKeyUtil;
import com.sanrad.nms.server.util.Parameter;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.SnmpCommKey;
import com.sanrad.nms.server.util.types.SrInteger;
import com.sanrad.nms.server.util.types.SrIpAddress;
import com.sanrad.nms.server.util.types.SrString;
import com.sanrad.nms.server.util.types.SrTAddress;
import com.sanrad.nms.server.util.types.SrTimeTicks;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

public class SnmpTargetAddressConfigurator
extends ElementConfigurator {
    public SnmpTargetAddressConfigurator() {
        super(ClassID.NEIGHBORE, "snmpTargetAddrTable", MibItem.NEIGHBOR_TGT_ADDRESS_RS, MibItem.STORAGE_DOMAIN_TBL_LAST_UPDATED);
    }

    public HashMap getListOfParams() {
        HashMap<ParameterCode, Object> paramList = new HashMap<ParameterCode, Object>(5);
        paramList.put(ParameterCode.NEIGHBOR_RETRIES, null);
        paramList.put(ParameterCode.NEIGHBOR_TIMEOUT, null);
        paramList.put(ParameterCode.NEIGHBOR_TADDRESS, null);
        return paramList;
    }

    protected void readDiscoverPostOperation(ConfigElementData element, CommVarBindList list) throws SrCommunicationException {
        String nameAsIndex = element.getSnmpKey().getKey();
        element.addParameter(new Parameter(ParameterCode.NEIGHBOR_NAME, new SrString(this.getNameFromIndex(nameAsIndex))));
        SrTAddress tAddress = (SrTAddress)element.getValue(ParameterCode.NEIGHBOR_TADDRESS);
        if (tAddress != null) {
            SrIpAddress ip = tAddress.getIp();
            element.setValue(ParameterCode.NEIGHBOR_IP_ADDRESS, ip);
            SrInteger port = tAddress.getPort();
            element.setValue(ParameterCode.NEIGHBOR_PORT, port);
            element.removeParameter(ParameterCode.NEIGHBOR_TADDRESS);
        }
        NeighborConfigurator neighborConfig = new NeighborConfigurator();
        neighborConfig.readDiscoverPostOperation(element, list);
    }

    private String getNameFromIndex(String nameAsIndex) {
        Vector<Byte> nameAsVector = new Vector<Byte>();
        while (nameAsIndex.indexOf(".") > 0) {
            nameAsVector.add(new Byte(nameAsIndex.substring(0, nameAsIndex.indexOf("."))));
            nameAsIndex = nameAsIndex.substring(nameAsIndex.indexOf(".") + 1);
        }
        nameAsVector.add(new Byte(nameAsIndex));
        byte[] nameAsArray = new byte[nameAsVector.size()];
        for (int i = 0; i < nameAsArray.length; ++i) {
            nameAsArray[i] = (Byte)nameAsVector.elementAt(i);
        }
        return new String(nameAsArray);
    }

    public void discover(CommKeyClassId vSwitchData) throws SrCommunicationException {
        char snmpAgentIndex = vSwitchData.getMyFirstSnmpAgentIndex();
        ConfigElementDataList tgtAddressList = this.getAllExtended(snmpAgentIndex, null, null);
        if (tgtAddressList.size() > 0) {
            this.sendDiscoveredElementsToEventMgr(tgtAddressList, vSwitchData);
        }
    }

    public ConfigElementDataList getAllExtended(char snmpAgentIndex, SrTimeTicks lastUpdate, CheckListConfigElementData checkListElement) throws SrCommunicationException {
        ConfigElementDataList tgtAddressList = this.getAll(snmpAgentIndex, null, checkListElement);
        if (tgtAddressList != null && tgtAddressList.size() > 0) {
            NeighborConfigurator neighborConfig = new NeighborConfigurator();
            ConfigElementDataList neighborsList = neighborConfig.getAllExtended(snmpAgentIndex, lastUpdate, null);
            this.mergeElementLists(tgtAddressList, neighborsList, false);
        }
        return tgtAddressList;
    }

    public void internalRead(ConfigElementData element) throws SrCommunicationException {
        super.internalRead(element);
        char snmpAgentIndex = element.getMyFirstSnmpAgentIndex();
        String neighborKey = "1." + element.getSnmpKey().getKey();
        SnmpCommKey neighborCommKey = new SnmpCommKey(neighborKey, snmpAgentIndex);
        NeighborConfigurator neighborConfig = new NeighborConfigurator();
        ConfigElementData neighborElement = new ConfigElementData(neighborCommKey, ClassID.NEIGHBORE);
        neighborConfig.internalRead(neighborElement);
        element.addParameter(neighborElement.getParametersList());
    }

    public void internalReadFields(ConfigElementData element) throws SrCommunicationException {
        NeighborConfigurator neighborConfig = new NeighborConfigurator();
        HashMap neighborParams = neighborConfig.getListOfParams();
        this.splitParameterListOfDifferentElement(element, neighborParams);
        if (element.containParameter(ParameterCode.NEIGHBOR_IP_ADDRESS) || element.containParameter(ParameterCode.NEIGHBOR_PORT)) {
            element.addParameter(new Parameter(ParameterCode.NEIGHBOR_TADDRESS));
        }
        super.internalReadFields(element);
        if (neighborParams.size() > 0) {
            String neighborKey = "1." + element.getSnmpKey().getKey();
            SnmpCommKey neighborCommKey = new SnmpCommKey(neighborKey, element.getMyFirstSnmpAgentIndex());
            ConfigElementData neighborElement = new ConfigElementData(neighborCommKey, ClassID.NEIGHBORE, neighborParams);
            neighborConfig.internalReadFields(neighborElement);
            element.addParameter(neighborElement.getParametersList());
        }
    }

    protected void mergeElementLists(ConfigElementDataList tgtAddress, ConfigElementDataList neighbors) {
        try {
            Iterator tgtAddressItr = tgtAddress.iterator();
            while (tgtAddressItr.hasNext()) {
                ConfigElementData tgtAddressElement = (ConfigElementData)tgtAddressItr.next();
                String tgtAddElemKey = tgtAddressElement.getCommKey()[0].getKey();
                Iterator neighborItr = neighbors.iterator();
                ConfigElementData neighborElem = null;
                while (neighborItr.hasNext() && neighborElem == null) {
                    ConfigElementData currentNeighborElem = (ConfigElementData)neighborItr.next();
                    String neighborElemKey = currentNeighborElem.getCommKey()[0].getKey();
                    if (!neighborElemKey.substring(neighborElemKey.indexOf(".") + 1).equals(tgtAddElemKey)) continue;
                    neighborElem = currentNeighborElem;
                    break;
                }
                if (neighborElem == null) continue;
                tgtAddressElement.addParameter(neighborElem.getParametersList());
            }
        }
        catch (Exception e) {
            String msg = "Failed to merger srSDNeighboursTable with data from SnmpTargetAdressTable";
            LogMgr.getServerLog().debug(msg, e);
        }
    }

    protected void addCommVarBindsToChangeList(CommVarBindList list, ConfigElementData element) {
        if (element.containParameter(ParameterCode.NEIGHBOR_IP_ADDRESS) || element.containParameter(ParameterCode.NEIGHBOR_PORT)) {
            SnmpCommKey tgtAdressKey = element.getSnmpKey();
            SrOid tAddressOid = new SrOid(MibItem.NEIGHBOR_TADDRESS.toString(), tgtAdressKey.toString());
            list.add(new SrSnmpVarBind(tAddressOid, null));
        }
        NeighborConfigurator neighborConfig = new NeighborConfigurator();
        neighborConfig.addCommVarBindsToChangeList(list, element);
    }

    public void internalCreate(ConfigElementData element) throws SrCommunicationException, SrElementOperationException {
        String name = element.getValue(ParameterCode.NEIGHBOR_NAME).toString();
        byte[] nameInBytes = name.getBytes();
        String commKey = "";
        for (int i = 0; i < nameInBytes.length; ++i) {
            commKey = commKey + "." + nameInBytes[i];
        }
        commKey = commKey.substring(1);
        char snmpAgentIndex = ((CommKeyClassId)element.getValue(ParameterCode.VSWITCH_ID)).getMyFirstSnmpAgentIndex();
        element.setCommKey(new SnmpCommKey(commKey, snmpAgentIndex));
        SrIpAddress ip = (SrIpAddress)element.getValue(ParameterCode.NEIGHBOR_IP_ADDRESS);
        SrInteger port = (SrInteger)element.getValue(ParameterCode.NEIGHBOR_PORT);
        SrTAddress tAddress = new SrTAddress(ip, port);
        element.addParameter(new Parameter(ParameterCode.NEIGHBOR_TADDRESS, tAddress));
        super.internalCreate(element);
        element.removeParameter(ParameterCode.NEIGHBOR_TADDRESS);
    }

    protected CommItem getCommItemForTrapCommKey(SrTrap trap) {
        switch (trap.getTrapType().getTrapId()) {
            case 7: {
                return MibItem.NEIGHBOR_STATUS;
            }
        }
        throw new UnsupportedOperationException("Operation not supported for trap " + trap.toString());
    }

    protected void trapProccessingPostOperation(ConfigElementData element, SrTrap trap) {
        SnmpCommKey neighborKey = element.getSnmpKey();
        String neighborKeyStr = neighborKey.getKey();
        if (neighborKeyStr.substring(0, 2).equals("1.")) {
            String neighborNewKey = neighborKey.getKey().substring(2);
            SnmpCommKey newKey = new SnmpCommKey(neighborNewKey, neighborKey.getSnmpAgentIndex());
            element.setCommKey(newKey);
        }
        try {
            this.readDiscoverPostOperation(element, trap.getVarBindList());
        }
        catch (SrCommunicationException ex) {
            LogMgr.getServerLog().error("Failed to convert Neighbor data from trap - Trap ignored", ex);
            return;
        }
        LogMgr.getServerLog().debug("Changed by Trap for " + element.getClassId().toString() + " CommKey is: " + CommKeyUtil.getKeyForMessage(element.getCommKey()));
        SrEventHandler.getEventMgr().sendChangeElementEvent(element);
    }

    protected void addCommVarBindsToReadList(CommVarBindList list, ConfigElementData element) {
        super.addCommVarBindsToReadList(list, element);
        NeighborConfigurator neighborConfig = new NeighborConfigurator();
        neighborConfig.addCommVarBindsToReadList(list, element);
    }
}

