/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr;

import com.sanrad.nms.server.comm.CommMgr;
import com.sanrad.nms.server.comm.CommVarBindList;
import com.sanrad.nms.server.comm.exception.SrCommunicationException;
import com.sanrad.nms.server.comm.snmp.MibItem;
import com.sanrad.nms.server.exception.SrElementOperationException;
import com.sanrad.nms.server.exception.SrElementOperationFailedException;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.ElementConfigurator;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.Parameter;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.SnmpCommKey;
import com.sanrad.nms.server.util.types.SrIpAddress;
import java.util.HashMap;

public class SnmpManagerConfigurator
extends ElementConfigurator {
    static Integer[] lastManagerIndex = new Integer[0];

    public SnmpManagerConfigurator() {
        super(ClassID.SNMP_MANAGER, "srManagersTable", MibItem.MANAGER_RS, MibItem.MANAGER_TBL_LAST_UPDATE);
    }

    public void internalCreate(ConfigElementData element) throws SrCommunicationException, SrElementOperationException {
        char agentIndex = element.getSnmpAgentFromParameter();
        String managerIp = CommMgr.getInstance(agentIndex).getManagerIpAddress(agentIndex);
        if (managerIp != null) {
            element.addParameter(new Parameter(ParameterCode.MANAGER_IP_ADDRESS, new SrIpAddress(managerIp)));
            if (lastManagerIndex.length <= agentIndex) {
                Integer[] newArray = new Integer[agentIndex + '\u0001'];
                System.arraycopy(lastManagerIndex, 0, newArray, 0, lastManagerIndex.length);
                newArray[agentIndex] = new Integer(0);
                lastManagerIndex = newArray;
            } else if (lastManagerIndex[agentIndex] == null) {
                SnmpManagerConfigurator.lastManagerIndex[agentIndex] = new Integer(0);
            }
        } else {
            ParameterCode[] params = new ParameterCode[]{ParameterCode.MANAGER_IP_ADDRESS};
            throw new SrElementOperationFailedException(this, element, params);
        }
        this.getAll(agentIndex, null, null);
        Integer newIndex = new Integer(lastManagerIndex[agentIndex] + 1);
        element.setCommKey(new SnmpCommKey(newIndex.toString(), agentIndex));
        super.internalCreate(element);
    }

    protected void readDiscoverPostOperation(ConfigElementData element, CommVarBindList list) throws SrCommunicationException {
        Integer managerIndex = new Integer(element.getSnmpKey().toString());
        char agentIndex = element.getMyFirstSnmpAgentIndex();
        if (lastManagerIndex.length <= agentIndex) {
            Integer[] newArray = new Integer[agentIndex + '\u0001'];
            System.arraycopy(lastManagerIndex, 0, newArray, 0, lastManagerIndex.length);
            newArray[agentIndex] = managerIndex;
            lastManagerIndex = newArray;
        } else if (lastManagerIndex[agentIndex] == null || managerIndex > lastManagerIndex[agentIndex]) {
            SnmpManagerConfigurator.lastManagerIndex[agentIndex] = managerIndex;
        }
    }

    public HashMap getListOfParams() {
        HashMap<ParameterCode, Object> paramList = new HashMap<ParameterCode, Object>(5);
        paramList.put(ParameterCode.MANAGER_IP_ADDRESS, null);
        paramList.put(ParameterCode.MANAGER_READ_COMMUNITY, null);
        paramList.put(ParameterCode.MANAGER_TRAP_ENABLE, null);
        paramList.put(ParameterCode.MANAGER_TRAP_PORT, null);
        paramList.put(ParameterCode.MANAGER_WRITE_COMMUNITY, null);
        return paramList;
    }
}

