/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr;

import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.ConfigElementDataList;
import com.sanrad.nms.server.mgr.ElementConfigurator;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.Parameter;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.SrOidType;
import com.sanrad.nms.server.util.types.SrString;
import com.sanrad.nms.server.util.types.constants.SCSITransportType;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;

public class ScsiTransportConfigurator
extends ElementConfigurator {
    public static final SrOidType ISCSI_NODE_INDEX_OID = new SrOidType("1.3.6.1.3.9999.1.6.1.1.1");
    public static final SrOidType SCSI_NODE_INDEX_OID = new SrOidType("1.3.6.1.4.1.10059.1.11.2.1.2.5.1.1");

    public ScsiTransportConfigurator() {
        super(ClassID.SCSI_TRANSPORT_ENTRY, "scsiTrnsptTable", null, null);
    }

    public HashMap getListOfParams() {
        HashMap<ParameterCode, Object> paramList = new HashMap<ParameterCode, Object>(5);
        paramList.put(ParameterCode.SCSI_TRANSPORT_TYPE, null);
        paramList.put(ParameterCode.SCSI_TRANSPORT_POINTER, null);
        paramList.put(ParameterCode.SCSI_TRANSPORT_DEVICE_NAME, null);
        return paramList;
    }

    public static void mergeInitiatorElementsListsWithTransport(ConfigElementDataList scsiInitiatorsList, ConfigElementDataList iscsiInitiatorsList, ConfigElementDataList remoteTargetElementsList, ConfigElementDataList remoteDiscoveryPortalsElements, ConfigElementDataList transportList) {
        Iterator trnsptItr = transportList.iterator();
        while (trnsptItr.hasNext()) {
            String iscsiInterfaceOidTypeStr = ((SrOidType)SCSITransportType.ISCSI_INTERFACE.userVal()).toDisplayString();
            ConfigElementData trnsptElm = (ConfigElementData)trnsptItr.next();
            SrOidType deviceTransportType = (SrOidType)trnsptElm.getValue(ParameterCode.SCSI_TRANSPORT_TYPE);
            String deviceTransportTypeStr = deviceTransportType.toDisplayString();
            SrOidType deviceTransportPointer = (SrOidType)trnsptElm.getValue(ParameterCode.SCSI_TRANSPORT_POINTER);
            String deviceTransportPointerStr = deviceTransportPointer.toDisplayString();
            if (!deviceTransportTypeStr.equals(iscsiInterfaceOidTypeStr)) continue;
            Iterator scsiItr = scsiInitiatorsList.iterator();
            while (scsiItr.hasNext()) {
                String scsiDeviceKey;
                ConfigElementData scsiElm = (ConfigElementData)scsiItr.next();
                if ((scsiElm.getClassId().equals(ClassID.ISCSI_REMOTE_TARGET) || scsiElm.getClassId().equals(ClassID.ISCSI_REMOTE_TARGET_PORTAL)) && !remoteTargetElementsList.contains(scsiElm)) {
                    remoteTargetElementsList.add(scsiElm);
                    continue;
                }
                if (scsiElm.getClassId().equals(ClassID.ISCSI_REMOTE_DISCOVERY_PORTAL) && !remoteDiscoveryPortalsElements.contains(scsiElm)) {
                    remoteDiscoveryPortalsElements.add(scsiElm);
                    continue;
                }
                if (scsiElm.getClassId().equals(ClassID.ISCSI_REMOTE_DISCOVERY_PORTAL) && !remoteDiscoveryPortalsElements.contains(scsiElm)) {
                    remoteDiscoveryPortalsElements.add(scsiElm);
                    continue;
                }
                String transportKey = new String(trnsptElm.getSnmpKey().getKey());
                String transportKeyParent = transportKey.substring(0, transportKey.lastIndexOf(46));
                if (!transportKeyParent.equals(scsiDeviceKey = new String(scsiElm.getSnmpKey().getKey()))) continue;
                Iterator iscsiItr = iscsiInitiatorsList.iterator();
                while (iscsiItr.hasNext()) {
                    ConfigElementData iscsiElm = (ConfigElementData)iscsiItr.next();
                    if (!deviceTransportPointerStr.endsWith(iscsiElm.getSnmpKey().getKey())) continue;
                    iscsiElm.addParameter(scsiElm.getParametersList());
                    iscsiElm.addParameter(new Parameter(ParameterCode.SCSI_DEVICE_ID, scsiElm.getCommKeyClassId()));
                    SrString initiatorAlias = (SrString)scsiElm.removeParameter(ParameterCode.SCSI_DEVICE_ALIAS);
                    SrString initiatorName = (SrString)trnsptElm.removeParameter(ParameterCode.SCSI_TRANSPORT_DEVICE_NAME);
                    iscsiElm.addParameter(new Parameter(ParameterCode.ISCSI_INITIATOR_ALIAS, initiatorAlias));
                    iscsiElm.addParameter(new Parameter(ParameterCode.ISCSI_INITIATOR_NAME, initiatorName));
                }
            }
        }
    }

    public static void mergeTargetElementsListsWithTransport(ConfigElementDataList scsiTargetsList, ConfigElementDataList iscsiTargetsList, ConfigElementDataList remoteInitiatorElementsList, ConfigElementDataList transportList) {
        Iterator trnsptItr = transportList.iterator();
        while (trnsptItr.hasNext()) {
            String iscsiInterfaceOidTypeStr = new SrOidType(SCSITransportType.ISCSI_INTERFACE_OID).toDisplayString();
            ConfigElementData trnsptElm = (ConfigElementData)trnsptItr.next();
            SrOidType deviceTransportType = (SrOidType)trnsptElm.getValue(ParameterCode.SCSI_TRANSPORT_TYPE);
            String deviceTransportTypeStr = deviceTransportType.toDisplayString();
            SrOidType deviceTransportPointer = (SrOidType)trnsptElm.getValue(ParameterCode.SCSI_TRANSPORT_POINTER);
            String deviceTransportPointerStr = deviceTransportPointer.toDisplayString();
            if (!deviceTransportTypeStr.equals(iscsiInterfaceOidTypeStr)) continue;
            Iterator scsiItr = scsiTargetsList.iterator();
            while (scsiItr.hasNext()) {
                ConfigElementData scsiElm = (ConfigElementData)scsiItr.next();
                if ((scsiElm.getClassId().equals(ClassID.ISCSI_REMOTE_INITIATOR) || scsiElm.getClassId().equals(ClassID.ISCSI_REMOTE_INITIATOR_STATISTICS)) && !remoteInitiatorElementsList.contains(scsiElm)) {
                    remoteInitiatorElementsList.add(scsiElm);
                    continue;
                }
                String transportKey = new String(trnsptElm.getSnmpKey().getKey());
                String scsiDeviceKey = new String(scsiElm.getSnmpKey().getKey());
                String transportKeyParent = transportKey.substring(0, transportKey.lastIndexOf(46));
                if (!transportKeyParent.equals(scsiDeviceKey)) continue;
                Iterator iscsiItr = iscsiTargetsList.iterator();
                while (iscsiItr.hasNext()) {
                    ConfigElementData iscsiElm = (ConfigElementData)iscsiItr.next();
                    if (!deviceTransportPointerStr.endsWith(iscsiElm.getSnmpKey().getKey())) continue;
                    iscsiElm.addParameter(scsiElm.getParametersList());
                    iscsiElm.addParameter(new Parameter(ParameterCode.SCSI_DEVICE_ID, scsiElm.getCommKeyClassId()));
                }
            }
        }
    }

    public static void mergeDevicePortElementsListsWithTransport(ConfigElementDataList scsiPortList, ConfigElementDataList transportList) {
        Iterator trnsptItr = transportList.iterator();
        ConfigElementDataList leftScsiPortList = new ConfigElementDataList();
        while (trnsptItr.hasNext()) {
            String iscsiInterfaceOidTypeStr = new SrOidType(SCSITransportType.ISCSI_INTERFACE_OID).toDisplayString();
            ConfigElementData trnsptElm = (ConfigElementData)trnsptItr.next();
            SrOidType deviceTransportType = (SrOidType)trnsptElm.getValue(ParameterCode.SCSI_TRANSPORT_TYPE);
            String deviceTransportTypeStr = deviceTransportType.toDisplayString();
            if (!deviceTransportTypeStr.equals(iscsiInterfaceOidTypeStr)) continue;
            String transportElmCommKey = trnsptElm.getSnmpKey().getKey();
            String deviceCommKeyFromTransportCommKey = transportElmCommKey.substring(0, transportElmCommKey.lastIndexOf("."));
            Iterator scsiPortsItr = scsiPortList.iterator();
            while (scsiPortsItr.hasNext()) {
                ConfigElementData scsiPortElm = (ConfigElementData)scsiPortsItr.next();
                String scsiPortElmKey = scsiPortElm.getSnmpKey().getKey();
                String scsiPortElmKeyParent = scsiPortElmKey.substring(0, scsiPortElmKey.lastIndexOf(46));
                if (!scsiPortElmKeyParent.equals(deviceCommKeyFromTransportCommKey)) continue;
                leftScsiPortList.add(scsiPortElm);
            }
        }
        scsiPortList.clear();
        scsiPortList.addAll((Collection)leftScsiPortList);
    }

    public static ConfigElementData mergeInitiatorElementWithTransport(ConfigElementData scsiInitiator, ConfigElementDataList iscsiInitiatorsList, ConfigElementDataList transportList) {
        ConfigElementData element = ScsiTransportConfigurator.mergeSCSIElementWithTransport(scsiInitiator, iscsiInitiatorsList, transportList, true);
        return element;
    }

    public static ConfigElementData mergeTargetElementWithTransport(ConfigElementData scsiTarget, ConfigElementDataList iscsiTargetsList, ConfigElementDataList transportList) {
        ConfigElementData element = ScsiTransportConfigurator.mergeSCSIElementWithTransport(scsiTarget, iscsiTargetsList, transportList, false);
        return element;
    }

    private static ConfigElementData mergeSCSIElementWithTransport(ConfigElementData scsiDevice, ConfigElementDataList iscsiElementsList, ConfigElementDataList transportList, boolean isInitiatorMerge) {
        Iterator trnsptItr = transportList.iterator();
        while (trnsptItr.hasNext()) {
            String scsiDeviceKey;
            String transportKey;
            String transportKeyParent;
            String iscsiInterfaceOidTypeStr = new SrOidType(SCSITransportType.ISCSI_INTERFACE_OID).toDisplayString();
            ConfigElementData trnsptElm = (ConfigElementData)trnsptItr.next();
            SrOidType deviceTransportType = (SrOidType)trnsptElm.getValue(ParameterCode.SCSI_TRANSPORT_TYPE);
            String deviceTransportTypeStr = deviceTransportType.toDisplayString();
            SrOidType deviceTransportPointer = (SrOidType)trnsptElm.getValue(ParameterCode.SCSI_TRANSPORT_POINTER);
            String deviceTransportPointerStr = deviceTransportPointer.toDisplayString();
            if (!deviceTransportTypeStr.equals(iscsiInterfaceOidTypeStr) || !(transportKeyParent = (transportKey = new String(trnsptElm.getSnmpKey().getKey())).substring(0, transportKey.lastIndexOf(46))).equals(scsiDeviceKey = new String(scsiDevice.getSnmpKey().getKey()))) continue;
            Iterator iscsiItr = iscsiElementsList.iterator();
            while (iscsiItr.hasNext()) {
                ConfigElementData iscsiElm = (ConfigElementData)iscsiItr.next();
                if (!deviceTransportPointerStr.endsWith(iscsiElm.getSnmpKey().getKey())) continue;
                iscsiElm.addParameter(scsiDevice.getParametersList());
                iscsiElm.addParameter(new Parameter(ParameterCode.SCSI_DEVICE_ID, scsiDevice.getCommKeyClassId()));
                if (isInitiatorMerge) {
                    SrString initiatorAlias = (SrString)scsiDevice.removeParameter(ParameterCode.SCSI_DEVICE_ALIAS);
                    SrString initiatorName = (SrString)trnsptElm.removeParameter(ParameterCode.SCSI_TRANSPORT_DEVICE_NAME);
                    iscsiElm.addParameter(new Parameter(ParameterCode.ISCSI_INITIATOR_ALIAS, initiatorAlias));
                    iscsiElm.addParameter(new Parameter(ParameterCode.ISCSI_INITIATOR_NAME, initiatorName));
                }
                return iscsiElm;
            }
        }
        return null;
    }
}

