/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr;

import com.sanrad.nms.server.comm.exception.SrCommunicationException;
import com.sanrad.nms.server.mgr.CheckListConfigElementData;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.ConfigElementDataList;
import com.sanrad.nms.server.mgr.ElementConfigurator;
import com.sanrad.nms.server.mgr.ScsiInitiatorPortConfigurator;
import com.sanrad.nms.server.mgr.ScsiTransportConfigurator;
import com.sanrad.nms.server.mgr.target.ScsiTargetPortsConfigurator;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.CommKeyUtil;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.SrTimeTicks;
import com.sanrad.nms.server.util.types.constants.SCSIPortRoleConstant;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

public class ScsiPortConfigurator
extends ElementConfigurator {
    public ScsiPortConfigurator() {
        super(ClassID.SCSI_PORT, "scsiPortTable", null, null);
    }

    public HashMap getListOfParams() {
        HashMap<ParameterCode, Object> paramList = new HashMap<ParameterCode, Object>(2);
        paramList.put(ParameterCode.SCSI_PORT_ROLE, null);
        return paramList;
    }

    public ConfigElementDataList getAllExtended(char snmpAgentIndex, SrTimeTicks lastUpdate, CheckListConfigElementData checkListElement) throws SrCommunicationException {
        ConfigElementDataList portList = this.getAll(snmpAgentIndex, null, null);
        ScsiInitiatorPortConfigurator initiatorPortConfig = new ScsiInitiatorPortConfigurator();
        ConfigElementDataList scsiInitiatorPortList = initiatorPortConfig.getAll(snmpAgentIndex, null, null);
        ScsiTargetPortsConfigurator targetPortConfig = new ScsiTargetPortsConfigurator();
        ConfigElementDataList scsiTargetPortList = targetPortConfig.getAllExtended(snmpAgentIndex, null, null);
        Iterator portItr = portList.iterator();
        while (portItr.hasNext()) {
            ConfigElementData portElem = (ConfigElementData)portItr.next();
            SCSIPortRoleConstant role = (SCSIPortRoleConstant)portElem.getValue(ParameterCode.SCSI_PORT_ROLE);
            if (role.equals(SCSIPortRoleConstant.INITIATOR)) {
                portElem.setClassId(ClassID.SCSI_INITIATOR_PORT);
                Iterator intrItr = scsiInitiatorPortList.iterator();
                while (intrItr.hasNext()) {
                    ConfigElementData intrElem = (ConfigElementData)intrItr.next();
                    if (!intrElem.compareCommKey(portElem)) continue;
                    intrElem.addParameter(portElem.getParametersList());
                }
                continue;
            }
            portElem.setClassId(ClassID.SCSI_TARGET_PORT);
            Iterator tgtItr = scsiTargetPortList.iterator();
            while (tgtItr.hasNext()) {
                ConfigElementData tgtElem = (ConfigElementData)tgtItr.next();
                if (!tgtElem.compareCommKey(portElem)) continue;
                tgtElem.addParameter(portElem.getParametersList());
            }
        }
        portList.clear();
        portList.addAll((Collection)scsiInitiatorPortList);
        portList.addAll((Collection)scsiTargetPortList);
        return portList;
    }

    public ConfigElementDataList refreshTable(char snmpAgentIndex, SrTimeTicks lastUpdate, CheckListConfigElementData checkListElement) throws SrCommunicationException {
        ConfigElementDataList portList = this.getAllExtended(snmpAgentIndex, null, null);
        ScsiTransportConfigurator trnsportConfig = new ScsiTransportConfigurator();
        ConfigElementDataList transportList = trnsportConfig.getAllExtended(snmpAgentIndex, null, null);
        ScsiTransportConfigurator.mergeDevicePortElementsListsWithTransport(portList, transportList);
        this.coordinateWithCheckList(snmpAgentIndex, portList, checkListElement);
        return portList;
    }

    private void coordinateWithCheckList(char snmpAgentIndex, ConfigElementDataList portList, CheckListConfigElementData checkListElement) {
        Vector<CommKeyClassId> commKeysToCheckList = new Vector<CommKeyClassId>();
        for (int i = 0; i < portList.size(); ++i) {
            ConfigElementData element = (ConfigElementData)portList.elementAt(i);
            CommKeyClassId commKeyClassIdToCheck = element.getCommKeyClassId();
            commKeysToCheckList.add(commKeyClassIdToCheck);
        }
        checkListElement.setCheckList(commKeysToCheckList);
        checkListElement.setValue(ParameterCode.VSWITCH_ID, CommKeyUtil.getVSwitchData(snmpAgentIndex));
        if (checkListElement.getClassId() == null) {
            checkListElement.setClassId(this.myClassId);
        }
    }
}

