/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr;

import com.sanrad.nms.server.comm.exception.SrCommunicationException;
import com.sanrad.nms.server.mgr.CheckListConfigElementData;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.ConfigElementDataList;
import com.sanrad.nms.server.mgr.ElementConfigurator;
import com.sanrad.nms.server.mgr.ISCSIInitiatorConfigurator;
import com.sanrad.nms.server.mgr.ISCSIRemotePortalDiscoveryConfigurator;
import com.sanrad.nms.server.mgr.SCSIRemoteTargetConfigurator;
import com.sanrad.nms.server.mgr.ScsiDeviceConfigurator;
import com.sanrad.nms.server.mgr.ScsiTransportConfigurator;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.SrTimeTicks;
import java.util.Collection;
import java.util.HashMap;

public class ScsiInitiatorDeviceConfigurator
extends ElementConfigurator {
    public ScsiInitiatorDeviceConfigurator() {
        super(ClassID.SCSI_INITIATOR, "scsiIntrDevTable", null, null);
    }

    public HashMap getListOfParams() {
        HashMap<ParameterCode, Object> paramList = new HashMap<ParameterCode, Object>(2);
        paramList.put(ParameterCode.SCSI_INITIATOR_TARGET_ACCESS_MODE, null);
        return paramList;
    }

    public void discover(CommKeyClassId vSwitchData) throws SrCommunicationException {
        char snmpAgentIndex = vSwitchData.getMyFirstSnmpAgentIndex();
        ConfigElementDataList initiatoresList = this.getAllExtended(snmpAgentIndex, null, null);
        if (initiatoresList.size() > 0) {
            this.sendDiscoveredElementsToEventMgr(initiatoresList, vSwitchData);
        }
    }

    public ConfigElementDataList getAllExtended(char snmpAgentIndex, SrTimeTicks lastUpdate, CheckListConfigElementData checkListElement) throws SrCommunicationException {
        SrTimeTicks noLastUpdateValuePerTable = null;
        ConfigElementDataList initiatorList = this.getAll(snmpAgentIndex, noLastUpdateValuePerTable, checkListElement);
        if (initiatorList.size() > 0) {
            SCSIRemoteTargetConfigurator remoteTargetConf = new SCSIRemoteTargetConfigurator();
            ConfigElementDataList remoteTargetiList = remoteTargetConf.getAllExtended(snmpAgentIndex, noLastUpdateValuePerTable, CheckListConfigElementData.NO_CHECK_LIST_NEEDED);
            initiatorList.addAll((Collection)remoteTargetiList);
            ISCSIRemotePortalDiscoveryConfigurator remoteDiscoveryPortalsConf = new ISCSIRemotePortalDiscoveryConfigurator();
            ConfigElementDataList remoteDiscoveryPortalsList = remoteDiscoveryPortalsConf.getAllExtended(snmpAgentIndex, noLastUpdateValuePerTable, CheckListConfigElementData.NO_CHECK_LIST_NEEDED);
            initiatorList.addAll((Collection)remoteDiscoveryPortalsList);
        }
        return initiatorList;
    }

    public void internalRead(ConfigElementData element) throws SrCommunicationException {
        super.internalRead(element);
        ConfigElementData scsiDeviceElement = new ConfigElementData(element.getCommKey(), ClassID.SCSI_DEVICE);
        ScsiDeviceConfigurator deviceConfigurator = new ScsiDeviceConfigurator();
        deviceConfigurator.internalRead(scsiDeviceElement);
        element.addParameter(scsiDeviceElement.getParametersList());
        ISCSIInitiatorConfigurator iscsiInitiatorConfig = new ISCSIInitiatorConfigurator();
        ConfigElementDataList initiatorList = iscsiInitiatorConfig.getAllExtended(element.getSnmpAgentFromParameter(), null, null);
        ScsiTransportConfigurator trnsportConfig = new ScsiTransportConfigurator();
        ConfigElementDataList transportList = trnsportConfig.getAllExtended(element.getSnmpAgentFromParameter(), null, null);
        ConfigElementData iscsiElement = ScsiTransportConfigurator.mergeInitiatorElementWithTransport(element, initiatorList, transportList);
        element.setCommKeyClassId(iscsiElement.getCommKeyClassId());
        element.getParametersList().clear();
        element.addParameter(iscsiElement.getParametersList());
    }
}

